//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// generated from apiService.mustache
package sample.cask.api

import _root_.sample.cask.model.Order
import scala.util.Failure
import scala.util.Try
import _root_.sample.cask.model.*

/**
 * The StoreService companion object.
 *
 * Use the StoreService() companion object to create an instance which returns a 'not implemented' error
 * for each operation.
 *
 */
object StoreService {

  /**
   * The 'Handler' is an implementation of StoreService convenient for delegating or overriding individual functions
   */
  case class Handler[F[_]](
        deleteOrderHandler : (orderId : String) => F[Unit], 
        getInventoryHandler : () => F[Map[String, Int]], 
        getOrderByIdHandler : (orderId : Long) => F[Order], 
        placeOrderHandler : (order : Order) => F[Order]
  ) extends StoreService[F] {

        override def deleteOrder(orderId : String) : F[Unit] = {
          deleteOrderHandler(orderId)
        }

        override def getInventory() : F[Map[String, Int]] = {
          getInventoryHandler()
        }

        override def getOrderById(orderId : Long) : F[Order] = {
          getOrderByIdHandler(orderId)
        }

        override def placeOrder(order : Order) : F[Order] = {
          placeOrderHandler(order)
        }
  }

  def apply() : StoreService[Try] = StoreService.Handler[Try](
        (_) => notImplemented("deleteOrder"), 
        () => notImplemented("getInventory"), 
        (_) => notImplemented("getOrderById"), 
        (_) => notImplemented("placeOrder")
  )

  private def notImplemented(name : String) = Failure(new Exception(s"TODO: $name not implemented"))
}

/**
 * The Store business-logic
 *
 *
 * The 'asHandler' will return an implementation which allows for easily overriding individual operations.
 *
 * equally there are "on&lt;Function&gt;" helper methods for easily overriding individual functions
 *
 * @tparam F the effect type (Future, Try, IO, ID, etc) of the operations
 */
trait StoreService[F[_]] {
  /** Delete purchase order by ID
   * 
   * @return 
   */
  def deleteOrder(orderId : String) : F[Unit]

  /**
   * override deleteOrder with the given handler
   * @return a new implementation of StoreService[F] with deleteOrder overridden using the given handler
   */
  final def onDeleteOrder(handler : (orderId : String) => F[Unit]) : StoreService[F] = {
    asHandler.copy(deleteOrderHandler = handler)
  }
  /** Returns pet inventories by status
   * 
   * @return Map[String, Int]
   */
  def getInventory() : F[Map[String, Int]]

  /**
   * override getInventory with the given handler
   * @return a new implementation of StoreService[F] with getInventory overridden using the given handler
   */
  final def onGetInventory(handler : () => F[Map[String, Int]]) : StoreService[F] = {
    asHandler.copy(getInventoryHandler = handler)
  }
  /** Find purchase order by ID
   * 
   * @return Order
   */
  def getOrderById(orderId : Long) : F[Order]

  /**
   * override getOrderById with the given handler
   * @return a new implementation of StoreService[F] with getOrderById overridden using the given handler
   */
  final def onGetOrderById(handler : (orderId : Long) => F[Order]) : StoreService[F] = {
    asHandler.copy(getOrderByIdHandler = handler)
  }
  /** Place an order for a pet
   * 
   * @return Order
   */
  def placeOrder(order : Order) : F[Order]

  /**
   * override placeOrder with the given handler
   * @return a new implementation of StoreService[F] with placeOrder overridden using the given handler
   */
  final def onPlaceOrder(handler : (order : Order) => F[Order]) : StoreService[F] = {
    asHandler.copy(placeOrderHandler = handler)
  }

  /**
   * @return a Handler implementation of this service
   */
  final def asHandler : StoreService.Handler[F] = this match {
      case h : StoreService.Handler[F] => h
      case _ =>
        StoreService.Handler[F](
              (orderId) => deleteOrder(orderId), 
              () => getInventory(), 
              (orderId) => getOrderById(orderId), 
              (order) => placeOrder(order)
        )
  }

  /**
   * This function will change the effect type of this service.
   *
   * It's not unlike a typical map operation from A => B, except we're not mapping
   * a type from A to B, but rather from F[A] => G[A] using the 'changeEffect' function.
   *
   * For, this could turn an asynchronous service (one which returns Future[_] types) into
   * a synchronous one (one which returns Try[_] types) by awaiting on the Future.
   *
   * It could change an IO type (like cats effect or ZIO) into an ID[A] which is just:
   * ```
   * type ID[A] => A
   * ```
   *
   * @tparam G the new "polymorphic" effect type
   * @param changeEffect the "natural transformation" which can change one effect type into another
   * @return a new StoreService service implementation with effect type [G]
   */
  final def mapEffect[G[_]](changeEffect : [A] => F[A] => G[A]) : StoreService[G] = {
    val self = this

    new StoreService[G] {
        override def deleteOrder(orderId : String) : G[Unit] = changeEffect {
          self.deleteOrder(orderId)
        }
        override def getInventory() : G[Map[String, Int]] = changeEffect {
          self.getInventory()
        }
        override def getOrderById(orderId : Long) : G[Order] = changeEffect {
          self.getOrderById(orderId)
        }
        override def placeOrder(order : Order) : G[Order] = changeEffect {
          self.placeOrder(order)
        }
    }
  }
}
