//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// generated from apiService.mustache
package sample.cask.api

import _root_.sample.cask.model.OneOfRequestAndResponse200Response
import _root_.sample.cask.model.OneOfRequestAndResponseRequest
import scala.util.Failure
import scala.util.Try
import _root_.sample.cask.model.*

/**
 * The ComplexRouteService companion object.
 *
 * Use the ComplexRouteService() companion object to create an instance which returns a 'not implemented' error
 * for each operation.
 *
 */
object ComplexRouteService {

  /**
   * The 'Handler' is an implementation of ComplexRouteService convenient for delegating or overriding individual functions
   */
  case class Handler[F[_]](
        oneOfRequestAndResponseHandler : (oneOfRequestAndResponseRequest : OneOfRequestAndResponseRequest) => F[OneOfRequestAndResponse200Response]
  ) extends ComplexRouteService[F] {

        override def oneOfRequestAndResponse(oneOfRequestAndResponseRequest : OneOfRequestAndResponseRequest) : F[OneOfRequestAndResponse200Response] = {
          oneOfRequestAndResponseHandler(oneOfRequestAndResponseRequest)
        }
  }

  def apply() : ComplexRouteService[Try] = ComplexRouteService.Handler[Try](
        (_) => notImplemented("oneOfRequestAndResponse")
  )

  private def notImplemented(name : String) = Failure(new Exception(s"TODO: $name not implemented"))
}

/**
 * The ComplexRoute business-logic
 *
 *
 * The 'asHandler' will return an implementation which allows for easily overriding individual operations.
 *
 * equally there are "on&lt;Function&gt;" helper methods for easily overriding individual functions
 *
 * @tparam F the effect type (Future, Try, IO, ID, etc) of the operations
 */
trait ComplexRouteService[F[_]] {
  /** Example route with 'oneOf' content and response
   * 
   * @return OneOfRequestAndResponse200Response
   */
  def oneOfRequestAndResponse(oneOfRequestAndResponseRequest : OneOfRequestAndResponseRequest) : F[OneOfRequestAndResponse200Response]

  /**
   * override oneOfRequestAndResponse with the given handler
   * @return a new implementation of ComplexRouteService[F] with oneOfRequestAndResponse overridden using the given handler
   */
  final def onOneOfRequestAndResponse(handler : (oneOfRequestAndResponseRequest : OneOfRequestAndResponseRequest) => F[OneOfRequestAndResponse200Response]) : ComplexRouteService[F] = {
    asHandler.copy(oneOfRequestAndResponseHandler = handler)
  }

  /**
   * @return a Handler implementation of this service
   */
  final def asHandler : ComplexRouteService.Handler[F] = this match {
      case h : ComplexRouteService.Handler[F] => h
      case _ =>
        ComplexRouteService.Handler[F](
              (oneOfRequestAndResponseRequest) => oneOfRequestAndResponse(oneOfRequestAndResponseRequest)
        )
  }

  /**
   * This function will change the effect type of this service.
   *
   * It's not unlike a typical map operation from A => B, except we're not mapping
   * a type from A to B, but rather from F[A] => G[A] using the 'changeEffect' function.
   *
   * For, this could turn an asynchronous service (one which returns Future[_] types) into
   * a synchronous one (one which returns Try[_] types) by awaiting on the Future.
   *
   * It could change an IO type (like cats effect or ZIO) into an ID[A] which is just:
   * ```
   * type ID[A] => A
   * ```
   *
   * @tparam G the new "polymorphic" effect type
   * @param changeEffect the "natural transformation" which can change one effect type into another
   * @return a new ComplexRouteService service implementation with effect type [G]
   */
  final def mapEffect[G[_]](changeEffect : [A] => F[A] => G[A]) : ComplexRouteService[G] = {
    val self = this

    new ComplexRouteService[G] {
        override def oneOfRequestAndResponse(oneOfRequestAndResponseRequest : OneOfRequestAndResponseRequest) : G[OneOfRequestAndResponse200Response] = changeEffect {
          self.oneOfRequestAndResponse(oneOfRequestAndResponseRequest)
        }
    }
  }
}
