//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// this is generated from apiRoutes.mustache
package sample.cask.api

import sample.cask.model.*

import upickle.default.{ReadWriter => RW, macroRW}
import upickle.default.*
import scala.util.Try

import java.time.OffsetDateTime
import sample.cask.model.User

class UserRoutes(service : UserService[Try]) extends cask.Routes {

    // route group for routeWorkAroundForGETUser
    @cask.get("/user", true)
    def routeWorkAroundForGETUser(request: cask.Request,username : Option[String] = None,password : Option[String] = None) = {
        request.remainingPathSegments match {
            case Seq("login") => loginUser(request,username.getOrElse(""), password.getOrElse(""))
            case Seq("logout") => logoutUser(request)
            case Seq(username) => getUserByName(username,request)
            case _          => cask.Response("Not Found", statusCode = 404)
        }
    }

        /** Create user
         * 
         */
        @cask.post("/user")
        def createUser(request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
              userJson <- Parsed.fromTry(request.bodyAsJson)
              userData <- Parsed.eval(UserData.fromJson(userJson)) /* not array or map */
              user <- Parsed.fromTry(UserData.validated(userData, failFast))
            resultTry <- Parsed.eval(service.createUser(user))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Creates list of users with given input array
         * 
         */
        @cask.post("/user/createWithArray")
        def createUsersWithArrayInput(request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            user <- Parsed.fromTry(UserData.manyFromJsonStringValidated(request.bodyAsString)).mapError(e => s"Error parsing json as an array of User from >${request.bodyAsString}< : ${e}") /* array */
            resultTry <- Parsed.eval(service.createUsersWithArrayInput(user))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Creates list of users with given input array
         * 
         */
        @cask.post("/user/createWithList")
        def createUsersWithListInput(request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            user <- Parsed.fromTry(UserData.manyFromJsonStringValidated(request.bodyAsString)).mapError(e => s"Error parsing json as an array of User from >${request.bodyAsString}< : ${e}") /* array */
            resultTry <- Parsed.eval(service.createUsersWithListInput(user))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Delete user
         * 
         */
        @cask.delete("/user/:username")
        def deleteUser(username : String, request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            username <- Parsed(username)
            resultTry <- Parsed.eval(service.deleteUser(username))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Get user by user name
         * 
         */
        // conflicts with [/user/{username}, /user/login, /user/logout] after/user, ignoring @cask.get("/user/:username")
        def getUserByName(username : String, request: cask.Request) = {

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            username <- Parsed(username)
            resultTry <- Parsed.eval(service.getUserByName(username))
            result <- Parsed.fromTry(resultTry)
        } yield result

        import User.{given, *} // this brings in upickle in the case of union (oneOf) types

        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(value : User) => cask.Response(data = write(value), 200, headers = Seq("Content-Type" -> "application/json"))
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Logs user into the system
         * 
         */
        // conflicts with [/user/{username}, /user/login, /user/logout] after/user, ignoring @cask.get("/user/login")
        def loginUser(request: cask.Request, username : String, password : String) = {

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            resultTry <- Parsed.eval(service.loginUser(username, password))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(value : String) => cask.Response(data = write(value), 200, headers = Seq("Content-Type" -> "application/json"))
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Logs out current logged in user session
         * 
         */
        // conflicts with [/user/{username}, /user/login, /user/logout] after/user, ignoring @cask.get("/user/logout")
        def logoutUser(request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            resultTry <- Parsed.eval(service.logoutUser())
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Updated user
         * 
         */
        @cask.put("/user/:username")
        def updateUser(username : String, request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            username <- Parsed(username)
              userJson <- Parsed.fromTry(request.bodyAsJson)
              userData <- Parsed.eval(UserData.fromJson(userJson)) /* not array or map */
              user <- Parsed.fromTry(UserData.validated(userData, failFast))
            resultTry <- Parsed.eval(service.updateUser(username, user))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }

    initialize()
}
