//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.9.2"
//> using lib "com.lihaoyi::scalatags:0.8.2"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// this file was generated from app.mustache
package cask.groupId.server

import scala.util.Try
import _root_.sample.cask.model.*
import _root_.sample.cask.api.*

/**
 * This class was created with the intention of being extended by some runnable object,
 * passing in the custom business logic services
 */
class BaseApp(
    override val appComplexRouteService : ComplexRouteService[Try] = ComplexRouteService(),

    override val appPetService : PetService[Try] = PetService(),

    override val appStoreService : StoreService[Try] = StoreService(),

    override val appUserService : UserService[Try] = UserService(),
    override val port : Int = sys.env.get("PORT").map(_.toInt).getOrElse(8080)) extends cask.MainRoutes with AppRoutes {

    /** routes for the UI
     * Subclasses can override to turn this off
     */
    def openApiRoute: Option[cask.Routes] = Option(OpenApiRoutes(port))

    override def allRoutes = appRoutes ++ openApiRoute


    override def host: String = "0.0.0.0"

    def start() = locally {
        initialize()
        println(box(s""" 🚀 browse to localhost:$port 🚀
        |      host : $host
        |      port : $port
        |   verbose : $verbose
        | debugMode : $debugMode
        |""".stripMargin))

        // if java.awt.Desktop.isDesktopSupported then {
        //    java.awt.Desktop.getDesktop.browse(new java.net.URI(s"http://localhost:${port}"))
        // }
    }
}
