<?php
/**
 * ControllerTest
 * PHP version 8.1.1
 *
 * @category Class
 * @package  OpenAPI\Server\Tests\Controller
 * @author   openapi-generator contributors
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Please update the test case below to test the endpoint.
 */

namespace OpenAPI\Server\Tests\Controller;

use OpenAPI\Server\Controller\Controller;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Request;

/**
 * ControllerTest Class Doc Comment
 *
 * @category           Class
 * @package            OpenAPI\Server\Tests\Controller
 * @author             openapi-generator contributors
 * @link               https://github.com/openapitools/openapi-generator
 * @coversDefaultClass \OpenAPI\Server\Controller\Controller
 */
class ControllerTest extends TestCase
{
    /**
     * Tests isContentTypeAllowed static method.
     *
     * @covers ::isContentTypeAllowed
     * @dataProvider dataProviderIsContentTypeAllowed
     */
    public function testIsContentTypeAllowed(?string $contentType, array $consumes, bool $expectedReturn): void
    {
        $request = new Request();
        $request->headers->set('CONTENT_TYPE', $contentType);// last one argument overrides header
        $this->assertSame(
            $expectedReturn,
            Controller::isContentTypeAllowed($request, $consumes),
            sprintf(
                'Failed assertion that "Content-Type: %s" %s by [%s] consumes array.',
                $contentType,
                ($expectedReturn) ? 'is allowed' : 'is forbidden',
                implode(', ', $consumes)
            )
        );
    }

    public static function dataProviderIsContentTypeAllowed(): array
    {
        return [
            'usual JSON content type' => [
                'application/json',
                ['application/json'],
                true,
            ],
            'extended content type from PR #6078' => [
                'application/json; charset=utf-8',
                ['application/json'],
                true,
            ],
            'more than one content types' => [
                'application/json',
                ['application/xml', 'application/json; charset=utf-8'],
                true,
            ],
            'empty consumes array' => [
                'application/json',
                [],
                true,
            ],
            'empty consumes and content type' => [
                null,
                [],
                true,
            ],
            'consumes everything' => [
                'application/json',
                ['*/*'],
                true,
            ],
            'fancy custom content type' => [
                'foobar/foobaz',
                ['application/xml', 'foobar/foobaz; charset=utf-8'],
                true,
            ],
            'empty content type' => [
                null,
                ['application/xml', 'application/json; charset=utf-8'],
                false,
            ],
            'content type out of consumes' => [
                'text/html',
                ['application/xml', 'application/json; charset=utf-8'],
                false,
            ],
        ];
    }
}
