# OpenAPIServer
This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

This [Symfony](https://symfony.com/) bundle is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PhpSymfonyServerCodegen

## Requirements

PHP 8.0 and later

## Installation & Usage

To install the dependencies via [Composer](http://getcomposer.org/), add the following repository to `composer.json` of your Symfony project:

```json
{
    "repositories": [{
        "type": "path",
        "url": "//Path to your generated openapi bundle"
    }],
}
```

Then run:

```
composer require openapitools/petstore:dev-master
```

to add the generated openapi bundle as a dependency.

## Tests

To run the unit tests for the generated bundle, first navigate to the directory containing the code, then run the following commands:

```
composer install
./vendor/bin/phpunit
```


## Getting Started

Step 1: Please follow the [installation procedure](#installation--usage) first.

Step 2: Enable the bundle in the bundle configuration:

```php
// app/config/bundles.php
return [
    // ...
    OpenAPI\Server\OpenAPIServerBundle::class => ['all' => true],
];
```

Step 3: Register the routes:

```yaml
# app/config/routes.yaml
open_api_server:
    resource: "@OpenAPIServerBundle/Resources/config/routing.yaml"
```

Step 4: Implement the API calls:

```php
<?php
// src/Acme/MyBundle/Api/PetApi.php

namespace Acme\MyBundle\Api;

use OpenAPI\Server\Api\PetApiInterface;

class PetApi implements PetApiInterface // An interface is autogenerated
{

    /**
     * Configure OAuth2 access token for authorization: petstore_auth
     */
    public function setpetstore_auth($oauthToken)
    {
        // Retrieve logged in user from $oauthToken ...
    }
    
    /**
     * Implementation of PetApiInterface#addPet
     */
    public function addPet(Pet $pet, int &$responseCode, array &$responseHeaders): array|object|null
    {
        // Implement the operation ...
    }

    // Other operation methods ...
}
```

Step 5: Tag your API implementation:

```yaml
# config/services.yaml
services:
    # ...
    Acme\MyBundle\Api\PetApi:
        tags:
            - { name: "open_api_server.api", api: "pet" }
    # ...
```

Now you can start using the bundle!


## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApiInterface* | [**addPet**](docs/Api/PetApiInterface.md#addpet) | **POST** /pet | Add a new pet to the store
*PetApiInterface* | [**deletePet**](docs/Api/PetApiInterface.md#deletepet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApiInterface* | [**downloadFile**](docs/Api/PetApiInterface.md#downloadfile) | **GET** /pet/{petId}/downloadImage | downloads an image
*PetApiInterface* | [**findPetsByStatus**](docs/Api/PetApiInterface.md#findpetsbystatus) | **GET** /pet/findByStatus | Finds Pets by status
*PetApiInterface* | [**findPetsByTags**](docs/Api/PetApiInterface.md#findpetsbytags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApiInterface* | [**getPetById**](docs/Api/PetApiInterface.md#getpetbyid) | **GET** /pet/{petId} | Find pet by ID
*PetApiInterface* | [**petAge**](docs/Api/PetApiInterface.md#petage) | **GET** /pet/{petId}/age | Get the age of the pet
*PetApiInterface* | [**petAvailableForSale**](docs/Api/PetApiInterface.md#petavailableforsale) | **GET** /pet/{petId}/available-for-sale | Whether the pet can currently be bought
*PetApiInterface* | [**updatePet**](docs/Api/PetApiInterface.md#updatepet) | **PUT** /pet | Update an existing pet
*PetApiInterface* | [**updatePetWithForm**](docs/Api/PetApiInterface.md#updatepetwithform) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApiInterface* | [**uploadFile**](docs/Api/PetApiInterface.md#uploadfile) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApiInterface* | [**deleteOrder**](docs/Api/StoreApiInterface.md#deleteorder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApiInterface* | [**getInventory**](docs/Api/StoreApiInterface.md#getinventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApiInterface* | [**getOrderById**](docs/Api/StoreApiInterface.md#getorderbyid) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApiInterface* | [**placeOrder**](docs/Api/StoreApiInterface.md#placeorder) | **POST** /store/order | Place an order for a pet
*UserApiInterface* | [**createUser**](docs/Api/UserApiInterface.md#createuser) | **POST** /user | Create user
*UserApiInterface* | [**createUsersWithArrayInput**](docs/Api/UserApiInterface.md#createuserswitharrayinput) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApiInterface* | [**createUsersWithListInput**](docs/Api/UserApiInterface.md#createuserswithlistinput) | **POST** /user/createWithList | Creates list of users with given input array
*UserApiInterface* | [**deleteUser**](docs/Api/UserApiInterface.md#deleteuser) | **DELETE** /user/{username} | Delete user
*UserApiInterface* | [**getUserByName**](docs/Api/UserApiInterface.md#getuserbyname) | **GET** /user/{username} | Get user by user name
*UserApiInterface* | [**loginUser**](docs/Api/UserApiInterface.md#loginuser) | **GET** /user/login | Logs user into the system
*UserApiInterface* | [**logoutUser**](docs/Api/UserApiInterface.md#logoutuser) | **GET** /user/logout | Logs out current logged in user session
*UserApiInterface* | [**updateUser**](docs/Api/UserApiInterface.md#updateuser) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [ApiResponse](docs/Model/ApiResponse.md)
 - [Category](docs/Model/Category.md)
 - [EnumStringModel](docs/Model/EnumStringModel.md)
 - [Order](docs/Model/Order.md)
 - [Pet](docs/Model/Pet.md)
 - [Tag](docs/Model/Tag.md)
 - [User](docs/Model/User.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author



