<?php
/**
 * Pet
 *
 * PHP version 8.1.1
 *
 * @category Class
 * @package  OpenAPI\Server\Model
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace OpenAPI\Server\Model;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\Accessor;
use JMS\Serializer\Annotation\SerializedName;

/**
 * Class representing the Pet model.
 *
 * A pet for sale in the pet store
 *
 * @package OpenAPI\Server\Model
 * @author  OpenAPI Generator team
 */

class Pet 
{
        /**
     * @var int|null
     * @SerializedName("id")
     * @Type("int")
    */
    #[Assert\Type("int")]
    protected ?int $id = null;

    /**
     * @var Category|null
     * @SerializedName("category")
     * @Type("OpenAPI\Server\Model\Category")
    */
    #[Assert\Type("OpenAPI\Server\Model\Category")]
    protected ?Category $category = null;

    /**
     * @var string|null
     * @SerializedName("name")
     * @Type("string")
    */
    #[Assert\NotNull]
    #[Assert\Type("string")]
    protected ?string $name = null;

    /**
     * @var string[]|null
     * @SerializedName("photoUrls")
     * @Type("array<string>")
    */
    #[Assert\NotNull]
    #[Assert\All([
        new Assert\Type("string"),
    ])]
    protected ?array $photoUrls = null;

    /**
     * @var Tag[]|null
     * @SerializedName("tags")
     * @Type("array<OpenAPI\Server\Model\Tag>")
    */
    #[Assert\All([
        new Assert\Type("OpenAPI\Server\Model\Tag"),
    ])]
    protected ?array $tags = null;

    /**
     * pet status in the store
     *
     * @var string|null
     * @SerializedName("status")
     * @Type("string")
    */
    #[Assert\Choice(['available', 'pending', 'sold'])]
    #[Assert\Type("string")]
    protected ?string $status = null;

    /**
     * Constructor
     * @param array|null $data Associated array of property values initializing the model
     */
    public function __construct(?array $data = null)
    {
        if (is_array($data)) {
            $this->id = array_key_exists('id', $data) ? $data['id'] : $this->id;
            $this->category = array_key_exists('category', $data) ? $data['category'] : $this->category;
            $this->name = array_key_exists('name', $data) ? $data['name'] : $this->name;
            $this->photoUrls = array_key_exists('photoUrls', $data) ? $data['photoUrls'] : $this->photoUrls;
            $this->tags = array_key_exists('tags', $data) ? $data['tags'] : $this->tags;
            $this->status = array_key_exists('status', $data) ? $data['status'] : $this->status;
        }
    }

    /**
     * Gets id.
     *
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
    * Sets id.
    *
    * @param int|null $id
    *
    * @return $this
    */
    public function setId(?int $id = null): self
    {
        $this->id = $id;

        return $this;
    }




    /**
     * Gets category.
     *
     * @return Category|null
     */
    public function getCategory(): ?Category
    {
        return $this->category;
    }

    /**
    * Sets category.
    *
    * @param Category|null $category
    *
    * @return $this
    */
    public function setCategory(?Category $category = null): self
    {
        $this->category = $category;

        return $this;
    }




    /**
     * Gets name.
     *
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
    * Sets name.
    *
    * @param string|null $name
    *
    * @return $this
    */
    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }




    /**
     * Gets photoUrls.
     *
     * @return string[]|null
     */
    public function getPhotoUrls(): ?array
    {
        return $this->photoUrls;
    }

    /**
    * Sets photoUrls.
    *
    * @param string[]|null $photoUrls
    *
    * @return $this
    */
    public function setPhotoUrls(?array $photoUrls): self
    {
        $this->photoUrls = $photoUrls;

        return $this;
    }




    /**
     * Gets tags.
     *
     * @return Tag[]|null
     */
    public function getTags(): ?array
    {
        return $this->tags;
    }

    /**
    * Sets tags.
    *
    * @param Tag[]|null $tags
    *
    * @return $this
    */
    public function setTags(?array $tags = null): self
    {
        $this->tags = $tags;

        return $this;
    }




    /**
     * Gets status.
     *
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
    * Sets status.
    *
    * @param string|null $status  pet status in the store
    *
    * @return $this
    */
    public function setStatus(?string $status = null): self
    {
        $this->status = $status;

        return $this;
    }



}


