<?php

/**
 * OpenAPI Petstore
 * PHP version 8.1
 *
 * @package OpenAPIServer
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */
namespace OpenAPIServer\Auth;

use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Dyorg\TokenAuthentication\TokenSearch;
use Dyorg\TokenAuthentication\Exceptions\UnauthorizedExceptionInterface;

/**
 * AbstractAuthenticator Class Doc Comment
 *
 * @package OpenAPIServer\Auth
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */
abstract class AbstractAuthenticator
{
    /**
     * @var string[]|null List of required scopes
     */
    protected $requiredScope;

    /**
     * Verify if token is valid on database
     * If token isn't valid, expired or has insufficient scope must throw an UnauthorizedExceptionInterface
     *
     * @param string $token Api Key
     *
     * @return array User object or associative array
     * @throws UnauthorizedExceptionInterface on invalid token
     */
    abstract protected function getUserByToken(string $token);

    /**
     * Handles the response for unauthorized access attempts.
     * 
     * This method is called when an access token is either not provided, invalid, or expired.
     * It constructs a response that includes an error message, the status code, and any other relevant information.
     * 
     * @param ServerRequestInterface         $request The HTTP request that led to the unauthorized access attempt.
     * @param ResponseInterface              $response The response object that will be modified to reflect the unauthorized status.
     * @param UnauthorizedExceptionInterface $exception The exception triggered due to unauthorized access, containing details such as the error message.
     *
     * @return ResponseInterface The modified response object with the unauthorized access error information, including a 401 status code and a JSON body with the error message and token information.
     */
    public static function handleUnauthorized(ServerRequestInterface $request, ResponseInterface $response, UnauthorizedExceptionInterface $exception)
    {
        $output = [
            'message' => $exception->getMessage(),
            'token' => $request->getAttribute('authorization_token'),
            'success' => false
        ];
    
        $response->getBody()->write(json_encode($output));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus(401);
    }

    /**
     * Authenticator constructor
     *
     * @param string[]|null $requiredScope List of required scopes
     */
    public function __construct($requiredScope = null)
    {
        $this->requiredScope = $requiredScope;
    }

    /**
     * Makes the api key validation of your application
     *
     * Just an example of implementation. Override this method to fit your needs
     *
     * @param ServerRequestInterface $request     HTTP request
     * @param TokenSearch            $tokenSearch Middleware instance which contains api key in token
     *
     * @return bool Must return either true or false
     * @throws UnauthorizedExceptionInterface when cannot parse token
     */
    public function __invoke(ServerRequestInterface &$request, TokenSearch $tokenSearch)
    {
       /**
        * Try find authorization token via header, parameters, cookie or attribute
        * If token not found, return response with status 401 (unauthorized)
        */
        $token = $tokenSearch->getToken($request);

        /**
         * Verify if token is valid on database
         * If token isn't valid, expired or has insufficient scope must throw an UnauthorizedExceptionInterface
         */
        $user = $this->getUserByToken($token);

        /**
         * Set authenticated user at attributes
         */
        $request = $request->withAttribute('authenticated_user', $user);

        return true;
    }
}
