<?php declare(strict_types=1);

/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * PHP version 8.1
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 * Source files are located at:
 *
 * > https://github.com/OpenAPITools/openapi-generator/blob/master/modules/openapi-generator/src/main/resources/php-laravel/
 */


use Illuminate\Support\Facades\Route;

/**
 * PATCH call123TestSpecialTags
 * Summary: To test special tags
 * Notes: To test special tags and operation ID starting with number
 */
Route::PATCH('/v2/another-fake/dummy', [\OpenAPI\Server\Http\Controllers\AnotherFakeController::class, 'call123TestSpecialTags'])->name('anotherFake.call123.test.special.tags');

/**
 * GET fooGet
 * Summary: 
 * Notes: 
 */
Route::GET('/v2/foo', [\OpenAPI\Server\Http\Controllers\DefaultController::class, 'fooGet'])->name('default.foo.get');

/**
 * GET fakeBigDecimalMap
 * Summary: 
 * Notes: for Java apache and Java native, test toUrlQueryString for maps with BegDecimal keys
 */
Route::GET('/v2/fake/BigDecimalMap', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeBigDecimalMap'])->name('fake.fake.big.decimal.map');

/**
 * GET fakeHealthGet
 * Summary: Health check endpoint
 * Notes: 
 */
Route::GET('/v2/fake/health', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeHealthGet'])->name('fake.fake.health.get');

/**
 * GET fakeHttpSignatureTest
 * Summary: test http signature authentication
 * Notes: 
 */
Route::GET('/v2/fake/http-signature-test', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeHttpSignatureTest'])->name('fake.fake.http.signature.test');

/**
 * POST fakeOuterBooleanSerialize
 * Summary: 
 * Notes: Test serialization of outer boolean types
 */
Route::POST('/v2/fake/outer/boolean', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeOuterBooleanSerialize'])->name('fake.fake.outer.boolean.serialize');

/**
 * POST fakeOuterCompositeSerialize
 * Summary: 
 * Notes: Test serialization of object with outer number type
 */
Route::POST('/v2/fake/outer/composite', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeOuterCompositeSerialize'])->name('fake.fake.outer.composite.serialize');

/**
 * POST fakeOuterNumberSerialize
 * Summary: 
 * Notes: Test serialization of outer number types
 */
Route::POST('/v2/fake/outer/number', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeOuterNumberSerialize'])->name('fake.fake.outer.number.serialize');

/**
 * POST fakeOuterStringSerialize
 * Summary: 
 * Notes: Test serialization of outer string types
 */
Route::POST('/v2/fake/outer/string', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakeOuterStringSerialize'])->name('fake.fake.outer.string.serialize');

/**
 * POST fakePropertyEnumIntegerSerialize
 * Summary: 
 * Notes: Test serialization of enum (int) properties with examples
 */
Route::POST('/v2/fake/property/enum-int', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'fakePropertyEnumIntegerSerialize'])->name('fake.fake.property.enum.integer.serialize');

/**
 * POST testAdditionalPropertiesReference
 * Summary: test referenced additionalProperties
 * Notes: 
 */
Route::POST('/v2/fake/additionalProperties-reference', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testAdditionalPropertiesReference'])->name('fake.test.additional.properties.reference');

/**
 * PUT testBodyWithBinary
 * Summary: 
 * Notes: For this test, the body has to be a binary file.
 */
Route::PUT('/v2/fake/body-with-binary', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testBodyWithBinary'])->name('fake.test.body.with.binary');

/**
 * PUT testBodyWithFileSchema
 * Summary: 
 * Notes: For this test, the body for this request must reference a schema named &#x60;File&#x60;.
 */
Route::PUT('/v2/fake/body-with-file-schema', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testBodyWithFileSchema'])->name('fake.test.body.with.file.schema');

/**
 * PUT testBodyWithQueryParams
 * Summary: 
 * Notes: 
 */
Route::PUT('/v2/fake/body-with-query-params', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testBodyWithQueryParams'])->name('fake.test.body.with.query.params');

/**
 * PATCH testClientModel
 * Summary: To test \&quot;client\&quot; model
 * Notes: To test \&quot;client\&quot; model
 */
Route::PATCH('/v2/fake', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testClientModel'])->name('fake.test.client.model');

/**
 * POST testEndpointParameters
 * Summary: Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
 * Notes: Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
 */
Route::POST('/v2/fake', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testEndpointParameters'])->name('fake.test.endpoint.parameters');

/**
 * GET testEnumParameters
 * Summary: To test enum parameters
 * Notes: To test enum parameters
 */
Route::GET('/v2/fake', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testEnumParameters'])->name('fake.test.enum.parameters');

/**
 * DELETE testGroupParameters
 * Summary: Fake endpoint to test group parameters (optional)
 * Notes: Fake endpoint to test group parameters (optional)
 */
Route::DELETE('/v2/fake', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testGroupParameters'])->name('fake.test.group.parameters');

/**
 * POST testInlineAdditionalProperties
 * Summary: test inline additionalProperties
 * Notes: 
 */
Route::POST('/v2/fake/inline-additionalProperties', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testInlineAdditionalProperties'])->name('fake.test.inline.additional.properties');

/**
 * POST testInlineFreeformAdditionalProperties
 * Summary: test inline free-form additionalProperties
 * Notes: 
 */
Route::POST('/v2/fake/inline-freeform-additionalProperties', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testInlineFreeformAdditionalProperties'])->name('fake.test.inline.freeform.additional.properties');

/**
 * GET testJsonFormData
 * Summary: test json serialization of form data
 * Notes: 
 */
Route::GET('/v2/fake/jsonFormData', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testJsonFormData'])->name('fake.test.json.form.data');

/**
 * POST testNullable
 * Summary: test nullable parent property
 * Notes: 
 */
Route::POST('/v2/fake/nullable', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testNullable'])->name('fake.test.nullable');

/**
 * PUT testQueryParameterCollectionFormat
 * Summary: 
 * Notes: To test the collection format in query parameters
 */
Route::PUT('/v2/fake/test-query-parameters', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testQueryParameterCollectionFormat'])->name('fake.test.query.parameter.collection.format');

/**
 * POST testStringMapReference
 * Summary: test referenced string map
 * Notes: 
 */
Route::POST('/v2/fake/stringMap-reference', [\OpenAPI\Server\Http\Controllers\FakeController::class, 'testStringMapReference'])->name('fake.test.string.map.reference');

/**
 * PATCH testClassname
 * Summary: To test class name in snake case
 * Notes: To test class name in snake case
 */
Route::PATCH('/v2/fake_classname_test', [\OpenAPI\Server\Http\Controllers\FakeClassnameTags123Controller::class, 'testClassname'])->name('fakeClassnameTags123.test.classname');

/**
 * POST addPet
 * Summary: Add a new pet to the store
 * Notes: 
 */
Route::POST('/v2/pet', [\OpenAPI\Server\Http\Controllers\PetController::class, 'addPet'])->name('pet.add.pet');

/**
 * DELETE deletePet
 * Summary: Deletes a pet
 * Notes: 
 */
Route::DELETE('/v2/pet/{petId}', [\OpenAPI\Server\Http\Controllers\PetController::class, 'deletePet'])->name('pet.delete.pet');

/**
 * GET findPetsByStatus
 * Summary: Finds Pets by status
 * Notes: Multiple status values can be provided with comma separated strings
 */
Route::GET('/v2/pet/findByStatus', [\OpenAPI\Server\Http\Controllers\PetController::class, 'findPetsByStatus'])->name('pet.find.pets.by.status');

/**
 * GET findPetsByTags
 * Summary: Finds Pets by tags
 * Notes: Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
 */
Route::GET('/v2/pet/findByTags', [\OpenAPI\Server\Http\Controllers\PetController::class, 'findPetsByTags'])->name('pet.find.pets.by.tags');

/**
 * GET getPetById
 * Summary: Find pet by ID
 * Notes: Returns a single pet
 */
Route::GET('/v2/pet/{petId}', [\OpenAPI\Server\Http\Controllers\PetController::class, 'getPetById'])->name('pet.get.pet.by.id');

/**
 * PUT updatePet
 * Summary: Update an existing pet
 * Notes: 
 */
Route::PUT('/v2/pet', [\OpenAPI\Server\Http\Controllers\PetController::class, 'updatePet'])->name('pet.update.pet');

/**
 * POST updatePetWithForm
 * Summary: Updates a pet in the store with form data
 * Notes: 
 */
Route::POST('/v2/pet/{petId}', [\OpenAPI\Server\Http\Controllers\PetController::class, 'updatePetWithForm'])->name('pet.update.pet.with.form');

/**
 * POST uploadFile
 * Summary: uploads an image
 * Notes: 
 */
Route::POST('/v2/pet/{petId}/uploadImage', [\OpenAPI\Server\Http\Controllers\PetController::class, 'uploadFile'])->name('pet.upload.file');

/**
 * POST uploadFileWithRequiredFile
 * Summary: uploads an image (required)
 * Notes: 
 */
Route::POST('/v2/fake/{petId}/uploadImageWithRequiredFile', [\OpenAPI\Server\Http\Controllers\PetController::class, 'uploadFileWithRequiredFile'])->name('pet.upload.file.with.required.file');

/**
 * DELETE deleteOrder
 * Summary: Delete purchase order by ID
 * Notes: For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
 */
Route::DELETE('/v2/store/order/{order_id}', [\OpenAPI\Server\Http\Controllers\StoreController::class, 'deleteOrder'])->name('store.delete.order');

/**
 * GET getInventory
 * Summary: Returns pet inventories by status
 * Notes: Returns a map of status codes to quantities
 */
Route::GET('/v2/store/inventory', [\OpenAPI\Server\Http\Controllers\StoreController::class, 'getInventory'])->name('store.get.inventory');

/**
 * GET getOrderById
 * Summary: Find purchase order by ID
 * Notes: For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generate exceptions
 */
Route::GET('/v2/store/order/{order_id}', [\OpenAPI\Server\Http\Controllers\StoreController::class, 'getOrderById'])->name('store.get.order.by.id');

/**
 * POST placeOrder
 * Summary: Place an order for a pet
 * Notes: 
 */
Route::POST('/v2/store/order', [\OpenAPI\Server\Http\Controllers\StoreController::class, 'placeOrder'])->name('store.place.order');

/**
 * POST createUser
 * Summary: Create user
 * Notes: This can only be done by the logged in user.
 */
Route::POST('/v2/user', [\OpenAPI\Server\Http\Controllers\UserController::class, 'createUser'])->name('user.create.user');

/**
 * POST createUsersWithArrayInput
 * Summary: Creates list of users with given input array
 * Notes: 
 */
Route::POST('/v2/user/createWithArray', [\OpenAPI\Server\Http\Controllers\UserController::class, 'createUsersWithArrayInput'])->name('user.create.users.with.array.input');

/**
 * POST createUsersWithListInput
 * Summary: Creates list of users with given input array
 * Notes: 
 */
Route::POST('/v2/user/createWithList', [\OpenAPI\Server\Http\Controllers\UserController::class, 'createUsersWithListInput'])->name('user.create.users.with.list.input');

/**
 * DELETE deleteUser
 * Summary: Delete user
 * Notes: This can only be done by the logged in user.
 */
Route::DELETE('/v2/user/{username}', [\OpenAPI\Server\Http\Controllers\UserController::class, 'deleteUser'])->name('user.delete.user');

/**
 * GET getUserByName
 * Summary: Get user by user name
 * Notes: 
 */
Route::GET('/v2/user/{username}', [\OpenAPI\Server\Http\Controllers\UserController::class, 'getUserByName'])->name('user.get.user.by.name');

/**
 * GET loginUser
 * Summary: Logs user into the system
 * Notes: 
 */
Route::GET('/v2/user/login', [\OpenAPI\Server\Http\Controllers\UserController::class, 'loginUser'])->name('user.login.user');

/**
 * GET logoutUser
 * Summary: Logs out current logged in user session
 * Notes: 
 */
Route::GET('/v2/user/logout', [\OpenAPI\Server\Http\Controllers\UserController::class, 'logoutUser'])->name('user.logout.user');

/**
 * PUT updateUser
 * Summary: Updated user
 * Notes: This can only be done by the logged in user.
 */
Route::PUT('/v2/user/{username}', [\OpenAPI\Server\Http\Controllers\UserController::class, 'updateUser'])->name('user.update.user');

