<?php declare(strict_types=1);

/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * PHP version 8.1
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 * Source files are located at:
 *
 * > https://github.com/OpenAPITools/openapi-generator/blob/master/modules/openapi-generator/src/main/resources/php-laravel/
 */


namespace OpenAPI\Server\Http\Controllers;

use Crell\Serde\SerdeCommon;
use Illuminate\Routing\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


use OpenAPI\Server\Api\StoreApiInterface;

class StoreController extends Controller
{
    /**
     * Constructor
     */
    public function __construct(
        private readonly StoreApiInterface $api,
        private readonly SerdeCommon $serde = new SerdeCommon(),
    )
    {
    }

    /**
     * Operation deleteOrder
     *
     * Delete purchase order by ID.
     *
     */
    public function deleteOrder(Request $request, string $orderId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'orderId' => $orderId,
                ],
                $request->all(),
            ),
            [
                'orderId' => [
                    'required',
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }



        $apiResult = $this->api->deleteOrder($orderId);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation getInventory
     *
     * Returns pet inventories by status.
     *
     */
    public function getInventory(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $apiResult = $this->api->getInventory();

        if (is_array($apiResult)) {
            $serialized = array_map(fn ($item) => $this->serde->serialize($item, format: 'array'), $apiResult);
            return response()->json($serialized, 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation getOrderById
     *
     * Find purchase order by ID.
     *
     */
    public function getOrderById(Request $request, int $orderId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'orderId' => $orderId,
                ],
                $request->all(),
            ),
            [
                'orderId' => [
                    'required',
                    'gte:1',
                    'lte:5',
                    'integer',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }



        $apiResult = $this->api->getOrderById($orderId);

        if ($apiResult instanceof \OpenAPI\Server\Model\Order) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation placeOrder
     *
     * Place an order for a pet.
     *
     */
    public function placeOrder(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $order = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\Order::class);


        $apiResult = $this->api->placeOrder($order);

        if ($apiResult instanceof \OpenAPI\Server\Model\Order) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
}
