<?php declare(strict_types=1);

/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * PHP version 8.1
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 * Source files are located at:
 *
 * > https://github.com/OpenAPITools/openapi-generator/blob/master/modules/openapi-generator/src/main/resources/php-laravel/
 */


namespace OpenAPI\Server\Http\Controllers;

use Crell\Serde\SerdeCommon;
use Illuminate\Routing\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


use OpenAPI\Server\Api\FakeApiInterface;

class FakeController extends Controller
{
    /**
     * Constructor
     */
    public function __construct(
        private readonly FakeApiInterface $api,
        private readonly SerdeCommon $serde = new SerdeCommon(),
    )
    {
    }

    /**
     * Operation fakeBigDecimalMap
     *
     * .
     *
     */
    public function fakeBigDecimalMap(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $apiResult = $this->api->fakeBigDecimalMap();

        if ($apiResult instanceof \OpenAPI\Server\Model\FakeBigDecimalMap200Response) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakeHealthGet
     *
     * Health check endpoint.
     *
     */
    public function fakeHealthGet(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $apiResult = $this->api->fakeHealthGet();

        if ($apiResult instanceof \OpenAPI\Server\Model\HealthCheckResult) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakeHttpSignatureTest
     *
     * test http signature authentication.
     *
     */
    public function fakeHttpSignatureTest(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $pet = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\Pet::class);

        $query1 = $request->string('query1')->value();

        $header1 = $request->string('header1')->value();


        $apiResult = $this->api->fakeHttpSignatureTest($pet, $query1, $header1);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakeOuterBooleanSerialize
     *
     * .
     *
     */
    public function fakeOuterBooleanSerialize(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $body = $request->boolean('body');


        $apiResult = $this->api->fakeOuterBooleanSerialize($body);

        if ($apiResult instanceof bool) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakeOuterCompositeSerialize
     *
     * .
     *
     */
    public function fakeOuterCompositeSerialize(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $outerComposite = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\OuterComposite::class);


        $apiResult = $this->api->fakeOuterCompositeSerialize($outerComposite);

        if ($apiResult instanceof \OpenAPI\Server\Model\OuterComposite) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakeOuterNumberSerialize
     *
     * .
     *
     */
    public function fakeOuterNumberSerialize(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $body = $request->float('body');


        $apiResult = $this->api->fakeOuterNumberSerialize($body);

        if ($apiResult instanceof float) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakeOuterStringSerialize
     *
     * .
     *
     */
    public function fakeOuterStringSerialize(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $body = $request->string('body')->value();


        $apiResult = $this->api->fakeOuterStringSerialize($body);

        if ($apiResult instanceof string) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation fakePropertyEnumIntegerSerialize
     *
     * .
     *
     */
    public function fakePropertyEnumIntegerSerialize(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $outerObjectWithEnumProperty = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\OuterObjectWithEnumProperty::class);


        $apiResult = $this->api->fakePropertyEnumIntegerSerialize($outerObjectWithEnumProperty);

        if ($apiResult instanceof \OpenAPI\Server\Model\OuterObjectWithEnumProperty) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testAdditionalPropertiesReference
     *
     * test referenced additionalProperties.
     *
     */
    public function testAdditionalPropertiesReference(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $requestBody = $request->get('requestBody');


        $apiResult = $this->api->testAdditionalPropertiesReference($requestBody);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testBodyWithBinary
     *
     * .
     *
     */
    public function testBodyWithBinary(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $body = $request->file('body');


        $apiResult = $this->api->testBodyWithBinary($body);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testBodyWithFileSchema
     *
     * .
     *
     */
    public function testBodyWithFileSchema(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $fileSchemaTestClass = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\FileSchemaTestClass::class);


        $apiResult = $this->api->testBodyWithFileSchema($fileSchemaTestClass);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testBodyWithQueryParams
     *
     * .
     *
     */
    public function testBodyWithQueryParams(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $query = $request->string('query')->value();

        $user = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\User::class);


        $apiResult = $this->api->testBodyWithQueryParams($query, $user);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testClientModel
     *
     * To test \"client\" model.
     *
     */
    public function testClientModel(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $client = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\Client::class);


        $apiResult = $this->api->testClientModel($client);

        if ($apiResult instanceof \OpenAPI\Server\Model\Client) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testEndpointParameters
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트.
     *
     */
    public function testEndpointParameters(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'number' => [
                    'required',
                    'gte:32.1',
                    'lte:543.2',
                ],
                'double' => [
                    'required',
                    'gte:67.8',
                    'lte:123.4',
                ],
                'patternWithoutDelimiter' => [
                    'required',
                    'regex:/^[A-Z].*/',
                    'string',
                ],
                'byte' => [
                    'required',
                ],
                'integer' => [
                    'gte:10',
                    'lte:100',
                    'integer',
                ],
                'int32' => [
                    'gte:20',
                    'lte:200',
                    'integer',
                ],
                'int64' => [
                    'integer',
                ],
                'float' => [
                    'lte:987.6',
                ],
                'string' => [
                    'regex:/[a-z]/i',
                    'string',
                ],
                'binary' => [
                    'file',
                ],
                'date' => [
                ],
                'dateTime' => [
                    'date',
                ],
                'password' => [
                    'min:10',
                    'max:64',
                    'string',
                ],
                'callback' => [
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $number = $request->float('number');

        $double = $request->float('double');

        $patternWithoutDelimiter = $request->string('patternWithoutDelimiter')->value();

        $byte = $request->string('byte')->value();

        $integer = $request->integer('integer');

        $int32 = $request->integer('int32');

        $int64 = $request->integer('int64');

        $float = $request->float('float');

        $string = $request->string('string')->value();

        $binary = $request->file('binary');

        $date = $request->date('date');

        $dateTime = $request->date('dateTime');

        $password = $request->string('password')->value();

        $callback = $request->string('callback')->value();


        $apiResult = $this->api->testEndpointParameters($number, $double, $patternWithoutDelimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $dateTime, $password, $callback);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testEnumParameters
     *
     * To test enum parameters.
     *
     */
    public function testEnumParameters(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'enumHeaderStringArray' => [
                    'array',
                ],
                'enumHeaderString' => [
                ],
                'enumQueryStringArray' => [
                    'array',
                ],
                'enumQueryString' => [
                ],
                'enumQueryInteger' => [
                ],
                'enumQueryDouble' => [
                ],
                'enumQueryModelArray' => [
                    'array',
                ],
                'enumFormStringArray' => [
                    'array',
                ],
                'enumFormString' => [
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $enumHeaderStringArray = $request->get('enumHeaderStringArray');

        $enumHeaderString = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\TestEnumParametersEnumHeaderStringParameter::class);

        $enumQueryStringArray = $request->get('enumQueryStringArray');

        $enumQueryString = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\TestEnumParametersEnumHeaderStringParameter::class);

        $enumQueryInteger = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\TestEnumParametersEnumQueryIntegerParameter::class);

        $enumQueryDouble = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\TestEnumParametersEnumQueryDoubleParameter::class);

        $enumQueryModelArray = $request->get('enumQueryModelArray');

        $enumFormStringArray = $request->get('enumFormStringArray');

        $enumFormString = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\TestEnumParametersRequestEnumFormString::class);


        $apiResult = $this->api->testEnumParameters($enumHeaderStringArray, $enumHeaderString, $enumQueryStringArray, $enumQueryString, $enumQueryInteger, $enumQueryDouble, $enumQueryModelArray, $enumFormStringArray, $enumFormString);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testGroupParameters
     *
     * Fake endpoint to test group parameters (optional).
     *
     */
    public function testGroupParameters(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'requiredStringGroup' => [
                    'required',
                    'integer',
                ],
                'requiredBooleanGroup' => [
                    'required',
                    'boolean',
                ],
                'requiredInt64Group' => [
                    'required',
                    'integer',
                ],
                'stringGroup' => [
                    'integer',
                ],
                'booleanGroup' => [
                    'boolean',
                ],
                'int64Group' => [
                    'integer',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $requiredStringGroup = $request->integer('requiredStringGroup');

        $requiredBooleanGroup = $request->boolean('requiredBooleanGroup');

        $requiredInt64Group = $request->integer('requiredInt64Group');

        $stringGroup = $request->integer('stringGroup');

        $booleanGroup = $request->boolean('booleanGroup');

        $int64Group = $request->integer('int64Group');


        $apiResult = $this->api->testGroupParameters($requiredStringGroup, $requiredBooleanGroup, $requiredInt64Group, $stringGroup, $booleanGroup, $int64Group);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testInlineAdditionalProperties
     *
     * test inline additionalProperties.
     *
     */
    public function testInlineAdditionalProperties(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $requestBody = $request->get('requestBody');


        $apiResult = $this->api->testInlineAdditionalProperties($requestBody);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testInlineFreeformAdditionalProperties
     *
     * test inline free-form additionalProperties.
     *
     */
    public function testInlineFreeformAdditionalProperties(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $testInlineFreeformAdditionalPropertiesRequest = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\TestInlineFreeformAdditionalPropertiesRequest::class);


        $apiResult = $this->api->testInlineFreeformAdditionalProperties($testInlineFreeformAdditionalPropertiesRequest);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testJsonFormData
     *
     * test json serialization of form data.
     *
     */
    public function testJsonFormData(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'param' => [
                    'required',
                    'string',
                ],
                'param2' => [
                    'required',
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $param = $request->string('param')->value();

        $param2 = $request->string('param2')->value();


        $apiResult = $this->api->testJsonFormData($param, $param2);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testNullable
     *
     * test nullable parent property.
     *
     */
    public function testNullable(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $childWithNullable = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\ChildWithNullable::class);


        $apiResult = $this->api->testNullable($childWithNullable);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testQueryParameterCollectionFormat
     *
     * .
     *
     */
    public function testQueryParameterCollectionFormat(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'pipe' => [
                    'required',
                    'array',
                ],
                'ioutil' => [
                    'required',
                    'array',
                ],
                'http' => [
                    'required',
                    'array',
                ],
                'url' => [
                    'required',
                    'array',
                ],
                'context' => [
                    'required',
                    'array',
                ],
                'allowEmpty' => [
                    'required',
                    'string',
                ],
                'language' => [
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $pipe = $request->get('pipe');

        $ioutil = $request->get('ioutil');

        $http = $request->get('http');

        $url = $request->get('url');

        $context = $request->get('context');

        $allowEmpty = $request->string('allowEmpty')->value();

        $language = $request->get('language');


        $apiResult = $this->api->testQueryParameterCollectionFormat($pipe, $ioutil, $http, $url, $context, $allowEmpty, $language);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation testStringMapReference
     *
     * test referenced string map.
     *
     */
    public function testStringMapReference(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $requestBody = $request->get('requestBody');


        $apiResult = $this->api->testStringMapReference($requestBody);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
}
