<?php

/**
 * OpenAPI Petstore
 * PHP version 8.x
 *
 * @package OpenAPIServer
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

namespace OpenAPIServer;

class RegisterRoutes {

    static public function registerRoutes(\OpenAPIServer\Api\AbstractPetApi|\OpenAPIServer\Api\AbstractStoreApi|\OpenAPIServer\Api\AbstractUserApi $handler): void
    {
        $reflectionClass = new \ReflectionClass($handler);

        if (declaresMethod($reflectionClass, 'addPet') && declaresMethod($reflectionClass, 'addPetStream')) {
            throw new \Exception('Operation addPet cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'addPet')) {
            \Flight::route('POST /pet', function () use ($handler) {
                $r = \Flight::request();
                $result = $handler->addPet(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\Pet')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'addPetStream')) {
            \Flight::route('POST /pet', function () use ($handler) {
                $r = \Flight::request();
                $handler->addPetStream(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\Pet')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'deletePet') && declaresMethod($reflectionClass, 'deletePetStream')) {
            throw new \Exception('Operation deletePet cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'deletePet')) {
            \Flight::route('DELETE /pet/@petId', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $handler->deletePet(
                    parseParam($petId, 'int'),
                    parseParam($r->getHeader('api_key'), '?string')
                );
                \Flight::halt(400);
            });
        }
        if (declaresMethod($reflectionClass, 'deletePetStream')) {
            \Flight::route('DELETE /pet/@petId', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $handler->deletePetStream(
                    parseParam($petId, 'int'),
                    parseParam($r->getHeader('api_key'), '?string')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 400]);
        }

        if (declaresMethod($reflectionClass, 'findPetsByStatus') && declaresMethod($reflectionClass, 'findPetsByStatusStream')) {
            throw new \Exception('Operation findPetsByStatus cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'findPetsByStatus')) {
            \Flight::route('GET /pet/findByStatus', function () use ($handler) {
                $r = \Flight::request();
                $result = $handler->findPetsByStatus(
                    parseParam($r->query['status'] ?? null, '\\OpenAPIServer\\Model\\FindPetsByStatusStatusParameterInner[]')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'findPetsByStatusStream')) {
            \Flight::route('GET /pet/findByStatus', function () use ($handler) {
                $r = \Flight::request();
                $handler->findPetsByStatusStream(
                    parseParam($r->query['status'] ?? null, '\\OpenAPIServer\\Model\\FindPetsByStatusStatusParameterInner[]')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'findPetsByTags') && declaresMethod($reflectionClass, 'findPetsByTagsStream')) {
            throw new \Exception('Operation findPetsByTags cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'findPetsByTags')) {
            \Flight::route('GET /pet/findByTags', function () use ($handler) {
                $r = \Flight::request();
                $result = $handler->findPetsByTags(
                    parseParam($r->query['tags'] ?? null, 'string[]')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'findPetsByTagsStream')) {
            \Flight::route('GET /pet/findByTags', function () use ($handler) {
                $r = \Flight::request();
                $handler->findPetsByTagsStream(
                    parseParam($r->query['tags'] ?? null, 'string[]')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'getPetById') && declaresMethod($reflectionClass, 'getPetByIdStream')) {
            throw new \Exception('Operation getPetById cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'getPetById')) {
            \Flight::route('GET /pet/@petId', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $result = $handler->getPetById(
                    parseParam($petId, 'int')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'getPetByIdStream')) {
            \Flight::route('GET /pet/@petId', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $handler->getPetByIdStream(
                    parseParam($petId, 'int')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'updatePet') && declaresMethod($reflectionClass, 'updatePetStream')) {
            throw new \Exception('Operation updatePet cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'updatePet')) {
            \Flight::route('PUT /pet', function () use ($handler) {
                $r = \Flight::request();
                $result = $handler->updatePet(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\Pet')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'updatePetStream')) {
            \Flight::route('PUT /pet', function () use ($handler) {
                $r = \Flight::request();
                $handler->updatePetStream(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\Pet')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'updatePetWithForm') && declaresMethod($reflectionClass, 'updatePetWithFormStream')) {
            throw new \Exception('Operation updatePetWithForm cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'updatePetWithForm')) {
            \Flight::route('POST /pet/@petId', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $handler->updatePetWithForm(
                    parseParam($petId, 'int')
                );
                \Flight::halt(405);
            });
        }
        if (declaresMethod($reflectionClass, 'updatePetWithFormStream')) {
            \Flight::route('POST /pet/@petId', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $handler->updatePetWithFormStream(
                    parseParam($petId, 'int')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 405]);
        }

        if (declaresMethod($reflectionClass, 'uploadFile') && declaresMethod($reflectionClass, 'uploadFileStream')) {
            throw new \Exception('Operation uploadFile cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'uploadFile')) {
            \Flight::route('POST /pet/@petId/uploadImage', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $result = $handler->uploadFile(
                    parseParam($petId, 'int')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'uploadFileStream')) {
            \Flight::route('POST /pet/@petId/uploadImage', function (string $petId) use ($handler) {
                $r = \Flight::request();
                $handler->uploadFileStream(
                    parseParam($petId, 'int')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'deleteOrder') && declaresMethod($reflectionClass, 'deleteOrderStream')) {
            throw new \Exception('Operation deleteOrder cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'deleteOrder')) {
            \Flight::route('DELETE /store/order/@orderId', function (string $orderId) use ($handler) {
                $r = \Flight::request();
                $handler->deleteOrder(
                    parseParam($orderId, 'string')
                );
                \Flight::halt(400);
            });
        }
        if (declaresMethod($reflectionClass, 'deleteOrderStream')) {
            \Flight::route('DELETE /store/order/@orderId', function (string $orderId) use ($handler) {
                $r = \Flight::request();
                $handler->deleteOrderStream(
                    parseParam($orderId, 'string')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 400]);
        }

        if (declaresMethod($reflectionClass, 'getInventory') && declaresMethod($reflectionClass, 'getInventoryStream')) {
            throw new \Exception('Operation getInventory cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'getInventory')) {
            \Flight::route('GET /store/inventory', function () use ($handler) {
                $r = \Flight::request();
                $handler->getInventory(
                );
                \Flight::halt(200);
            });
        }
        if (declaresMethod($reflectionClass, 'getInventoryStream')) {
            \Flight::route('GET /store/inventory', function () use ($handler) {
                $r = \Flight::request();
                $handler->getInventoryStream(
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200]);
        }

        if (declaresMethod($reflectionClass, 'getOrderById') && declaresMethod($reflectionClass, 'getOrderByIdStream')) {
            throw new \Exception('Operation getOrderById cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'getOrderById')) {
            \Flight::route('GET /store/order/@orderId', function (string $orderId) use ($handler) {
                $r = \Flight::request();
                $result = $handler->getOrderById(
                    parseParam($orderId, 'int')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'getOrderByIdStream')) {
            \Flight::route('GET /store/order/@orderId', function (string $orderId) use ($handler) {
                $r = \Flight::request();
                $handler->getOrderByIdStream(
                    parseParam($orderId, 'int')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'placeOrder') && declaresMethod($reflectionClass, 'placeOrderStream')) {
            throw new \Exception('Operation placeOrder cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'placeOrder')) {
            \Flight::route('POST /store/order', function () use ($handler) {
                $r = \Flight::request();
                $result = $handler->placeOrder(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\Order')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'placeOrderStream')) {
            \Flight::route('POST /store/order', function () use ($handler) {
                $r = \Flight::request();
                $handler->placeOrderStream(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\Order')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'createUser') && declaresMethod($reflectionClass, 'createUserStream')) {
            throw new \Exception('Operation createUser cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'createUser')) {
            \Flight::route('POST /user', function () use ($handler) {
                $r = \Flight::request();
                $handler->createUser(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User')
                );
                \Flight::halt(200);
            });
        }
        if (declaresMethod($reflectionClass, 'createUserStream')) {
            \Flight::route('POST /user', function () use ($handler) {
                $r = \Flight::request();
                $handler->createUserStream(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200]);
        }

        if (declaresMethod($reflectionClass, 'createUsersWithArrayInput') && declaresMethod($reflectionClass, 'createUsersWithArrayInputStream')) {
            throw new \Exception('Operation createUsersWithArrayInput cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'createUsersWithArrayInput')) {
            \Flight::route('POST /user/createWithArray', function () use ($handler) {
                $r = \Flight::request();
                $handler->createUsersWithArrayInput(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User[]')
                );
                \Flight::halt(200);
            });
        }
        if (declaresMethod($reflectionClass, 'createUsersWithArrayInputStream')) {
            \Flight::route('POST /user/createWithArray', function () use ($handler) {
                $r = \Flight::request();
                $handler->createUsersWithArrayInputStream(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User[]')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200]);
        }

        if (declaresMethod($reflectionClass, 'createUsersWithListInput') && declaresMethod($reflectionClass, 'createUsersWithListInputStream')) {
            throw new \Exception('Operation createUsersWithListInput cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'createUsersWithListInput')) {
            \Flight::route('POST /user/createWithList', function () use ($handler) {
                $r = \Flight::request();
                $handler->createUsersWithListInput(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User[]')
                );
                \Flight::halt(200);
            });
        }
        if (declaresMethod($reflectionClass, 'createUsersWithListInputStream')) {
            \Flight::route('POST /user/createWithList', function () use ($handler) {
                $r = \Flight::request();
                $handler->createUsersWithListInputStream(
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User[]')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200]);
        }

        if (declaresMethod($reflectionClass, 'deleteUser') && declaresMethod($reflectionClass, 'deleteUserStream')) {
            throw new \Exception('Operation deleteUser cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'deleteUser')) {
            \Flight::route('DELETE /user/@username', function (string $username) use ($handler) {
                $r = \Flight::request();
                $handler->deleteUser(
                    parseParam($username, 'string')
                );
                \Flight::halt(400);
            });
        }
        if (declaresMethod($reflectionClass, 'deleteUserStream')) {
            \Flight::route('DELETE /user/@username', function (string $username) use ($handler) {
                $r = \Flight::request();
                $handler->deleteUserStream(
                    parseParam($username, 'string')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 400]);
        }

        if (declaresMethod($reflectionClass, 'getUserByName') && declaresMethod($reflectionClass, 'getUserByNameStream')) {
            throw new \Exception('Operation getUserByName cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'getUserByName')) {
            \Flight::route('GET /user/@username', function (string $username) use ($handler) {
                $r = \Flight::request();
                $result = $handler->getUserByName(
                    parseParam($username, 'string')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'getUserByNameStream')) {
            \Flight::route('GET /user/@username', function (string $username) use ($handler) {
                $r = \Flight::request();
                $handler->getUserByNameStream(
                    parseParam($username, 'string')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'loginUser') && declaresMethod($reflectionClass, 'loginUserStream')) {
            throw new \Exception('Operation loginUser cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'loginUser')) {
            \Flight::route('GET /user/login', function () use ($handler) {
                $r = \Flight::request();
                $result = $handler->loginUser(
                    parseParam($r->query['username'] ?? null, 'string'),
                    parseParam($r->query['password'] ?? null, 'string')
                );
                if ($result === null) {
                    \Flight::halt(200);
                } else {
                    \Flight::json($result, 200);
                }
            });
        }
        if (declaresMethod($reflectionClass, 'loginUserStream')) {
            \Flight::route('GET /user/login', function () use ($handler) {
                $r = \Flight::request();
                $handler->loginUserStream(
                    parseParam($r->query['username'] ?? null, 'string'),
                    parseParam($r->query['password'] ?? null, 'string')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200, 'Content-Type' => 'application/json']);
        }

        if (declaresMethod($reflectionClass, 'logoutUser') && declaresMethod($reflectionClass, 'logoutUserStream')) {
            throw new \Exception('Operation logoutUser cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'logoutUser')) {
            \Flight::route('GET /user/logout', function () use ($handler) {
                $r = \Flight::request();
                $handler->logoutUser(
                );
                \Flight::halt(200);
            });
        }
        if (declaresMethod($reflectionClass, 'logoutUserStream')) {
            \Flight::route('GET /user/logout', function () use ($handler) {
                $r = \Flight::request();
                $handler->logoutUserStream(
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 200]);
        }

        if (declaresMethod($reflectionClass, 'updateUser') && declaresMethod($reflectionClass, 'updateUserStream')) {
            throw new \Exception('Operation updateUser cannot be both streaming and non-streaming');
        }
        if (declaresMethod($reflectionClass, 'updateUser')) {
            \Flight::route('PUT /user/@username', function (string $username) use ($handler) {
                $r = \Flight::request();
                $handler->updateUser(
                    parseParam($username, 'string'),
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User')
                );
                \Flight::halt(400);
            });
        }
        if (declaresMethod($reflectionClass, 'updateUserStream')) {
            \Flight::route('PUT /user/@username', function (string $username) use ($handler) {
                $r = \Flight::request();
                $handler->updateUserStream(
                    parseParam($username, 'string'),
                    parseParam(json_decode($r->getBody(), true), '\\OpenAPIServer\\Model\\User')
                );
                // ignore return value: streaming expected
            })->streamWithHeaders(['status' => 400]);
        }

    }
}


function parseParam(mixed $param, string $type)
{
    $nonNullType = str_replace('?', '', $type);
    if ($param === null) {
        return null;
    } elseif ($nonNullType === 'int') {
        return intval($param);
    } elseif ($nonNullType === 'float') {
        return floatval($param);
    } elseif ($nonNullType === 'bool') {
        return filter_var($param, FILTER_VALIDATE_BOOLEAN);
    } elseif (str_ends_with($type, '[]')) {
        return array_map(fn($el) => parseParam($el, substr($type, 0, -2)), $param);
    } elseif (str_starts_with($nonNullType, '\\OpenAPIServer\\Model')) {
        if (enum_exists($nonNullType)) {
            return $nonNullType::tryFrom($param);
        }
        return $nonNullType::fromArray($param);
    } else {
        return $param;
    }
}

function declaresMethod(\ReflectionClass $reflectionClass, string $methodName): bool
{
    return $reflectionClass->hasMethod($methodName) && $reflectionClass->getMethod($methodName)->getDeclaringClass()->getName() === $reflectionClass->getName();
}
