<?php
/**
 * User
 *
 * PHP version 8.1.1
 *
 * @category Class
 * @package  OpenAPIServer\Model
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */


namespace OpenAPIServer\Model;

/**
 * Class representing the User model.
 *
 * A User who is purchasing from the pet store
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 */

class User  implements \JsonSerializable
{
        /**
     * @var int|null
     * @SerializedName("id")
     * @Assert\Type("int")
     * @Type("int")
     */
    public ?int $id;

    /**
     * @var string|null
     * @SerializedName("username")
     * @Assert\Type("string")
     * @Type("string")
     */
    public ?string $username;

    /**
     * @var string|null
     * @SerializedName("firstName")
     * @Assert\Type("string")
     * @Type("string")
     */
    public ?string $firstName;

    /**
     * @var string|null
     * @SerializedName("lastName")
     * @Assert\Type("string")
     * @Type("string")
     */
    public ?string $lastName;

    /**
     * @var string|null
     * @SerializedName("email")
     * @Assert\Type("string")
     * @Type("string")
     */
    public ?string $email;

    /**
     * @var string|null
     * @SerializedName("password")
     * @Assert\Type("string")
     * @Type("string")
     */
    public ?string $password;

    /**
     * @var string|null
     * @SerializedName("phone")
     * @Assert\Type("string")
     * @Type("string")
     */
    public ?string $phone;

    /**
     * User Status
     *
     * @var int|null
     * @SerializedName("userStatus")
     * @Assert\Type("int")
     * @Type("int")
     */
    public ?int $userStatus;

    /**
     * Constructor
     *
     * @param int|null $id
     * @param string|null $username
     * @param string|null $firstName
     * @param string|null $lastName
     * @param string|null $email
     * @param string|null $password
     * @param string|null $phone
     * @param int|null $userStatus
     */
    public function __construct(?int $id, ?string $username, ?string $firstName, ?string $lastName, ?string $email, ?string $password, ?string $phone, ?int $userStatus)
    {
        $this->id = $id;
        $this->username = $username;
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->email = $email;
        $this->password = $password;
        $this->phone = $phone;
        $this->userStatus = $userStatus;
    }

    public static function fromArray(array $data): self
    {
        return new self(
            $data['id'] ?? null,
            $data['username'] ?? null,
            $data['firstName'] ?? null,
            $data['lastName'] ?? null,
            $data['email'] ?? null,
            $data['password'] ?? null,
            $data['phone'] ?? null,
            $data['userStatus'] ?? null,
        );
    }

    public function jsonSerialize(): mixed {
        return [
            'id' => $this->id,
            'username' => $this->username,
            'firstName' => $this->firstName,
            'lastName' => $this->lastName,
            'email' => $this->email,
            'password' => $this->password,
            'phone' => $this->phone,
            'userStatus' => $this->userStatus,
        ];
    }
}


