<?php
/**
 * Pet
 *
 * PHP version 8.1.1
 *
 * @category Class
 * @package  OpenAPIServer\Model
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */


namespace OpenAPIServer\Model;

/**
 * Class representing the Pet model.
 *
 * A pet for sale in the pet store
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 */

class Pet  implements \JsonSerializable
{
        /**
     * @var int|null
     * @SerializedName("id")
     * @Assert\Type("int")
     * @Type("int")
     */
    public ?int $id;

    /**
     * @var Category|null
     * @SerializedName("category")
     * @Assert\Type("\OpenAPIServer\Model\Category")
     * @Type("\OpenAPIServer\Model\Category")
     */
    public ?Category $category;

    /**
     * @var string
     * @SerializedName("name")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     */
    public string $name;

    /**
     * @var string[]
     * @SerializedName("photoUrls")
     * @Assert\NotNull()
     * @Assert\All({
     *   @Assert\Type("string")
     * })
     * @Type("array<string>")
     */
    public array $photoUrls;

    /**
     * @var Tag[]|null
     * @SerializedName("tags")
     * @Assert\All({
     *   @Assert\Type("\OpenAPIServer\Model\Tag")
     * })
     * @Type("array<\OpenAPIServer\Model\Tag>")
     */
    public ?array $tags;

    /**
     * @var PetStatus|null
     * @SerializedName("status")
        * @Accessor(getter="getSerializedStatus")
        * @Type("string")
     */
    public ?PetStatus $status;

    /**
     * Constructor
     *
     * @param int|null $id
     * @param Category|null $category
     * @param string $name
     * @param string[] $photoUrls
     * @param Tag[]|null $tags
     * @param PetStatus|null $status
     */
    public function __construct(?int $id, ?Category $category, string $name, array $photoUrls, ?array $tags, ?PetStatus $status)
    {
        $this->id = $id;
        $this->category = $category;
        $this->name = $name;
        $this->photoUrls = $photoUrls;
        $this->tags = $tags;
        $this->status = $status;
    }

    public static function fromArray(array $data): self
    {
        return new self(
            $data['id'] ?? null,
            isset($data['category']) ? Category::fromArray($data['category']) : null,
            $data['name'] ?? null,
            $data['photoUrls'] ?? null,
            isset($data['tags']) ? array_map(fn($item) => Tag::fromArray($item), $data['tags']) : null,
            isset($data['status']) ? PetStatus::tryFrom($data['status']) : null,
        );
    }

    public function jsonSerialize(): mixed {
        return [
            'id' => $this->id,
            'category' => $this->category,
            'name' => $this->name,
            'photoUrls' => $this->photoUrls,
            'tags' => $this->tags,
            'status' => $this->status,
        ];
    }
}


