package org.openapitools.model

import java.util.Objects
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.annotation.JsonSubTypes
import com.fasterxml.jackson.annotation.JsonTypeInfo
import com.fasterxml.jackson.annotation.JsonValue
import org.openapitools.model.Category
import org.openapitools.model.Color
import org.openapitools.model.Tag
import java.io.Serializable
import javax.validation.constraints.DecimalMax
import javax.validation.constraints.DecimalMin
import javax.validation.constraints.Email
import javax.validation.constraints.Max
import javax.validation.constraints.Min
import javax.validation.constraints.NotNull
import javax.validation.constraints.Pattern
import javax.validation.constraints.Size
import javax.validation.Valid
import io.swagger.annotations.ApiModelProperty

/**
 * 
 * @param name 
 * @param photoUrls 
 * @param petType 
 * @param id 
 * @param category 
 * @param tags 
 * @param color 
 */
@JsonIgnoreProperties(
  value = ["petType"], // ignore manually set petType, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the petType to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "petType", visible = true)
@JsonSubTypes(
      JsonSubTypes.Type(value = Cat::class, name = "Cat"),
      JsonSubTypes.Type(value = Dog::class, name = "Dog")
)

interface Pet : Serializable, com.some.pack.Named, com.some.pack.WithCategory, com.some.pack.WithDefaultMethods {
        
        @get:ApiModelProperty(example = "null", required = true, value = "")
        override val name: kotlin.String

        
        @get:ApiModelProperty(example = "null", required = true, value = "")
        val photoUrls: kotlin.collections.List<kotlin.String>

        
        @get:ApiModelProperty(example = "null", required = true, value = "")
        val petType: kotlin.String

        
        @get:ApiModelProperty(example = "null", value = "")
        val id: kotlin.Long? 

        
        @get:ApiModelProperty(example = "null", value = "")
        override val category: Category? 

        
        @get:ApiModelProperty(example = "null", value = "")
        val tags: kotlin.collections.List<Tag>? 

        
        @get:ApiModelProperty(example = "null", value = "")
        val color: Color? 


    companion object {
        private const val serialVersionUID: kotlin.Long = 1
    }
}

