/**
* NOTE: Auto generated by OpenAPI Generator (7.20.0-SNAPSHOT)
* Spring 6 Declarative HTTP Interface
*/
package org.openapitools.api

import org.openapitools.model.User

import io.swagger.v3.oas.annotations.*
import io.swagger.v3.oas.annotations.enums.*
import io.swagger.v3.oas.annotations.media.*
import io.swagger.v3.oas.annotations.responses.*
import io.swagger.v3.oas.annotations.security.*

import org.springframework.web.service.annotation.*
import org.springframework.web.bind.annotation.*
import org.springframework.http.ResponseEntity

import org.springframework.validation.annotation.Validated
import jakarta.validation.Valid
import jakarta.validation.constraints.*

import reactor.core.publisher.Flux
import reactor.core.publisher.Mono

import kotlin.collections.List
import kotlin.collections.Map

@Validated
interface UserApi {

    @HttpExchange(
        url = PATH_CREATE_USER /* "/user" */,
        method = "POST"
    )
    fun createUser(
        @Parameter(description = "Created user object", required = true) @Valid @RequestBody user: User
    ): Mono<ResponseEntity<Unit>>


    @HttpExchange(
        url = PATH_CREATE_USERS_WITH_ARRAY_INPUT /* "/user/createWithArray" */,
        method = "POST"
    )
    fun createUsersWithArrayInput(
        @Parameter(description = "List of user object", required = true) @Valid @RequestBody user: kotlin.collections.List<User>
    ): Mono<ResponseEntity<Unit>>


    @HttpExchange(
        url = PATH_CREATE_USERS_WITH_LIST_INPUT /* "/user/createWithList" */,
        method = "POST"
    )
    fun createUsersWithListInput(
        @Parameter(description = "List of user object", required = true) @Valid @RequestBody user: kotlin.collections.List<User>
    ): Mono<ResponseEntity<Unit>>


    @HttpExchange(
        url = PATH_DELETE_USER /* "/user/{username}" */,
        method = "DELETE"
    )
    fun deleteUser(
        @Parameter(description = "The name that needs to be deleted", required = true) @PathVariable("username") username: kotlin.String
    ): Mono<ResponseEntity<Unit>>


    @HttpExchange(
        url = PATH_GET_USER_BY_NAME /* "/user/{username}" */,
        method = "GET"
    )
    fun getUserByName(
        @Parameter(description = "The name that needs to be fetched. Use user1 for testing.", required = true) @PathVariable("username") username: kotlin.String
    ): Mono<ResponseEntity<User>>


    @HttpExchange(
        url = PATH_LOGIN_USER /* "/user/login" */,
        method = "GET"
    )
    fun loginUser(
        @NotNull @Pattern(regexp="^[a-zA-Z0-9]+[a-zA-Z0-9\\.\\-_]*[a-zA-Z0-9]+$") @Parameter(description = "The user name for login", required = true) @Valid @RequestParam(value = "username", required = true) username: kotlin.String,
        @NotNull @Parameter(description = "The password for login in clear text", required = true) @Valid @RequestParam(value = "password", required = true) password: kotlin.String
    ): Mono<ResponseEntity<kotlin.String>>


    @HttpExchange(
        url = PATH_LOGOUT_USER /* "/user/logout" */,
        method = "GET"
    )
    fun logoutUser(
    ): Mono<ResponseEntity<Unit>>


    @HttpExchange(
        url = PATH_UPDATE_USER /* "/user/{username}" */,
        method = "PUT"
    )
    fun updateUser(
        @Parameter(description = "name that need to be deleted", required = true) @PathVariable("username") username: kotlin.String,
        @Parameter(description = "Updated user object", required = true) @Valid @RequestBody user: User
    ): Mono<ResponseEntity<Unit>>


    companion object {
        //for your own safety never directly reuse these path definitions in tests
        const val PATH_CREATE_USER: String = "/user"
        const val PATH_CREATE_USERS_WITH_ARRAY_INPUT: String = "/user/createWithArray"
        const val PATH_CREATE_USERS_WITH_LIST_INPUT: String = "/user/createWithList"
        const val PATH_DELETE_USER: String = "/user/{username}"
        const val PATH_GET_USER_BY_NAME: String = "/user/{username}"
        const val PATH_LOGIN_USER: String = "/user/login"
        const val PATH_LOGOUT_USER: String = "/user/logout"
        const val PATH_UPDATE_USER: String = "/user/{username}"
    }
}
