# This file was generated by the Julia OpenAPI Code Generator
# Do not modify this file directly. Modify the OpenAPI specification instead.


function add_pet_read(handler)
    function add_pet_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        openapi_params["Pet"] = OpenAPI.Servers.to_param_type(Pet, String(req.body))
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function add_pet_validate(handler)
    function add_pet_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "add_pet"
        
        n = "Pet"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function add_pet_invoke(impl; post_invoke=nothing)
    function add_pet_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.add_pet(req::HTTP.Request, openapi_params["Pet"];)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function delete_pet_read(handler)
    function delete_pet_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        path_params = HTTP.getparams(req)
        openapi_params["petId"] = OpenAPI.Servers.to_param(Int64, path_params, "petId", required=true, )
        headers = Dict{String,String}(HTTP.headers(req))
        openapi_params["api_key"] = OpenAPI.Servers.to_param(String, headers, "api_key", )
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function delete_pet_validate(handler)
    function delete_pet_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "delete_pet"
        
        n = "petId"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end
        
        n = "api_key"
        v = get(openapi_params, n, nothing)
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function delete_pet_invoke(impl; post_invoke=nothing)
    function delete_pet_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.delete_pet(req::HTTP.Request, openapi_params["petId"]; api_key=get(openapi_params, "api_key", nothing),)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function find_pets_by_status_read(handler)
    function find_pets_by_status_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        query_params = HTTP.queryparams(URIs.URI(req.target))
        openapi_params["status"] = OpenAPI.Servers.to_param(Vector{String}, query_params, "status", required=true, style="form", is_explode=false)
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function find_pets_by_status_validate(handler)
    function find_pets_by_status_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "find_pets_by_status"
        
        n = "status"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function find_pets_by_status_invoke(impl; post_invoke=nothing)
    function find_pets_by_status_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.find_pets_by_status(req::HTTP.Request, openapi_params["status"];)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function find_pets_by_tags_read(handler)
    function find_pets_by_tags_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        query_params = HTTP.queryparams(URIs.URI(req.target))
        openapi_params["tags"] = OpenAPI.Servers.to_param(Vector{String}, query_params, "tags", required=true, style="form", is_explode=false)
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function find_pets_by_tags_validate(handler)
    function find_pets_by_tags_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "find_pets_by_tags"
        
        n = "tags"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function find_pets_by_tags_invoke(impl; post_invoke=nothing)
    function find_pets_by_tags_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.find_pets_by_tags(req::HTTP.Request, openapi_params["tags"];)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function get_pet_by_id_read(handler)
    function get_pet_by_id_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        path_params = HTTP.getparams(req)
        openapi_params["petId"] = OpenAPI.Servers.to_param(Int64, path_params, "petId", required=true, )
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function get_pet_by_id_validate(handler)
    function get_pet_by_id_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "get_pet_by_id"
        
        n = "petId"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function get_pet_by_id_invoke(impl; post_invoke=nothing)
    function get_pet_by_id_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.get_pet_by_id(req::HTTP.Request, openapi_params["petId"];)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function update_pet_read(handler)
    function update_pet_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        openapi_params["Pet"] = OpenAPI.Servers.to_param_type(Pet, String(req.body))
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function update_pet_validate(handler)
    function update_pet_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "update_pet"
        
        n = "Pet"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function update_pet_invoke(impl; post_invoke=nothing)
    function update_pet_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.update_pet(req::HTTP.Request, openapi_params["Pet"];)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function update_pet_with_form_read(handler)
    function update_pet_with_form_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        path_params = HTTP.getparams(req)
        openapi_params["petId"] = OpenAPI.Servers.to_param(Int64, path_params, "petId", required=true, )
        ismultipart = false
        form_data = ismultipart ? HTTP.parse_multipart_form(req) : HTTP.queryparams(String(copy(req.body)))
        openapi_params["name"] = OpenAPI.Servers.to_param(String, form_data, "name"; multipart=ismultipart, isfile=false, )
        openapi_params["status"] = OpenAPI.Servers.to_param(String, form_data, "status"; multipart=ismultipart, isfile=false, )
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function update_pet_with_form_validate(handler)
    function update_pet_with_form_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "update_pet_with_form"
        
        n = "petId"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end
        
        n = "name"
        v = get(openapi_params, n, nothing)
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end
        
        n = "status"
        v = get(openapi_params, n, nothing)
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function update_pet_with_form_invoke(impl; post_invoke=nothing)
    function update_pet_with_form_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.update_pet_with_form(req::HTTP.Request, openapi_params["petId"]; name=get(openapi_params, "name", nothing), status=get(openapi_params, "status", nothing),)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end

function upload_file_read(handler)
    function upload_file_read_handler(req::HTTP.Request)
        openapi_params = Dict{String,Any}()
        path_params = HTTP.getparams(req)
        openapi_params["petId"] = OpenAPI.Servers.to_param(Int64, path_params, "petId", required=true, )
        ismultipart = true
        form_data = ismultipart ? HTTP.parse_multipart_form(req) : HTTP.queryparams(String(copy(req.body)))
        openapi_params["additionalMetadata"] = OpenAPI.Servers.to_param(String, form_data, "additionalMetadata"; multipart=ismultipart, isfile=false, )
        openapi_params["file"] = OpenAPI.Servers.to_param(Vector{UInt8}, form_data, "file"; multipart=ismultipart, isfile=true, )
        req.context[:openapi_params] = openapi_params

        return handler(req)
    end
end

function upload_file_validate(handler)
    function upload_file_validate_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        op = "upload_file"
        
        n = "petId"
        v = get(openapi_params, n, nothing)
        isnothing(v) && throw(OpenAPI.ValidationException(;reason="missing parameter $n", operation_or_model=op))
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end
        
        n = "additionalMetadata"
        v = get(openapi_params, n, nothing)
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end
        
        n = "file"
        v = get(openapi_params, n, nothing)
        if !isnothing(v)
            if isa(v, OpenAPI.APIModel)
                OpenAPI.validate_properties(v)
                if !OpenAPI.check_required(v)
                    throw(OpenAPI.ValidationException(;reason="$n is missing required properties", operation_or_model=op))
                end
            end
        end

        return handler(req)
    end
end

function upload_file_invoke(impl; post_invoke=nothing)
    function upload_file_invoke_handler(req::HTTP.Request)
        openapi_params = req.context[:openapi_params]
        ret = impl.upload_file(req::HTTP.Request, openapi_params["petId"]; additional_metadata=get(openapi_params, "additionalMetadata", nothing), file=get(openapi_params, "file", nothing),)
        resp = OpenAPI.Servers.server_response(ret)
        return (post_invoke === nothing) ? resp : post_invoke(req, resp)
    end
end


function registerPetApi(router::HTTP.Router, impl; path_prefix::String="", optional_middlewares...)
    HTTP.register!(router, "POST", path_prefix * "/pet", OpenAPI.Servers.middleware(impl, add_pet_read, add_pet_validate, add_pet_invoke; optional_middlewares...))
    HTTP.register!(router, "DELETE", path_prefix * "/pet/{petId}", OpenAPI.Servers.middleware(impl, delete_pet_read, delete_pet_validate, delete_pet_invoke; optional_middlewares...))
    HTTP.register!(router, "GET", path_prefix * "/pet/findByStatus", OpenAPI.Servers.middleware(impl, find_pets_by_status_read, find_pets_by_status_validate, find_pets_by_status_invoke; optional_middlewares...))
    HTTP.register!(router, "GET", path_prefix * "/pet/findByTags", OpenAPI.Servers.middleware(impl, find_pets_by_tags_read, find_pets_by_tags_validate, find_pets_by_tags_invoke; optional_middlewares...))
    HTTP.register!(router, "GET", path_prefix * "/pet/{petId}", OpenAPI.Servers.middleware(impl, get_pet_by_id_read, get_pet_by_id_validate, get_pet_by_id_invoke; optional_middlewares...))
    HTTP.register!(router, "PUT", path_prefix * "/pet", OpenAPI.Servers.middleware(impl, update_pet_read, update_pet_validate, update_pet_invoke; optional_middlewares...))
    HTTP.register!(router, "POST", path_prefix * "/pet/{petId}", OpenAPI.Servers.middleware(impl, update_pet_with_form_read, update_pet_with_form_validate, update_pet_with_form_invoke; optional_middlewares...))
    HTTP.register!(router, "POST", path_prefix * "/pet/{petId}/uploadImage", OpenAPI.Servers.middleware(impl, upload_file_read, upload_file_validate, upload_file_invoke; optional_middlewares...))
    return router
end
