# This file was generated by the Julia OpenAPI Code Generator
# Do not modify this file directly. Modify the OpenAPI specification instead.


@doc raw"""
Encapsulates generated server code for OpenAPIGenPetStoreServer

The following server methods must be implemented:

- **uuid_default_value**
    - *invocation:* GET /fake/uuid_default_value_test
    - *signature:* uuid_default_value(req::HTTP.Request, uuid_parameter::String;) -> Nothing
- **add_pet**
    - *invocation:* POST /pet
    - *signature:* add_pet(req::HTTP.Request, pet::Pet;) -> Pet
- **delete_pet**
    - *invocation:* DELETE /pet/{petId}
    - *signature:* delete_pet(req::HTTP.Request, pet_id::Int64; api_key=nothing,) -> Nothing
- **find_pets_by_status**
    - *invocation:* GET /pet/findByStatus
    - *signature:* find_pets_by_status(req::HTTP.Request, status::Vector{String};) -> Vector{Pet}
- **find_pets_by_tags**
    - *invocation:* GET /pet/findByTags
    - *signature:* find_pets_by_tags(req::HTTP.Request, tags::Vector{String};) -> Vector{Pet}
- **get_pet_by_id**
    - *invocation:* GET /pet/{petId}
    - *signature:* get_pet_by_id(req::HTTP.Request, pet_id::Int64;) -> Pet
- **update_pet**
    - *invocation:* PUT /pet
    - *signature:* update_pet(req::HTTP.Request, pet::Pet;) -> Pet
- **update_pet_with_form**
    - *invocation:* POST /pet/{petId}
    - *signature:* update_pet_with_form(req::HTTP.Request, pet_id::Int64; name=nothing, status=nothing,) -> Nothing
- **upload_file**
    - *invocation:* POST /pet/{petId}/uploadImage
    - *signature:* upload_file(req::HTTP.Request, pet_id::Int64; additional_metadata=nothing, file=nothing,) -> ApiResponse
- **delete_order**
    - *invocation:* DELETE /store/order/{orderId}
    - *signature:* delete_order(req::HTTP.Request, order_id::String;) -> Nothing
- **get_inventory**
    - *invocation:* GET /store/inventory
    - *signature:* get_inventory(req::HTTP.Request;) -> Dict{String, Int64}
- **get_order_by_id**
    - *invocation:* GET /store/order/{orderId}
    - *signature:* get_order_by_id(req::HTTP.Request, order_id::Int64;) -> Order
- **place_order**
    - *invocation:* POST /store/order
    - *signature:* place_order(req::HTTP.Request, order::Order;) -> Order
- **create_user**
    - *invocation:* POST /user
    - *signature:* create_user(req::HTTP.Request, user::User;) -> Nothing
- **create_users_with_array_input**
    - *invocation:* POST /user/createWithArray
    - *signature:* create_users_with_array_input(req::HTTP.Request, user::Vector{User};) -> Nothing
- **create_users_with_list_input**
    - *invocation:* POST /user/createWithList
    - *signature:* create_users_with_list_input(req::HTTP.Request, user::Vector{User};) -> Nothing
- **delete_user**
    - *invocation:* DELETE /user/{username}
    - *signature:* delete_user(req::HTTP.Request, username::String;) -> Nothing
- **get_user_by_name**
    - *invocation:* GET /user/{username}
    - *signature:* get_user_by_name(req::HTTP.Request, username::String;) -> User
- **login_user**
    - *invocation:* GET /user/login
    - *signature:* login_user(req::HTTP.Request, username::String, password::String;) -> String
- **logout_user**
    - *invocation:* GET /user/logout
    - *signature:* logout_user(req::HTTP.Request;) -> Nothing
- **update_user**
    - *invocation:* PUT /user/{username}
    - *signature:* update_user(req::HTTP.Request, username::String, user::User;) -> Nothing
"""
module OpenAPIGenPetStoreServer

using HTTP
using URIs
using Dates
using TimeZones
using OpenAPI
using OpenAPI.Servers

const API_VERSION = "1.0.0"

include("modelincludes.jl")

include("apis/api_FakeApi.jl")
include("apis/api_PetApi.jl")
include("apis/api_StoreApi.jl")
include("apis/api_UserApi.jl")

"""
Register handlers for all APIs in this module in the supplied `Router` instance.

Paramerets:
- `router`: Router to register handlers in
- `impl`: module that implements the server methods

Optional parameters:
- `path_prefix`: prefix to be applied to all paths
- `optional_middlewares`: Register one or more optional middlewares to be applied to all requests.

Optional middlewares can be one or more of:
    - `init`: called before the request is processed
    - `pre_validation`: called after the request is parsed but before validation
    - `pre_invoke`: called after validation but before the handler is invoked
    - `post_invoke`: called after the handler is invoked but before the response is sent

The order in which middlewares are invoked are:
`init |> read |> pre_validation |> validate |> pre_invoke |> invoke |> post_invoke`
"""
function register(router::HTTP.Router, impl; path_prefix::String="", optional_middlewares...)
    registerFakeApi(router, impl; path_prefix=path_prefix, optional_middlewares...)
    registerPetApi(router, impl; path_prefix=path_prefix, optional_middlewares...)
    registerStoreApi(router, impl; path_prefix=path_prefix, optional_middlewares...)
    registerUserApi(router, impl; path_prefix=path_prefix, optional_middlewares...)
    return router
end

# export models
export AnotherModel
export ApiResponse
export Category
export Order
export Pet
export Tag
export User

end # module OpenAPIGenPetStoreServer
