/**
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (7.11.0-SNAPSHOT).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package org.openapitools.api;

import org.junit.jupiter.api.Test;
import org.apache.camel.test.spring.junit5.CamelSpringBootTest;
import org.springframework.boot.test.context.SpringBootTest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.HttpResponse;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;

@CamelSpringBootTest
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.DEFINED_PORT)
public class StoreApiTest {
    private static final String API_URL = "http://127.0.0.1:8080/api/v1";

    @Test
    public void getOrderByIdTestJson() throws Exception {
        String contentType = "application/json";
        String accept = "application/json";
        String url = API_URL + "/store/order/{orderId}";
        HttpRequest httpRequest = Unirest.get(url);
        httpRequest = httpRequest.header("Accept", accept);
        httpRequest = httpRequest.routeParam("orderId", "1");
        
        
        HttpResponse<JsonNode> httpResponse = httpRequest.asJson();
        Assertions.assertTrue(httpResponse.getStatus() < 400 || httpResponse.getStatus() == 415);
    }
    
    @Test
    public void getOrderByIdTestXml() throws Exception {
        String contentType = "application/xml";
        String accept = "application/xml";
        String url = API_URL + "/store/order/{orderId}";
        HttpRequest httpRequest = Unirest.get(url);
        httpRequest = httpRequest.header("Accept", accept);
        httpRequest = httpRequest.routeParam("orderId", "1");
        
        
        HttpResponse<String> httpResponse = httpRequest.asString();
        Assertions.assertTrue(httpResponse.getStatus() < 400 || httpResponse.getStatus() == 415);
    }
    @Test
    public void placeOrderTestJson() throws Exception {
        String contentType = "application/json";
        String accept = "application/json";
        String url = API_URL + "/store/order";
        HttpRequest httpRequest = Unirest.post(url);
        httpRequest = httpRequest.header("Content-Type", contentType);
        httpRequest = httpRequest.header("Accept", accept);
        
        String requestBody = "{ \"petId\" : 6, \"quantity\" : 1, \"id\" : 0, \"shipDate\" : \"2000-01-23T04:56:07.000+00:00\", \"complete\" : false, \"status\" : \"placed\" }";
        httpRequest = ((HttpRequestWithBody) httpRequest).body(requestBody).getHttpRequest();
        
        
        HttpResponse<JsonNode> httpResponse = httpRequest.asJson();
        Assertions.assertTrue(httpResponse.getStatus() < 400 || httpResponse.getStatus() == 415);
    }
    
    @Test
    public void placeOrderTestXml() throws Exception {
        String contentType = "application/xml";
        String accept = "application/xml";
        String url = API_URL + "/store/order";
        HttpRequest httpRequest = Unirest.post(url);
        httpRequest = httpRequest.header("Content-Type", contentType);
        httpRequest = httpRequest.header("Accept", accept);
        
        String requestBody = "<Order> <id>123456789</id> <petId>123456789</petId> <quantity>123</quantity> <shipDate>2000-01-23T04:56:07.000Z</shipDate> <status>aeiou</status> <complete>true</complete> </Order>";
        httpRequest = ((HttpRequestWithBody) httpRequest).body(requestBody).getHttpRequest();
        
        
        HttpResponse<String> httpResponse = httpRequest.asString();
        Assertions.assertTrue(httpResponse.getStatus() < 400 || httpResponse.getStatus() == 415);
    }
}