// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * API version: 1.0.0
 */

package petstoreserver

import (
	"encoding/json"
	"net/http"
	"strings"
	"time"
	"os"

	"github.com/go-chi/chi/v5"
)

// PetAPIController binds http requests to an api service and writes the service results to the http response
type PetAPIController struct {
	service PetAPIServicer
	errorHandler ErrorHandler
}

// PetAPIOption for how the controller is set up.
type PetAPIOption func(*PetAPIController)

// WithPetAPIErrorHandler inject ErrorHandler into controller
func WithPetAPIErrorHandler(h ErrorHandler) PetAPIOption {
	return func(c *PetAPIController) {
		c.errorHandler = h
	}
}

// NewPetAPIController creates a default api controller
func NewPetAPIController(s PetAPIServicer, opts ...PetAPIOption) *PetAPIController {
	controller := &PetAPIController{
		service:      s,
		errorHandler: DefaultErrorHandler,
	}

	for _, opt := range opts {
		opt(controller)
	}

	return controller
}

// Routes returns all the api routes for the PetAPIController
func (c *PetAPIController) Routes() Routes {
	return Routes{
		"UpdatePet": Route{
			"UpdatePet",
			strings.ToUpper("Put"),
			"/v2/pet",
			c.UpdatePet,
		},
		"AddPet": Route{
			"AddPet",
			strings.ToUpper("Post"),
			"/v2/pet",
			c.AddPet,
		},
		"FindPetsByStatus": Route{
			"FindPetsByStatus",
			strings.ToUpper("Get"),
			"/v2/pet/findByStatus",
			c.FindPetsByStatus,
		},
		"SearchPet": Route{
			"SearchPet",
			strings.ToUpper("Get"),
			"/v2/pet/searchPetWithManyFilters",
			c.SearchPet,
		},
		"FindPetsByTags": Route{
			"FindPetsByTags",
			strings.ToUpper("Get"),
			"/v2/pet/findByTags",
			c.FindPetsByTags,
		},
		"FilterPetsByCategory": Route{
			"FilterPetsByCategory",
			strings.ToUpper("Get"),
			"/v2/pet/filterPets/{gender}",
			c.FilterPetsByCategory,
		},
		"GetPetById": Route{
			"GetPetById",
			strings.ToUpper("Get"),
			"/v2/pet/{petId}",
			c.GetPetById,
		},
		"UpdatePetWithForm": Route{
			"UpdatePetWithForm",
			strings.ToUpper("Post"),
			"/v2/pet/{petId}",
			c.UpdatePetWithForm,
		},
		"DeletePet": Route{
			"DeletePet",
			strings.ToUpper("Delete"),
			"/v2/pet/{petId}",
			c.DeletePet,
		},
		"GetPetImageById": Route{
			"GetPetImageById",
			strings.ToUpper("Get"),
			"/v2/pet/{petId}/uploadImage",
			c.GetPetImageById,
		},
		"UploadFile": Route{
			"UploadFile",
			strings.ToUpper("Post"),
			"/v2/pet/{petId}/uploadImage",
			c.UploadFile,
		},
		"UploadFileArrayOfFiles": Route{
			"UploadFileArrayOfFiles",
			strings.ToUpper("Post"),
			"/v2/fake/uploadImage/array of_file",
			c.UploadFileArrayOfFiles,
		},
		"GetPetsUsingBooleanQueryParameters": Route{
			"GetPetsUsingBooleanQueryParameters",
			strings.ToUpper("Get"),
			"/v2/pets/boolean/parsing",
			c.GetPetsUsingBooleanQueryParameters,
		},
		"GetPetsByTime": Route{
			"GetPetsByTime",
			strings.ToUpper("Get"),
			"/v2/pets/byTime/{createdTime}",
			c.GetPetsByTime,
		},
	}
}

// OrderedRoutes returns all the api routes in a deterministic order for the PetAPIController
func (c *PetAPIController) OrderedRoutes() []Route {
	return []Route{
		Route{
			"UpdatePet",
			strings.ToUpper("Put"),
			"/v2/pet",
			c.UpdatePet,
		},
		Route{
			"AddPet",
			strings.ToUpper("Post"),
			"/v2/pet",
			c.AddPet,
		},
		Route{
			"FindPetsByStatus",
			strings.ToUpper("Get"),
			"/v2/pet/findByStatus",
			c.FindPetsByStatus,
		},
		Route{
			"SearchPet",
			strings.ToUpper("Get"),
			"/v2/pet/searchPetWithManyFilters",
			c.SearchPet,
		},
		Route{
			"FindPetsByTags",
			strings.ToUpper("Get"),
			"/v2/pet/findByTags",
			c.FindPetsByTags,
		},
		Route{
			"FilterPetsByCategory",
			strings.ToUpper("Get"),
			"/v2/pet/filterPets/{gender}",
			c.FilterPetsByCategory,
		},
		Route{
			"GetPetById",
			strings.ToUpper("Get"),
			"/v2/pet/{petId}",
			c.GetPetById,
		},
		Route{
			"UpdatePetWithForm",
			strings.ToUpper("Post"),
			"/v2/pet/{petId}",
			c.UpdatePetWithForm,
		},
		Route{
			"DeletePet",
			strings.ToUpper("Delete"),
			"/v2/pet/{petId}",
			c.DeletePet,
		},
		Route{
			"GetPetImageById",
			strings.ToUpper("Get"),
			"/v2/pet/{petId}/uploadImage",
			c.GetPetImageById,
		},
		Route{
			"UploadFile",
			strings.ToUpper("Post"),
			"/v2/pet/{petId}/uploadImage",
			c.UploadFile,
		},
		Route{
			"UploadFileArrayOfFiles",
			strings.ToUpper("Post"),
			"/v2/fake/uploadImage/array of_file",
			c.UploadFileArrayOfFiles,
		},
		Route{
			"GetPetsUsingBooleanQueryParameters",
			strings.ToUpper("Get"),
			"/v2/pets/boolean/parsing",
			c.GetPetsUsingBooleanQueryParameters,
		},
		Route{
			"GetPetsByTime",
			strings.ToUpper("Get"),
			"/v2/pets/byTime/{createdTime}",
			c.GetPetsByTime,
		},
	}
}



// UpdatePet - Update an existing pet
func (c *PetAPIController) UpdatePet(w http.ResponseWriter, r *http.Request) {
	var petParam Pet
	d := json.NewDecoder(r.Body)
	d.DisallowUnknownFields()
	if err := d.Decode(&petParam); err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	if err := AssertPetRequired(petParam); err != nil {
		c.errorHandler(w, r, err, nil)
		return
	}
	if err := AssertPetConstraints(petParam); err != nil {
		c.errorHandler(w, r, err, nil)
		return
	}
	result, err := c.service.UpdatePet(r.Context(), petParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// AddPet - Add a new pet to the store
func (c *PetAPIController) AddPet(w http.ResponseWriter, r *http.Request) {
	var petParam Pet
	d := json.NewDecoder(r.Body)
	d.DisallowUnknownFields()
	if err := d.Decode(&petParam); err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	if err := AssertPetRequired(petParam); err != nil {
		c.errorHandler(w, r, err, nil)
		return
	}
	if err := AssertPetConstraints(petParam); err != nil {
		c.errorHandler(w, r, err, nil)
		return
	}
	result, err := c.service.AddPet(r.Context(), petParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// FindPetsByStatus - Finds Pets by status
func (c *PetAPIController) FindPetsByStatus(w http.ResponseWriter, r *http.Request) {
	query, err := parseQuery(r.URL.RawQuery)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	var statusParam []string
	if query.Has("status") {
		statusParam = strings.Split(query.Get("status"), ",")
	}
	inlineEnumPathParam := chi.URLParam(r, "inlineEnumPath")
	if inlineEnumPathParam == "" {
		c.errorHandler(w, r, &RequiredError{"inlineEnumPath"}, nil)
		return
	}
	var inlineEnumParam string
	if query.Has("inlineEnum") {
		param := query.Get("inlineEnum")

		inlineEnumParam = param
	} else {
	}
	var defaultIntParam int32
	if query.Has("defaultInt") {
		param, err := parseNumericParameter[int32](
			query.Get("defaultInt"),
			WithParse[int32](parseInt32),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "defaultInt", Err: err}, nil)
			return
		}

		defaultIntParam = param
	} else {
		var param int32 = 1
		defaultIntParam = param
	}
	var defaultNumParam float32
	if query.Has("defaultNum") {
		param, err := parseNumericParameter[float32](
			query.Get("defaultNum"),
			WithParse[float32](parseFloat32),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "defaultNum", Err: err}, nil)
			return
		}

		defaultNumParam = param
	} else {
		var param float32 = 1.5
		defaultNumParam = param
	}
	var defaultStrParam string
	if query.Has("defaultStr") {
		param := query.Get("defaultStr")

		defaultStrParam = param
	} else {
		param := "default"
		defaultStrParam = param
	}
	result, err := c.service.FindPetsByStatus(r.Context(), statusParam, inlineEnumPathParam, inlineEnumParam, defaultIntParam, defaultNumParam, defaultStrParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// SearchPet - Search Pets by filters
func (c *PetAPIController) SearchPet(w http.ResponseWriter, r *http.Request) {
	query, err := parseQuery(r.URL.RawQuery)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	var ageParam *int64
	if query.Has("age") {
		param, err := parseNumericParameter[int64](
			query.Get("age"),
			WithParse[int64](parseInt64),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "age", Err: err}, nil)
			return
		}

		ageParam = &param
	} else {
	}
	var priceParam *float32
	if query.Has("price") {
		param, err := parseNumericParameter[float32](
			query.Get("price"),
			WithParse[float32](parseFloat32),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "price", Err: err}, nil)
			return
		}

		priceParam = &param
	} else {
	}
	var bornAfterParam *time.Time
	if query.Has("bornAfter"){
		param, err := parseTime(query.Get("bornAfter"))
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "bornAfter", Err: err}, nil)
			return
		}

		bornAfterParam = &param
	} else {
	}
	var oldParam *bool
	if query.Has("old") {
		param, err := parseBoolParameter(
			query.Get("old"),
			WithParse[bool](parseBool),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "old", Err: err}, nil)
			return
		}

		oldParam = &param
	} else {
	}
	result, err := c.service.SearchPet(r.Context(), ageParam, priceParam, bornAfterParam, oldParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// FindPetsByTags - Finds Pets by tags
// Deprecated
func (c *PetAPIController) FindPetsByTags(w http.ResponseWriter, r *http.Request) {
	query, err := parseQuery(r.URL.RawQuery)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	var tagsParam []string
	if query.Has("tags") {
		tagsParam = strings.Split(query.Get("tags"), ",")
	}
	var bornAfterParam time.Time
	if query.Has("bornAfter"){
		param, err := parseTime(query.Get("bornAfter"))
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "bornAfter", Err: err}, nil)
			return
		}

		bornAfterParam = param
	} else {
		c.errorHandler(w, r, &RequiredError{"bornAfter"}, nil)
		return
	}
	var bornBeforeParam time.Time
	if query.Has("bornBefore"){
		param, err := parseTime(query.Get("bornBefore"))
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "bornBefore", Err: err}, nil)
			return
		}

		bornBeforeParam = param
	} else {
	}
	var colourParam Colour
	if query.Has("colour") {
		param := Colour(query.Get("colour"))

		colourParam = param
	} else {
	}
	result, err := c.service.FindPetsByTags(r.Context(), tagsParam, bornAfterParam, bornBeforeParam, colourParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// FilterPetsByCategory - Finds Pets
func (c *PetAPIController) FilterPetsByCategory(w http.ResponseWriter, r *http.Request) {
	query, err := parseQuery(r.URL.RawQuery)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	genderParam, err := NewGenderFromValue(chi.URLParam(r, "gender"))
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "gender", Err: err}, nil)
		return
	}
	var speciesParam Species
	if query.Has("species") {
		param := Species(query.Get("species"))

		speciesParam = param
	} else {
		c.errorHandler(w, r, &RequiredError{Field: "species"}, nil)
		return
	}
	var notSpeciesParam []Species
	if query.Has("notSpecies") {
		paramSplits := strings.Split(query.Get("notSpecies"), ",")
		notSpeciesParam = make([]Species, 0, len(paramSplits))
		for _, param := range paramSplits {
			paramEnum, err := NewSpeciesFromValue(param)
			if err != nil {
				c.errorHandler(w, r, &ParsingError{Param: "notSpecies", Err: err}, nil)
				return
			}
			notSpeciesParam = append(notSpeciesParam, paramEnum)
		}
	}
	result, err := c.service.FilterPetsByCategory(r.Context(), genderParam, speciesParam, notSpeciesParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// GetPetById - Find pet by ID
func (c *PetAPIController) GetPetById(w http.ResponseWriter, r *http.Request) {
	petIdParam, err := parseNumericParameter[int64](
		chi.URLParam(r, "petId"),
		WithRequire[int64](parseInt64),
	)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "petId", Err: err}, nil)
		return
	}
	result, err := c.service.GetPetById(r.Context(), petIdParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// UpdatePetWithForm - Updates a pet in the store with form data
func (c *PetAPIController) UpdatePetWithForm(w http.ResponseWriter, r *http.Request) {
	if err := r.ParseForm(); err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	petIdParam, err := parseNumericParameter[int64](
		chi.URLParam(r, "petId"),
		WithRequire[int64](parseInt64),
	)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "petId", Err: err}, nil)
		return
	}
	
	
	nameParam := r.FormValue("name")
	
	
	statusParam := r.FormValue("status")
	result, err := c.service.UpdatePetWithForm(r.Context(), petIdParam, nameParam, statusParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// DeletePet - Deletes a pet
func (c *PetAPIController) DeletePet(w http.ResponseWriter, r *http.Request) {
	petIdParam, err := parseNumericParameter[int64](
		chi.URLParam(r, "petId"),
		WithRequire[int64](parseInt64),
	)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "petId", Err: err}, nil)
		return
	}
	apiKeyParam := r.Header.Get("api_key")
	result, err := c.service.DeletePet(r.Context(), petIdParam, apiKeyParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// GetPetImageById - Returns the image for the Pet that has been previously uploaded
func (c *PetAPIController) GetPetImageById(w http.ResponseWriter, r *http.Request) {
	petIdParam, err := parseNumericParameter[int64](
		chi.URLParam(r, "petId"),
		WithRequire[int64](parseInt64),
	)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "petId", Err: err}, nil)
		return
	}
	result, err := c.service.GetPetImageById(r.Context(), petIdParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// UploadFile - uploads an image
func (c *PetAPIController) UploadFile(w http.ResponseWriter, r *http.Request) {
	if err := r.ParseMultipartForm(32 << 20); err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	petIdParam, err := parseNumericParameter[int64](
		chi.URLParam(r, "petId"),
		WithRequire[int64](parseInt64),
	)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "petId", Err: err}, nil)
		return
	}
	
	
	additionalMetadataParam := r.FormValue("additionalMetadata")
	
	
	extraOptionalMetadataParam := strings.Split(r.FormValue("extraOptionalMetadata"), ",")
	var fileParam *os.File
	{
		param, err := ReadFormFileToTempFile(r, "file")
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "file", Err: err}, nil)
			return
		}

		fileParam = param
	}
	
	
	result, err := c.service.UploadFile(r.Context(), petIdParam, additionalMetadataParam, extraOptionalMetadataParam, fileParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// UploadFileArrayOfFiles - uploads images (array of files)
func (c *PetAPIController) UploadFileArrayOfFiles(w http.ResponseWriter, r *http.Request) {
	if err := r.ParseMultipartForm(32 << 20); err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	petIdParam, err := parseNumericParameter[int64](
		chi.URLParam(r, "petId"),
		WithRequire[int64](parseInt64),
	)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "petId", Err: err}, nil)
		return
	}
	
	
	additionalMetadataParam := r.FormValue("additionalMetadata")
	var filesParam []*os.File
	{
		param, err := ReadFormFilesToTempFiles(r, "files")
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "files", Err: err}, nil)
			return
		}

		filesParam = param
	}
	
	
	result, err := c.service.UploadFileArrayOfFiles(r.Context(), petIdParam, additionalMetadataParam, filesParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// GetPetsUsingBooleanQueryParameters - Get the pets by only using boolean query parameters
func (c *PetAPIController) GetPetsUsingBooleanQueryParameters(w http.ResponseWriter, r *http.Request) {
	query, err := parseQuery(r.URL.RawQuery)
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	var exprParam bool
	if query.Has("expr") {
		param, err := parseBoolParameter(
			query.Get("expr"),
			WithParse[bool](parseBool),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "expr", Err: err}, nil)
			return
		}

		exprParam = param
	} else {
		c.errorHandler(w, r, &RequiredError{Field: "expr"}, nil)
		return
	}
	var groupingParam bool
	if query.Has("grouping") {
		param, err := parseBoolParameter(
			query.Get("grouping"),
			WithParse[bool](parseBool),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "grouping", Err: err}, nil)
			return
		}

		groupingParam = param
	} else {
	}
	var inactiveParam bool
	if query.Has("inactive") {
		param, err := parseBoolParameter(
			query.Get("inactive"),
			WithParse[bool](parseBool),
		)
		if err != nil {
			c.errorHandler(w, r, &ParsingError{Param: "inactive", Err: err}, nil)
			return
		}

		inactiveParam = param
	} else {
		var param bool = false
		inactiveParam = param
	}
	result, err := c.service.GetPetsUsingBooleanQueryParameters(r.Context(), exprParam, groupingParam, inactiveParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}

// GetPetsByTime - Get the pets by time
func (c *PetAPIController) GetPetsByTime(w http.ResponseWriter, r *http.Request) {
	createdTimeParam, err := parseTime(chi.URLParam(r, "createdTime"))
	if err != nil {
		c.errorHandler(w, r, &ParsingError{Param: "createdTime", Err: err}, nil)
		return
	}
	result, err := c.service.GetPetsByTime(r.Context(), createdTimeParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}
