// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * API version: 1.0.0
 */

package petstoreserver

import (
	"encoding/json"
	"net/http"
	"strings"
)

// FakeAPIController binds http requests to an api service and writes the service results to the http response
type FakeAPIController struct {
	service FakeAPIServicer
	errorHandler ErrorHandler
}

// FakeAPIOption for how the controller is set up.
type FakeAPIOption func(*FakeAPIController)

// WithFakeAPIErrorHandler inject ErrorHandler into controller
func WithFakeAPIErrorHandler(h ErrorHandler) FakeAPIOption {
	return func(c *FakeAPIController) {
		c.errorHandler = h
	}
}

// NewFakeAPIController creates a default api controller
func NewFakeAPIController(s FakeAPIServicer, opts ...FakeAPIOption) *FakeAPIController {
	controller := &FakeAPIController{
		service:      s,
		errorHandler: DefaultErrorHandler,
	}

	for _, opt := range opts {
		opt(controller)
	}

	return controller
}

// Routes returns all the api routes for the FakeAPIController
func (c *FakeAPIController) Routes() Routes {
	return Routes{
		"FakePostTest": Route{
			"FakePostTest",
			strings.ToUpper("Post"),
			"/v2/fake/collection/test",
			c.FakePostTest,
		},
	}
}

// OrderedRoutes returns all the api routes in a deterministic order for the FakeAPIController
func (c *FakeAPIController) OrderedRoutes() []Route {
	return []Route{
		Route{
			"FakePostTest",
			strings.ToUpper("Post"),
			"/v2/fake/collection/test",
			c.FakePostTest,
		},
	}
}



// FakePostTest - POST a test batch
func (c *FakeAPIController) FakePostTest(w http.ResponseWriter, r *http.Request) {
	var bodyParam string
	d := json.NewDecoder(r.Body)
	d.DisallowUnknownFields()
	if err := d.Decode(&bodyParam); err != nil {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	result, err := c.service.FakePostTest(r.Context(), bodyParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}
