/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 7.20.0-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#include <corvusoft/restbed/byte.hpp>
#include <corvusoft/restbed/string.hpp>
#include <corvusoft/restbed/settings.hpp>
#include <corvusoft/restbed/request.hpp>
#include <corvusoft/restbed/uri.hpp>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string.hpp>

#include "FakeApi.h"

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

namespace {
[[maybe_unused]]
std::string selectPreferredContentType(const std::vector<std::string>& contentTypes) {
    if (contentTypes.size() == 0) {
        return "application/json";
    }

    if (contentTypes.size() == 1) {
        return contentTypes.at(0);
    }

    static const std::array<std::string, 2> preferredTypes = {"json", "xml"};
    for (const auto& preferredType: preferredTypes) {
        const auto ret = std::find_if(contentTypes.cbegin(),
        contentTypes.cend(),
        [preferredType](const std::string& str) {
            return str.find(preferredType) != std::string::npos;});
        if (ret != contentTypes.cend()) {
            return *ret;
        }
    }

    return contentTypes.at(0);
}
}

FakeApiException::FakeApiException(int status_code, std::string what)
  : m_status(status_code),
    m_what(what)
{

}
int FakeApiException::getStatus() const
{
    return m_status;
}
const char* FakeApiException::what() const noexcept
{
    return m_what.c_str();
}


template<class MODEL_T>
MODEL_T extractJsonModelBodyParam(const std::string& bodyContent)
{
    std::stringstream sstream(bodyContent);
    boost::property_tree::ptree pt;
    boost::property_tree::json_parser::read_json(sstream, pt);

    auto model = MODEL_T(pt);
    return model;
}

template<class MODEL_T>
std::vector<MODEL_T> extractJsonArrayBodyParam(const std::string& bodyContent)
{
    std::stringstream sstream(bodyContent);
    boost::property_tree::ptree pt;
    boost::property_tree::json_parser::read_json(sstream, pt);

    auto arrayRet = std::vector<MODEL_T>();
    for (const auto& child: pt) {
        arrayRet.emplace_back(MODEL_T(child.second));
    }
    return arrayRet;
}

template <class KEY_T, class VAL_T>
std::string convertMapResponse(const std::map<KEY_T, VAL_T>& map)
{
    boost::property_tree::ptree pt;
    for(const auto &kv: map) {
    pt.push_back(boost::property_tree::ptree::value_type(
        boost::lexical_cast<std::string>(kv.first),
        boost::property_tree::ptree(
        boost::lexical_cast<std::string>(kv.second))));
    }
    std::stringstream sstream;
    write_json(sstream, pt);
    std::string result = sstream.str();
    return result;
}

namespace FakeApiResources {
FakeBigDecimalMapResource::FakeBigDecimalMapResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/BigDecimalMap");
	this->set_method_handler("GET",
		std::bind(&FakeBigDecimalMapResource::handler_GET_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeBigDecimalMapResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeBigDecimalMapResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeBigDecimalMapResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeBigDecimalMapResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeBigDecimalMapResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeBigDecimalMapResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeBigDecimalMapResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    
    int status_code = 500;
    FakeBigDecimalMap_200_response resultObject = FakeBigDecimalMap_200_response{};
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_GET();
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "*/*",
    };
    static const std::string acceptTypes{
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        result = resultObject.toJsonString();
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, FakeBigDecimalMap_200_response> FakeBigDecimalMapResource::handler_GET(
        )
{
    return handler_GET_func();
}


std::string FakeBigDecimalMapResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeBigDecimalMapResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeHealthResource::FakeHealthResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/health");
	this->set_method_handler("GET",
		std::bind(&FakeHealthResource::handler_GET_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeHealthResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeHealthResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeHealthResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeHealthResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeHealthResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeHealthResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeHealthResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    
    int status_code = 500;
    HealthCheckResult resultObject = HealthCheckResult{};
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_GET();
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json",
    };
    static const std::string acceptTypes{
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        result = resultObject.toJsonString();
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, HealthCheckResult> FakeHealthResource::handler_GET(
        )
{
    return handler_GET_func();
}


std::string FakeHealthResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeHealthResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeHttp_signature_testResource::FakeHttp_signature_testResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/http-signature-test");
	this->set_method_handler("GET",
		std::bind(&FakeHttp_signature_testResource::handler_GET_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeHttp_signature_testResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeHttp_signature_testResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeHttp_signature_testResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeHttp_signature_testResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeHttp_signature_testResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeHttp_signature_testResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeHttp_signature_testResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto pet = extractJsonModelBodyParam<Pet>(bodyContent);
    // Getting the query params
    std::string query1 = request->get_query_parameter("query1", "");
    // Getting the headers
    std::string header1 = request->get_header("header_1", "");
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_GET(pet, query1, header1);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, application/xml, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeHttp_signature_testResource::handler_GET(
        Pet & pet, std::string & query1, std::string & header1)
{
    return handler_GET_func(pet, query1, header1);
}


std::string FakeHttp_signature_testResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeHttp_signature_testResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeOuterBooleanResource::FakeOuterBooleanResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/outer/boolean");
	this->set_method_handler("POST",
		std::bind(&FakeOuterBooleanResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeOuterBooleanResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeOuterBooleanResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeOuterBooleanResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeOuterBooleanResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeOuterBooleanResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeOuterBooleanResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeOuterBooleanResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto body = boost::lexical_cast<bool>(bodyContent);
    
    int status_code = 500;
    bool resultObject = false;
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_POST(body);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "*/*",
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, bool> FakeOuterBooleanResource::handler_POST(
        bool & body)
{
    return handler_POST_func(body);
}


std::string FakeOuterBooleanResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeOuterBooleanResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeOuterCompositeResource::FakeOuterCompositeResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/outer/composite");
	this->set_method_handler("POST",
		std::bind(&FakeOuterCompositeResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeOuterCompositeResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeOuterCompositeResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeOuterCompositeResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeOuterCompositeResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeOuterCompositeResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeOuterCompositeResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeOuterCompositeResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto outerComposite = extractJsonModelBodyParam<OuterComposite>(bodyContent);
    
    int status_code = 500;
    OuterComposite resultObject = OuterComposite{};
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_POST(outerComposite);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "*/*",
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        result = resultObject.toJsonString();
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, OuterComposite> FakeOuterCompositeResource::handler_POST(
        OuterComposite & outerComposite)
{
    return handler_POST_func(outerComposite);
}


std::string FakeOuterCompositeResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeOuterCompositeResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeOuterNumberResource::FakeOuterNumberResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/outer/number");
	this->set_method_handler("POST",
		std::bind(&FakeOuterNumberResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeOuterNumberResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeOuterNumberResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeOuterNumberResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeOuterNumberResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeOuterNumberResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeOuterNumberResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeOuterNumberResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto body = boost::lexical_cast<double>(bodyContent);
    
    int status_code = 500;
    double resultObject = 0.0;
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_POST(body);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "*/*",
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, double> FakeOuterNumberResource::handler_POST(
        double & body)
{
    return handler_POST_func(body);
}


std::string FakeOuterNumberResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeOuterNumberResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeOuterStringResource::FakeOuterStringResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/outer/string");
	this->set_method_handler("POST",
		std::bind(&FakeOuterStringResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeOuterStringResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeOuterStringResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeOuterStringResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeOuterStringResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeOuterStringResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeOuterStringResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeOuterStringResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto body = boost::lexical_cast<std::string>(bodyContent);
    
    int status_code = 500;
    std::string resultObject = "";
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_POST(body);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "*/*",
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        result = resultObject;
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, std::string> FakeOuterStringResource::handler_POST(
        std::string & body)
{
    return handler_POST_func(body);
}


std::string FakeOuterStringResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeOuterStringResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakePropertyEnum_intResource::FakePropertyEnum_intResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/property/enum-int");
	this->set_method_handler("POST",
		std::bind(&FakePropertyEnum_intResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakePropertyEnum_intResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakePropertyEnum_intResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakePropertyEnum_intResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakePropertyEnum_intResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakePropertyEnum_intResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakePropertyEnum_intResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakePropertyEnum_intResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto outerObjectWithEnumProperty = extractJsonModelBodyParam<OuterObjectWithEnumProperty>(bodyContent);
    
    int status_code = 500;
    OuterObjectWithEnumProperty resultObject = OuterObjectWithEnumProperty{};
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_POST(outerObjectWithEnumProperty);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "*/*",
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        result = resultObject.toJsonString();
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


std::pair<int, OuterObjectWithEnumProperty> FakePropertyEnum_intResource::handler_POST(
        OuterObjectWithEnumProperty & outerObjectWithEnumProperty)
{
    return handler_POST_func(outerObjectWithEnumProperty);
}


std::string FakePropertyEnum_intResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakePropertyEnum_intResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeAdditionalProperties_referenceResource::FakeAdditionalProperties_referenceResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/additionalProperties-reference");
	this->set_method_handler("POST",
		std::bind(&FakeAdditionalProperties_referenceResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeAdditionalProperties_referenceResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeAdditionalProperties_referenceResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeAdditionalProperties_referenceResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeAdditionalProperties_referenceResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeAdditionalProperties_referenceResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeAdditionalProperties_referenceResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeAdditionalProperties_referenceResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    std::map<std::string, AnyType> requestBody; // TODO
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_POST(requestBody);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeAdditionalProperties_referenceResource::handler_POST(
        std::map<std::string, AnyType> & requestBody)
{
    return handler_POST_func(requestBody);
}


std::string FakeAdditionalProperties_referenceResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeAdditionalProperties_referenceResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeBody_with_binaryResource::FakeBody_with_binaryResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/body-with-binary");
	this->set_method_handler("PUT",
		std::bind(&FakeBody_with_binaryResource::handler_PUT_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeBody_with_binaryResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeBody_with_binaryResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeBody_with_binaryResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeBody_with_binaryResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeBody_with_binaryResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeBody_with_binaryResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeBody_with_binaryResource::handler_PUT_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto body = boost::lexical_cast<std::string>(bodyContent);
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_PUT(body);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "image/png, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeBody_with_binaryResource::handler_PUT(
        std::string & body)
{
    return handler_PUT_func(body);
}


std::string FakeBody_with_binaryResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeBody_with_binaryResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeBody_with_file_schemaResource::FakeBody_with_file_schemaResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/body-with-file-schema");
	this->set_method_handler("PUT",
		std::bind(&FakeBody_with_file_schemaResource::handler_PUT_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeBody_with_file_schemaResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeBody_with_file_schemaResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeBody_with_file_schemaResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeBody_with_file_schemaResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeBody_with_file_schemaResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeBody_with_file_schemaResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeBody_with_file_schemaResource::handler_PUT_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto fileSchemaTestClass = extractJsonModelBodyParam<FileSchemaTestClass>(bodyContent);
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_PUT(fileSchemaTestClass);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeBody_with_file_schemaResource::handler_PUT(
        FileSchemaTestClass & fileSchemaTestClass)
{
    return handler_PUT_func(fileSchemaTestClass);
}


std::string FakeBody_with_file_schemaResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeBody_with_file_schemaResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeBody_with_query_paramsResource::FakeBody_with_query_paramsResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/body-with-query-params");
	this->set_method_handler("PUT",
		std::bind(&FakeBody_with_query_paramsResource::handler_PUT_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeBody_with_query_paramsResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeBody_with_query_paramsResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeBody_with_query_paramsResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeBody_with_query_paramsResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeBody_with_query_paramsResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeBody_with_query_paramsResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeBody_with_query_paramsResource::handler_PUT_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto user = extractJsonModelBodyParam<User>(bodyContent);
    // Getting the query params
    std::string query = request->get_query_parameter("query", "");
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_PUT(query, user);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeBody_with_query_paramsResource::handler_PUT(
        std::string & query, User & user)
{
    return handler_PUT_func(query, user);
}


std::string FakeBody_with_query_paramsResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeBody_with_query_paramsResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeResource::FakeResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake");
	this->set_method_handler("PATCH",
		std::bind(&FakeResource::handler_PATCH_internal, this,
			std::placeholders::_1));
	this->set_method_handler("POST",
		std::bind(&FakeResource::handler_POST_internal, this,
			std::placeholders::_1));
	this->set_method_handler("GET",
		std::bind(&FakeResource::handler_GET_internal, this,
			std::placeholders::_1));
	this->set_method_handler("DELETE",
		std::bind(&FakeResource::handler_DELETE_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeResource::handler_PATCH_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto client = extractJsonModelBodyParam<Client>(bodyContent);
    
    int status_code = 500;
    Client resultObject = Client{};
    std::string result = "";
    
    try {
        std::tie(status_code, resultObject) =
            handler_PATCH(client);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json",
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        result = resultObject.toJsonString();
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}

// x-extension
void FakeResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session) {
    const auto request = session->get_request();
    auto integer = boost::lexical_cast<int32_t>(extractFormParamsFromBody("integer", extractBodyContent(session)));
    auto int32 = boost::lexical_cast<int32_t>(extractFormParamsFromBody("int32", extractBodyContent(session)));
    auto int64 = boost::lexical_cast<int64_t>(extractFormParamsFromBody("int64", extractBodyContent(session)));
    auto number = boost::lexical_cast<double>(extractFormParamsFromBody("number", extractBodyContent(session)));
    auto r_float = boost::lexical_cast<float>(extractFormParamsFromBody("r_float", extractBodyContent(session)));
    auto r_double = boost::lexical_cast<double>(extractFormParamsFromBody("r_double", extractBodyContent(session)));
    auto string = boost::lexical_cast<std::string>(extractFormParamsFromBody("string", extractBodyContent(session)));
    auto patternWithoutDelimiter = boost::lexical_cast<std::string>(extractFormParamsFromBody("patternWithoutDelimiter", extractBodyContent(session)));
    auto byte = boost::lexical_cast<std::string>(extractFormParamsFromBody("byte", extractBodyContent(session)));
    auto binary = boost::lexical_cast<std::string>(extractFormParamsFromBody("binary", extractBodyContent(session)));
    auto date = boost::lexical_cast<std::string>(extractFormParamsFromBody("date", extractBodyContent(session)));
    auto dateTime = boost::lexical_cast<std::string>(extractFormParamsFromBody("dateTime", extractBodyContent(session)));
    auto password = boost::lexical_cast<std::string>(extractFormParamsFromBody("password", extractBodyContent(session)));
    auto callback = boost::lexical_cast<std::string>(extractFormParamsFromBody("callback", extractBodyContent(session)));
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_POST(number, r_double, patternWithoutDelimiter, byte, integer, int32, int64, r_float, string, binary, date, dateTime, password, callback);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/x-www-form-urlencoded, "
    };
    
    if (status_code == 400) {
        responseHeaders.insert(std::make_pair("Content-Type", "text/plain"));
        result = "Invalid username supplied";
    
        returnResponse(session, 400, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    if (status_code == 404) {
        responseHeaders.insert(std::make_pair("Content-Type", "text/plain"));
        result = "User not found";
    
        returnResponse(session, 404, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}
// x-extension
void FakeResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session) {
    const auto request = session->get_request();
    std::string enumFormStringArray_raw = extractFormParamsFromBody("enumFormStringArray", extractBodyContent(session));
    std::vector<std::string> enumFormStringArray;
    boost::split(enumFormStringArray, enumFormStringArray_raw, boost::is_any_of(","));
    auto enumFormString = boost::lexical_cast<std::string>(extractFormParamsFromBody("enumFormString", extractBodyContent(session)));
    // Getting the query params
    std::string enumQueryStringArray_raw = request->get_query_parameter("enumQueryStringArray");
    std::vector<std::string> enumQueryStringArray;
    std::vector<std::string> enumQueryStringArray_temp;
    boost::split(enumQueryStringArray_temp, enumQueryStringArray_raw, boost::is_any_of(","));
    std::copy(enumQueryStringArray_temp.begin(), enumQueryStringArray_temp.end(), std::inserter(enumQueryStringArray, std::next(enumQueryStringArray.begin())));
    std::string enumQueryString = request->get_query_parameter("enumQueryString", "-efg");
    int32_t enumQueryInteger = request->get_query_parameter("enumQueryInteger", 0);
    double enumQueryDouble = request->get_query_parameter("enumQueryDouble", 0.0);
    std::string enumQueryModelArray_raw = request->get_query_parameter("enumQueryModelArray");
    std::vector<EnumClass> enumQueryModelArray;
    std::vector<std::string> enumQueryModelArray_temp;
    boost::split(enumQueryModelArray_temp, enumQueryModelArray_raw, boost::is_any_of(","));
    std::transform(enumQueryModelArray_temp.begin(), enumQueryModelArray_temp.end(), std::back_inserter(enumQueryModelArray), [](const auto& i){ EnumClass ret; ret.fromString(i); return ret;});
    // Getting the headers
    std::string enumHeaderStringArray_raw = request->get_header("enumHeaderStringArray");
    std::vector<std::string> enumHeaderStringArray;
    boost::split(enumHeaderStringArray, enumHeaderStringArray_raw, boost::is_any_of(","));
    std::string enumHeaderString = request->get_header("enum_header_string", "-efg");
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_GET(enumHeaderStringArray, enumHeaderString, enumQueryStringArray, enumQueryString, enumQueryInteger, enumQueryDouble, enumQueryModelArray, enumFormStringArray, enumFormString);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/x-www-form-urlencoded, "
    };
    
    if (status_code == 400) {
        responseHeaders.insert(std::make_pair("Content-Type", "text/plain"));
        result = "Invalid request";
    
        returnResponse(session, 400, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    if (status_code == 404) {
        responseHeaders.insert(std::make_pair("Content-Type", "text/plain"));
        result = "Not found";
    
        returnResponse(session, 404, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}
// x-extension
void FakeResource::handler_DELETE_internal(const std::shared_ptr<restbed::Session> session) {
    const auto request = session->get_request();
    // Getting the query params
    int32_t requiredStringGroup = request->get_query_parameter("requiredStringGroup", 0);
    int64_t requiredInt64Group = request->get_query_parameter("requiredInt64Group", 0L);
    int32_t stringGroup = request->get_query_parameter("stringGroup", 0);
    int64_t int64Group = request->get_query_parameter("int64Group", 0L);
    // Getting the headers
    bool requiredBooleanGroup = request->get_header("required_boolean_group", false);
    bool booleanGroup = request->get_header("boolean_group", false);
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_DELETE(requiredStringGroup, requiredBooleanGroup, requiredInt64Group, stringGroup, booleanGroup, int64Group);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
    };
    
    if (status_code == 400) {
        responseHeaders.insert(std::make_pair("Content-Type", "text/plain"));
        result = "Something wrong";
    
        returnResponse(session, 400, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}

std::pair<int, Client> FakeResource::handler_PATCH(
        Client & client)
{
    return handler_PATCH_func(client);
}

int FakeResource::handler_POST(
    double & number, double & r_double, std::string & patternWithoutDelimiter, std::string & byte, int32_t & integer, int32_t & int32, int64_t & int64, float & r_float, std::string & string, std::string & binary, std::string & date, std::string & dateTime, std::string & password, std::string & callback)
{
    return handler_POST_func(number, r_double, patternWithoutDelimiter, byte, integer, int32, int64, r_float, string, binary, date, dateTime, password, callback);
}
int FakeResource::handler_GET(
    std::vector<std::string> & enumHeaderStringArray, std::string & enumHeaderString, std::vector<std::string> & enumQueryStringArray, std::string & enumQueryString, int32_t & enumQueryInteger, double & enumQueryDouble, std::vector<EnumClass> & enumQueryModelArray, std::vector<std::string> & enumFormStringArray, std::string & enumFormString)
{
    return handler_GET_func(enumHeaderStringArray, enumHeaderString, enumQueryStringArray, enumQueryString, enumQueryInteger, enumQueryDouble, enumQueryModelArray, enumFormStringArray, enumFormString);
}
int FakeResource::handler_DELETE(
    int32_t & requiredStringGroup, bool & requiredBooleanGroup, int64_t & requiredInt64Group, int32_t & stringGroup, bool & booleanGroup, int64_t & int64Group)
{
    return handler_DELETE_func(requiredStringGroup, requiredBooleanGroup, requiredInt64Group, stringGroup, booleanGroup, int64Group);
}

std::string FakeResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeInline_additionalPropertiesResource::FakeInline_additionalPropertiesResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/inline-additionalProperties");
	this->set_method_handler("POST",
		std::bind(&FakeInline_additionalPropertiesResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeInline_additionalPropertiesResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeInline_additionalPropertiesResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeInline_additionalPropertiesResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeInline_additionalPropertiesResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeInline_additionalPropertiesResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeInline_additionalPropertiesResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeInline_additionalPropertiesResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    std::map<std::string, std::string> requestBody; // TODO
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_POST(requestBody);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeInline_additionalPropertiesResource::handler_POST(
        std::map<std::string, std::string> & requestBody)
{
    return handler_POST_func(requestBody);
}


std::string FakeInline_additionalPropertiesResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeInline_additionalPropertiesResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeInline_freeform_additionalPropertiesResource::FakeInline_freeform_additionalPropertiesResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/inline-freeform-additionalProperties");
	this->set_method_handler("POST",
		std::bind(&FakeInline_freeform_additionalPropertiesResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeInline_freeform_additionalPropertiesResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeInline_freeform_additionalPropertiesResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeInline_freeform_additionalPropertiesResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeInline_freeform_additionalPropertiesResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeInline_freeform_additionalPropertiesResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeInline_freeform_additionalPropertiesResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeInline_freeform_additionalPropertiesResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto testInlineFreeformAdditionalPropertiesRequest = extractJsonModelBodyParam<TestInlineFreeformAdditionalProperties_request>(bodyContent);
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_POST(testInlineFreeformAdditionalPropertiesRequest);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeInline_freeform_additionalPropertiesResource::handler_POST(
        TestInlineFreeformAdditionalProperties_request & testInlineFreeformAdditionalPropertiesRequest)
{
    return handler_POST_func(testInlineFreeformAdditionalPropertiesRequest);
}


std::string FakeInline_freeform_additionalPropertiesResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeInline_freeform_additionalPropertiesResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeJsonFormDataResource::FakeJsonFormDataResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/jsonFormData");
	this->set_method_handler("GET",
		std::bind(&FakeJsonFormDataResource::handler_GET_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeJsonFormDataResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeJsonFormDataResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeJsonFormDataResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeJsonFormDataResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeJsonFormDataResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeJsonFormDataResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeJsonFormDataResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    auto param = boost::lexical_cast<std::string>(extractFormParamsFromBody("param", extractBodyContent(session)));
    auto param2 = boost::lexical_cast<std::string>(extractFormParamsFromBody("param2", extractBodyContent(session)));
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_GET(param, param2);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/x-www-form-urlencoded, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeJsonFormDataResource::handler_GET(
        std::string & param, std::string & param2)
{
    return handler_GET_func(param, param2);
}


std::string FakeJsonFormDataResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeJsonFormDataResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeNullableResource::FakeNullableResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/nullable");
	this->set_method_handler("POST",
		std::bind(&FakeNullableResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeNullableResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeNullableResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeNullableResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeNullableResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeNullableResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeNullableResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeNullableResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    auto childWithNullable = extractJsonModelBodyParam<ChildWithNullable>(bodyContent);
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_POST(childWithNullable);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeNullableResource::handler_POST(
        ChildWithNullable & childWithNullable)
{
    return handler_POST_func(childWithNullable);
}


std::string FakeNullableResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeNullableResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeTest_query_parametersResource::FakeTest_query_parametersResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/test-query-parameters");
	this->set_method_handler("PUT",
		std::bind(&FakeTest_query_parametersResource::handler_PUT_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeTest_query_parametersResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeTest_query_parametersResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeTest_query_parametersResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeTest_query_parametersResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeTest_query_parametersResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeTest_query_parametersResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeTest_query_parametersResource::handler_PUT_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // Getting the query params
    std::string pipe_raw = request->get_query_parameter("pipe");
    std::vector<std::string> pipe;
    std::vector<std::string> pipe_temp;
    boost::split(pipe_temp, pipe_raw, boost::is_any_of(","));
    std::copy(pipe_temp.begin(), pipe_temp.end(), std::inserter(pipe, std::next(pipe.begin())));
    std::string ioutil_raw = request->get_query_parameter("ioutil");
    std::vector<std::string> ioutil;
    std::vector<std::string> ioutil_temp;
    boost::split(ioutil_temp, ioutil_raw, boost::is_any_of(","));
    std::copy(ioutil_temp.begin(), ioutil_temp.end(), std::inserter(ioutil, std::next(ioutil.begin())));
    std::string http_raw = request->get_query_parameter("http");
    std::vector<std::string> http;
    std::vector<std::string> http_temp;
    boost::split(http_temp, http_raw, boost::is_any_of(","));
    std::copy(http_temp.begin(), http_temp.end(), std::inserter(http, std::next(http.begin())));
    std::string url_raw = request->get_query_parameter("url");
    std::vector<std::string> url;
    std::vector<std::string> url_temp;
    boost::split(url_temp, url_raw, boost::is_any_of(","));
    std::copy(url_temp.begin(), url_temp.end(), std::inserter(url, std::next(url.begin())));
    std::string context_raw = request->get_query_parameter("context");
    std::vector<std::string> context;
    std::vector<std::string> context_temp;
    boost::split(context_temp, context_raw, boost::is_any_of(","));
    std::copy(context_temp.begin(), context_temp.end(), std::inserter(context, std::next(context.begin())));
    std::stringstream language_raw(request->get_query_parameter("language"));
    boost::property_tree::ptree language_pt;
    boost::property_tree::json_parser::read_json(language_raw,language_pt);
    std::map<std::string, std::string> language = std::map<std::string, std::string>{};
    for (auto& item: language_pt) {
        language.emplace(item.first, item.second.get_value<std::string>());
    }
    std::string allowEmpty = request->get_query_parameter("allowEmpty", "");
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_PUT(pipe, ioutil, http, url, context, allowEmpty, language);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeTest_query_parametersResource::handler_PUT(
        std::vector<std::string> & pipe, std::vector<std::string> & ioutil, std::vector<std::string> & http, std::vector<std::string> & url, std::vector<std::string> & context, std::string & allowEmpty, std::map<std::string, std::string> & language)
{
    return handler_PUT_func(pipe, ioutil, http, url, context, allowEmpty, language);
}


std::string FakeTest_query_parametersResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeTest_query_parametersResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}
FakeStringMap_referenceResource::FakeStringMap_referenceResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/fake/stringMap-reference");
	this->set_method_handler("POST",
		std::bind(&FakeStringMap_referenceResource::handler_POST_internal, this,
			std::placeholders::_1));
}

std::pair<int, std::string> FakeStringMap_referenceResource::handleFakeApiException(const FakeApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> FakeStringMap_referenceResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> FakeStringMap_referenceResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void FakeStringMap_referenceResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void FakeStringMap_referenceResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, std::multimap<std::string, std::string>& responseHeaders)
{
    responseHeaders.insert(std::make_pair("Connection", "close"));
    session->close(status, result, responseHeaders);
}

void FakeStringMap_referenceResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void FakeStringMap_referenceResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    // body params or form params here from the body content string
    std::string bodyContent = extractBodyContent(session);
    std::map<std::string, std::string> requestBody; // TODO
    
    int status_code = 500;
    std::string result = "";
    
    try {
        status_code =
            handler_POST(requestBody);
    }
    catch(const FakeApiException& e) {
        std::tie(status_code, result) = handleFakeApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }
    
    std::multimap< std::string, std::string > responseHeaders {};
    static const std::vector<std::string> contentTypes{
        "application/json"
    };
    static const std::string acceptTypes{
        "application/json, "
    };
    
    if (status_code == 200) {
        responseHeaders.insert(std::make_pair("Content-Type", selectPreferredContentType(contentTypes)));
        if (!acceptTypes.empty()) {
            responseHeaders.insert(std::make_pair("Accept", acceptTypes));
        }
    
        returnResponse(session, 200, result.empty() ? "{}" : result, responseHeaders);
        return;
    }
    defaultSessionClose(session, status_code, result);
    
    
}


int FakeStringMap_referenceResource::handler_POST(
        std::map<std::string, std::string> & requestBody)
{
    return handler_POST_func(requestBody);
}


std::string FakeStringMap_referenceResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

std::string FakeStringMap_referenceResource::extractFormParamsFromBody(const std::string& paramName, const std::string& body) {
    const auto uri = restbed::Uri("urlencoded?" + body, true);
    const auto params = uri.get_query_parameters();
    const auto result = params.find(paramName);
    if (result != params.cend()) {
        return result->second;
    }
    return "";
}

} /* namespace FakeApiResources */

FakeApi::FakeApi(std::shared_ptr<restbed::Service> const& restbedService)
: m_service(restbedService)
{
}

FakeApi::~FakeApi() {}

std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> FakeApi::getFakeBigDecimalMapResource() {
    if (!m_spFakeBigDecimalMapResource) {
        setResource(std::make_shared<FakeApiResources::FakeBigDecimalMapResource>());
    }
    return m_spFakeBigDecimalMapResource;
}
std::shared_ptr<FakeApiResources::FakeHealthResource> FakeApi::getFakeHealthResource() {
    if (!m_spFakeHealthResource) {
        setResource(std::make_shared<FakeApiResources::FakeHealthResource>());
    }
    return m_spFakeHealthResource;
}
std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> FakeApi::getFakeHttp_signature_testResource() {
    if (!m_spFakeHttp_signature_testResource) {
        setResource(std::make_shared<FakeApiResources::FakeHttp_signature_testResource>());
    }
    return m_spFakeHttp_signature_testResource;
}
std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> FakeApi::getFakeOuterBooleanResource() {
    if (!m_spFakeOuterBooleanResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterBooleanResource>());
    }
    return m_spFakeOuterBooleanResource;
}
std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> FakeApi::getFakeOuterCompositeResource() {
    if (!m_spFakeOuterCompositeResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterCompositeResource>());
    }
    return m_spFakeOuterCompositeResource;
}
std::shared_ptr<FakeApiResources::FakeOuterNumberResource> FakeApi::getFakeOuterNumberResource() {
    if (!m_spFakeOuterNumberResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterNumberResource>());
    }
    return m_spFakeOuterNumberResource;
}
std::shared_ptr<FakeApiResources::FakeOuterStringResource> FakeApi::getFakeOuterStringResource() {
    if (!m_spFakeOuterStringResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterStringResource>());
    }
    return m_spFakeOuterStringResource;
}
std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> FakeApi::getFakePropertyEnum_intResource() {
    if (!m_spFakePropertyEnum_intResource) {
        setResource(std::make_shared<FakeApiResources::FakePropertyEnum_intResource>());
    }
    return m_spFakePropertyEnum_intResource;
}
std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> FakeApi::getFakeAdditionalProperties_referenceResource() {
    if (!m_spFakeAdditionalProperties_referenceResource) {
        setResource(std::make_shared<FakeApiResources::FakeAdditionalProperties_referenceResource>());
    }
    return m_spFakeAdditionalProperties_referenceResource;
}
std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> FakeApi::getFakeBody_with_binaryResource() {
    if (!m_spFakeBody_with_binaryResource) {
        setResource(std::make_shared<FakeApiResources::FakeBody_with_binaryResource>());
    }
    return m_spFakeBody_with_binaryResource;
}
std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> FakeApi::getFakeBody_with_file_schemaResource() {
    if (!m_spFakeBody_with_file_schemaResource) {
        setResource(std::make_shared<FakeApiResources::FakeBody_with_file_schemaResource>());
    }
    return m_spFakeBody_with_file_schemaResource;
}
std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> FakeApi::getFakeBody_with_query_paramsResource() {
    if (!m_spFakeBody_with_query_paramsResource) {
        setResource(std::make_shared<FakeApiResources::FakeBody_with_query_paramsResource>());
    }
    return m_spFakeBody_with_query_paramsResource;
}
std::shared_ptr<FakeApiResources::FakeResource> FakeApi::getFakeResource() {
    if (!m_spFakeResource) {
        setResource(std::make_shared<FakeApiResources::FakeResource>());
    }
    return m_spFakeResource;
}
std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> FakeApi::getFakeInline_additionalPropertiesResource() {
    if (!m_spFakeInline_additionalPropertiesResource) {
        setResource(std::make_shared<FakeApiResources::FakeInline_additionalPropertiesResource>());
    }
    return m_spFakeInline_additionalPropertiesResource;
}
std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> FakeApi::getFakeInline_freeform_additionalPropertiesResource() {
    if (!m_spFakeInline_freeform_additionalPropertiesResource) {
        setResource(std::make_shared<FakeApiResources::FakeInline_freeform_additionalPropertiesResource>());
    }
    return m_spFakeInline_freeform_additionalPropertiesResource;
}
std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> FakeApi::getFakeJsonFormDataResource() {
    if (!m_spFakeJsonFormDataResource) {
        setResource(std::make_shared<FakeApiResources::FakeJsonFormDataResource>());
    }
    return m_spFakeJsonFormDataResource;
}
std::shared_ptr<FakeApiResources::FakeNullableResource> FakeApi::getFakeNullableResource() {
    if (!m_spFakeNullableResource) {
        setResource(std::make_shared<FakeApiResources::FakeNullableResource>());
    }
    return m_spFakeNullableResource;
}
std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> FakeApi::getFakeTest_query_parametersResource() {
    if (!m_spFakeTest_query_parametersResource) {
        setResource(std::make_shared<FakeApiResources::FakeTest_query_parametersResource>());
    }
    return m_spFakeTest_query_parametersResource;
}
std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> FakeApi::getFakeStringMap_referenceResource() {
    if (!m_spFakeStringMap_referenceResource) {
        setResource(std::make_shared<FakeApiResources::FakeStringMap_referenceResource>());
    }
    return m_spFakeStringMap_referenceResource;
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> resource) {
    m_spFakeBigDecimalMapResource = resource;
    m_service->publish(m_spFakeBigDecimalMapResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeHealthResource> resource) {
    m_spFakeHealthResource = resource;
    m_service->publish(m_spFakeHealthResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> resource) {
    m_spFakeHttp_signature_testResource = resource;
    m_service->publish(m_spFakeHttp_signature_testResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> resource) {
    m_spFakeOuterBooleanResource = resource;
    m_service->publish(m_spFakeOuterBooleanResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> resource) {
    m_spFakeOuterCompositeResource = resource;
    m_service->publish(m_spFakeOuterCompositeResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeOuterNumberResource> resource) {
    m_spFakeOuterNumberResource = resource;
    m_service->publish(m_spFakeOuterNumberResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeOuterStringResource> resource) {
    m_spFakeOuterStringResource = resource;
    m_service->publish(m_spFakeOuterStringResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> resource) {
    m_spFakePropertyEnum_intResource = resource;
    m_service->publish(m_spFakePropertyEnum_intResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> resource) {
    m_spFakeAdditionalProperties_referenceResource = resource;
    m_service->publish(m_spFakeAdditionalProperties_referenceResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> resource) {
    m_spFakeBody_with_binaryResource = resource;
    m_service->publish(m_spFakeBody_with_binaryResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> resource) {
    m_spFakeBody_with_file_schemaResource = resource;
    m_service->publish(m_spFakeBody_with_file_schemaResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> resource) {
    m_spFakeBody_with_query_paramsResource = resource;
    m_service->publish(m_spFakeBody_with_query_paramsResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeResource> resource) {
    m_spFakeResource = resource;
    m_service->publish(m_spFakeResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> resource) {
    m_spFakeInline_additionalPropertiesResource = resource;
    m_service->publish(m_spFakeInline_additionalPropertiesResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> resource) {
    m_spFakeInline_freeform_additionalPropertiesResource = resource;
    m_service->publish(m_spFakeInline_freeform_additionalPropertiesResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> resource) {
    m_spFakeJsonFormDataResource = resource;
    m_service->publish(m_spFakeJsonFormDataResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeNullableResource> resource) {
    m_spFakeNullableResource = resource;
    m_service->publish(m_spFakeNullableResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> resource) {
    m_spFakeTest_query_parametersResource = resource;
    m_service->publish(m_spFakeTest_query_parametersResource);
}
void FakeApi::setResource(std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> resource) {
    m_spFakeStringMap_referenceResource = resource;
    m_service->publish(m_spFakeStringMap_referenceResource);
}
void FakeApi::setFakeApiFakeBigDecimalMapResource(std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> spFakeBigDecimalMapResource) {
    m_spFakeBigDecimalMapResource = spFakeBigDecimalMapResource;
    m_service->publish(m_spFakeBigDecimalMapResource);
}
void FakeApi::setFakeApiFakeHealthResource(std::shared_ptr<FakeApiResources::FakeHealthResource> spFakeHealthResource) {
    m_spFakeHealthResource = spFakeHealthResource;
    m_service->publish(m_spFakeHealthResource);
}
void FakeApi::setFakeApiFakeHttp_signature_testResource(std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> spFakeHttp_signature_testResource) {
    m_spFakeHttp_signature_testResource = spFakeHttp_signature_testResource;
    m_service->publish(m_spFakeHttp_signature_testResource);
}
void FakeApi::setFakeApiFakeOuterBooleanResource(std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> spFakeOuterBooleanResource) {
    m_spFakeOuterBooleanResource = spFakeOuterBooleanResource;
    m_service->publish(m_spFakeOuterBooleanResource);
}
void FakeApi::setFakeApiFakeOuterCompositeResource(std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> spFakeOuterCompositeResource) {
    m_spFakeOuterCompositeResource = spFakeOuterCompositeResource;
    m_service->publish(m_spFakeOuterCompositeResource);
}
void FakeApi::setFakeApiFakeOuterNumberResource(std::shared_ptr<FakeApiResources::FakeOuterNumberResource> spFakeOuterNumberResource) {
    m_spFakeOuterNumberResource = spFakeOuterNumberResource;
    m_service->publish(m_spFakeOuterNumberResource);
}
void FakeApi::setFakeApiFakeOuterStringResource(std::shared_ptr<FakeApiResources::FakeOuterStringResource> spFakeOuterStringResource) {
    m_spFakeOuterStringResource = spFakeOuterStringResource;
    m_service->publish(m_spFakeOuterStringResource);
}
void FakeApi::setFakeApiFakePropertyEnum_intResource(std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> spFakePropertyEnum_intResource) {
    m_spFakePropertyEnum_intResource = spFakePropertyEnum_intResource;
    m_service->publish(m_spFakePropertyEnum_intResource);
}
void FakeApi::setFakeApiFakeAdditionalProperties_referenceResource(std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> spFakeAdditionalProperties_referenceResource) {
    m_spFakeAdditionalProperties_referenceResource = spFakeAdditionalProperties_referenceResource;
    m_service->publish(m_spFakeAdditionalProperties_referenceResource);
}
void FakeApi::setFakeApiFakeBody_with_binaryResource(std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> spFakeBody_with_binaryResource) {
    m_spFakeBody_with_binaryResource = spFakeBody_with_binaryResource;
    m_service->publish(m_spFakeBody_with_binaryResource);
}
void FakeApi::setFakeApiFakeBody_with_file_schemaResource(std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> spFakeBody_with_file_schemaResource) {
    m_spFakeBody_with_file_schemaResource = spFakeBody_with_file_schemaResource;
    m_service->publish(m_spFakeBody_with_file_schemaResource);
}
void FakeApi::setFakeApiFakeBody_with_query_paramsResource(std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> spFakeBody_with_query_paramsResource) {
    m_spFakeBody_with_query_paramsResource = spFakeBody_with_query_paramsResource;
    m_service->publish(m_spFakeBody_with_query_paramsResource);
}
void FakeApi::setFakeApiFakeResource(std::shared_ptr<FakeApiResources::FakeResource> spFakeResource) {
    m_spFakeResource = spFakeResource;
    m_service->publish(m_spFakeResource);
}
void FakeApi::setFakeApiFakeInline_additionalPropertiesResource(std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> spFakeInline_additionalPropertiesResource) {
    m_spFakeInline_additionalPropertiesResource = spFakeInline_additionalPropertiesResource;
    m_service->publish(m_spFakeInline_additionalPropertiesResource);
}
void FakeApi::setFakeApiFakeInline_freeform_additionalPropertiesResource(std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> spFakeInline_freeform_additionalPropertiesResource) {
    m_spFakeInline_freeform_additionalPropertiesResource = spFakeInline_freeform_additionalPropertiesResource;
    m_service->publish(m_spFakeInline_freeform_additionalPropertiesResource);
}
void FakeApi::setFakeApiFakeJsonFormDataResource(std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> spFakeJsonFormDataResource) {
    m_spFakeJsonFormDataResource = spFakeJsonFormDataResource;
    m_service->publish(m_spFakeJsonFormDataResource);
}
void FakeApi::setFakeApiFakeNullableResource(std::shared_ptr<FakeApiResources::FakeNullableResource> spFakeNullableResource) {
    m_spFakeNullableResource = spFakeNullableResource;
    m_service->publish(m_spFakeNullableResource);
}
void FakeApi::setFakeApiFakeTest_query_parametersResource(std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> spFakeTest_query_parametersResource) {
    m_spFakeTest_query_parametersResource = spFakeTest_query_parametersResource;
    m_service->publish(m_spFakeTest_query_parametersResource);
}
void FakeApi::setFakeApiFakeStringMap_referenceResource(std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> spFakeStringMap_referenceResource) {
    m_spFakeStringMap_referenceResource = spFakeStringMap_referenceResource;
    m_service->publish(m_spFakeStringMap_referenceResource);
}


void FakeApi::publishDefaultResources() {
    if (!m_spFakeBigDecimalMapResource) {
        setResource(std::make_shared<FakeApiResources::FakeBigDecimalMapResource>());
    }
    if (!m_spFakeHealthResource) {
        setResource(std::make_shared<FakeApiResources::FakeHealthResource>());
    }
    if (!m_spFakeHttp_signature_testResource) {
        setResource(std::make_shared<FakeApiResources::FakeHttp_signature_testResource>());
    }
    if (!m_spFakeOuterBooleanResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterBooleanResource>());
    }
    if (!m_spFakeOuterCompositeResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterCompositeResource>());
    }
    if (!m_spFakeOuterNumberResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterNumberResource>());
    }
    if (!m_spFakeOuterStringResource) {
        setResource(std::make_shared<FakeApiResources::FakeOuterStringResource>());
    }
    if (!m_spFakePropertyEnum_intResource) {
        setResource(std::make_shared<FakeApiResources::FakePropertyEnum_intResource>());
    }
    if (!m_spFakeAdditionalProperties_referenceResource) {
        setResource(std::make_shared<FakeApiResources::FakeAdditionalProperties_referenceResource>());
    }
    if (!m_spFakeBody_with_binaryResource) {
        setResource(std::make_shared<FakeApiResources::FakeBody_with_binaryResource>());
    }
    if (!m_spFakeBody_with_file_schemaResource) {
        setResource(std::make_shared<FakeApiResources::FakeBody_with_file_schemaResource>());
    }
    if (!m_spFakeBody_with_query_paramsResource) {
        setResource(std::make_shared<FakeApiResources::FakeBody_with_query_paramsResource>());
    }
    if (!m_spFakeResource) {
        setResource(std::make_shared<FakeApiResources::FakeResource>());
    }
    if (!m_spFakeInline_additionalPropertiesResource) {
        setResource(std::make_shared<FakeApiResources::FakeInline_additionalPropertiesResource>());
    }
    if (!m_spFakeInline_freeform_additionalPropertiesResource) {
        setResource(std::make_shared<FakeApiResources::FakeInline_freeform_additionalPropertiesResource>());
    }
    if (!m_spFakeJsonFormDataResource) {
        setResource(std::make_shared<FakeApiResources::FakeJsonFormDataResource>());
    }
    if (!m_spFakeNullableResource) {
        setResource(std::make_shared<FakeApiResources::FakeNullableResource>());
    }
    if (!m_spFakeTest_query_parametersResource) {
        setResource(std::make_shared<FakeApiResources::FakeTest_query_parametersResource>());
    }
    if (!m_spFakeStringMap_referenceResource) {
        setResource(std::make_shared<FakeApiResources::FakeStringMap_referenceResource>());
    }
}

std::shared_ptr<restbed::Service> FakeApi::service() {
    return m_service;
}


}
}
}
}

