/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator unset.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#include <corvusoft/restbed/byte.hpp>
#include <corvusoft/restbed/string.hpp>
#include <corvusoft/restbed/settings.hpp>
#include <corvusoft/restbed/request.hpp>
#include <corvusoft/restbed/uri.hpp>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string.hpp>

#include "UserApi.h"

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

UserApiException::UserApiException(int status_code, std::string what)
  : m_status(status_code),
    m_what(what)
{

}
int UserApiException::getStatus() const
{
    return m_status;
}
const char* UserApiException::what() const noexcept
{
    return m_what.c_str();
}


template<class MODEL_T>
std::shared_ptr<MODEL_T> extractJsonModelBodyParam(const std::string& bodyContent)
{
    std::stringstream sstream(bodyContent);
    boost::property_tree::ptree pt;
    boost::property_tree::json_parser::read_json(sstream, pt);

    auto model = std::make_shared<MODEL_T>(pt);
    return model;
}

template<class MODEL_T>
std::vector<std::shared_ptr<MODEL_T>> extractJsonArrayBodyParam(const std::string& bodyContent)
{
    std::stringstream sstream(bodyContent);
    boost::property_tree::ptree pt;
    boost::property_tree::json_parser::read_json(sstream, pt);

    auto arrayRet = std::vector<std::shared_ptr<MODEL_T>>();
    for (const auto& child: pt) {
        arrayRet.emplace_back(std::make_shared<MODEL_T>(child.second));
    }
    return arrayRet;
}

template <class KEY_T, class VAL_T>
std::string convertMapResponse(const std::map<KEY_T, VAL_T>& map)
{
    boost::property_tree::ptree pt;
    for(const auto &kv: map) {
    pt.push_back(boost::property_tree::ptree::value_type(
        boost::lexical_cast<std::string>(kv.first),
        boost::property_tree::ptree(
        boost::lexical_cast<std::string>(kv.second))));
    }
    std::stringstream sstream;
    write_json(sstream, pt);
    std::string result = sstream.str();
    return result;
}

UserApiUserResource::UserApiUserResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/user/");
	this->set_method_handler("POST",
		std::bind(&UserApiUserResource::handler_POST_internal, this,
			std::placeholders::_1));
}

UserApiUserResource::~UserApiUserResource()
{
}

std::pair<int, std::string> UserApiUserResource::handleUserApiException(const UserApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> UserApiUserResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> UserApiUserResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void UserApiUserResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void UserApiUserResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void UserApiUserResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void UserApiUserResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    std::string bodyContent = extractBodyContent(session);

    // Get body params or form params here from the body content string
    auto user = extractJsonModelBodyParam<User>(bodyContent);




    int status_code = 500;
    std::string result = "";

    try {
         status_code =
             handler_POST(user);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 0) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 0, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


int UserApiUserResource::handler_POST(
        std::shared_ptr<User> const & user)
{
    throw UserApiException(501, "Not implemented");
}


std::string UserApiUserResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
UserApiUserCreateWithArrayResource::UserApiUserCreateWithArrayResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/user/createWithArray/");
	this->set_method_handler("POST",
		std::bind(&UserApiUserCreateWithArrayResource::handler_POST_internal, this,
			std::placeholders::_1));
}

UserApiUserCreateWithArrayResource::~UserApiUserCreateWithArrayResource()
{
}

std::pair<int, std::string> UserApiUserCreateWithArrayResource::handleUserApiException(const UserApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> UserApiUserCreateWithArrayResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> UserApiUserCreateWithArrayResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void UserApiUserCreateWithArrayResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void UserApiUserCreateWithArrayResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void UserApiUserCreateWithArrayResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void UserApiUserCreateWithArrayResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    std::string bodyContent = extractBodyContent(session);

    // Get body params or form params here from the body content string
    auto user = extractJsonArrayBodyParam<User>(bodyContent);




    int status_code = 500;
    std::string result = "";

    try {
         status_code =
             handler_POST(user);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 0) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 0, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


int UserApiUserCreateWithArrayResource::handler_POST(
        std::vector<std::shared_ptr<User>> const & user)
{
    throw UserApiException(501, "Not implemented");
}


std::string UserApiUserCreateWithArrayResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
UserApiUserCreateWithListResource::UserApiUserCreateWithListResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/user/createWithList/");
	this->set_method_handler("POST",
		std::bind(&UserApiUserCreateWithListResource::handler_POST_internal, this,
			std::placeholders::_1));
}

UserApiUserCreateWithListResource::~UserApiUserCreateWithListResource()
{
}

std::pair<int, std::string> UserApiUserCreateWithListResource::handleUserApiException(const UserApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> UserApiUserCreateWithListResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> UserApiUserCreateWithListResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void UserApiUserCreateWithListResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void UserApiUserCreateWithListResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void UserApiUserCreateWithListResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void UserApiUserCreateWithListResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    std::string bodyContent = extractBodyContent(session);

    // Get body params or form params here from the body content string
    auto user = extractJsonArrayBodyParam<User>(bodyContent);




    int status_code = 500;
    std::string result = "";

    try {
         status_code =
             handler_POST(user);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 0) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 0, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


int UserApiUserCreateWithListResource::handler_POST(
        std::vector<std::shared_ptr<User>> const & user)
{
    throw UserApiException(501, "Not implemented");
}


std::string UserApiUserCreateWithListResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
UserApiUserUsernameResource::UserApiUserUsernameResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/user/{username: .*}/");
	this->set_method_handler("DELETE",
		std::bind(&UserApiUserUsernameResource::handler_DELETE_internal, this,
			std::placeholders::_1));
	this->set_method_handler("GET",
		std::bind(&UserApiUserUsernameResource::handler_GET_internal, this,
			std::placeholders::_1));
	this->set_method_handler("PUT",
		std::bind(&UserApiUserUsernameResource::handler_PUT_internal, this,
			std::placeholders::_1));
}

UserApiUserUsernameResource::~UserApiUserUsernameResource()
{
}

std::pair<int, std::string> UserApiUserUsernameResource::handleUserApiException(const UserApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> UserApiUserUsernameResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> UserApiUserUsernameResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void UserApiUserUsernameResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void UserApiUserUsernameResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void UserApiUserUsernameResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void UserApiUserUsernameResource::handler_DELETE_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();

    // Getting the path params
    const std::string username = getPathParam_username(request);



    int status_code = 500;
    std::string result = "";

    try {
         status_code =
             handler_DELETE(username);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid username supplied" : result, contentType);
        return;
    }
    if (status_code == 404) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 404, result.empty() ? "User not found" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}

// x-extension
void UserApiUserUsernameResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session) {

    const auto request = session->get_request();

    // Getting the path params
    const std::string username = getPathParam_username_x_extension(request);


    int status_code = 500;
    std::shared_ptr<User> resultObject = std::make_shared<User>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
            handler_GET(username);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {
        result = resultObject->toJsonString();

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid username supplied" : result, contentType);
        return;
    }
    if (status_code == 404) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 404, result.empty() ? "User not found" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}
// x-extension
void UserApiUserUsernameResource::handler_PUT_internal(const std::shared_ptr<restbed::Session> session) {

    const auto request = session->get_request();
    std::string bodyContent = extractBodyContent(session);

    // body params or form params here from the body content string
    auto username = std::make_shared<>(bodyContent);
    auto user = extractJsonModelBodyParam<User>(bodyContent);

    // Getting the path params
    const std::string username = getPathParam_username_x_extension(request);


    int status_code = 500;
    std::string result = "";

    try {
        status_code =
            handler_PUT(username, user);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid user supplied" : result, contentType);
        return;
    }
    if (status_code == 404) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 404, result.empty() ? "User not found" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}

int UserApiUserUsernameResource::handler_DELETE(
        std::string const & username)
{
    throw UserApiException(501, "Not implemented");
}

std::pair<int, std::shared_ptr<User>> UserApiUserUsernameResource::handler_GET(
    std::string const & username)
{
    throw UserApiException(501, "Not implemented");
}
int UserApiUserUsernameResource::handler_PUT(
    std::string const & username, std::shared_ptr<User> const & user)
{
    throw UserApiException(501, "Not implemented");
}

std::string UserApiUserUsernameResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
UserApiUserLoginResource::UserApiUserLoginResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/user/login/");
	this->set_method_handler("GET",
		std::bind(&UserApiUserLoginResource::handler_GET_internal, this,
			std::placeholders::_1));
}

UserApiUserLoginResource::~UserApiUserLoginResource()
{
}

std::pair<int, std::string> UserApiUserLoginResource::handleUserApiException(const UserApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> UserApiUserLoginResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> UserApiUserLoginResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void UserApiUserLoginResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void UserApiUserLoginResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void UserApiUserLoginResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void UserApiUserLoginResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();


    // Getting the query params
    const std::string username = getQueryParam_username(request);
    const std::string password = getQueryParam_password(request);


    int status_code = 500;
    std::string resultObject = "";
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
             handler_GET(username, password);
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {
        result = resultObject;
        // Description: Cookie authentication key for use with the `api_key` apiKey authentication.
        setResponseHeader(session, "Set-Cookie");
        // Description: calls per hour allowed by the user
        setResponseHeader(session, "X-Rate-Limit");
        // Description: date in UTC when token expires
        setResponseHeader(session, "X-Expires-After");

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid username/password supplied" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


std::pair<int, std::string> UserApiUserLoginResource::handler_GET(
        std::string const & username, std::string const & password)
{
    throw UserApiException(501, "Not implemented");
}


std::string UserApiUserLoginResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
UserApiUserLogoutResource::UserApiUserLogoutResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/user/logout/");
	this->set_method_handler("GET",
		std::bind(&UserApiUserLogoutResource::handler_GET_internal, this,
			std::placeholders::_1));
}

UserApiUserLogoutResource::~UserApiUserLogoutResource()
{
}

std::pair<int, std::string> UserApiUserLogoutResource::handleUserApiException(const UserApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> UserApiUserLogoutResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> UserApiUserLogoutResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void UserApiUserLogoutResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void UserApiUserLogoutResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void UserApiUserLogoutResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void UserApiUserLogoutResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();




    int status_code = 500;
    std::string result = "";

    try {
         status_code =
             handler_GET();
    }
    catch(const UserApiException& e) {
        std::tie(status_code, result) = handleUserApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 0) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 0, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


int UserApiUserLogoutResource::handler_GET(
        )
{
    throw UserApiException(501, "Not implemented");
}


std::string UserApiUserLogoutResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

UserApi::UserApi(std::shared_ptr<restbed::Service> const& restbedService)
: m_service(restbedService)
{
}

UserApi::~UserApi() {}

void UserApi::setUserApiUserResource(std::shared_ptr<UserApiUserResource> spUserApiUserResource) {
    m_spUserApiUserResource = spUserApiUserResource;
    m_service->publish(m_spUserApiUserResource);
}
void UserApi::setUserApiUserCreateWithArrayResource(std::shared_ptr<UserApiUserCreateWithArrayResource> spUserApiUserCreateWithArrayResource) {
    m_spUserApiUserCreateWithArrayResource = spUserApiUserCreateWithArrayResource;
    m_service->publish(m_spUserApiUserCreateWithArrayResource);
}
void UserApi::setUserApiUserCreateWithListResource(std::shared_ptr<UserApiUserCreateWithListResource> spUserApiUserCreateWithListResource) {
    m_spUserApiUserCreateWithListResource = spUserApiUserCreateWithListResource;
    m_service->publish(m_spUserApiUserCreateWithListResource);
}
void UserApi::setUserApiUserUsernameResource(std::shared_ptr<UserApiUserUsernameResource> spUserApiUserUsernameResource) {
    m_spUserApiUserUsernameResource = spUserApiUserUsernameResource;
    m_service->publish(m_spUserApiUserUsernameResource);
}
void UserApi::setUserApiUserLoginResource(std::shared_ptr<UserApiUserLoginResource> spUserApiUserLoginResource) {
    m_spUserApiUserLoginResource = spUserApiUserLoginResource;
    m_service->publish(m_spUserApiUserLoginResource);
}
void UserApi::setUserApiUserLogoutResource(std::shared_ptr<UserApiUserLogoutResource> spUserApiUserLogoutResource) {
    m_spUserApiUserLogoutResource = spUserApiUserLogoutResource;
    m_service->publish(m_spUserApiUserLogoutResource);
}


void UserApi::publishDefaultResources() {
    if (!m_spUserApiUserResource) {
        setUserApiUserResource(std::make_shared<UserApiUserResource>());
    }
    if (!m_spUserApiUserCreateWithArrayResource) {
        setUserApiUserCreateWithArrayResource(std::make_shared<UserApiUserCreateWithArrayResource>());
    }
    if (!m_spUserApiUserCreateWithListResource) {
        setUserApiUserCreateWithListResource(std::make_shared<UserApiUserCreateWithListResource>());
    }
    if (!m_spUserApiUserUsernameResource) {
        setUserApiUserUsernameResource(std::make_shared<UserApiUserUsernameResource>());
    }
    if (!m_spUserApiUserLoginResource) {
        setUserApiUserLoginResource(std::make_shared<UserApiUserLoginResource>());
    }
    if (!m_spUserApiUserLogoutResource) {
        setUserApiUserLogoutResource(std::make_shared<UserApiUserLogoutResource>());
    }
}

std::shared_ptr<restbed::Service> UserApi::service() {
    return m_service;
}


}
}
}
}

