/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator unset.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * PetApi.h
 *
 * 
 */

#ifndef PetApi_H_
#define PetApi_H_


#include <memory>
#include <utility>
#include <exception>

#include <corvusoft/restbed/session.hpp>
#include <corvusoft/restbed/resource.hpp>
#include <corvusoft/restbed/request.hpp>
#include <corvusoft/restbed/service.hpp>
#include <corvusoft/restbed/settings.hpp>

#include "ApiResponse.h"
#include "Pet.h"
#include <string>

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

///
/// Exception to flag problems in the handlers
///
class  PetApiException: public std::exception
{
public:
    PetApiException(int status_code, std::string what);

    int getStatus() const;
    const char* what() const noexcept override;

private:
    int m_status;
    std::string m_what;
};

/// <summary>
/// Add a new pet to the store
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  PetApiPetResource: public restbed::Resource
{
public:
    PetApiPetResource(const std::string& context = "/v2");
    virtual ~PetApiPetResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, std::shared_ptr<Pet>> handler_POST(
        std::shared_ptr<Pet> const & pet);

    virtual std::pair<int, std::shared_ptr<Pet>> handler_PUT(
        std::shared_ptr<Pet> const & pet);

protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handlePetApiException(const PetApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
    void handler_PUT_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Deletes a pet
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  PetApiPetPetIdResource: public restbed::Resource
{
public:
    PetApiPetPetIdResource(const std::string& context = "/v2");
    virtual ~PetApiPetPetIdResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_DELETE(
        int64_t const & petId, std::string const & apiKey);

    virtual std::pair<int, std::shared_ptr<Pet>> handler_GET(
        int64_t const & petId);
    virtual int handler_POST(
        int64_t const & petId, std::string const & name, std::string const & status);

protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);

    virtual int64_t getPathParam_petId(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("petId", 0L);
    }

    virtual std::string getHeader_api_key(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_header("api_key", "");
    }


    virtual int64_t getPathParam_petId_x_extension(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("petId", 0L);
    }
    virtual int64_t getPathParam_petId_x_extension(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("petId", 0L);
    }

    virtual std::pair<int, std::string> handlePetApiException(const PetApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_DELETE_internal(const std::shared_ptr<restbed::Session> session);
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Finds Pets by status
/// </summary>
/// <remarks>
/// Multiple status values can be provided with comma separated strings
/// </remarks>
class  PetApiPetFindByStatusResource: public restbed::Resource
{
public:
    PetApiPetFindByStatusResource(const std::string& context = "/v2");
    virtual ~PetApiPetFindByStatusResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, std::vector<std::shared_ptr<Pet>>> handler_GET(
        std::vector<std::string> const & status);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handlePetApiException(const PetApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Finds Pets by tags
/// </summary>
/// <remarks>
/// Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
/// </remarks>
class  PetApiPetFindByTagsResource: public restbed::Resource
{
public:
    PetApiPetFindByTagsResource(const std::string& context = "/v2");
    virtual ~PetApiPetFindByTagsResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, std::vector<std::shared_ptr<Pet>>> handler_GET(
        std::vector<std::string> const & tags);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handlePetApiException(const PetApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// uploads an image
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  PetApiPetPetIdUploadImageResource: public restbed::Resource
{
public:
    PetApiPetPetIdUploadImageResource(const std::string& context = "/v2");
    virtual ~PetApiPetPetIdUploadImageResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, std::shared_ptr<ApiResponse>> handler_POST(
        int64_t const & petId, std::string const & additionalMetadata, std::string const & file);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);

    virtual int64_t getPathParam_petId(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("petId", 0L);
    }



    virtual std::pair<int, std::string> handlePetApiException(const PetApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};



//
// The restbed service to actually implement the REST server
//
class  PetApi
{
public:
    explicit PetApi(std::shared_ptr<restbed::Service> const& restbedService);
	virtual ~PetApi();

    virtual void setPetApiPetResource(std::shared_ptr<PetApiPetResource> spPetApiPetResource);
    virtual void setPetApiPetPetIdResource(std::shared_ptr<PetApiPetPetIdResource> spPetApiPetPetIdResource);
    virtual void setPetApiPetFindByStatusResource(std::shared_ptr<PetApiPetFindByStatusResource> spPetApiPetFindByStatusResource);
    virtual void setPetApiPetFindByTagsResource(std::shared_ptr<PetApiPetFindByTagsResource> spPetApiPetFindByTagsResource);
    virtual void setPetApiPetPetIdUploadImageResource(std::shared_ptr<PetApiPetPetIdUploadImageResource> spPetApiPetPetIdUploadImageResource);

    virtual void publishDefaultResources();

    virtual std::shared_ptr<restbed::Service> service();

protected:
	std::shared_ptr<PetApiPetResource> m_spPetApiPetResource;
	std::shared_ptr<PetApiPetPetIdResource> m_spPetApiPetPetIdResource;
	std::shared_ptr<PetApiPetFindByStatusResource> m_spPetApiPetFindByStatusResource;
	std::shared_ptr<PetApiPetFindByTagsResource> m_spPetApiPetFindByTagsResource;
	std::shared_ptr<PetApiPetPetIdUploadImageResource> m_spPetApiPetPetIdUploadImageResource;

private:
    std::shared_ptr<restbed::Service> m_service;
};


}
}
}
}

#endif /* PetApi_H_ */

