/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include <QJsonArray>
#include <QJsonDocument>
#include <QJsonObject>
#include <QVariantMap>
#include <QDebug>

#include "OAIHelpers.h"
#include "OAIPetApiRequest.h"

namespace OpenAPI {

OAIPetApiRequest::OAIPetApiRequest(QHttpEngine::Socket *s, QSharedPointer<OAIPetApiHandler> hdl) : QObject(s), socket(s), handler(hdl) {
    auto headers = s->headers();
    for(auto itr = headers.begin(); itr != headers.end(); itr++) {
        requestHeaders.insert(QString(itr.key()), QString(itr.value()));
    }
}

OAIPetApiRequest::~OAIPetApiRequest(){
    disconnect(this, nullptr, nullptr, nullptr);
    qDebug() << "OAIPetApiRequest::~OAIPetApiRequest()";
}

QMap<QString, QString>
OAIPetApiRequest::getRequestHeaders() const {
    return requestHeaders;
}

void OAIPetApiRequest::setResponseHeaders(const QMultiMap<QString, QString>& headers){
    for(auto itr = headers.begin(); itr != headers.end(); ++itr) {
        responseHeaders.insert(itr.key(), itr.value());
    }
}


QHttpEngine::Socket* OAIPetApiRequest::getRawSocket(){
    return socket;
}


void OAIPetApiRequest::addPetRequest(){
    qDebug() << "/v2/pet";
    connect(this, &OAIPetApiRequest::addPet, handler.data(), &OAIPetApiHandler::addPet);

    
 
    
    QJsonDocument doc;
    socket->readJson(doc);
    QJsonObject obj = doc.object();
    OAIPet body;
    ::OpenAPI::fromJsonValue(body, obj);
    

    Q_EMIT addPet(body);
}


void OAIPetApiRequest::deletePetRequest(const QString& pet_idstr){
    qDebug() << "/v2/pet/{petId}";
    connect(this, &OAIPetApiRequest::deletePet, handler.data(), &OAIPetApiHandler::deletePet);

    
    qint64 pet_id;
    fromStringValue(pet_idstr, pet_id);
    
    QString api_key;
    if(socket->headers().keys().contains("api_key")){
        fromStringValue(socket->queryString().value("api_key"), api_key);
    }
    

    Q_EMIT deletePet(pet_id, api_key);
}


void OAIPetApiRequest::findPetsByStatusRequest(){
    qDebug() << "/v2/pet/findByStatus";
    connect(this, &OAIPetApiRequest::findPetsByStatus, handler.data(), &OAIPetApiHandler::findPetsByStatus);

    
    QList<QString> status;
    if(socket->queryString().keys().contains("status")){
        fromStringValue(socket->queryString().values("status"), status);
    }
    


    Q_EMIT findPetsByStatus(status);
}


void OAIPetApiRequest::findPetsByTagsRequest(){
    qDebug() << "/v2/pet/findByTags";
    connect(this, &OAIPetApiRequest::findPetsByTags, handler.data(), &OAIPetApiHandler::findPetsByTags);

    
    QList<QString> tags;
    if(socket->queryString().keys().contains("tags")){
        fromStringValue(socket->queryString().values("tags"), tags);
    }
    


    Q_EMIT findPetsByTags(tags);
}


void OAIPetApiRequest::getPetByIdRequest(const QString& pet_idstr){
    qDebug() << "/v2/pet/{petId}";
    connect(this, &OAIPetApiRequest::getPetById, handler.data(), &OAIPetApiHandler::getPetById);

    
    qint64 pet_id;
    fromStringValue(pet_idstr, pet_id);
    

    Q_EMIT getPetById(pet_id);
}


void OAIPetApiRequest::updatePetRequest(){
    qDebug() << "/v2/pet";
    connect(this, &OAIPetApiRequest::updatePet, handler.data(), &OAIPetApiHandler::updatePet);

    
 
    
    QJsonDocument doc;
    socket->readJson(doc);
    QJsonObject obj = doc.object();
    OAIPet body;
    ::OpenAPI::fromJsonValue(body, obj);
    

    Q_EMIT updatePet(body);
}


void OAIPetApiRequest::updatePetWithFormRequest(const QString& pet_idstr){
    qDebug() << "/v2/pet/{petId}";
    connect(this, &OAIPetApiRequest::updatePetWithForm, handler.data(), &OAIPetApiHandler::updatePetWithForm);

    
    qint64 pet_id;
    fromStringValue(pet_idstr, pet_id);
    
    QString name;
    QString status;

    Q_EMIT updatePetWithForm(pet_id, name, status);
}


void OAIPetApiRequest::uploadFileRequest(const QString& pet_idstr){
    qDebug() << "/v2/pet/{petId}/uploadImage";
    connect(this, &OAIPetApiRequest::uploadFile, handler.data(), &OAIPetApiHandler::uploadFile);

    
    qint64 pet_id;
    fromStringValue(pet_idstr, pet_id);
    
    QString additional_metadata;
    OAIHttpFileElement file;

    Q_EMIT uploadFile(pet_id, additional_metadata, file);
}



void OAIPetApiRequest::addPetResponse(){
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::OK);
    socket->writeHeaders();
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::deletePetResponse(){
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::OK);
    socket->writeHeaders();
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::findPetsByStatusResponse(const QList<OAIPet>& res){
    setSocketResponseHeaders();
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toArray());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::findPetsByTagsResponse(const QList<OAIPet>& res){
    setSocketResponseHeaders();
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toArray());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::getPetByIdResponse(const OAIPet& res){
    setSocketResponseHeaders();
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toObject());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::updatePetResponse(){
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::OK);
    socket->writeHeaders();
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::updatePetWithFormResponse(){
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::OK);
    socket->writeHeaders();
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::uploadFileResponse(const OAIApiResponse& res){
    setSocketResponseHeaders();
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toObject());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}


void OAIPetApiRequest::addPetError(QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::NotFound);
    socket->write(error_str.toUtf8());
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::deletePetError(QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::NotFound);
    socket->write(error_str.toUtf8());
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::findPetsByStatusError(const QList<OAIPet>& res, QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    Q_UNUSED(error_str);  // response will be used instead of error string
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toArray());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::findPetsByTagsError(const QList<OAIPet>& res, QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    Q_UNUSED(error_str);  // response will be used instead of error string
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toArray());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::getPetByIdError(const OAIPet& res, QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    Q_UNUSED(error_str);  // response will be used instead of error string
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toObject());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::updatePetError(QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::NotFound);
    socket->write(error_str.toUtf8());
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::updatePetWithFormError(QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    socket->setStatusCode(QHttpEngine::Socket::NotFound);
    socket->write(error_str.toUtf8());
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::uploadFileError(const OAIApiResponse& res, QNetworkReply::NetworkError error_type, QString& error_str){
    Q_UNUSED(error_type); // TODO: Remap error_type to QHttpEngine::Socket errors
    setSocketResponseHeaders();
    Q_UNUSED(error_str);  // response will be used instead of error string
    QJsonDocument resDoc(::OpenAPI::toJsonValue(res).toObject());
    socket->writeJson(resDoc);
    if(socket->isOpen()){
        socket->close();
    }
}


void OAIPetApiRequest::sendCustomResponse(QByteArray & res, QNetworkReply::NetworkError error_type){
    Q_UNUSED(error_type); // TODO
    socket->write(res);
    if(socket->isOpen()){
        socket->close();
    }
}

void OAIPetApiRequest::sendCustomResponse(QIODevice *res, QNetworkReply::NetworkError error_type){
    Q_UNUSED(error_type);  // TODO
    socket->write(res->readAll());
    if(socket->isOpen()){
        socket->close();
    }
}

}
