/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * UserApi.h
 *
 * 
 */

#ifndef UserApi_H_
#define UserApi_H_


#include "ApiBase.h"

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>

#include <optional>
#include <utility>

#include "User.h"
#include <string>
#include <vector>

namespace org::openapitools::server::api
{

class  UserApi : public ApiBase {
public:
    explicit UserApi(const std::shared_ptr<Pistache::Rest::Router>& rtr);
    ~UserApi() override = default;
    void init() override;

    static const std::string base;

private:
    void setupRoutes();

    void create_user_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void create_users_with_array_input_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void create_users_with_list_input_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void delete_user_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void get_user_by_name_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void login_user_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void logout_user_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void update_user_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void user_api_default_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);

    /// <summary>
    /// Helper function to handle unexpected Exceptions during Parameter parsing and validation.
    /// May be overridden to return custom error formats. This is called inside a catch block.
    /// Important: When overriding, do not call `throw ex;`, but instead use `throw;`.
    /// </summary>
    virtual void handleParsingException(const std::exception& ex, Pistache::Http::ResponseWriter &response) const noexcept;

    /// <summary>
    /// Helper function to handle unexpected Exceptions during Parameter parsing and validation.
    /// May be overridden to return custom error formats. This is called inside a catch block.
    /// Important: When overriding, do not call `throw ex;`, but instead use `throw;`.
    /// </summary>
    virtual std::pair<Pistache::Http::Code, std::string> handleParsingException(const std::exception& ex) const noexcept;

    /// <summary>
    /// Helper function to handle unexpected Exceptions during processing of the request in handler functions.
    /// May be overridden to return custom error formats. This is called inside a catch block.
    /// Important: When overriding, do not call `throw ex;`, but instead use `throw;`.
    /// </summary>
    virtual void handleOperationException(const std::exception& ex, Pistache::Http::ResponseWriter &response) const noexcept;

    /// <summary>
    /// Helper function to handle unexpected Exceptions during processing of the request in handler functions.
    /// May be overridden to return custom error formats. This is called inside a catch block.
    /// Important: When overriding, do not call `throw ex;`, but instead use `throw;`.
    /// </summary>
    virtual std::pair<Pistache::Http::Code, std::string> handleOperationException(const std::exception& ex) const noexcept;

    /// <summary>
    /// Create user
    /// </summary>
    /// <remarks>
    /// This can only be done by the logged in user.
    /// </remarks>
    /// <param name="body">Created user object</param>
    virtual void create_user( const org::openapitools::server::model::User &body, Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Creates list of users with given input array
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="body">List of user object</param>
    virtual void create_users_with_array_input( const std::vector<org::openapitools::server::model::User> &body, Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Creates list of users with given input array
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="body">List of user object</param>
    virtual void create_users_with_list_input( const std::vector<org::openapitools::server::model::User> &body, Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Delete user
    /// </summary>
    /// <remarks>
    /// This can only be done by the logged in user.
    /// </remarks>
    /// <param name="username">The name that needs to be deleted</param>
    virtual void delete_user( const std::string &username, Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Get user by user name
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="username">The name that needs to be fetched. Use user1 for testing.</param>
    virtual void get_user_by_name( const std::string &username, Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Logs user into the system
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="username">The user name for login</param>
    /// <param name="password">The password for login in clear text</param>
    virtual void login_user( const std::optional<std::string> &username, const std::optional<std::string> &password, Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Logs out current logged in user session
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    virtual void logout_user( Pistache::Http::ResponseWriter &response) = 0;
    /// <summary>
    /// Updated user
    /// </summary>
    /// <remarks>
    /// This can only be done by the logged in user.
    /// </remarks>
    /// <param name="username">name that need to be deleted</param>
    /// <param name="body">Updated user object</param>
    virtual void update_user( const std::string &username, const org::openapitools::server::model::User &body, Pistache::Http::ResponseWriter &response) = 0;

};

} // namespace org::openapitools::server::api

#endif /* UserApi_H_ */

