/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/

#include "UserApi.h"
#include "Helpers.h"

namespace org::openapitools::server::api
{

using namespace org::openapitools::server::helpers;
using namespace org::openapitools::server::model;

const std::string UserApi::base = "/v2";

UserApi::UserApi(const std::shared_ptr<Pistache::Rest::Router>& rtr)
    : ApiBase(rtr)
{}

void UserApi::init() {
    setupRoutes();
}

void UserApi::setupRoutes() {
    using namespace Pistache::Rest;

    Routes::Post(*router, base + "/user", Routes::bind(&UserApi::create_user_handler, this));
    Routes::Post(*router, base + "/user/createWithArray", Routes::bind(&UserApi::create_users_with_array_input_handler, this));
    Routes::Post(*router, base + "/user/createWithList", Routes::bind(&UserApi::create_users_with_list_input_handler, this));
    Routes::Delete(*router, base + "/user/:username", Routes::bind(&UserApi::delete_user_handler, this));
    Routes::Get(*router, base + "/user/:username", Routes::bind(&UserApi::get_user_by_name_handler, this));
    Routes::Get(*router, base + "/user/login", Routes::bind(&UserApi::login_user_handler, this));
    Routes::Get(*router, base + "/user/logout", Routes::bind(&UserApi::logout_user_handler, this));
    Routes::Put(*router, base + "/user/:username", Routes::bind(&UserApi::update_user_handler, this));

    // Default handler, called when a route is not found
    router->addCustomHandler(Routes::bind(&UserApi::user_api_default_handler, this));
}

void UserApi::handleParsingException(const std::exception& ex, Pistache::Http::ResponseWriter &response) const noexcept {
    std::pair<Pistache::Http::Code, std::string> codeAndError = handleParsingException(ex);
    response.send(codeAndError.first, codeAndError.second);
}

std::pair<Pistache::Http::Code, std::string> UserApi::handleParsingException(const std::exception& ex) const noexcept {
    try {
        throw;
    } catch (nlohmann::detail::exception &e) {
        return std::make_pair(Pistache::Http::Code::Bad_Request, e.what());
    } catch (org::openapitools::server::helpers::ValidationException &e) {
        return std::make_pair(Pistache::Http::Code::Bad_Request, e.what());
    } catch (std::exception &e) {
        return std::make_pair(Pistache::Http::Code::Internal_Server_Error, e.what());
    }
}

void UserApi::handleOperationException(const std::exception& ex, Pistache::Http::ResponseWriter &response) const noexcept {
    std::pair<Pistache::Http::Code, std::string> codeAndError = handleOperationException(ex);
    response.send(codeAndError.first, codeAndError.second);
}

std::pair<Pistache::Http::Code, std::string> UserApi::handleOperationException(const std::exception& ex) const noexcept {
    return std::make_pair(Pistache::Http::Code::Internal_Server_Error, ex.what());
}

void UserApi::create_user_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        
        // Getting the body param
        
        User body;
        
        
        
    

        try {
            nlohmann::json::parse(request.body()).get_to(body);
            body.validate();
        } catch (std::exception& e) {
            this->handleParsingException(e, response);
            return;
        }

        try {





            this->create_user(body, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::create_users_with_array_input_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        
        // Getting the body param
                std::vector<User> body;
        
        
    

        try {
            nlohmann::json::parse(request.body()).get_to(body);
            for (const auto& validationParam : body) 
                validationParam.validate();
        } catch (std::exception& e) {
            this->handleParsingException(e, response);
            return;
        }

        try {





            this->create_users_with_array_input(body, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::create_users_with_list_input_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        
        // Getting the body param
                std::vector<User> body;
        
        
    

        try {
            nlohmann::json::parse(request.body()).get_to(body);
            for (const auto& validationParam : body) 
                validationParam.validate();
        } catch (std::exception& e) {
            this->handleParsingException(e, response);
            return;
        }

        try {





            this->create_users_with_list_input(body, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::delete_user_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        // Getting the path params
        auto username = request.param(":username").as<std::string>();
        
        
    


        try {





            this->delete_user(username, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::get_user_by_name_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        // Getting the path params
        auto username = request.param(":username").as<std::string>();
        
        
    


        try {





            this->get_user_by_name(username, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::login_user_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        
        
        // Getting the query params
        auto usernameQuery = request.query().get("username");
        std::optional<std::string> username;
        if (usernameQuery.has_value()) {
            std::string valueQuery_instance;
            if (fromStringValue(usernameQuery.value(), valueQuery_instance)) {
                username = valueQuery_instance;
            }
        }
        auto passwordQuery = request.query().get("password");
        std::optional<std::string> password;
        if (passwordQuery.has_value()) {
            std::string valueQuery_instance;
            if (fromStringValue(passwordQuery.value(), valueQuery_instance)) {
                password = valueQuery_instance;
            }
        }
    


        try {





            this->login_user(username, password, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::logout_user_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        
        
    


        try {





            this->logout_user(response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}

void UserApi::update_user_handler(const Pistache::Rest::Request& request, Pistache::Http::ResponseWriter response) {
    try {

        // Getting the path params
        auto username = request.param(":username").as<std::string>();
        
        // Getting the body param
        
        User body;
        
        
        
    

        try {
            nlohmann::json::parse(request.body()).get_to(body);
            body.validate();
        } catch (std::exception& e) {
            this->handleParsingException(e, response);
            return;
        }

        try {





            this->update_user(username, body, response);
            } catch (Pistache::Http::HttpError &e) {
                response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
                return;
            } catch (std::exception &e) {
                this->handleOperationException(e, response);
                return;
            }

    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    }


}


void UserApi::user_api_default_handler(const Pistache::Rest::Request &, Pistache::Http::ResponseWriter response) {
    response.send(Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

} // namespace org::openapitools::server::api

