/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * UserApi.h
 *
 * 
 */

#ifndef UserApi_H_
#define UserApi_H_



#include "oatpp/web/server/api/ApiController.hpp"
#include "oatpp/core/macro/codegen.hpp"
#include "oatpp/core/macro/component.hpp"
#include "oatpp/core/Types.hpp"

#include "User.hpp"

#include OATPP_CODEGEN_BEGIN(ApiController) ///< Begin ApiController codegen section

namespace org::openapitools::server::api
{

class UserApi : public oatpp::web::server::api::ApiController {
public:

  UserApi(OATPP_COMPONENT(std::shared_ptr<ObjectMapper>, objectMapper) /* Inject object mapper */)
    : oatpp::web::server::api::ApiController(objectMapper) 
  {}

  /// <summary>
  /// Create user
  /// </summary>
  /// <remarks>
  /// This can only be done by the logged in user.
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="user">Created user object</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> create_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::Object<org::openapitools::server::model::User> &user) = 0;

  ENDPOINT("POST", "/user", create_user_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), BODY_DTO(oatpp::Object<org::openapitools::server::model::User>, user)) {
      return create_user(request, user);
  }
  /// <summary>
  /// Creates list of users with given input array
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="user">List of user object</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> create_users_with_array_input(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::Object<org::openapitools::server::model::User>> &user) = 0;

  ENDPOINT("POST", "/user/createWithArray", create_users_with_array_input_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), BODY_DTO(oatpp::Vector<oatpp::Object<org::openapitools::server::model::User>>, user)) {
      return create_users_with_array_input(request, user);
  }
  /// <summary>
  /// Creates list of users with given input array
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="user">List of user object</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> create_users_with_list_input(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::Object<org::openapitools::server::model::User>> &user) = 0;

  ENDPOINT("POST", "/user/createWithList", create_users_with_list_input_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), BODY_DTO(oatpp::Vector<oatpp::Object<org::openapitools::server::model::User>>, user)) {
      return create_users_with_list_input(request, user);
  }
  /// <summary>
  /// Delete user
  /// </summary>
  /// <remarks>
  /// This can only be done by the logged in user.
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="username">The name that needs to be deleted</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> delete_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username) = 0;

  ENDPOINT("DELETE", "/user/{username}", delete_user_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::String, username)) {
      return delete_user(request, username);
  }
  /// <summary>
  /// Get user by user name
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="username">The name that needs to be fetched. Use user1 for testing.</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> get_user_by_name(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username) = 0;

  ENDPOINT("GET", "/user/{username}", get_user_by_name_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::String, username)) {
      return get_user_by_name(request, username);
  }
  /// <summary>
  /// Logs user into the system
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="username">The user name for login</param>
  /// <param name="password">The password for login in clear text</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> login_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username, const oatpp::String &password) = 0;

  ENDPOINT("GET", "/user/login", login_user_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), QUERY(oatpp::String, username), QUERY(oatpp::String, password)) {
      return login_user(request, username, password);
  }
  /// <summary>
  /// Logs out current logged in user session
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> logout_user(const std::shared_ptr<IncomingRequest> &request) = 0;

  ENDPOINT("GET", "/user/logout", logout_user_handler, REQUEST(std::shared_ptr<IncomingRequest>, request)) {
      return logout_user(request);
  }
  /// <summary>
  /// Updated user
  /// </summary>
  /// <remarks>
  /// This can only be done by the logged in user.
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="username">name that need to be deleted</param>
  /// <param name="user">Updated user object</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> update_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username, const oatpp::Object<org::openapitools::server::model::User> &user) = 0;

  ENDPOINT("PUT", "/user/{username}", update_user_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::String, username), BODY_DTO(oatpp::Object<org::openapitools::server::model::User>, user)) {
      return update_user(request, username, user);
  }
};

#include OATPP_CODEGEN_END(ApiController) ///< End ApiController codegen section

} // namespace org::openapitools::server::api

#endif /* UserApi_H_ */

