/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * PetApi.h
 *
 * 
 */

#ifndef PetApi_H_
#define PetApi_H_



#include "oatpp/web/server/api/ApiController.hpp"
#include "oatpp/core/macro/codegen.hpp"
#include "oatpp/core/macro/component.hpp"
#include "oatpp/core/Types.hpp"

#include "ApiResponse.hpp"
#include "Pet.hpp"

#include OATPP_CODEGEN_BEGIN(ApiController) ///< Begin ApiController codegen section

namespace org::openapitools::server::api
{

class PetApi : public oatpp::web::server::api::ApiController {
public:

  PetApi(OATPP_COMPONENT(std::shared_ptr<ObjectMapper>, objectMapper) /* Inject object mapper */)
    : oatpp::web::server::api::ApiController(objectMapper) 
  {}

  /// <summary>
  /// Add a new pet to the store
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="pet">Pet object that needs to be added to the store</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> add_pet(const std::shared_ptr<IncomingRequest> &request, const oatpp::Object<org::openapitools::server::model::Pet> &pet) = 0;

  ENDPOINT("POST", "/pet", add_pet_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), BODY_DTO(oatpp::Object<org::openapitools::server::model::Pet>, pet)) {
      return add_pet(request, pet);
  }
  /// <summary>
  /// Deletes a pet
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="petId">Pet id to delete</param>
  /// <param name="apiKey"> (optional, default to &quot;&quot;)</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> delete_pet(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId, const oatpp::String &apiKey) = 0;

  ENDPOINT("DELETE", "/pet/{petId}", delete_pet_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::Int64, petId), HEADER(oatpp::String, apiKey, "apiKey")) {
      return delete_pet(request, petId, apiKey);
  }
  /// <summary>
  /// Finds Pets by status
  /// </summary>
  /// <remarks>
  /// Multiple status values can be provided with comma separated strings
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="status">Status values that need to be considered for filter</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> find_pets_by_status(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::String> &status) = 0;

  ENDPOINT("GET", "/pet/findByStatus", find_pets_by_status_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), QUERY(oatpp::Vector<oatpp::String>, status)) {
      return find_pets_by_status(request, status);
  }
  /// <summary>
  /// Finds Pets by tags
  /// </summary>
  /// <remarks>
  /// Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="tags">Tags to filter by</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> find_pets_by_tags(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::String> &tags) = 0;

  ENDPOINT("GET", "/pet/findByTags", find_pets_by_tags_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), QUERY(oatpp::Vector<oatpp::String>, tags)) {
      return find_pets_by_tags(request, tags);
  }
  /// <summary>
  /// Find pet by ID
  /// </summary>
  /// <remarks>
  /// Returns a single pet
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="petId">ID of pet to return</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> get_pet_by_id(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId) = 0;

  ENDPOINT("GET", "/pet/{petId}", get_pet_by_id_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::Int64, petId)) {
      return get_pet_by_id(request, petId);
  }
  /// <summary>
  /// Update an existing pet
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="pet">Pet object that needs to be added to the store</param>
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> update_pet(const std::shared_ptr<IncomingRequest> &request, const oatpp::Object<org::openapitools::server::model::Pet> &pet) = 0;

  ENDPOINT("PUT", "/pet", update_pet_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), BODY_DTO(oatpp::Object<org::openapitools::server::model::Pet>, pet)) {
      return update_pet(request, pet);
  }
  /// <summary>
  /// Updates a pet in the store with form data
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="petId">ID of pet that needs to be updated</param>
  
  
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> update_pet_with_form(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId) = 0;

  ENDPOINT("POST", "/pet/{petId}", update_pet_with_form_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::Int64, petId)) {
      return update_pet_with_form(request, petId);
  }
  /// <summary>
  /// uploads an image
  /// </summary>
  /// <remarks>
  /// 
  /// </remarks>
  /// <param name="request">HTTP Request</param>
  /// <param name="petId">ID of pet to update</param>
  
  
  virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> upload_file(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId) = 0;

  ENDPOINT("POST", "/pet/{petId}/uploadImage", upload_file_handler, REQUEST(std::shared_ptr<IncomingRequest>, request), PATH(oatpp::Int64, petId)) {
      return upload_file(request, petId);
  }
};

#include OATPP_CODEGEN_END(ApiController) ///< End ApiController codegen section

} // namespace org::openapitools::server::api

#endif /* PetApi_H_ */

