/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Org.OpenAPITools.Attributes;
using Org.OpenAPITools.Models;

namespace Org.OpenAPITools.Controllers
{ 
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public abstract class PetApiController : ControllerBase
    { 
        /// <summary>
        /// Add a new pet to the store
        /// </summary>
        /// <param name="pet">Pet object that needs to be added to the store</param>
        /// <response code="200">successful operation</response>
        /// <response code="405">Invalid input</response>
        [HttpPost]
        [Route("/v2/pet")]
        [Consumes("application/json", "application/xml")]
        [ValidateModelState]
        [ProducesResponseType(statusCode: 200, type: typeof(Pet))]
        public abstract IActionResult AddPet([FromBody]Pet pet);

        /// <summary>
        /// Deletes a pet
        /// </summary>
        /// <param name="petId">Pet id to delete</param>
        /// <param name="apiKey"></param>
        /// <response code="400">Invalid pet value</response>
        [HttpDelete]
        [Route("/v2/pet/{petId}")]
        [ValidateModelState]
        public abstract IActionResult DeletePet([FromRoute (Name = "petId")][Required]long petId, [FromHeader (Name = "api_key")]string apiKey);

        /// <summary>
        /// Finds Pets by status
        /// </summary>
        /// <remarks>Multiple status values can be provided with comma separated strings</remarks>
        /// <param name="status">Status values that need to be considered for filter (deprecated)</param>
        /// <response code="200">successful operation</response>
        /// <response code="400">Invalid status value</response>
        [HttpGet]
        [Route("/v2/pet/findByStatus")]
        [ValidateModelState]
        [ProducesResponseType(statusCode: 200, type: typeof(List<Pet>))]
        public abstract IActionResult FindPetsByStatus([FromQuery (Name = "status")][Required()]List<string> status);

        /// <summary>
        /// Finds Pets by tags
        /// </summary>
        /// <remarks>Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.</remarks>
        /// <param name="tags">Tags to filter by</param>
        /// <response code="200">successful operation</response>
        /// <response code="400">Invalid tag value</response>
        [HttpGet]
        [Route("/v2/pet/findByTags")]
        [ValidateModelState]
        [ProducesResponseType(statusCode: 200, type: typeof(List<Pet>))]
        [Obsolete]
        public abstract IActionResult FindPetsByTags([FromQuery (Name = "tags")][Required()]List<string> tags);

        /// <summary>
        /// Find pet by ID
        /// </summary>
        /// <remarks>Returns a single pet</remarks>
        /// <param name="petId">ID of pet to return</param>
        /// <response code="200">successful operation</response>
        /// <response code="400">Invalid ID supplied</response>
        /// <response code="404">Pet not found</response>
        [HttpGet]
        [Route("/v2/pet/{petId}")]
        [Authorize(Policy = "api_key")]
        [ValidateModelState]
        [ProducesResponseType(statusCode: 200, type: typeof(Pet))]
        public abstract IActionResult GetPetById([FromRoute (Name = "petId")][Required]long petId);

        /// <summary>
        /// Update an existing pet
        /// </summary>
        /// <param name="pet">Pet object that needs to be added to the store</param>
        /// <response code="200">successful operation</response>
        /// <response code="400">Invalid ID supplied</response>
        /// <response code="404">Pet not found</response>
        /// <response code="405">Validation exception</response>
        [HttpPut]
        [Route("/v2/pet")]
        [Consumes("application/json", "application/xml")]
        [ValidateModelState]
        [ProducesResponseType(statusCode: 200, type: typeof(Pet))]
        public abstract IActionResult UpdatePet([FromBody]Pet pet);

        /// <summary>
        /// Updates a pet in the store with form data
        /// </summary>
        /// <param name="petId">ID of pet that needs to be updated</param>
        /// <param name="name">Updated name of the pet</param>
        /// <param name="status">Updated status of the pet</param>
        /// <response code="405">Invalid input</response>
        [HttpPost]
        [Route("/v2/pet/{petId}")]
        [Consumes("application/x-www-form-urlencoded")]
        [ValidateModelState]
        public abstract IActionResult UpdatePetWithForm([FromRoute (Name = "petId")][Required]long petId, [FromForm (Name = "name")]string name, [FromForm (Name = "status")]string status);

        /// <summary>
        /// uploads an image
        /// </summary>
        /// <param name="petId">ID of pet to update</param>
        /// <param name="additionalMetadata">Additional data to pass to server</param>
        /// <param name="file">file to upload</param>
        /// <response code="200">successful operation</response>
        [HttpPost]
        [Route("/v2/pet/{petId}/uploadImage")]
        [Consumes("multipart/form-data")]
        [ValidateModelState]
        [ProducesResponseType(statusCode: 200, type: typeof(ApiResponse))]
        public abstract IActionResult UploadFile([FromRoute (Name = "petId")][Required]long petId, [FromForm (Name = "additionalMetadata")]string additionalMetadata, IFormFile file);
    }
}
