// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

/*
 * optional body
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 1.0.1
 */

package petstoreserver

import (
	"encoding/json"
	"errors"
	"io"
	"net/http"
	"strings"
)

// JustApiAPIController binds http requests to an api service and writes the service results to the http response
type JustApiAPIController struct {
	service JustApiAPIServicer
	errorHandler ErrorHandler
}

// JustApiAPIOption for how the controller is set up.
type JustApiAPIOption func(*JustApiAPIController)

// WithJustApiAPIErrorHandler inject ErrorHandler into controller
func WithJustApiAPIErrorHandler(h ErrorHandler) JustApiAPIOption {
	return func(c *JustApiAPIController) {
		c.errorHandler = h
	}
}

// NewJustApiAPIController creates a default api controller
func NewJustApiAPIController(s JustApiAPIServicer, opts ...JustApiAPIOption) *JustApiAPIController {
	controller := &JustApiAPIController{
		service:      s,
		errorHandler: DefaultErrorHandler,
	}

	for _, opt := range opts {
		opt(controller)
	}

	return controller
}

// Routes returns all the api routes for the JustApiAPIController
func (c *JustApiAPIController) Routes() Routes {
	return Routes{
		"SendOptionalPayload": Route{
			"SendOptionalPayload",
			strings.ToUpper("Post"),
			"/api/v1/silly",
			c.SendOptionalPayload,
		},
	}
}

// OrderedRoutes returns all the api routes in a deterministic order for the JustApiAPIController
func (c *JustApiAPIController) OrderedRoutes() []Route {
	return []Route{
		Route{
			"SendOptionalPayload",
			strings.ToUpper("Post"),
			"/api/v1/silly",
			c.SendOptionalPayload,
		},
	}
}



// SendOptionalPayload - 
func (c *JustApiAPIController) SendOptionalPayload(w http.ResponseWriter, r *http.Request) {
	var payloadParam Payload
	d := json.NewDecoder(r.Body)
	d.DisallowUnknownFields()
	if err := d.Decode(&payloadParam); err != nil && !errors.Is(err, io.EOF) {
		c.errorHandler(w, r, &ParsingError{Err: err}, nil)
		return
	}
	if err := AssertPayloadRequired(payloadParam); err != nil {
		c.errorHandler(w, r, err, nil)
		return
	}
	if err := AssertPayloadConstraints(payloadParam); err != nil {
		c.errorHandler(w, r, err, nil)
		return
	}
	result, err := c.service.SendOptionalPayload(r.Context(), payloadParam)
	// If an error occurred, encode the error with the status code
	if err != nil {
		c.errorHandler(w, r, err, &result)
		return
	}
	// If no error, encode the body and the result code
	_ = EncodeJSONResponse(result.Body, &result.Code, result.Headers, w)
}
