/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package org.openapitools.database.models

import org.ktorm.dsl.*
import org.ktorm.schema.*
import org.ktorm.database.Database
import org.openapitools.client.models.*


/**
 * A pet for sale in the pet store
 * @param name 
 * @param photoUrls 
 * @param id 
 * @param category 
 * @param tags 
 * @param status pet status in the store
 */
object Pets : BaseTable<Pet>("Pet") {
    val name = text("name")
    val id = long("id") /* null */
    val category = long("category") /* null */
    @Deprecated(message = "This property is deprecated.")
    val status = text("status").transform({ Pet.Status.valueOf(it ?: "available") }, { it.value }) /* null */ /* pet status in the store */


    /**
     * Create an entity of type Pet from the model
     */
    override fun doCreateEntity(row: QueryRowSet, withReferences: Boolean) = Pet(
        name = row[name] ?: "" /* kotlin.String */,
        photoUrls = emptyList() /* kotlin.Array<kotlin.String> */,
        id = row[id]  /* kotlin.Long? */,
        category = Categorys.createEntity(row, withReferences) /* Category? */,
        tags = emptyList() /* kotlin.Array<Tag>? */,
        status = row[status]  /* kotlin.String? */ /* pet status in the store */
    )

    /**
    * Assign all the columns from the entity of type Pet to the DML expression.
    *
    * Usage:
    *
    * ```kotlin
    * let entity = Pet()
    * database.update(Pets, {
    *     assignFrom(entity)
    * })
    * ```
    * @return the builder with the columns for the update or insert.
    */
    fun AssignmentsBuilder.assignFrom(entity: Pet) {
        this.apply {
            set(Pets.name, entity.name)
            set(Pets.id, entity.id)
            set(Pets.category, entity.category)
            set(Pets.status, entity.status)
        }
    }

}


object PetPhotoUrls : BaseTable<Pair<kotlin.Long, kotlin.String>>("PetPhotoUrls") {
    val pet = long("pet")
    val photoUrls = text("photoUrls")

    override fun doCreateEntity(row: QueryRowSet, withReferences: Boolean): Pair<kotlin.Long, kotlin.String> =
        Pair(row[pet] ?: 0, row[photoUrls] ?: "")

    fun AssignmentsBuilder.assignFrom(entity: Pair<kotlin.Long, kotlin.String>) {
        this.apply {
            set(PetPhotoUrls.pet, entity.first)
            set(PetPhotoUrls.photoUrls, entity.second)
        }
    }

}

object PetTag : BaseTable<Pair<kotlin.Long, kotlin.Long>>("PetTag") {
    val pet = long("pet")
    val tag = long("tag")

    override fun doCreateEntity(row: QueryRowSet, withReferences: Boolean): Pair<kotlin.Long, kotlin.Long> =
        Pair(row[pet] ?: 0, row[tag] ?: 0)

    fun AssignmentsBuilder.assignFrom(entity: Pair<kotlin.Long, kotlin.Long>) {
        this.apply {
            set(PetTag.pet, entity.first)
            set(PetTag.tag, entity.second)
        }
    }

}

