# Go API client for petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```sh
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```go
import petstore "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```go
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `petstore.ContextServerIndex` of type `int`.

```go
ctx := context.WithValue(context.Background(), petstore.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `petstore.ContextServerVariables` of type `map[string]string`.

```go
ctx := context.WithValue(context.Background(), petstore.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `petstore.ContextOperationServerIndices` and `petstore.ContextOperationServerVariables` context maps.

```go
ctx := context.WithValue(context.Background(), petstore.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), petstore.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnotherFakeAPI* | [**Call123TestSpecialTags**](docs/AnotherFakeAPI.md#call123testspecialtags) | **Patch** /another-fake/dummy | To test special tags
*DefaultAPI* | [**FooGet**](docs/DefaultAPI.md#fooget) | **Get** /foo | 
*DefaultAPI* | [**SomeOpsRequiringRefInt**](docs/DefaultAPI.md#someopsrequiringrefint) | **Post** /fake/wrapped-integer-ref | 
*FakeAPI* | [**FakeHealthGet**](docs/FakeAPI.md#fakehealthget) | **Get** /fake/health | Health check endpoint
*FakeAPI* | [**FakeOuterBooleanSerialize**](docs/FakeAPI.md#fakeouterbooleanserialize) | **Post** /fake/outer/boolean | 
*FakeAPI* | [**FakeOuterCompositeSerialize**](docs/FakeAPI.md#fakeoutercompositeserialize) | **Post** /fake/outer/composite | 
*FakeAPI* | [**FakeOuterNumberSerialize**](docs/FakeAPI.md#fakeouternumberserialize) | **Post** /fake/outer/number | 
*FakeAPI* | [**FakeOuterStringSerialize**](docs/FakeAPI.md#fakeouterstringserialize) | **Post** /fake/outer/string | 
*FakeAPI* | [**GetParameterNameMapping**](docs/FakeAPI.md#getparameternamemapping) | **Get** /fake/parameter-name-mapping | parameter name mapping test
*FakeAPI* | [**QueryArrayWithDefaultValues**](docs/FakeAPI.md#queryarraywithdefaultvalues) | **Post** /fake/query-array-with-default-values | to test query array with default values
*FakeAPI* | [**TestAdditionalPropertiesReference**](docs/FakeAPI.md#testadditionalpropertiesreference) | **Post** /fake/additionalProperties-reference | test referenced additionalProperties
*FakeAPI* | [**TestBodyWithFileSchema**](docs/FakeAPI.md#testbodywithfileschema) | **Put** /fake/body-with-file-schema | 
*FakeAPI* | [**TestBodyWithQueryParams**](docs/FakeAPI.md#testbodywithqueryparams) | **Put** /fake/body-with-query-params | 
*FakeAPI* | [**TestClientModel**](docs/FakeAPI.md#testclientmodel) | **Patch** /fake | To test \&quot;client\&quot; model
*FakeAPI* | [**TestEndpointParameters**](docs/FakeAPI.md#testendpointparameters) | **Post** /fake | Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
*FakeAPI* | [**TestEnumParameters**](docs/FakeAPI.md#testenumparameters) | **Get** /fake | To test enum parameters
*FakeAPI* | [**TestGroupParameters**](docs/FakeAPI.md#testgroupparameters) | **Delete** /fake | Fake endpoint to test group parameters (optional)
*FakeAPI* | [**TestInlineAdditionalProperties**](docs/FakeAPI.md#testinlineadditionalproperties) | **Post** /fake/inline-additionalProperties | test inline additionalProperties
*FakeAPI* | [**TestInlineFreeformAdditionalProperties**](docs/FakeAPI.md#testinlinefreeformadditionalproperties) | **Post** /fake/inline-freeform-additionalProperties | test inline free-form additionalProperties
*FakeAPI* | [**TestJsonFormData**](docs/FakeAPI.md#testjsonformdata) | **Get** /fake/jsonFormData | test json serialization of form data
*FakeAPI* | [**TestQueryDeepObject**](docs/FakeAPI.md#testquerydeepobject) | **Get** /fake/deep_object_test | 
*FakeAPI* | [**TestQueryDeepObjectAnyof**](docs/FakeAPI.md#testquerydeepobjectanyof) | **Get** /fake/deep_object_anyof_test | 
*FakeAPI* | [**TestQueryParameterCollectionFormat**](docs/FakeAPI.md#testqueryparametercollectionformat) | **Put** /fake/test-query-parameters | 
*FakeAPI* | [**TestStringMapReference**](docs/FakeAPI.md#teststringmapreference) | **Post** /fake/stringMap-reference | test referenced string map
*FakeAPI* | [**TestUniqueItemsHeaderAndQueryParameterCollectionFormat**](docs/FakeAPI.md#testuniqueitemsheaderandqueryparametercollectionformat) | **Put** /fake/test-unique-parameters | 
*FakeClassnameTags123API* | [**TestClassname**](docs/FakeClassnameTags123API.md#testclassname) | **Patch** /fake_classname_test | To test class name in snake case
*PetAPI* | [**AddPet**](docs/PetAPI.md#addpet) | **Post** /pet | Add a new pet to the store
*PetAPI* | [**DeletePet**](docs/PetAPI.md#deletepet) | **Delete** /pet/{petId} | Deletes a pet
*PetAPI* | [**FindPetsByStatus**](docs/PetAPI.md#findpetsbystatus) | **Get** /pet/findByStatus | Finds Pets by status
*PetAPI* | [**FindPetsByTags**](docs/PetAPI.md#findpetsbytags) | **Get** /pet/findByTags | Finds Pets by tags
*PetAPI* | [**GetPetById**](docs/PetAPI.md#getpetbyid) | **Get** /pet/{petId} | Find pet by ID
*PetAPI* | [**UpdatePet**](docs/PetAPI.md#updatepet) | **Put** /pet | Update an existing pet
*PetAPI* | [**UpdatePetWithForm**](docs/PetAPI.md#updatepetwithform) | **Post** /pet/{petId} | Updates a pet in the store with form data
*PetAPI* | [**UploadFile**](docs/PetAPI.md#uploadfile) | **Post** /pet/{petId}/uploadImage | uploads an image
*PetAPI* | [**UploadFileWithRequiredFile**](docs/PetAPI.md#uploadfilewithrequiredfile) | **Post** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*StoreAPI* | [**DeleteOrder**](docs/StoreAPI.md#deleteorder) | **Delete** /store/order/{order_id} | Delete purchase order by ID
*StoreAPI* | [**GetInventory**](docs/StoreAPI.md#getinventory) | **Get** /store/inventory | Returns pet inventories by status
*StoreAPI* | [**GetOrderById**](docs/StoreAPI.md#getorderbyid) | **Get** /store/order/{order_id} | Find purchase order by ID
*StoreAPI* | [**PlaceOrder**](docs/StoreAPI.md#placeorder) | **Post** /store/order | Place an order for a pet
*UserAPI* | [**CreateUser**](docs/UserAPI.md#createuser) | **Post** /user | Create user
*UserAPI* | [**CreateUsersWithArrayInput**](docs/UserAPI.md#createuserswitharrayinput) | **Post** /user/createWithArray | Creates list of users with given input array
*UserAPI* | [**CreateUsersWithListInput**](docs/UserAPI.md#createuserswithlistinput) | **Post** /user/createWithList | Creates list of users with given input array
*UserAPI* | [**DeleteUser**](docs/UserAPI.md#deleteuser) | **Delete** /user/{username} | Delete user
*UserAPI* | [**GetUserByName**](docs/UserAPI.md#getuserbyname) | **Get** /user/{username} | Get user by user name
*UserAPI* | [**LoginUser**](docs/UserAPI.md#loginuser) | **Get** /user/login | Logs user into the system
*UserAPI* | [**LogoutUser**](docs/UserAPI.md#logoutuser) | **Get** /user/logout | Logs out current logged in user session
*UserAPI* | [**UpdateUser**](docs/UserAPI.md#updateuser) | **Put** /user/{username} | Updated user


## Documentation For Models

 - [AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [AllOfPrimitiveTypes](docs/AllOfPrimitiveTypes.md)
 - [Animal](docs/Animal.md)
 - [AnyOfPrimitiveType](docs/AnyOfPrimitiveType.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [Apple](docs/Apple.md)
 - [AppleReq](docs/AppleReq.md)
 - [ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [ArrayTest](docs/ArrayTest.md)
 - [ArrayTestWithWrapped](docs/ArrayTestWithWrapped.md)
 - [ArrayTestWithWrappedAndName](docs/ArrayTestWithWrappedAndName.md)
 - [Banana](docs/Banana.md)
 - [BananaReq](docs/BananaReq.md)
 - [Capitalization](docs/Capitalization.md)
 - [Cat](docs/Cat.md)
 - [Category](docs/Category.md)
 - [ClassModel](docs/ClassModel.md)
 - [Client](docs/Client.md)
 - [Dog](docs/Dog.md)
 - [DuplicatedPropChild](docs/DuplicatedPropChild.md)
 - [DuplicatedPropParent](docs/DuplicatedPropParent.md)
 - [EnumArrays](docs/EnumArrays.md)
 - [EnumClass](docs/EnumClass.md)
 - [EnumTest](docs/EnumTest.md)
 - [ExampleEnum](docs/ExampleEnum.md)
 - [File](docs/File.md)
 - [FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [FilterAny](docs/FilterAny.md)
 - [FilterTypeRange](docs/FilterTypeRange.md)
 - [FilterTypeRegex](docs/FilterTypeRegex.md)
 - [Foo](docs/Foo.md)
 - [FooGetDefaultResponse](docs/FooGetDefaultResponse.md)
 - [FormatTest](docs/FormatTest.md)
 - [Fruit](docs/Fruit.md)
 - [FruitJuice](docs/FruitJuice.md)
 - [FruitReq](docs/FruitReq.md)
 - [GmFruit](docs/GmFruit.md)
 - [HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [HealthCheckResult](docs/HealthCheckResult.md)
 - [IDsWrapper](docs/IDsWrapper.md)
 - [IncidentData](docs/IncidentData.md)
 - [List](docs/List.md)
 - [Mammal](docs/Mammal.md)
 - [MapOfFileTest](docs/MapOfFileTest.md)
 - [MapTest](docs/MapTest.md)
 - [MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [Model200Response](docs/Model200Response.md)
 - [Name](docs/Name.md)
 - [NullableAllOf](docs/NullableAllOf.md)
 - [NullableAllOfChild](docs/NullableAllOfChild.md)
 - [NullableClass](docs/NullableClass.md)
 - [NumberOnly](docs/NumberOnly.md)
 - [OneOfPrimitiveType](docs/OneOfPrimitiveType.md)
 - [OneOfPrimitiveTypeChild](docs/OneOfPrimitiveTypeChild.md)
 - [OneOfPrimitiveTypes](docs/OneOfPrimitiveTypes.md)
 - [OneOfWithComplexType](docs/OneOfWithComplexType.md)
 - [Order](docs/Order.md)
 - [OuterComposite](docs/OuterComposite.md)
 - [OuterEnum](docs/OuterEnum.md)
 - [OuterEnumDefaultValue](docs/OuterEnumDefaultValue.md)
 - [OuterEnumInteger](docs/OuterEnumInteger.md)
 - [OuterEnumIntegerDefaultValue](docs/OuterEnumIntegerDefaultValue.md)
 - [Pet](docs/Pet.md)
 - [PropertyNameMapping](docs/PropertyNameMapping.md)
 - [ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [ReadOnlyWithDefault](docs/ReadOnlyWithDefault.md)
 - [Return](docs/Return.md)
 - [SomeOpsRequiringRefIntRequest](docs/SomeOpsRequiringRefIntRequest.md)
 - [SpecialModelName](docs/SpecialModelName.md)
 - [Tag](docs/Tag.md)
 - [TestInlineFreeformAdditionalPropertiesRequest](docs/TestInlineFreeformAdditionalPropertiesRequest.md)
 - [User](docs/User.md)
 - [Whale](docs/Whale.md)
 - [Zebra](docs/Zebra.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### petstore_auth


- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://localhost/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

Example

```go
auth := context.WithValue(context.Background(), petstore.ContextAccessToken, "ACCESSTOKENSTRING")
r, err := client.Service.Operation(auth, args)
```

Or via OAuth2 module to automatically refresh tokens and perform user authentication.

```go
import "golang.org/x/oauth2"

/* Perform OAuth2 round trip request and obtain a token */

tokenSource := oauth2cfg.TokenSource(createContext(httpClient), &token)
auth := context.WithValue(oauth2.NoContext, petstore.ContextOAuth2, tokenSource)
r, err := client.Service.Operation(auth, args)
```

### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: api_key and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		petstore.ContextAPIKeys,
		map[string]petstore.APIKey{
			"api_key": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```

### api_key_query

- **Type**: API key
- **API key parameter name**: api_key_query
- **Location**: URL query string

Note, each API key must be added to a map of `map[string]APIKey` where the key is: api_key_query and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		petstore.ContextAPIKeys,
		map[string]petstore.APIKey{
			"api_key_query": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```

### http_basic_test

- **Type**: HTTP basic authentication

Example

```go
auth := context.WithValue(context.Background(), petstore.ContextBasicAuth, petstore.BasicAuth{
	UserName: "username",
	Password: "password",
})
r, err := client.Service.Operation(auth, args)
```

### bearer_test

- **Type**: HTTP Bearer token authentication

Example

```go
auth := context.WithValue(context.Background(), petstore.ContextAccessToken, "BEARER_TOKEN_STRING")
r, err := client.Service.Operation(auth, args)
```

### http_signature_test

- **Type**: HTTP signature authentication

Example

```go
	authConfig := petstore.HttpSignatureAuth{
		KeyId:                "my-key-id",
		PrivateKeyPath:       "rsa.pem",
		Passphrase:           "my-passphrase",
		SigningScheme:        petstore.HttpSigningSchemeHs2019,
		SignedHeaders:        []string{
			petstore.HttpSignatureParameterRequestTarget, // The special (request-target) parameter expresses the HTTP request target.
			petstore.HttpSignatureParameterCreated,       // Time when request was signed, formatted as a Unix timestamp integer value.
			"Host",                                 // The Host request header specifies the domain name of the server, and optionally the TCP port number.
			"Date",                                 // The date and time at which the message was originated.
			"Content-Type",                         // The Media type of the body of the request.
			"Digest",                               // A cryptographic digest of the request body.
		},
		SigningAlgorithm:     petstore.HttpSigningAlgorithmRsaPSS,
		SignatureMaxValidity: 5 * time.Minute,
	}
	var authCtx context.Context
	var err error
	if authCtx, err = authConfig.ContextWithValue(context.Background()); err != nil {
		// Process error
	}
	r, err = client.Service.Operation(auth, args)

```

## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



