# petstore

Petstore - the Ruby gem for the OpenAPI Extension generating aliases to maps and arrays as models

This specification shows how to generate aliases to maps and arrays as models.

This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.RubyClientCodegen

## Installation

### Build a gem

To build the Ruby code into a gem:

```shell
gem build petstore.gemspec
```

Then either install the gem locally:

```shell
gem install ./petstore-1.0.0.gem
```

(for development, run `gem install --dev ./petstore-1.0.0.gem` to install the development dependencies)

or publish the gem to a gem hosting service, e.g. [RubyGems](https://rubygems.org/).

Finally add this to the Gemfile:

    gem 'petstore', '~> 1.0.0'

### Install from Git

If the Ruby gem is hosted at a git repository: https://github.com/GIT_USER_ID/GIT_REPO_ID, then add the following in the Gemfile:

    gem 'petstore', :git => 'https://github.com/GIT_USER_ID/GIT_REPO_ID.git'

### Include the Ruby code directly

Include the Ruby code directly using `-I` as follows:

```shell
ruby -Ilib script.rb
```

## Getting Started

Please follow the [installation](#installation) procedure and then run the following code:

```ruby
# Load the gem
require 'petstore'

api_instance = Petstore::UsageApi.new
opts = {
  array_alias: Petstore::ArrayAlias.new # ArrayAlias | 
}

begin
  #Use alias to array
  result = api_instance.array(opts)
  p result
rescue Petstore::ApiError => e
  puts "Exception when calling UsageApi->array: #{e}"
end

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*Petstore::UsageApi* | [**array**](docs/UsageApi.md#array) | **GET** /array | Use alias to array
*Petstore::UsageApi* | [**map**](docs/UsageApi.md#map) | **GET** /map | Use alias to map


## Documentation for Models

 - [Petstore::ArrayAlias](docs/ArrayAlias.md)
 - [Petstore::MapAlias](docs/MapAlias.md)


## Documentation for Authorization

Endpoints do not require authorization.

