// tslint:disable
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import { HttpMethods, QueryConfig, ResponseBody, ResponseText } from 'redux-query';
import * as runtime from '../runtime';
import {
    ModelApiResponse,
    ModelApiResponseFromJSON,
    ModelApiResponseToJSON,
    Pet,
    PetFromJSON,
    PetToJSON,
} from '../models';

export interface AddPetRequest {
    body: Pet;
}

export interface DeletePetRequest {
    petId: number;
    apiKey?: string;
}

export interface FindPetsByStatusRequest {
    status: Array<FindPetsByStatusStatusEnum>;
}

export interface FindPetsByTagsRequest {
    tags: Array<string>;
}

export interface GetPetByIdRequest {
    petId: number;
}

export interface UpdatePetRequest {
    body: Pet;
}

export interface UpdatePetWithFormRequest {
    petId: number;
    name?: string;
    status?: string;
}

export interface UploadFileRequest {
    petId: number;
    additionalMetadata?: string;
    file?: Blob;
}


/**
 * Add a new pet to the store
 */
function addPetRaw<T>(requestParameters: AddPetRequest, requestConfig: runtime.TypedQueryConfig<T, void> = {}): QueryConfig<T> {
    if (requestParameters.body === null || requestParameters.body === undefined) {
        throw new runtime.RequiredError('body','Required parameter requestParameters.body was null or undefined when calling addPet.');
    }

    let queryParameters = null;


    const headerParameters : runtime.HttpHeaders = {};

    headerParameters['Content-Type'] = 'application/json';


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet`,
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'POST',
            headers: headerParameters,
        },
        body: queryParameters || PetToJSON(requestParameters.body),
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
    }

    return config;
}

/**
* Add a new pet to the store
*/
export function addPet<T>(requestParameters: AddPetRequest, requestConfig?: runtime.TypedQueryConfig<T, void>): QueryConfig<T> {
    return addPetRaw(requestParameters, requestConfig);
}

/**
 * Deletes a pet
 */
function deletePetRaw<T>(requestParameters: DeletePetRequest, requestConfig: runtime.TypedQueryConfig<T, void> = {}): QueryConfig<T> {
    if (requestParameters.petId === null || requestParameters.petId === undefined) {
        throw new runtime.RequiredError('petId','Required parameter requestParameters.petId was null or undefined when calling deletePet.');
    }

    let queryParameters = null;


    const headerParameters : runtime.HttpHeaders = {};

    if (requestParameters.apiKey !== undefined && requestParameters.apiKey !== null) {
        headerParameters['api_key'] = String(requestParameters.apiKey);
    }


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet/{petId}`.replace(`{${"petId"}}`, encodeURIComponent(String(requestParameters.petId))),
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'DELETE',
            headers: headerParameters,
        },
        body: queryParameters,
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
    }

    return config;
}

/**
* Deletes a pet
*/
export function deletePet<T>(requestParameters: DeletePetRequest, requestConfig?: runtime.TypedQueryConfig<T, void>): QueryConfig<T> {
    return deletePetRaw(requestParameters, requestConfig);
}

/**
 * Multiple status values can be provided with comma separated strings
 * Finds Pets by status
 */
function findPetsByStatusRaw<T>(requestParameters: FindPetsByStatusRequest, requestConfig: runtime.TypedQueryConfig<T, Array<Pet>> = {}): QueryConfig<T> {
    if (requestParameters.status === null || requestParameters.status === undefined) {
        throw new runtime.RequiredError('status','Required parameter requestParameters.status was null or undefined when calling findPetsByStatus.');
    }

    let queryParameters = null;

    queryParameters = {};


    if (requestParameters.status) {
        queryParameters['status'] = requestParameters.status?.join(runtime.COLLECTION_FORMATS["csv"]);
    }

    const headerParameters : runtime.HttpHeaders = {};


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet/findByStatus`,
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'GET',
            headers: headerParameters,
        },
        body: queryParameters,
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
        config.transform = (body: ResponseBody, text: ResponseBody) => requestTransform(body.map(PetFromJSON), text);
    }

    return config;
}

/**
* Multiple status values can be provided with comma separated strings
* Finds Pets by status
*/
export function findPetsByStatus<T>(requestParameters: FindPetsByStatusRequest, requestConfig?: runtime.TypedQueryConfig<T, Array<Pet>>): QueryConfig<T> {
    return findPetsByStatusRaw(requestParameters, requestConfig);
}

/**
 * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
 * Finds Pets by tags
 */
function findPetsByTagsRaw<T>(requestParameters: FindPetsByTagsRequest, requestConfig: runtime.TypedQueryConfig<T, Array<Pet>> = {}): QueryConfig<T> {
    if (requestParameters.tags === null || requestParameters.tags === undefined) {
        throw new runtime.RequiredError('tags','Required parameter requestParameters.tags was null or undefined when calling findPetsByTags.');
    }

    let queryParameters = null;

    queryParameters = {};


    if (requestParameters.tags) {
        queryParameters['tags'] = requestParameters.tags?.join(runtime.COLLECTION_FORMATS["csv"]);
    }

    const headerParameters : runtime.HttpHeaders = {};


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet/findByTags`,
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'GET',
            headers: headerParameters,
        },
        body: queryParameters,
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
        config.transform = (body: ResponseBody, text: ResponseBody) => requestTransform(body.map(PetFromJSON), text);
    }

    return config;
}

/**
* Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
* Finds Pets by tags
*/
export function findPetsByTags<T>(requestParameters: FindPetsByTagsRequest, requestConfig?: runtime.TypedQueryConfig<T, Array<Pet>>): QueryConfig<T> {
    return findPetsByTagsRaw(requestParameters, requestConfig);
}

/**
 * Returns a single pet
 * Find pet by ID
 */
function getPetByIdRaw<T>(requestParameters: GetPetByIdRequest, requestConfig: runtime.TypedQueryConfig<T, Pet> = {}): QueryConfig<T> {
    if (requestParameters.petId === null || requestParameters.petId === undefined) {
        throw new runtime.RequiredError('petId','Required parameter requestParameters.petId was null or undefined when calling getPetById.');
    }

    let queryParameters = null;


    const headerParameters : runtime.HttpHeaders = {};


    const { meta = {} } = requestConfig;

    meta.authType = ['api_key', 'header'];
    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet/{petId}`.replace(`{${"petId"}}`, encodeURIComponent(String(requestParameters.petId))),
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'GET',
            headers: headerParameters,
        },
        body: queryParameters,
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
        config.transform = (body: ResponseBody, text: ResponseBody) => requestTransform(PetFromJSON(body), text);
    }

    return config;
}

/**
* Returns a single pet
* Find pet by ID
*/
export function getPetById<T>(requestParameters: GetPetByIdRequest, requestConfig?: runtime.TypedQueryConfig<T, Pet>): QueryConfig<T> {
    return getPetByIdRaw(requestParameters, requestConfig);
}

/**
 * Update an existing pet
 */
function updatePetRaw<T>(requestParameters: UpdatePetRequest, requestConfig: runtime.TypedQueryConfig<T, void> = {}): QueryConfig<T> {
    if (requestParameters.body === null || requestParameters.body === undefined) {
        throw new runtime.RequiredError('body','Required parameter requestParameters.body was null or undefined when calling updatePet.');
    }

    let queryParameters = null;


    const headerParameters : runtime.HttpHeaders = {};

    headerParameters['Content-Type'] = 'application/json';


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet`,
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'PUT',
            headers: headerParameters,
        },
        body: queryParameters || PetToJSON(requestParameters.body),
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
    }

    return config;
}

/**
* Update an existing pet
*/
export function updatePet<T>(requestParameters: UpdatePetRequest, requestConfig?: runtime.TypedQueryConfig<T, void>): QueryConfig<T> {
    return updatePetRaw(requestParameters, requestConfig);
}

/**
 * Updates a pet in the store with form data
 */
function updatePetWithFormRaw<T>(requestParameters: UpdatePetWithFormRequest, requestConfig: runtime.TypedQueryConfig<T, void> = {}): QueryConfig<T> {
    if (requestParameters.petId === null || requestParameters.petId === undefined) {
        throw new runtime.RequiredError('petId','Required parameter requestParameters.petId was null or undefined when calling updatePetWithForm.');
    }

    let queryParameters = null;


    const headerParameters : runtime.HttpHeaders = {};


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const formData = new FormData();
    if (requestParameters.name !== undefined) {
        formData.append('name', requestParameters.name as any);
    }

    if (requestParameters.status !== undefined) {
        formData.append('status', requestParameters.status as any);
    }

    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet/{petId}`.replace(`{${"petId"}}`, encodeURIComponent(String(requestParameters.petId))),
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'POST',
            headers: headerParameters,
        },
        body: formData,
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
    }

    return config;
}

/**
* Updates a pet in the store with form data
*/
export function updatePetWithForm<T>(requestParameters: UpdatePetWithFormRequest, requestConfig?: runtime.TypedQueryConfig<T, void>): QueryConfig<T> {
    return updatePetWithFormRaw(requestParameters, requestConfig);
}

/**
 * uploads an image
 */
function uploadFileRaw<T>(requestParameters: UploadFileRequest, requestConfig: runtime.TypedQueryConfig<T, ModelApiResponse> = {}): QueryConfig<T> {
    if (requestParameters.petId === null || requestParameters.petId === undefined) {
        throw new runtime.RequiredError('petId','Required parameter requestParameters.petId was null or undefined when calling uploadFile.');
    }

    let queryParameters = null;


    const headerParameters : runtime.HttpHeaders = {};


    const { meta = {} } = requestConfig;

    meta.authType = ['oauth', ["write:pets", "read:pets"]];
    const formData = new FormData();
    if (requestParameters.additionalMetadata !== undefined) {
        formData.append('additionalMetadata', requestParameters.additionalMetadata as any);
    }

    if (requestParameters.file !== undefined) {
        formData.append('file', requestParameters.file as any);
    }

    const config: QueryConfig<T> = {
        url: `${runtime.Configuration.basePath}/pet/{petId}/uploadImage`.replace(`{${"petId"}}`, encodeURIComponent(String(requestParameters.petId))),
        meta,
        update: requestConfig.update,
        queryKey: requestConfig.queryKey,
        optimisticUpdate: requestConfig.optimisticUpdate,
        force: requestConfig.force,
        rollback: requestConfig.rollback,
        options: {
            method: 'POST',
            headers: headerParameters,
        },
        body: formData,
    };

    const { transform: requestTransform } = requestConfig;
    if (requestTransform) {
        config.transform = (body: ResponseBody, text: ResponseBody) => requestTransform(ModelApiResponseFromJSON(body), text);
    }

    return config;
}

/**
* uploads an image
*/
export function uploadFile<T>(requestParameters: UploadFileRequest, requestConfig?: runtime.TypedQueryConfig<T, ModelApiResponse>): QueryConfig<T> {
    return uploadFileRaw(requestParameters, requestConfig);
}


/**
    * @export
    * @enum {string}
    */
export enum FindPetsByStatusStatusEnum {
    Available = 'available',
    Pending = 'pending',
    Sold = 'sold'
}
