/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */

import { HttpService, Injectable, Optional } from '@nestjs/common';
import type { AxiosRequestConfig, AxiosResponse } from 'axios';
import { Observable, from, of, switchMap } from 'rxjs';
import { ApiResponse } from '../model/apiResponse';
import { Pet } from '../model/pet';
import { Configuration } from '../configuration';
import { COLLECTION_FORMATS } from '../variables';


@Injectable()
export class PetService {

    protected basePath = 'http://petstore.swagger.io/v2';
    public defaultHeaders: Record<string,string> = {};
    public configuration = new Configuration();
    protected httpClient: HttpService;

    constructor(httpClient: HttpService, @Optional() configuration: Configuration) {
        this.configuration = configuration || this.configuration;
        this.basePath = configuration?.basePath || this.basePath;
        this.httpClient = configuration?.httpClient || httpClient;
    }

    /**
     * @param consumes string[] mime-types
     * @return true: consumes contains 'multipart/form-data', false: otherwise
     */
    private canConsumeForm(consumes: string[]): boolean {
        const form = 'multipart/form-data';
        return consumes.includes(form);
    }

    /**
     * Add a new pet to the store
     * 
     * @param pet Pet object that needs to be added to the store
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [addPetOpts.config] Override http request option.
     */
    public addPet(pet: Pet, addPetOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<Pet>>;
    public addPet(pet: Pet, addPetOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (pet === null || pet === undefined) {
            throw new Error('Required parameter pet was null or undefined when calling addPet.');
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'application/xml',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json',
            'application/xml'
        ];
        const httpContentTypeSelected: string | undefined = this.configuration.selectHeaderContentType(consumes);
        if (httpContentTypeSelected != undefined) {
            headers['Content-Type'] = httpContentTypeSelected;
        }
        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.post<Pet>(`${this.basePath}/pet`,
                    pet,
                    {
                        withCredentials: this.configuration.withCredentials,
                        ...addPetOpts?.config,
                        headers: {...headers, ...addPetOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * Deletes a pet
     * 
     * @param petId Pet id to delete
     * @param apiKey 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [deletePetOpts.config] Override http request option.
     */
    public deletePet(petId: number, apiKey?: string, deletePetOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<any>>;
    public deletePet(petId: number, apiKey?: string, deletePetOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (petId === null || petId === undefined) {
            throw new Error('Required parameter petId was null or undefined when calling deletePet.');
        }

        let headers = {...this.defaultHeaders};
        if (apiKey !== undefined && apiKey !== null) {
            headers['api_key'] = String(apiKey);
        }

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];
        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.delete<any>(`${this.basePath}/pet/${encodeURIComponent(String(petId))}`,
                    {
                        withCredentials: this.configuration.withCredentials,
                        ...deletePetOpts?.config,
                        headers: {...headers, ...deletePetOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [findPetsByStatusOpts.config] Override http request option.
     */
    public findPetsByStatus(status: Array<'available' | 'pending' | 'sold'>, findPetsByStatusOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<Array<Pet>>>;
    public findPetsByStatus(status: Array<'available' | 'pending' | 'sold'>, findPetsByStatusOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (status === null || status === undefined) {
            throw new Error('Required parameter status was null or undefined when calling findPetsByStatus.');
        }

        let queryParameters = new URLSearchParams();
        if (status) {
            queryParameters.append('status', status.join(COLLECTION_FORMATS['csv']));
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'application/xml',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];
        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.get<Array<Pet>>(`${this.basePath}/pet/findByStatus`,
                    {
                        params: queryParameters,
                        withCredentials: this.configuration.withCredentials,
                        ...findPetsByStatusOpts?.config,
                        headers: {...headers, ...findPetsByStatusOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [findPetsByTagsOpts.config] Override http request option.
     */
    public findPetsByTags(tags: Array<string>, findPetsByTagsOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<Array<Pet>>>;
    public findPetsByTags(tags: Array<string>, findPetsByTagsOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (tags === null || tags === undefined) {
            throw new Error('Required parameter tags was null or undefined when calling findPetsByTags.');
        }

        let queryParameters = new URLSearchParams();
        if (tags) {
            queryParameters.append('tags', tags.join(COLLECTION_FORMATS['csv']));
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'application/xml',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];
        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.get<Array<Pet>>(`${this.basePath}/pet/findByTags`,
                    {
                        params: queryParameters,
                        withCredentials: this.configuration.withCredentials,
                        ...findPetsByTagsOpts?.config,
                        headers: {...headers, ...findPetsByTagsOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * Find pet by ID
     * Returns a single pet
     * @param petId ID of pet to return
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [getPetByIdOpts.config] Override http request option.
     */
    public getPetById(petId: number, getPetByIdOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<Pet>>;
    public getPetById(petId: number, getPetByIdOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (petId === null || petId === undefined) {
            throw new Error('Required parameter petId was null or undefined when calling getPetById.');
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (api_key) required
        if (this.configuration.apiKeys?.["api_key"]) {
            headers['api_key'] = this.configuration.apiKeys["api_key"];
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'application/xml',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];
        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.get<Pet>(`${this.basePath}/pet/${encodeURIComponent(String(petId))}`,
                    {
                        withCredentials: this.configuration.withCredentials,
                        ...getPetByIdOpts?.config,
                        headers: {...headers, ...getPetByIdOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * Update an existing pet
     * 
     * @param pet Pet object that needs to be added to the store
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [updatePetOpts.config] Override http request option.
     */
    public updatePet(pet: Pet, updatePetOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<Pet>>;
    public updatePet(pet: Pet, updatePetOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (pet === null || pet === undefined) {
            throw new Error('Required parameter pet was null or undefined when calling updatePet.');
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'application/xml',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json',
            'application/xml'
        ];
        const httpContentTypeSelected: string | undefined = this.configuration.selectHeaderContentType(consumes);
        if (httpContentTypeSelected != undefined) {
            headers['Content-Type'] = httpContentTypeSelected;
        }
        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.put<Pet>(`${this.basePath}/pet`,
                    pet,
                    {
                        withCredentials: this.configuration.withCredentials,
                        ...updatePetOpts?.config,
                        headers: {...headers, ...updatePetOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * Updates a pet in the store with form data
     * 
     * @param petId ID of pet that needs to be updated
     * @param name Updated name of the pet
     * @param status Updated status of the pet
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [updatePetWithFormOpts.config] Override http request option.
     */
    public updatePetWithForm(petId: number, name?: string, status?: string, updatePetWithFormOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<any>>;
    public updatePetWithForm(petId: number, name?: string, status?: string, updatePetWithFormOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (petId === null || petId === undefined) {
            throw new Error('Required parameter petId was null or undefined when calling updatePetWithForm.');
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/x-www-form-urlencoded'
        ];

        const canConsumeForm = this.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): void; };
        let useForm = false;
        let convertFormParamsToString = false;
        if (useForm) {
            formParams = new FormData();
        } else {
            // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        }

        if (name !== undefined) {
            formParams!.append('name', <any>name);
        }

        if (status !== undefined) {
            formParams!.append('status', <any>status);
        }

        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.post<any>(`${this.basePath}/pet/${encodeURIComponent(String(petId))}`,
                    convertFormParamsToString ? formParams!.toString() : formParams!,
                    {
                        withCredentials: this.configuration.withCredentials,
                        ...updatePetWithFormOpts?.config,
                        headers: {...headers, ...updatePetWithFormOpts?.config?.headers},
                    }
                );
            })
        );
    }
    /**
     * uploads an image
     * 
     * @param petId ID of pet to update
     * @param additionalMetadata Additional data to pass to server
     * @param file file to upload
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     * @param {*} [uploadFileOpts.config] Override http request option.
     */
    public uploadFile(petId: number, additionalMetadata?: string, file?: Blob, uploadFileOpts?: { config?: AxiosRequestConfig }): Observable<AxiosResponse<ApiResponse>>;
    public uploadFile(petId: number, additionalMetadata?: string, file?: Blob, uploadFileOpts?: { config?: AxiosRequestConfig }): Observable<any> {
        if (petId === null || petId === undefined) {
            throw new Error('Required parameter petId was null or undefined when calling uploadFile.');
        }

        let headers = {...this.defaultHeaders};

        let accessTokenObservable: Observable<any> = of(null);

        // authentication (petstore_auth) required
        if (this.configuration.accessToken) {
            accessTokenObservable = typeof this.configuration.accessToken === 'function'
                ? from(Promise.resolve(this.configuration.accessToken()))
                : from(Promise.resolve(this.configuration.accessToken))
        }

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers['Accept'] = httpHeaderAcceptSelected;
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'multipart/form-data'
        ];

        const canConsumeForm = this.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): void; };
        let useForm = false;
        let convertFormParamsToString = false;

        // use FormData to transmit files using content-type "multipart/form-data"
        // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        }

        if (additionalMetadata !== undefined) {
            formParams!.append('additionalMetadata', <any>additionalMetadata);
        }

        if (file !== undefined) {
            formParams!.append('file', <any>file);
        }

        return accessTokenObservable.pipe(
            switchMap((accessToken) => {
                if (accessToken) {
                    headers['Authorization'] = `Bearer ${accessToken}`;
                }

                return this.httpClient.post<ApiResponse>(`${this.basePath}/pet/${encodeURIComponent(String(petId))}/uploadImage`,
                    convertFormParamsToString ? formParams!.toString() : formParams!,
                    {
                        withCredentials: this.configuration.withCredentials,
                        ...uploadFileOpts?.config,
                        headers: {...headers, ...uploadFileOpts?.config?.headers},
                    }
                );
            })
        );
    }
}
