/* tslint:disable */
/* eslint-disable */
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import {Api} from './index';
import {List} from 'immutable';
import {all, fork, put, takeLatest} from "redux-saga/effects";
import {apiCall, createSagaAction as originalCreateSagaAction, BaseEntitySupportPayloadApiAction, BasePayloadApiAction, NormalizedRecordEntities, normalizedEntities} from "../runtimeSagasAndRecords";
import {Action} from "redux-ts-simple";

import {
    Category,
    CategoryRecord,
    categoryRecordUtils,
    FindPetsByStatusResponse,
    FindPetsByStatusResponseRecord,
    findPetsByStatusResponseRecordUtils,
    FindPetsByUserResponse,
    FindPetsByUserResponseRecord,
    findPetsByUserResponseRecordUtils,
    ModelApiResponse,
    ModelApiResponseRecord,
    modelApiResponseRecordUtils,
    Pet,
    PetRecord,
    petRecordUtils,
    PetRegionsResponse,
    PetRegionsResponseRecord,
    petRegionsResponseRecordUtils,
    UserRecord,
} from '../models/index';

import {
    FindPetsByStatusStatusEnum,
} from './PetApi';

const createSagaAction = <T>(type: string) => originalCreateSagaAction<T>(type, {namespace: "api_petApi"});

export const petApiSagaMap = new Map<string, () => Generator<any, any, any>>([
        ["addPet", addPetSaga],
        ["deletePet", deletePetSaga],
        ["findPetsByIds", findPetsByIdsSaga],
        ["findPetsByStatus", findPetsByStatusSaga],
        ["findPetsByTags", findPetsByTagsSaga],
        ["findPetsByUserIds", findPetsByUserIdsSaga],
        ["getPetById", getPetByIdSaga],
        ["getPetRegions", getPetRegionsSaga],
        ["updatePet", updatePetSaga],
        ["updatePetRegions", updatePetRegionsSaga],
        ["updatePetWithForm", updatePetWithFormSaga],
        ["uploadFile", uploadFileSaga],
    ]
);

export function *petApiAllSagas() {
    yield all([...petApiSagaMap.values()].map(actionSaga => fork(actionSaga)));
}

//region addPet

export interface PayloadAddPet extends PayloadAddPetRequest, BasePayloadApiAction {
}

export interface PayloadAddPetRequest {
    dummyCat: CategoryRecord;
}

export const addPetRequest = createSagaAction<PayloadAddPetRequest>("addPetRequest");
export const addPetSuccess = createSagaAction<void>("addPetSuccess");
export const addPetFailure = createSagaAction<{error: any, requestPayload: PayloadAddPet}>("addPetFailure");

export const addPet = createSagaAction<PayloadAddPet>("addPet");

export function *addPetSaga() {
    yield takeLatest(addPet, addPetSagaImp);
}

export function *addPetSagaImp(_action_: Action<PayloadAddPet>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            dummyCat,
        } = _payloadRest_;

        yield put(addPetRequest(_action_.payload));

        const response = yield apiCall(Api.petApi, Api.petApi['addPet'],
            categoryRecordUtils.toApi(dummyCat),
        );

            yield put(addPetSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(addPetFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region deletePet

export interface PayloadDeletePet extends PayloadDeletePetRequest, BasePayloadApiAction {
}

export interface PayloadDeletePetRequest {
    petId: string;
    apiKey?: string;
}

export const deletePetRequest = createSagaAction<PayloadDeletePetRequest>("deletePetRequest");
export const deletePetSuccess = createSagaAction<void>("deletePetSuccess");
export const deletePetFailure = createSagaAction<{error: any, requestPayload: PayloadDeletePet}>("deletePetFailure");

export const deletePet = createSagaAction<PayloadDeletePet>("deletePet");

export function *deletePetSaga() {
    yield takeLatest(deletePet, deletePetSagaImp);
}

export function *deletePetSagaImp(_action_: Action<PayloadDeletePet>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            petId,
            apiKey,
        } = _payloadRest_;

        yield put(deletePetRequest(_action_.payload));

        const response = yield apiCall(Api.petApi, Api.petApi['deletePet'],
            parseFloat(petId),
            apiKey,
        );

            yield put(deletePetSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(deletePetFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region findPetsByIds

export interface PayloadFindPetsByIds extends PayloadFindPetsByIdsRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadFindPetsByIdsRequest {
    ids: List<string>;
}

export const findPetsByIdsRequest = createSagaAction<PayloadFindPetsByIdsRequest>("findPetsByIdsRequest");
export const findPetsByIdsSuccess = createSagaAction<List<PetRecord>>("findPetsByIdsSuccess");
export const findPetsByIdsSuccess_Entities = createSagaAction<NormalizedRecordEntities>("findPetsByIdsSuccess_Entities");
export const findPetsByIdsFailure = createSagaAction<{error: any, requestPayload: PayloadFindPetsByIds}>("findPetsByIdsFailure");

export const findPetsByIds = createSagaAction<PayloadFindPetsByIds>("findPetsByIds");

export function *findPetsByIdsSaga() {
    yield takeLatest(findPetsByIds, findPetsByIdsSagaImp);
}

export function *findPetsByIdsSagaImp(_action_: Action<PayloadFindPetsByIds>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            ids,
        } = _payloadRest_;

        yield put(findPetsByIdsRequest(requestPayload));

        const response: Required<Array<Pet>> = yield apiCall(Api.petApi, Api.petApi['findPetsByIds'],
            ids.map(p => (p ? parseFloat(p) : null) as number ).toArray(),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = petRecordUtils.fromApiArrayAsEntities(response);
            yield put(normalizedEntities(successReturnValue));
            yield put(findPetsByIdsSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = petRecordUtils.fromApiArray(response);
            yield put(findPetsByIdsSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(findPetsByIdsFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region findPetsByStatus

export interface PayloadFindPetsByStatus extends PayloadFindPetsByStatusRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadFindPetsByStatusRequest {
    status: List<FindPetsByStatusStatusEnum>;
}

export const findPetsByStatusRequest = createSagaAction<PayloadFindPetsByStatusRequest>("findPetsByStatusRequest");
export const findPetsByStatusSuccess = createSagaAction<List<PetRecord>>("findPetsByStatusSuccess");
export const findPetsByStatusSuccess_Entities = createSagaAction<NormalizedRecordEntities>("findPetsByStatusSuccess_Entities");
export const findPetsByStatusFailure = createSagaAction<{error: any, requestPayload: PayloadFindPetsByStatus}>("findPetsByStatusFailure");

export const findPetsByStatus = createSagaAction<PayloadFindPetsByStatus>("findPetsByStatus");

export function *findPetsByStatusSaga() {
    yield takeLatest(findPetsByStatus, findPetsByStatusSagaImp);
}

export function *findPetsByStatusSagaImp(_action_: Action<PayloadFindPetsByStatus>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            status,
        } = _payloadRest_;

        yield put(findPetsByStatusRequest(requestPayload));

        const response: Required<FindPetsByStatusResponse> = yield apiCall(Api.petApi, Api.petApi['findPetsByStatus'],
            status.toJS(),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = findPetsByStatusResponseRecordUtils.fromApiPassthroughAsEntities(response);
            yield put(normalizedEntities(successReturnValue));
            yield put(findPetsByStatusSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = findPetsByStatusResponseRecordUtils.fromApiPassthrough(response);
            yield put(findPetsByStatusSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(findPetsByStatusFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region findPetsByTags

export interface PayloadFindPetsByTags extends PayloadFindPetsByTagsRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadFindPetsByTagsRequest {
    tags: List<string>;
}

export const findPetsByTagsRequest = createSagaAction<PayloadFindPetsByTagsRequest>("findPetsByTagsRequest");
export const findPetsByTagsSuccess = createSagaAction<List<PetRecord>>("findPetsByTagsSuccess");
export const findPetsByTagsSuccess_Entities = createSagaAction<NormalizedRecordEntities>("findPetsByTagsSuccess_Entities");
export const findPetsByTagsFailure = createSagaAction<{error: any, requestPayload: PayloadFindPetsByTags}>("findPetsByTagsFailure");

export const findPetsByTags = createSagaAction<PayloadFindPetsByTags>("findPetsByTags");

export function *findPetsByTagsSaga() {
    yield takeLatest(findPetsByTags, findPetsByTagsSagaImp);
}

export function *findPetsByTagsSagaImp(_action_: Action<PayloadFindPetsByTags>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            tags,
        } = _payloadRest_;

        yield put(findPetsByTagsRequest(requestPayload));

        const response: Required<Array<Pet>> = yield apiCall(Api.petApi, Api.petApi['findPetsByTags'],
            tags.toJS(),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = petRecordUtils.fromApiArrayAsEntities(response);
            yield put(normalizedEntities(successReturnValue));
            yield put(findPetsByTagsSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = petRecordUtils.fromApiArray(response);
            yield put(findPetsByTagsSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(findPetsByTagsFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region findPetsByUserIds

export interface PayloadFindPetsByUserIds extends PayloadFindPetsByUserIdsRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadFindPetsByUserIdsRequest {
    ids: List<string>;
}

export const findPetsByUserIdsRequest = createSagaAction<PayloadFindPetsByUserIdsRequest>("findPetsByUserIdsRequest");
export const findPetsByUserIdsSuccess = createSagaAction<List<UserRecord>>("findPetsByUserIdsSuccess");
export const findPetsByUserIdsSuccess_Entities = createSagaAction<NormalizedRecordEntities>("findPetsByUserIdsSuccess_Entities");
export const findPetsByUserIdsFailure = createSagaAction<{error: any, requestPayload: PayloadFindPetsByUserIds}>("findPetsByUserIdsFailure");

export const findPetsByUserIds = createSagaAction<PayloadFindPetsByUserIds>("findPetsByUserIds");

export function *findPetsByUserIdsSaga() {
    yield takeLatest(findPetsByUserIds, findPetsByUserIdsSagaImp);
}

export function *findPetsByUserIdsSagaImp(_action_: Action<PayloadFindPetsByUserIds>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            ids,
        } = _payloadRest_;

        yield put(findPetsByUserIdsRequest(requestPayload));

        const response: Required<FindPetsByUserResponse> = yield apiCall(Api.petApi, Api.petApi['findPetsByUserIds'],
            ids.map(p => (p ? parseFloat(p) : null) as number ).toArray(),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = findPetsByUserResponseRecordUtils.fromApiPassthroughAsEntities(response);
            yield put(normalizedEntities(successReturnValue));
            yield put(findPetsByUserIdsSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = findPetsByUserResponseRecordUtils.fromApiPassthrough(response);
            yield put(findPetsByUserIdsSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(findPetsByUserIdsFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region getPetById

export interface PayloadGetPetById extends PayloadGetPetByIdRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadGetPetByIdRequest {
    petId: string;
}

export const getPetByIdRequest = createSagaAction<PayloadGetPetByIdRequest>("getPetByIdRequest");
export const getPetByIdSuccess = createSagaAction<PetRecord>("getPetByIdSuccess");
export const getPetByIdSuccess_Entities = createSagaAction<NormalizedRecordEntities>("getPetByIdSuccess_Entities");
export const getPetByIdFailure = createSagaAction<{error: any, requestPayload: PayloadGetPetById}>("getPetByIdFailure");

export const getPetById = createSagaAction<PayloadGetPetById>("getPetById");

export function *getPetByIdSaga() {
    yield takeLatest(getPetById, getPetByIdSagaImp);
}

export function *getPetByIdSagaImp(_action_: Action<PayloadGetPetById>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            petId,
        } = _payloadRest_;

        yield put(getPetByIdRequest(requestPayload));

        const response: Required<Pet> = yield apiCall(Api.petApi, Api.petApi['getPetById'],
            parseFloat(petId),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = petRecordUtils.fromApiArrayAsEntities([response]);
            yield put(normalizedEntities(successReturnValue));
            yield put(getPetByIdSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = petRecordUtils.fromApi(response);
            yield put(getPetByIdSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(getPetByIdFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region getPetRegions

export interface PayloadGetPetRegions extends PayloadGetPetRegionsRequest, BasePayloadApiAction {
}

export interface PayloadGetPetRegionsRequest {
    petId: string;
}

export const getPetRegionsRequest = createSagaAction<PayloadGetPetRegionsRequest>("getPetRegionsRequest");
export const getPetRegionsSuccess = createSagaAction<List<List<string | null>>>("getPetRegionsSuccess");
export const getPetRegionsFailure = createSagaAction<{error: any, requestPayload: PayloadGetPetRegions}>("getPetRegionsFailure");

export const getPetRegions = createSagaAction<PayloadGetPetRegions>("getPetRegions");

export function *getPetRegionsSaga() {
    yield takeLatest(getPetRegions, getPetRegionsSagaImp);
}

export function *getPetRegionsSagaImp(_action_: Action<PayloadGetPetRegions>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            petId,
        } = _payloadRest_;

        yield put(getPetRegionsRequest(_action_.payload));

        const response: Required<PetRegionsResponse> = yield apiCall(Api.petApi, Api.petApi['getPetRegions'],
            parseFloat(petId),
        );

        let successReturnValue: any = undefined;
            successReturnValue = petRegionsResponseRecordUtils.fromApiPassthrough(response);
            yield put(getPetRegionsSuccess(successReturnValue));

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(getPetRegionsFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region updatePet

export interface PayloadUpdatePet extends PayloadUpdatePetRequest, BasePayloadApiAction {
}

export interface PayloadUpdatePetRequest {
    body: PetRecord;
}

export const updatePetRequest = createSagaAction<PayloadUpdatePetRequest>("updatePetRequest");
export const updatePetSuccess = createSagaAction<void>("updatePetSuccess");
export const updatePetFailure = createSagaAction<{error: any, requestPayload: PayloadUpdatePet}>("updatePetFailure");

export const updatePet = createSagaAction<PayloadUpdatePet>("updatePet");

export function *updatePetSaga() {
    yield takeLatest(updatePet, updatePetSagaImp);
}

export function *updatePetSagaImp(_action_: Action<PayloadUpdatePet>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            body,
        } = _payloadRest_;

        yield put(updatePetRequest(_action_.payload));

        const response = yield apiCall(Api.petApi, Api.petApi['updatePet'],
            petRecordUtils.toApi(body),
        );

            yield put(updatePetSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(updatePetFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region updatePetRegions

export interface PayloadUpdatePetRegions extends PayloadUpdatePetRegionsRequest, BasePayloadApiAction {
}

export interface PayloadUpdatePetRegionsRequest {
    petId: string;
    newRegions: List<List<string | null>>;
}

export const updatePetRegionsRequest = createSagaAction<PayloadUpdatePetRegionsRequest>("updatePetRegionsRequest");
export const updatePetRegionsSuccess = createSagaAction<List<List<string | null>>>("updatePetRegionsSuccess");
export const updatePetRegionsFailure = createSagaAction<{error: any, requestPayload: PayloadUpdatePetRegions}>("updatePetRegionsFailure");

export const updatePetRegions = createSagaAction<PayloadUpdatePetRegions>("updatePetRegions");

export function *updatePetRegionsSaga() {
    yield takeLatest(updatePetRegions, updatePetRegionsSagaImp);
}

export function *updatePetRegionsSagaImp(_action_: Action<PayloadUpdatePetRegions>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            petId,
            newRegions,
        } = _payloadRest_;

        yield put(updatePetRegionsRequest(_action_.payload));

        const response: Required<PetRegionsResponse> = yield apiCall(Api.petApi, Api.petApi['updatePetRegions'],
            parseFloat(petId),
            newRegions.map(p => p.toArray().map(p2 => (p2 ? parseFloat(p2) : null) as number)).toArray(),
        );

        let successReturnValue: any = undefined;
            successReturnValue = petRegionsResponseRecordUtils.fromApiPassthrough(response);
            yield put(updatePetRegionsSuccess(successReturnValue));

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(updatePetRegionsFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region updatePetWithForm

export interface PayloadUpdatePetWithForm extends PayloadUpdatePetWithFormRequest, BasePayloadApiAction {
}

export interface PayloadUpdatePetWithFormRequest {
    petId: string;
    name?: string;
    status?: string;
}

export const updatePetWithFormRequest = createSagaAction<PayloadUpdatePetWithFormRequest>("updatePetWithFormRequest");
export const updatePetWithFormSuccess = createSagaAction<void>("updatePetWithFormSuccess");
export const updatePetWithFormFailure = createSagaAction<{error: any, requestPayload: PayloadUpdatePetWithForm}>("updatePetWithFormFailure");

export const updatePetWithForm = createSagaAction<PayloadUpdatePetWithForm>("updatePetWithForm");

export function *updatePetWithFormSaga() {
    yield takeLatest(updatePetWithForm, updatePetWithFormSagaImp);
}

export function *updatePetWithFormSagaImp(_action_: Action<PayloadUpdatePetWithForm>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            petId,
            name,
            status,
        } = _payloadRest_;

        yield put(updatePetWithFormRequest(_action_.payload));

        const response = yield apiCall(Api.petApi, Api.petApi['updatePetWithForm'],
            parseFloat(petId),
            name,
            status,
        );

            yield put(updatePetWithFormSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(updatePetWithFormFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region uploadFile

export interface PayloadUploadFile extends PayloadUploadFileRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadUploadFileRequest {
    petId: string;
    additionalMetadata?: string;
    file?: Blob;
}

export const uploadFileRequest = createSagaAction<PayloadUploadFileRequest>("uploadFileRequest");
export const uploadFileSuccess = createSagaAction<ModelApiResponseRecord>("uploadFileSuccess");
export const uploadFileSuccess_Entities = createSagaAction<NormalizedRecordEntities>("uploadFileSuccess_Entities");
export const uploadFileFailure = createSagaAction<{error: any, requestPayload: PayloadUploadFile}>("uploadFileFailure");

export const uploadFile = createSagaAction<PayloadUploadFile>("uploadFile");

export function *uploadFileSaga() {
    yield takeLatest(uploadFile, uploadFileSagaImp);
}

export function *uploadFileSagaImp(_action_: Action<PayloadUploadFile>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            petId,
            additionalMetadata,
            file,
        } = _payloadRest_;

        yield put(uploadFileRequest(requestPayload));

        const response: Required<ModelApiResponse> = yield apiCall(Api.petApi, Api.petApi['uploadFile'],
            parseFloat(petId),
            additionalMetadata,
            file,
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = modelApiResponseRecordUtils.fromApiArrayAsEntities([response]);
            yield put(normalizedEntities(successReturnValue));
            yield put(uploadFileSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = modelApiResponseRecordUtils.fromApi(response);
            yield put(uploadFileSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(uploadFileFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
