import { BrowserModule } from '@angular/platform-browser'
import { NgModule } from '@angular/core'
import { HttpClientModule } from '@angular/common/http'
import {
  ApiModule,
  Configuration,
  type ConfigurationParameters
} from '@swagger/typescript-angular-petstore'

import { AppComponent } from './app.component'

export const apiConfigurationParams: ConfigurationParameters = {
  credentials: { api_key: 'foobar' }
}

export const apiConfig = new Configuration(apiConfigurationParams)

export function getApiConfig () {
  return apiConfig
}

@NgModule({
  imports: [
    BrowserModule,
    HttpClientModule,
    ApiModule.forRoot(getApiConfig)
  ],
  providers: [
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
