// Extensions.swift
//
// Generated by openapi-generator
// https://openapi-generator.tech
//

import Foundation
#if canImport(FoundationNetworking)
import FoundationNetworking
#endif

extension Bool: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension Float: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension Int: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension Int32: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension Int64: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension Double: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension Decimal: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension String: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension URL: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension UUID: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable { self }
}

extension RawRepresentable where RawValue: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable {
        rawValue.asParameter(codableHelper: codableHelper)
    }
}

private func encodeIfPossible<T: Sendable>(_ object: T, codableHelper: CodableHelper) -> any Sendable {
    if let encodableObject = object as? ParameterConvertible {
        return encodableObject.asParameter(codableHelper: codableHelper)
    } else {
        return object
    }
}

extension Array where Element: Sendable {
    func asParameter(codableHelper: CodableHelper) -> any Sendable {
        return self.map { encodeIfPossible($0, codableHelper: codableHelper) }
    }
}

extension Set where Element: Sendable {
    func asParameter(codableHelper: CodableHelper) -> any Sendable {
        return Array(self).asParameter(codableHelper: codableHelper)
    }
}

extension Dictionary where Key: Sendable, Value: Sendable {
    func asParameter(codableHelper: CodableHelper) -> any Sendable {
        var dictionary = [Key: any Sendable]()
        for (key, value) in self {
            dictionary[key] = encodeIfPossible(value, codableHelper: codableHelper)
        }
        return dictionary
    }
}

extension Data: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable {
        return self.base64EncodedString(options: Data.Base64EncodingOptions())
    }
}

extension Date: ParameterConvertible {
    func asParameter(codableHelper: CodableHelper) -> any Sendable {
        return codableHelper.dateFormatter.string(from: self)
    }
}

extension String: @retroactive CodingKey {

    public var stringValue: String {
        return self
    }

    public init?(stringValue: String) {
        self.init(stringLiteral: stringValue)
    }

    public var intValue: Int? {
        return nil
    }

    public init?(intValue: Int) {
        return nil
    }

}

extension KeyedEncodingContainerProtocol {

    public mutating func encodeArray<T>(_ values: [T], forKey key: Self.Key) throws where T: Encodable {
        var arrayContainer = nestedUnkeyedContainer(forKey: key)
        try arrayContainer.encode(contentsOf: values)
    }

    public mutating func encodeArrayIfPresent<T>(_ values: [T]?, forKey key: Self.Key) throws where T: Encodable {
        if let values = values {
            try encodeArray(values, forKey: key)
        }
    }

    public mutating func encodeMap<T>(_ pairs: [Self.Key: T]) throws where T: Encodable {
        for (key, value) in pairs {
            try encode(value, forKey: key)
        }
    }

    public mutating func encodeMapIfPresent<T>(_ pairs: [Self.Key: T]?) throws where T: Encodable {
        if let pairs = pairs {
            try encodeMap(pairs)
        }
    }

    public mutating func encode(_ value: Decimal, forKey key: Self.Key) throws {
        let decimalNumber = NSDecimalNumber(decimal: value)
        let numberFormatter = NumberFormatter()
        numberFormatter.numberStyle = .decimal
        numberFormatter.locale = Locale(identifier: "en_US")
        let formattedString = numberFormatter.string(from: decimalNumber) ?? "\(value)"
        try encode(formattedString, forKey: key)
    }

    public mutating func encodeIfPresent(_ value: Decimal?, forKey key: Self.Key) throws {
        if let value = value {
            try encode(value, forKey: key)
        }
    }
}

extension KeyedDecodingContainerProtocol {

    public func decodeArray<T>(_ type: T.Type, forKey key: Self.Key) throws -> [T] where T: Decodable {
        var tmpArray = [T]()

        var nestedContainer = try nestedUnkeyedContainer(forKey: key)
        while !nestedContainer.isAtEnd {
            let arrayValue = try nestedContainer.decode(T.self)
            tmpArray.append(arrayValue)
        }

        return tmpArray
    }

    public func decodeArrayIfPresent<T>(_ type: T.Type, forKey key: Self.Key) throws -> [T]? where T: Decodable {
        var tmpArray: [T]?

        if contains(key) {
            tmpArray = try decodeArray(T.self, forKey: key)
        }

        return tmpArray
    }

    public func decodeMap<T>(_ type: T.Type, excludedKeys: Set<Self.Key>) throws -> [Self.Key: T] where T: Decodable {
        var map: [Self.Key: T] = [:]

        for key in allKeys {
            if !excludedKeys.contains(key) {
                let value = try decode(T.self, forKey: key)
                map[key] = value
            }
        }

        return map
    }

    public func decode(_ type: Decimal.Type, forKey key: Self.Key) throws -> Decimal {
        let stringValue = try decode(String.self, forKey: key)
        guard let decimalValue = Decimal(string: stringValue) else {
            let context = DecodingError.Context(codingPath: [key], debugDescription: "The key \(key) couldn't be converted to a Decimal value")
            throw DecodingError.typeMismatch(type, context)
        }

        return decimalValue
    }

    public func decodeIfPresent(_ type: Decimal.Type, forKey key: Self.Key) throws -> Decimal? {
        guard let stringValue = try decodeIfPresent(String.self, forKey: key) else {
            return nil
        }
        guard let decimalValue = Decimal(string: stringValue) else {
            let context = DecodingError.Context(codingPath: [key], debugDescription: "The key \(key) couldn't be converted to a Decimal value")
            throw DecodingError.typeMismatch(type, context)
        }

        return decimalValue
    }

}
