/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.openapitools.client.api

import java.time.OffsetDateTime
import org.openapitools.client.model.User
import org.openapitools.client.core.JsonSupport.{*, given}
import org.openapitools.client.core.FormSerializable
import org.openapitools.client.core.FormStyleFormat
import org.openapitools.client.core.HeaderSerializable
import org.openapitools.client.core.ApiKeyLocation
import org.openapitools.client.core.PathStyleFormat
import org.openapitools.client.core.PathSerializable
import org.openapitools.client.core.CookieSerializable
import org.openapitools.client.core.Helpers.*
import sttp.client4.jsoniter.*
import sttp.client4.*
import sttp.model.Method

object UserApi:
  def apply(baseUrl: String = "http://petstore.swagger.io/v2"): UserApi[org.openapitools.client.core.Authorization.NoAuthorization.type] = UserApi(baseUrl, org.openapitools.client.core.Authorization.NoAuthorization)
  def withBasicAuth(baseUrl: String, username: String, password: String): UserApi[org.openapitools.client.core.Authorization.BasicAuth] =
    UserApi(baseUrl, org.openapitools.client.core.Authorization.BasicAuth(username, password))

  def withApiKeyAuth(baseUrl: String, apiKey: String): UserApi[org.openapitools.client.core.Authorization.ApiKey] =
    UserApi(baseUrl, org.openapitools.client.core.Authorization.ApiKey(apiKey))

  def withBearerTokenAuth(baseUrl: String, token: String): UserApi[org.openapitools.client.core.Authorization.BearerToken] =
    UserApi(baseUrl, org.openapitools.client.core.Authorization.BearerToken(token))

case class UserApi[Auth <: org.openapitools.client.core.Authorization] private (baseUrl: String, authConfig: org.openapitools.client.core.Authorization):
  def withBasicAuth(username: String, password: String): UserApi[org.openapitools.client.core.Authorization.BasicAuth] =
    copy(authConfig = org.openapitools.client.core.Authorization.BasicAuth(username, password))

  def withApiKeyAuth(apiKey: String): UserApi[org.openapitools.client.core.Authorization.ApiKey] =
    copy(authConfig = org.openapitools.client.core.Authorization.ApiKey(apiKey))

  def withNoAuth: UserApi[org.openapitools.client.core.Authorization.NoAuthorization.type] =
    copy(authConfig = org.openapitools.client.core.Authorization.NoAuthorization)

  def withBearerTokenAuth(token: String): UserApi[org.openapitools.client.core.Authorization.BearerToken] =
    copy(authConfig = org.openapitools.client.core.Authorization.BearerToken(token))

  /**
   * This can only be done by the logged in user.
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   * 
   * @param user Created user object
   */
  def createUser(user: User)(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val requestURL =
      uri"$baseUrl/user"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .body(asJson(user))
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * 
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   * 
   * @param user List of user object
   */
  def createUsersWithArrayInput(user: Seq[User])(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val requestURL =
      uri"$baseUrl/user/createWithArray"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .body(asJson(user))
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * 
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   * 
   * @param user List of user object
   */
  def createUsersWithListInput(user: Seq[User])(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val requestURL =
      uri"$baseUrl/user/createWithList"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .body(asJson(user))
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * This can only be done by the logged in user.
   * 
   * Expected answers:
   *   code 400 :  (Invalid username supplied)
   *   code 404 :  (User not found)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   * 
   * @param username The name that needs to be deleted
   */
  def deleteUser(username: String)(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val usernamePathParam = PathSerializable.serialize("username", username, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/user/${usernamePathParam}"

    basicRequest
      .method(Method.DELETE, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : User (successful operation)
   *   code 400 :  (Invalid username supplied)
   *   code 404 :  (User not found)
   * 
   * @param username The name that needs to be fetched. Use user1 for testing.
   */
  def getUserByName(username: String): sttp.client4.Request[Either[ResponseException[String], User]] =
    val usernamePathParam = PathSerializable.serialize("username", username, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/user/${usernamePathParam}"

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .response(asJson[User])

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : String (successful operation)
   *              Headers :
   *                Set-Cookie - Cookie authentication key for use with the `api_key` apiKey authentication.
   *                X-Rate-Limit - calls per hour allowed by the user
   *                X-Expires-After - date in UTC when token expires
   *   code 400 :  (Invalid username/password supplied)
   * 
   * @param username The user name for login
   * @param password The password for login in clear text
   */
  def loginUser(username: String, password: String): sttp.client4.Request[Either[ResponseException[String], String]] =
    val requestURL =
      uri"$baseUrl/user/login"
        .addParams(FormSerializable.serialize("username", username, FormStyleFormat.FORM, true): _*)
        .addParams(FormSerializable.serialize("password", password, FormStyleFormat.FORM, true): _*)

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .response(asJson[String])

  /**
   * 
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   */
  def logoutUser(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val requestURL =
      uri"$baseUrl/user/logout"

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * This can only be done by the logged in user.
   * 
   * Expected answers:
   *   code 400 :  (Invalid user supplied)
   *   code 404 :  (User not found)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   * 
   * @param username name that need to be deleted
   * @param user Updated user object
   */
  def updateUser(username: String, user: User)(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val usernamePathParam = PathSerializable.serialize("username", username, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/user/${usernamePathParam}"

    basicRequest
      .method(Method.PUT, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .body(asJson(user))
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

end UserApi