/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.openapitools.client.api

import org.openapitools.client.model.Order
import org.openapitools.client.core.JsonSupport.{*, given}
import org.openapitools.client.core.FormSerializable
import org.openapitools.client.core.FormStyleFormat
import org.openapitools.client.core.HeaderSerializable
import org.openapitools.client.core.ApiKeyLocation
import org.openapitools.client.core.PathStyleFormat
import org.openapitools.client.core.PathSerializable
import org.openapitools.client.core.CookieSerializable
import org.openapitools.client.core.Helpers.*
import sttp.client4.jsoniter.*
import sttp.client4.*
import sttp.model.Method

object StoreApi:
  def apply(baseUrl: String = "http://petstore.swagger.io/v2"): StoreApi[org.openapitools.client.core.Authorization.NoAuthorization.type] = StoreApi(baseUrl, org.openapitools.client.core.Authorization.NoAuthorization)
  def withBasicAuth(baseUrl: String, username: String, password: String): StoreApi[org.openapitools.client.core.Authorization.BasicAuth] =
    StoreApi(baseUrl, org.openapitools.client.core.Authorization.BasicAuth(username, password))

  def withApiKeyAuth(baseUrl: String, apiKey: String): StoreApi[org.openapitools.client.core.Authorization.ApiKey] =
    StoreApi(baseUrl, org.openapitools.client.core.Authorization.ApiKey(apiKey))

  def withBearerTokenAuth(baseUrl: String, token: String): StoreApi[org.openapitools.client.core.Authorization.BearerToken] =
    StoreApi(baseUrl, org.openapitools.client.core.Authorization.BearerToken(token))

case class StoreApi[Auth <: org.openapitools.client.core.Authorization] private (baseUrl: String, authConfig: org.openapitools.client.core.Authorization):
  def withBasicAuth(username: String, password: String): StoreApi[org.openapitools.client.core.Authorization.BasicAuth] =
    copy(authConfig = org.openapitools.client.core.Authorization.BasicAuth(username, password))

  def withApiKeyAuth(apiKey: String): StoreApi[org.openapitools.client.core.Authorization.ApiKey] =
    copy(authConfig = org.openapitools.client.core.Authorization.ApiKey(apiKey))

  def withNoAuth: StoreApi[org.openapitools.client.core.Authorization.NoAuthorization.type] =
    copy(authConfig = org.openapitools.client.core.Authorization.NoAuthorization)

  def withBearerTokenAuth(token: String): StoreApi[org.openapitools.client.core.Authorization.BearerToken] =
    copy(authConfig = org.openapitools.client.core.Authorization.BearerToken(token))

  /**
   * For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
   * 
   * Expected answers:
   *   code 400 :  (Invalid ID supplied)
   *   code 404 :  (Order not found)
   * 
   * @param orderId ID of the order that needs to be deleted
   */
  def deleteOrder(orderId: String): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val orderIdPathParam = PathSerializable.serialize("orderId", orderId, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/store/order/${orderIdPathParam}"

    basicRequest
      .method(Method.DELETE, requestURL)
      .contentType("application/json")
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * Returns a map of status codes to quantities
   * 
   * Expected answers:
   *   code 200 : Map[String, Int] (successful operation)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   */
  def getInventory(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Map[String, Int]]] =
    val requestURL =
      uri"$baseUrl/store/inventory"

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .response(asJson[Map[String, Int]])

  /**
   * For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions
   * 
   * Expected answers:
   *   code 200 : Order (successful operation)
   *   code 400 :  (Invalid ID supplied)
   *   code 404 :  (Order not found)
   * 
   * @param orderId ID of pet that needs to be fetched
   */
  def getOrderById(orderId: Long): sttp.client4.Request[Either[ResponseException[String], Order]] =
    val orderIdPathParam = PathSerializable.serialize("orderId", orderId, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/store/order/${orderIdPathParam}"

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .response(asJson[Order])

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : Order (successful operation)
   *   code 400 :  (Invalid Order)
   * 
   * @param order order placed for purchasing the pet
   */
  def placeOrder(order: Order): sttp.client4.Request[Either[ResponseException[String], Order]] =
    val requestURL =
      uri"$baseUrl/store/order"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("application/json")
      .body(asJson(order))
      .response(asJson[Order])

end StoreApi