/** OpenAPI Petstore
  * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
  *
  * The version of the OpenAPI document: 1.0.0
  * Contact: team@openapitools.org
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech
  * Do not edit the class manually.
  */
package org.openapitools.client.apis

import cats.effect.Concurrent
import io.circe.Encoder
import org.http4s.Uri
import org.http4s.client.Client as Http4sClient
import org.openapitools.client.models.ApiResponse
import java.io.File
import org.openapitools.client.models.FindPetsByStatusStatusParameterInner
import org.openapitools.client.models.Pet
import scala.collection.immutable.Seq
import org.openapitools.client.models.*

trait PetApiEndpoints[F[*]] {

  def addPet(pet: Pet): F[Pet]
  def deletePet(petId: Long, apiKey: Option[String] = None): F[Unit]
  def findPetsByStatus(status: Seq[FindPetsByStatusStatusParameterInner]): F[Seq[Pet]]
  def findPetsByTags(tags: Seq[String]): F[Seq[Pet]]
  def getPetById(petId: Long)(using auth: _Authorization.ApiKey): F[Pet]
  def updatePet(pet: Pet): F[Pet]
  def updatePetWithForm(petId: Long, name: Option[String] = None, status: Option[String] = None): F[Unit]
  def uploadFile(petId: Long, additionalMetadata: Option[String] = None, file: Option[File] = None): F[ApiResponse]

}

class PetApiEndpointsImpl[F[*]: Concurrent](
  override val baseUrl: Uri,
  defaultHeaders: Seq[(String, String)] = Nil,
  httpClient: Http4sClient[F]
) extends BaseClient[F](baseUrl, defaultHeaders, httpClient) with PetApiEndpoints[F] {
  
  import JsonSupports.*
  import io.circe.syntax.EncoderOps
  import cats.implicits.toFlatMapOps

  override def addPet(pet: Pet): F[Pet] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Pet, Pet](
      method = "POST",
      path = s"/pet",
      body = Some(pet),
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, Pet]("Pet", r)
        case r if r.status.code == 405 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def deletePet(petId: Long, apiKey: Option[String] = None): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json"),
      apiKey.map(x => "api_key" -> x)
    ).flatten

    _executeRequest[Unit, Unit](
      method = "DELETE",
      path = s"/pet/${petId}",
      body = None,
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def findPetsByStatus(status: Seq[FindPetsByStatusStatusParameterInner]): F[Seq[Pet]] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten
    val queryParameters = (
      Some(status.map("status" -> _))
    ).toSeq.flatten

    _executeRequest[Unit, Seq[Pet]](
      method = "GET",
      path = s"/pet/findByStatus",
      body = None,
      formParameters = None,
      queryParameters = queryParameters,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, Seq[Pet]]("Seq[Pet]", r)
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def findPetsByTags(tags: Seq[String]): F[Seq[Pet]] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten
    val queryParameters = (
      Some(tags.map("tags" -> _))
    ).toSeq.flatten

    _executeRequest[Unit, Seq[Pet]](
      method = "GET",
      path = s"/pet/findByTags",
      body = None,
      formParameters = None,
      queryParameters = queryParameters,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, Seq[Pet]]("Seq[Pet]", r)
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def getPetById(petId: Long)(using auth: _Authorization.ApiKey): F[Pet] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Unit, Pet](
      method = "GET",
      path = s"/pet/${petId}",
      body = None,
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        
        case r if r.status.code == 200 => parseJson[F, Pet]("Pet", r)
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
        case r if r.status.code == 404 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def updatePet(pet: Pet): F[Pet] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Pet, Pet](
      method = "PUT",
      path = s"/pet",
      body = Some(pet),
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, Pet]("Pet", r)
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
        case r if r.status.code == 404 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
        case r if r.status.code == 405 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def updatePetWithForm(petId: Long, name: Option[String] = None, status: Option[String] = None): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/x-www-form-urlencoded")
    ).flatten
    val formParameters = Some((
      name.map("name" -> _).map(Seq(_)) ++ 
      status.map("status" -> _).map(Seq(_))
    ).toSeq.flatten)

    _executeRequest[Unit, Unit](
      method = "POST",
      path = s"/pet/${petId}",
      body = None,
      formParameters = formParameters,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => Concurrent[F].pure(())
        case r if r.status.code == 405 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def uploadFile(petId: Long, additionalMetadata: Option[String] = None, file: Option[File] = None): F[ApiResponse] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "multipart/form-data")
    ).flatten
    val formParameters = Some((
      additionalMetadata.map("additionalMetadata" -> _).map(Seq(_)) ++ 
      file.map("file" -> _).map(Seq(_))
    ).toSeq.flatten)

    _executeRequest[Unit, ApiResponse](
      method = "POST",
      path = s"/pet/${petId}/uploadImage",
      body = None,
      formParameters = formParameters,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, ApiResponse]("ApiResponse", r)
    }
  }

}


