# Rust API client for petstore-reqwest-avoid-box

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `petstore-reqwest-avoid-box` and add the following to `Cargo.toml` under `[dependencies]`:

```
petstore-reqwest-avoid-box = { path = "./petstore-reqwest-avoid-box" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FakeApi* | [**test_nullable_required_param**](docs/FakeApi.md#test_nullable_required_param) | **GET** /fake/user/{user_name} | To test nullable required parameters
*PetApi* | [**add_pet**](docs/PetApi.md#add_pet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**delete_pet**](docs/PetApi.md#delete_pet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**find_pets_by_status**](docs/PetApi.md#find_pets_by_status) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**find_pets_by_tags**](docs/PetApi.md#find_pets_by_tags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**get_pet_by_id**](docs/PetApi.md#get_pet_by_id) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**pets_explode_post**](docs/PetApi.md#pets_explode_post) | **POST** /pets/explode | List all pets
*PetApi* | [**pets_post**](docs/PetApi.md#pets_post) | **POST** /pets | List all pets
*PetApi* | [**update_pet**](docs/PetApi.md#update_pet) | **PUT** /pet | Update an existing pet
*PetApi* | [**update_pet_with_form**](docs/PetApi.md#update_pet_with_form) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**upload_file**](docs/PetApi.md#upload_file) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApi* | [**delete_order**](docs/StoreApi.md#delete_order) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApi* | [**get_inventory**](docs/StoreApi.md#get_inventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**get_order_by_id**](docs/StoreApi.md#get_order_by_id) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApi* | [**place_order**](docs/StoreApi.md#place_order) | **POST** /store/order | Place an order for a pet
*TestingApi* | [**tests_all_of_with_one_model_get**](docs/TestingApi.md#tests_all_of_with_one_model_get) | **GET** /tests/allOfWithOneModel | Test for allOf with a single option. (One of the issues in #20500)
*TestingApi* | [**tests_file_response_get**](docs/TestingApi.md#tests_file_response_get) | **GET** /tests/fileResponse | Returns an image file
*TestingApi* | [**tests_inline_enum_boxing_get**](docs/TestingApi.md#tests_inline_enum_boxing_get) | **GET** /tests/inlineEnumBoxing | Get model with inline enums
*TestingApi* | [**tests_inline_enum_boxing_post**](docs/TestingApi.md#tests_inline_enum_boxing_post) | **POST** /tests/inlineEnumBoxing | Test for inline enum fields not being boxed in model constructors
*TestingApi* | [**tests_type_testing_get**](docs/TestingApi.md#tests_type_testing_get) | **GET** /tests/typeTesting | Route to test the TypeTesting schema
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user | Create user
*UserApi* | [**create_users_with_array_input**](docs/UserApi.md#create_users_with_array_input) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**create_users_with_list_input**](docs/UserApi.md#create_users_with_list_input) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{username} | Delete user
*UserApi* | [**get_user_by_name**](docs/UserApi.md#get_user_by_name) | **GET** /user/{username} | Get user by user name
*UserApi* | [**login_user**](docs/UserApi.md#login_user) | **GET** /user/login | Logs user into the system
*UserApi* | [**logout_user**](docs/UserApi.md#logout_user) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [ActionContainer](docs/ActionContainer.md)
 - [AnyTypeTest](docs/AnyTypeTest.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ArrayItemRefTest](docs/ArrayItemRefTest.md)
 - [Baz](docs/Baz.md)
 - [Category](docs/Category.md)
 - [EnumArrayTesting](docs/EnumArrayTesting.md)
 - [ModelWithInlineEnum](docs/ModelWithInlineEnum.md)
 - [ModelWithInlineEnumMetadata](docs/ModelWithInlineEnumMetadata.md)
 - [NullableArray](docs/NullableArray.md)
 - [NumericEnumTesting](docs/NumericEnumTesting.md)
 - [OptionalTesting](docs/OptionalTesting.md)
 - [Order](docs/Order.md)
 - [Page](docs/Page.md)
 - [Person](docs/Person.md)
 - [Pet](docs/Pet.md)
 - [PropertyTest](docs/PropertyTest.md)
 - [Ref](docs/Ref.md)
 - [Return](docs/Return.md)
 - [Tag](docs/Tag.md)
 - [TestAllOfWithMultiMetadataOnly](docs/TestAllOfWithMultiMetadataOnly.md)
 - [TypeTesting](docs/TypeTesting.md)
 - [UniqueItemArrayTesting](docs/UniqueItemArrayTesting.md)
 - [User](docs/User.md)
 - [Vehicle](docs/Vehicle.md)
 - [WithInnerOneOf](docs/WithInnerOneOf.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



