=begin
#OpenAPI Petstore

#This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

The version of the OpenAPI document: 1.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.20.0-SNAPSHOT

=end

module Petstore
  class Configuration
    # Defines url scheme
    attr_accessor :scheme

    # Defines url host
    attr_accessor :host

    # Defines url base path
    attr_accessor :base_path

    # Define server configuration index
    attr_accessor :server_index

    # Define server operation configuration index
    attr_accessor :server_operation_index

    # Default server variables
    attr_accessor :server_variables

    # Default server operation variables
    attr_accessor :server_operation_variables

    # Defines API keys used with API Key authentications.
    #
    # @return [Hash] key: parameter name, value: parameter value (API key)
    #
    # @example parameter name is "api_key", API key is "xxx" (e.g. "api_key=xxx" in query string)
    #   config.api_key['api_key'] = 'xxx'
    attr_accessor :api_key

    # Defines API key prefixes used with API Key authentications.
    #
    # @return [Hash] key: parameter name, value: API key prefix
    #
    # @example parameter name is "Authorization", API key prefix is "Token" (e.g. "Authorization: Token xxx" in headers)
    #   config.api_key_prefix['api_key'] = 'Token'
    attr_accessor :api_key_prefix

    # Defines the username used with HTTP basic authentication.
    #
    # @return [String]
    attr_accessor :username

    # Defines the password used with HTTP basic authentication.
    #
    # @return [String]
    attr_accessor :password

    # Defines the access token (Bearer) used with OAuth2.
    attr_accessor :access_token

    # Defines a Proc used to fetch or refresh access tokens (Bearer) used with OAuth2.
    # Overrides the access_token if set
    # @return [Proc]
    attr_accessor :access_token_getter

    # Set this to return data as binary instead of downloading a temp file. When enabled (set to true)
    # HTTP responses with return type `File` will be returned as a stream of binary data.
    # Default to false.
    attr_accessor :return_binary_data

    # Set this to enable/disable debugging. When enabled (set to true), HTTP request/response
    # details will be logged with `logger.debug` (see the `logger` attribute).
    # Default to false.
    #
    # @return [true, false]
    attr_accessor :debugging

    # Set this to ignore operation servers for the API client. This is useful when you need to
    # send requests to a different server than the one specified in the OpenAPI document.
    # Will default to the base url defined in the spec but can be overridden by setting
    # `scheme`, `host`, `base_path` directly.
    # Default to false.
    # @return [true, false]
    attr_accessor :ignore_operation_servers

    # Defines the logger used for debugging.
    # Default to `Rails.logger` (when in Rails) or logging to STDOUT.
    #
    # @return [#debug]
    attr_accessor :logger

    # Defines the temporary folder to store downloaded files
    # (for API endpoints that have file response).
    # Default to use `Tempfile`.
    #
    # @return [String]
    attr_accessor :temp_folder_path

    # The time limit for HTTP request in seconds.
    # Default to 0 (never times out).
    attr_accessor :timeout

    # Set this to false to skip client side validation in the operation.
    # Default to true.
    # @return [true, false]
    attr_accessor :client_side_validation

    ### TLS/SSL setting
    # Set this to false to skip verifying SSL certificate when calling API from https server.
    # Default to true.
    #
    # @note Do NOT set it to false in production code, otherwise you would face multiple types of cryptographic attacks.
    #
    # @return [true, false]
    attr_accessor :ssl_verify

    ### TLS/SSL setting
    # Any `OpenSSL::SSL::` constant (see https://ruby-doc.org/stdlib-2.5.1/libdoc/openssl/rdoc/OpenSSL/SSL.html)
    #
    # @note Do NOT set it to false in production code, otherwise you would face multiple types of cryptographic attacks.
    #
    attr_accessor :ssl_verify_mode

    ### TLS/SSL setting
    # Set this to customize the certificate file to verify the peer.
    #
    # @return [String] the path to the certificate file
    attr_accessor :ssl_ca_file

    ### TLS/SSL setting
    # Client certificate file (for client certificate)
    attr_accessor :ssl_client_cert

    ### TLS/SSL setting
    # Client private key file (for client certificate)
    attr_accessor :ssl_client_key

    ### Proxy setting
    # HTTP Proxy settings
    attr_accessor :proxy

    # Set this to customize parameters encoder of array parameter.
    # Default to nil. Faraday uses NestedParamsEncoder when nil.
    #
    # @see The params_encoder option of Faraday. Related source code:
    # https://github.com/lostisland/faraday/tree/main/lib/faraday/encoders
    attr_accessor :params_encoder


    attr_accessor :inject_format

    attr_accessor :force_ending_format

    def initialize
      @scheme = 'http'
      @host = 'petstore.swagger.io'
      @base_path = '/v2'
      @server_index = nil
      @server_operation_index = {}
      @server_variables = {}
      @server_operation_variables = {}
      @api_key = {}
      @api_key_prefix = {}
      @client_side_validation = true
      @ssl_verify = true
      @ssl_verify_mode = nil
      @ssl_ca_file = nil
      @ssl_client_cert = nil
      @ssl_client_key = nil
      @middlewares = Hash.new { |h, k| h[k] = [] }
      @configure_connection_blocks = []
      @timeout = 60
      # return data as binary instead of file
      @return_binary_data = false
      @params_encoder = nil
      @debugging = false
      @ignore_operation_servers = false
      @inject_format = false
      @force_ending_format = false
      @logger = defined?(Rails) ? Rails.logger : Logger.new(STDOUT)

      yield(self) if block_given?
    end

    # The default Configuration object.
    def self.default
      @@default ||= Configuration.new
    end

    def configure
      yield(self) if block_given?
    end

    def scheme=(scheme)
      # remove :// from scheme
      @scheme = scheme.sub(/:\/\//, '')
    end

    def host=(host)
      # remove http(s):// and anything after a slash
      @host = host.sub(/https?:\/\//, '').split('/').first
    end

    def base_path=(base_path)
      # Add leading and trailing slashes to base_path
      @base_path = "/#{base_path}".gsub(/\/+/, '/')
      @base_path = '' if @base_path == '/'
    end

    # Returns base URL for specified operation based on server settings
    def base_url(operation = nil)
      return "#{scheme}://#{[host, base_path].join('/').gsub(/\/+/, '/')}".sub(/\/+\z/, '') if ignore_operation_servers
      if operation_server_settings.key?(operation) then
        index = server_operation_index.fetch(operation, server_index)
        server_url(index.nil? ? 0 : index, server_operation_variables.fetch(operation, server_variables), operation_server_settings[operation])
      else
        server_index.nil? ? "#{scheme}://#{[host, base_path].join('/').gsub(/\/+/, '/')}".sub(/\/+\z/, '') : server_url(server_index, server_variables, nil)
      end
    end

    # Gets API key (with prefix if set).
    # @param [String] param_name the parameter name of API key auth
    def api_key_with_prefix(param_name, param_alias = nil)
      key = @api_key[param_name]
      key = @api_key.fetch(param_alias, key) unless param_alias.nil?
      if @api_key_prefix[param_name]
        "#{@api_key_prefix[param_name]} #{key}"
      else
        key
      end
    end

    # Gets access_token using access_token_getter or uses the static access_token
    def access_token_with_refresh
      return access_token if access_token_getter.nil?
      access_token_getter.call
    end

    # Gets Basic Auth token string
    def basic_auth_token
      'Basic ' + ["#{username}:#{password}"].pack('m').delete("\r\n")
    end

    # Returns Auth Settings hash for api client.
    def auth_settings
      {
        'petstore_auth' =>
          {
            type: 'oauth2',
            in: 'header',
            key: 'Authorization',
            value: "Bearer #{access_token_with_refresh}"
          },
        'api_key' =>
          {
            type: 'api_key',
            in: 'header',
            key: 'api_key',
            value: api_key_with_prefix('api_key')
          },
        'api_key_query' =>
          {
            type: 'api_key',
            in: 'query',
            key: 'api_key_query',
            value: api_key_with_prefix('api_key_query')
          },
        'http_basic_test' =>
          {
            type: 'basic',
            in: 'header',
            key: 'Authorization',
            value: basic_auth_token
          },
        'bearer_test' =>
          {
            type: 'bearer',
            in: 'header',
            format: 'JWT',
            key: 'Authorization',
            value: "Bearer #{access_token_with_refresh}"
          },
      }
    end

    # Returns an array of Server setting
    def server_settings
      [
        {
          url: "http://{server}.swagger.io:{port}/v2",
          description: "petstore server",
          variables: {
            server: {
                description: "No description provided",
                default_value: "petstore",
                enum_values: [
                  "petstore",
                  "qa-petstore",
                  "dev-petstore"
                ]
              },
            port: {
                description: "No description provided",
                default_value: "80",
                enum_values: [
                  "80",
                  "8080"
                ]
              }
            }
        },
        {
          url: "https://localhost:8080/{version}",
          description: "The local server",
          variables: {
            version: {
                description: "No description provided",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
        },
        {
          url: "https://127.0.0.1/no_varaible",
          description: "The local server without variables",
        },
        {
          url: "http://server.{version}.openapi-generator.tech",
          description: "The openapi-generator test server",
          variables: {
            version: {
                description: "target server",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
        }
      ]
    end

    def operation_server_settings
      {
        "PetApi.add_pet": [
          {
          url: "http://petstore.swagger.io/v2",
          description: "No description provided",
          },
          {
          url: "http://path-server-test.petstore.local/v2",
          description: "No description provided",
          },
          {
          url: "http://{server}.swagger.io:{port}/v2",
          description: "test server with variables",
          variables: {
            server: {
                description: "target server",
                default_value: "petstore",
                enum_values: [
                  "petstore",
                  "qa-petstore",
                  "dev-petstore"
                ]
              },
            port: {
                description: "No description provided",
                default_value: "80",
                enum_values: [
                  "80",
                  "8080"
                ]
              }
            }
          },
          {
          url: "http://path.{version}.test.openapi-generator.tech/v2",
          description: "test server with variables",
          variables: {
            version: {
                description: "target server",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
          }
        ],
        "PetApi.delete_pet": [
          {
          url: "http://petstore.swagger.io/v2",
          description: "No description provided",
          },
          {
          url: "http://path-server-test.petstore.local/v2",
          description: "No description provided",
          },
          {
          url: "http://{server}.swagger.io:{port}/v2",
          description: "test server with variables",
          variables: {
            server: {
                description: "target server",
                default_value: "petstore",
                enum_values: [
                  "petstore",
                  "qa-petstore",
                  "dev-petstore"
                ]
              },
            port: {
                description: "No description provided",
                default_value: "80",
                enum_values: [
                  "80",
                  "8080"
                ]
              }
            }
          },
          {
          url: "http://path.{version}.test.openapi-generator.tech/v2",
          description: "test server with variables",
          variables: {
            version: {
                description: "target server",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
          }
        ],
        "PetApi.get_pet_by_id": [
          {
          url: "http://petstore.swagger.io/v2",
          description: "No description provided",
          },
          {
          url: "http://path-server-test.petstore.local/v2",
          description: "No description provided",
          },
          {
          url: "http://{server}.swagger.io:{port}/v2",
          description: "test server with variables",
          variables: {
            server: {
                description: "target server",
                default_value: "petstore",
                enum_values: [
                  "petstore",
                  "qa-petstore",
                  "dev-petstore"
                ]
              },
            port: {
                description: "No description provided",
                default_value: "80",
                enum_values: [
                  "80",
                  "8080"
                ]
              }
            }
          },
          {
          url: "http://path.{version}.test.openapi-generator.tech/v2",
          description: "test server with variables",
          variables: {
            version: {
                description: "target server",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
          }
        ],
        "PetApi.update_pet": [
          {
          url: "http://petstore.swagger.io/v2",
          description: "No description provided",
          },
          {
          url: "http://path-server-test.petstore.local/v2",
          description: "No description provided",
          },
          {
          url: "http://{server}.swagger.io:{port}/v2",
          description: "test server with variables",
          variables: {
            server: {
                description: "target server",
                default_value: "petstore",
                enum_values: [
                  "petstore",
                  "qa-petstore",
                  "dev-petstore"
                ]
              },
            port: {
                description: "No description provided",
                default_value: "80",
                enum_values: [
                  "80",
                  "8080"
                ]
              }
            }
          },
          {
          url: "http://path.{version}.test.openapi-generator.tech/v2",
          description: "test server with variables",
          variables: {
            version: {
                description: "target server",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
          }
        ],
        "PetApi.update_pet_with_form": [
          {
          url: "http://petstore.swagger.io/v2",
          description: "No description provided",
          },
          {
          url: "http://path-server-test.petstore.local/v2",
          description: "No description provided",
          },
          {
          url: "http://{server}.swagger.io:{port}/v2",
          description: "test server with variables",
          variables: {
            server: {
                description: "target server",
                default_value: "petstore",
                enum_values: [
                  "petstore",
                  "qa-petstore",
                  "dev-petstore"
                ]
              },
            port: {
                description: "No description provided",
                default_value: "80",
                enum_values: [
                  "80",
                  "8080"
                ]
              }
            }
          },
          {
          url: "http://path.{version}.test.openapi-generator.tech/v2",
          description: "test server with variables",
          variables: {
            version: {
                description: "target server",
                default_value: "v2",
                enum_values: [
                  "v1",
                  "v2"
                ]
              }
            }
          }
        ],
      }
    end

    # Returns URL based on server settings
    #
    # @param index array index of the server settings
    # @param variables hash of variable and the corresponding value
    def server_url(index, variables = {}, servers = nil)
      servers = server_settings if servers == nil

      # check array index out of bound
      if (index.nil? || index < 0 || index >= servers.size)
        fail ArgumentError, "Invalid index #{index} when selecting the server. Must not be nil and must be less than #{servers.size}"
      end

      server = servers[index]
      url = server[:url]

      return url unless server.key? :variables

      # go through variable and assign a value
      server[:variables].each do |name, variable|
        if variables.key?(name)
          if (!server[:variables][name].key?(:enum_values) || server[:variables][name][:enum_values].include?(variables[name]))
            url.gsub! "{" + name.to_s + "}", variables[name]
          else
            fail ArgumentError, "The variable `#{name}` in the server URL has invalid value #{variables[name]}. Must be #{server[:variables][name][:enum_values]}."
          end
        else
          # use default value
          url.gsub! "{" + name.to_s + "}", server[:variables][name][:default_value]
        end
      end

      url
    end

    # Configure Faraday connection directly.
    #
    # ```
    # c.configure_faraday_connection do |conn|
    #   conn.use Faraday::HttpCache, shared_cache: false, logger: logger
    #   conn.response :logger, nil, headers: true, bodies: true, log_level: :debug do |logger|
    #     logger.filter(/(Authorization: )(.*)/, '\1[REDACTED]')
    #   end
    # end
    #
    # c.configure_faraday_connection do |conn|
    #   conn.adapter :typhoeus
    # end
    # ```
    #
    # @param block [Proc] `#call`able object that takes one arg, the connection
    def configure_faraday_connection(&block)
      @configure_connection_blocks << block
    end

    def configure_connection(conn)
      @configure_connection_blocks.each do |block|
        block.call(conn)
      end
    end

    # Adds middleware to the stack
    def use(*middleware)
      set_faraday_middleware(:use, *middleware)
    end

    # Adds request middleware to the stack
    def request(*middleware)
      set_faraday_middleware(:request, *middleware)
    end

    # Adds response middleware to the stack
    def response(*middleware)
      set_faraday_middleware(:response, *middleware)
    end

    # Adds Faraday middleware setting information to the stack
    #
    # @example Use the `set_faraday_middleware` method to set middleware information
    #   config.set_faraday_middleware(:request, :retry, max: 3, methods: [:get, :post], retry_statuses: [503])
    #   config.set_faraday_middleware(:response, :logger, nil, { bodies: true, log_level: :debug })
    #   config.set_faraday_middleware(:use, Faraday::HttpCache, store: Rails.cache, shared_cache: false)
    #   config.set_faraday_middleware(:insert, 0, FaradayMiddleware::FollowRedirects, { standards_compliant: true, limit: 1 })
    #   config.set_faraday_middleware(:swap, 0, Faraday::Response::Logger)
    #   config.set_faraday_middleware(:delete, Faraday::Multipart::Middleware)
    #
    # @see https://github.com/lostisland/faraday/blob/v2.3.0/lib/faraday/rack_builder.rb#L92-L143
    def set_faraday_middleware(operation, key, *args, &block)
      unless [:request, :response, :use, :insert, :insert_before, :insert_after, :swap, :delete].include?(operation)
        fail ArgumentError, "Invalid faraday middleware operation #{operation}. Must be" \
                            " :request, :response, :use, :insert, :insert_before, :insert_after, :swap or :delete."
      end

      @middlewares[operation] << [key, args, block]
    end
    ruby2_keywords(:set_faraday_middleware) if respond_to?(:ruby2_keywords, true)

    # Set up middleware on the connection
    def configure_middleware(connection)
      return if @middlewares.empty?

      [:request, :response, :use, :insert, :insert_before, :insert_after, :swap].each do |operation|
        next unless @middlewares.key?(operation)

        @middlewares[operation].each do |key, args, block|
          connection.builder.send(operation, key, *args, &block)
        end
      end

      if @middlewares.key?(:delete)
        @middlewares[:delete].each do |key, _args, _block|
          connection.builder.delete(key)
        end
      end
    end

  end
end
