#
# OpenAPI Petstore
# This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: "" \
# Version: 1.0.0
# Generated by OpenAPI Generator: https://openapi-generator.tech
#

<#
.SYNOPSIS

No summary available.

.DESCRIPTION

No description available.

.PARAMETER Json

JSON object

.OUTPUTS

GmFruit<PSCustomObject>
#>
function ConvertFrom-PSJsonToGmFruit {
    [CmdletBinding()]
    Param (
        [AllowEmptyString()]
        [string]$Json
    )

    Process {
        $match = 0
        $matchType = $null
        $matchInstance = $null

        if ($match -ne 0) { # no match yet
            # try to match Apple defined in the anyOf schemas
            try {
                $matchInstance = ConvertFrom-PSJsonToApple $Json

                foreach($property in $matchInstance.PsObject.Properties) {
                    if ($null -ne $property.Value) {
                        $matchType = "Apple"
                        $match++
                        break
                    }
                }
            } catch {
                # fail to match the schema defined in anyOf, proceed to the next one
                Write-Debug "Failed to match 'Apple' defined in anyOf (PSGmFruit). Proceeding to the next one if any."
            }
        }

        if ($match -ne 0) { # no match yet
            # try to match Banana defined in the anyOf schemas
            try {
                $matchInstance = ConvertFrom-PSJsonToBanana $Json

                foreach($property in $matchInstance.PsObject.Properties) {
                    if ($null -ne $property.Value) {
                        $matchType = "Banana"
                        $match++
                        break
                    }
                }
            } catch {
                # fail to match the schema defined in anyOf, proceed to the next one
                Write-Debug "Failed to match 'Banana' defined in anyOf (PSGmFruit). Proceeding to the next one if any."
            }
        }

        if ($match -eq 1) {
            return [PSCustomObject]@{
                "ActualType" = ${matchType}
                "ActualInstance" = ${matchInstance}
                "anyOfSchemas" = @("Apple", "Banana")
            }
        } else {
            throw "Error! The JSON payload doesn't matches any type defined in anyOf schemas ([Apple, Banana]). JSON Payload: $($Json)"
        }
    }
}

