# PSPetstore - the PowerShell module for the OpenAPI Petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

This PowerShell module is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- SDK version: 0.1.2
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PowerShellClientCodegen

<a id="frameworks-supported"></a>
## Frameworks supported
- PowerShell 5.0 or later

<a id="dependencies"></a>
## Dependencies

<a id="installation"></a>
## Installation

To install from PowerShell Gallery (https://www.powershellgallery.com/packages/PSPetstore)
```powershell
Import-Module -Name PSPetstore -Verbose
```

To install from the source, run the following command to build and install the PowerShell module locally:
```powershell
Build.ps1
Import-Module -Name '.\src\PSPetstore' -Verbose
```

To avoid function name collision, one can use `-Prefix`, e.g. `Import-Module -Name '.\src\PSPetstore' -Prefix prefix`

To uninstall the module, simply run:
```powershell
Remove-Module -FullyQualifiedName @{ModuleName = "PSPetstore"; ModuleVersion = "0.1.2"}
```

<a id="tests"></a>
## Tests

To install and run `Pester`, please execute the following commands in the terminal:

```powershell
Install-module -name Pester -force

Invoke-Pester
```

For troubleshooting, please run `$DebugPreference = 'Continue'` to turn on debugging and disable it with `$DebugPreference = 'SilentlyContinue'` when done with the troubleshooting.

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PSAnotherFakeApi* | [**Invoke-PS123TestSpecialTags**](docs/PSAnotherFakeApi.md#Invoke-PS123TestSpecialTags) | **PATCH** /another-fake/dummy | To test special tags
*PSDefaultApi* | [**Invoke-PSFooGet**](docs/PSDefaultApi.md#Invoke-PSFooGet) | **GET** /foo | 
*PSFakeApi* | [**Invoke-PSFakeHealthGet**](docs/PSFakeApi.md#Invoke-PSFakeHealthGet) | **GET** /fake/health | Health check endpoint
*PSFakeApi* | [**Invoke-PSFakeOuterBooleanSerialize**](docs/PSFakeApi.md#Invoke-PSFakeOuterBooleanSerialize) | **POST** /fake/outer/boolean | 
*PSFakeApi* | [**Invoke-PSFakeOuterCompositeSerialize**](docs/PSFakeApi.md#Invoke-PSFakeOuterCompositeSerialize) | **POST** /fake/outer/composite | 
*PSFakeApi* | [**Invoke-PSFakeOuterNumberSerialize**](docs/PSFakeApi.md#Invoke-PSFakeOuterNumberSerialize) | **POST** /fake/outer/number | 
*PSFakeApi* | [**Invoke-PSFakeOuterStringSerialize**](docs/PSFakeApi.md#Invoke-PSFakeOuterStringSerialize) | **POST** /fake/outer/string | 
*PSFakeApi* | [**Get-PSArrayOfEnums**](docs/PSFakeApi.md#Get-PSArrayOfEnums) | **GET** /fake/array-of-enums | Array of Enums
*PSFakeApi* | [**Test-PSAdditionalPropertiesReference**](docs/PSFakeApi.md#Test-PSAdditionalPropertiesReference) | **POST** /fake/additionalProperties-reference | test referenced additionalProperties
*PSFakeApi* | [**Test-PSBodyWithFileSchema**](docs/PSFakeApi.md#Test-PSBodyWithFileSchema) | **PUT** /fake/body-with-file-schema | 
*PSFakeApi* | [**Test-PSBodyWithQueryParams**](docs/PSFakeApi.md#Test-PSBodyWithQueryParams) | **PUT** /fake/body-with-query-params | 
*PSFakeApi* | [**Test-PSClientModel**](docs/PSFakeApi.md#Test-PSClientModel) | **PATCH** /fake | To test ""client"" model
*PSFakeApi* | [**Test-PSEndpointParameters**](docs/PSFakeApi.md#Test-PSEndpointParameters) | **POST** /fake | Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
*PSFakeApi* | [**Test-PSEnumParameters**](docs/PSFakeApi.md#Test-PSEnumParameters) | **GET** /fake | To test enum parameters
*PSFakeApi* | [**Test-PSGroupParameters**](docs/PSFakeApi.md#Test-PSGroupParameters) | **DELETE** /fake | Fake endpoint to test group parameters (optional)
*PSFakeApi* | [**Test-PSInlineAdditionalProperties**](docs/PSFakeApi.md#Test-PSInlineAdditionalProperties) | **POST** /fake/inline-additionalProperties | test inline additionalProperties
*PSFakeApi* | [**Test-PSInlineFreeformAdditionalProperties**](docs/PSFakeApi.md#Test-PSInlineFreeformAdditionalProperties) | **POST** /fake/inline-freeform-additionalProperties | test inline free-form additionalProperties
*PSFakeApi* | [**Test-PSJsonFormData**](docs/PSFakeApi.md#Test-PSJsonFormData) | **GET** /fake/jsonFormData | test json serialization of form data
*PSFakeApi* | [**Test-PSQueryParameterCollectionFormat**](docs/PSFakeApi.md#Test-PSQueryParameterCollectionFormat) | **PUT** /fake/test-query-parameters | 
*PSFakeApi* | [**Test-PSStringMapReference**](docs/PSFakeApi.md#Test-PSStringMapReference) | **POST** /fake/stringMap-reference | test referenced string map
*PSFakeClassnameTags123Api* | [**Test-PSClassname**](docs/PSFakeClassnameTags123Api.md#Test-PSClassname) | **PATCH** /fake_classname_test | To test class name in snake case
*PSPetApi* | [**Add-PSPet**](docs/PSPetApi.md#Add-PSPet) | **POST** /pet | Add a new pet to the store
*PSPetApi* | [**Remove-Pet**](docs/PSPetApi.md#remove-pet) | **DELETE** /pet/{petId} | Deletes a pet
*PSPetApi* | [**Find-PSPetsByStatus**](docs/PSPetApi.md#Find-PSPetsByStatus) | **GET** /pet/findByStatus | Finds Pets by status
*PSPetApi* | [**Find-PSPetsByTags**](docs/PSPetApi.md#Find-PSPetsByTags) | **GET** /pet/findByTags | Finds Pets by tags
*PSPetApi* | [**Get-PSPetById**](docs/PSPetApi.md#Get-PSPetById) | **GET** /pet/{petId} | Find pet by ID
*PSPetApi* | [**Update-PSPet**](docs/PSPetApi.md#Update-PSPet) | **PUT** /pet | Update an existing pet
*PSPetApi* | [**Update-PSPetWithForm**](docs/PSPetApi.md#Update-PSPetWithForm) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PSPetApi* | [**Invoke-PSUploadFile**](docs/PSPetApi.md#Invoke-PSUploadFile) | **POST** /pet/{petId}/uploadImage | uploads an image
*PSPetApi* | [**Invoke-PSUploadFileWithRequiredFile**](docs/PSPetApi.md#Invoke-PSUploadFileWithRequiredFile) | **POST** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*PSStoreApi* | [**Remove-PSOrder**](docs/PSStoreApi.md#Remove-PSOrder) | **DELETE** /store/order/{order_id} | Delete purchase order by ID
*PSStoreApi* | [**Get-PSInventory**](docs/PSStoreApi.md#Get-PSInventory) | **GET** /store/inventory | Returns pet inventories by status
*PSStoreApi* | [**Get-PSOrderById**](docs/PSStoreApi.md#Get-PSOrderById) | **GET** /store/order/{order_id} | Find purchase order by ID
*PSStoreApi* | [**Invoke-PSPlaceOrder**](docs/PSStoreApi.md#Invoke-PSPlaceOrder) | **POST** /store/order | Place an order for a pet
*PSUserApi* | [**New-PSUser**](docs/PSUserApi.md#New-PSUser) | **POST** /user | Create user
*PSUserApi* | [**New-PSUsersWithArrayInput**](docs/PSUserApi.md#New-PSUsersWithArrayInput) | **POST** /user/createWithArray | Creates list of users with given input array
*PSUserApi* | [**New-PSUsersWithListInput**](docs/PSUserApi.md#New-PSUsersWithListInput) | **POST** /user/createWithList | Creates list of users with given input array
*PSUserApi* | [**Remove-PSUser**](docs/PSUserApi.md#Remove-PSUser) | **DELETE** /user/{username} | Delete user
*PSUserApi* | [**Get-PSUserByName**](docs/PSUserApi.md#Get-PSUserByName) | **GET** /user/{username} | Get user by user name
*PSUserApi* | [**Invoke-PSLoginUser**](docs/PSUserApi.md#Invoke-PSLoginUser) | **GET** /user/login | Logs user into the system
*PSUserApi* | [**Invoke-PSLogoutUser**](docs/PSUserApi.md#Invoke-PSLogoutUser) | **GET** /user/logout | Logs out current logged in user session
*PSUserApi* | [**Update-PSUser**](docs/PSUserApi.md#Update-PSUser) | **PUT** /user/{username} | Updated user


## Documentation for Models

 - [PSPetstore\Model.AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [PSPetstore\Model.Animal](docs/Animal.md)
 - [PSPetstore\Model.ApiResponse](docs/ApiResponse.md)
 - [PSPetstore\Model.Apple](docs/Apple.md)
 - [PSPetstore\Model.AppleReq](docs/AppleReq.md)
 - [PSPetstore\Model.ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [PSPetstore\Model.ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [PSPetstore\Model.ArrayTest](docs/ArrayTest.md)
 - [PSPetstore\Model.Banana](docs/Banana.md)
 - [PSPetstore\Model.BananaReq](docs/BananaReq.md)
 - [PSPetstore\Model.BasquePig](docs/BasquePig.md)
 - [PSPetstore\Model.Capitalization](docs/Capitalization.md)
 - [PSPetstore\Model.Cat](docs/Cat.md)
 - [PSPetstore\Model.Category](docs/Category.md)
 - [PSPetstore\Model.ClassModel](docs/ClassModel.md)
 - [PSPetstore\Model.Client](docs/Client.md)
 - [PSPetstore\Model.ComplexQuadrilateral](docs/ComplexQuadrilateral.md)
 - [PSPetstore\Model.DanishPig](docs/DanishPig.md)
 - [PSPetstore\Model.DeprecatedObject](docs/DeprecatedObject.md)
 - [PSPetstore\Model.Dog](docs/Dog.md)
 - [PSPetstore\Model.Drawing](docs/Drawing.md)
 - [PSPetstore\Model.EnumArrays](docs/EnumArrays.md)
 - [PSPetstore\Model.EnumTest](docs/EnumTest.md)
 - [PSPetstore\Model.EquilateralTriangle](docs/EquilateralTriangle.md)
 - [PSPetstore\Model.File](docs/File.md)
 - [PSPetstore\Model.FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [PSPetstore\Model.Foo](docs/Foo.md)
 - [PSPetstore\Model.FooGetDefaultResponse](docs/FooGetDefaultResponse.md)
 - [PSPetstore\Model.FormatTest](docs/FormatTest.md)
 - [PSPetstore\Model.Fruit](docs/Fruit.md)
 - [PSPetstore\Model.FruitReq](docs/FruitReq.md)
 - [PSPetstore\Model.GmFruit](docs/GmFruit.md)
 - [PSPetstore\Model.GrandparentAnimal](docs/GrandparentAnimal.md)
 - [PSPetstore\Model.HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [PSPetstore\Model.HealthCheckResult](docs/HealthCheckResult.md)
 - [PSPetstore\Model.IsoscelesTriangle](docs/IsoscelesTriangle.md)
 - [PSPetstore\Model.List](docs/List.md)
 - [PSPetstore\Model.Mammal](docs/Mammal.md)
 - [PSPetstore\Model.MapTest](docs/MapTest.md)
 - [PSPetstore\Model.MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [PSPetstore\Model.Model200Response](docs/Model200Response.md)
 - [PSPetstore\Model.ModelReturn](docs/ModelReturn.md)
 - [PSPetstore\Model.Name](docs/Name.md)
 - [PSPetstore\Model.NewModel](docs/NewModel.md)
 - [PSPetstore\Model.NullableClass](docs/NullableClass.md)
 - [PSPetstore\Model.NullableShape](docs/NullableShape.md)
 - [PSPetstore\Model.NumberOnly](docs/NumberOnly.md)
 - [PSPetstore\Model.ObjectWithDeprecatedFields](docs/ObjectWithDeprecatedFields.md)
 - [PSPetstore\Model.Order](docs/Order.md)
 - [PSPetstore\Model.OuterComposite](docs/OuterComposite.md)
 - [PSPetstore\Model.OuterEnum](docs/OuterEnum.md)
 - [PSPetstore\Model.OuterEnumDefaultValue](docs/OuterEnumDefaultValue.md)
 - [PSPetstore\Model.OuterEnumInteger](docs/OuterEnumInteger.md)
 - [PSPetstore\Model.OuterEnumIntegerDefaultValue](docs/OuterEnumIntegerDefaultValue.md)
 - [PSPetstore\Model.ParentPet](docs/ParentPet.md)
 - [PSPetstore\Model.Pet](docs/Pet.md)
 - [PSPetstore\Model.PetWithRequiredTags](docs/PetWithRequiredTags.md)
 - [PSPetstore\Model.Pig](docs/Pig.md)
 - [PSPetstore\Model.Quadrilateral](docs/Quadrilateral.md)
 - [PSPetstore\Model.QuadrilateralInterface](docs/QuadrilateralInterface.md)
 - [PSPetstore\Model.ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [PSPetstore\Model.ScaleneTriangle](docs/ScaleneTriangle.md)
 - [PSPetstore\Model.Shape](docs/Shape.md)
 - [PSPetstore\Model.ShapeInterface](docs/ShapeInterface.md)
 - [PSPetstore\Model.ShapeOrNull](docs/ShapeOrNull.md)
 - [PSPetstore\Model.SimpleQuadrilateral](docs/SimpleQuadrilateral.md)
 - [PSPetstore\Model.SpecialModelName](docs/SpecialModelName.md)
 - [PSPetstore\Model.Tag](docs/Tag.md)
 - [PSPetstore\Model.TestInlineFreeformAdditionalPropertiesRequest](docs/TestInlineFreeformAdditionalPropertiesRequest.md)
 - [PSPetstore\Model.Triangle](docs/Triangle.md)
 - [PSPetstore\Model.TriangleInterface](docs/TriangleInterface.md)
 - [PSPetstore\Model.User](docs/User.md)
 - [PSPetstore\Model.Whale](docs/Whale.md)
 - [PSPetstore\Model.Zebra](docs/Zebra.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="petstore_auth"></a>
### petstore_auth


- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - write:pets: modify pets in your account
  - read:pets: read your pets

<a id="api_key"></a>
### api_key

- **Type**: API key

- **API key parameter name**: api_key_name
- **Location**: HTTP header

<a id="api_key_query"></a>
### api_key_query

- **Type**: API key

- **API key parameter name**: api_key_query_name
- **Location**: URL query string

<a id="http_basic_test"></a>
### http_basic_test


- **Type**: HTTP basic authentication

<a id="bearer_test"></a>
### bearer_test


- **Type**: HTTP Bearer Token authentication (JWT)

<a id="http_signature_test"></a>
### http_signature_test


- **Type**: HTTP signature authentication

