<?php
/**
 * PetApi
 * PHP version 7.2
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Psr7\MultipartStream;
use Http\Client\Common\Plugin\ErrorPlugin;
use Http\Client\Common\Plugin\RedirectPlugin;
use Http\Client\Common\PluginClient;
use Http\Client\Common\PluginClientFactory;
use Http\Client\Exception\HttpException;
use Http\Client\HttpAsyncClient;
use Http\Discovery\HttpAsyncClientDiscovery;
use Http\Discovery\Psr17FactoryDiscovery;
use Http\Discovery\Psr18ClientDiscovery;
use Http\Message\RequestFactory;
use Http\Promise\Promise;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\DebugPlugin;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\StreamFactoryInterface;
use Psr\Http\Message\UriFactoryInterface;
use Psr\Http\Message\UriInterface;
use function sprintf;

/**
 * PetApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PetApi
{
    /**
     * @var PluginClient
     */
    protected $httpClient;

    /**
     * @var PluginClient
     */
    protected $httpAsyncClient;

    /**
     * @var UriFactoryInterface
     */
    protected $uriFactory;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @var RequestFactoryInterface
     */
    protected $requestFactory;

    /**
     * @var StreamFactoryInterface
     */
    protected $streamFactory;

    public function __construct(
        ?ClientInterface $httpClient = null,
        ?Configuration $config = null,
        ?HttpAsyncClient $httpAsyncClient = null,
        ?UriFactoryInterface $uriFactory = null,
        ?RequestFactoryInterface $requestFactory = null,
        ?StreamFactoryInterface $streamFactory = null,
        ?HeaderSelector $selector = null,
        ?array $plugins = null,
        $hostIndex = 0
    ) {
        $this->config = $config ?? (new Configuration())->setHost('http://petstore.swagger.io:80/v2');
        $this->requestFactory = $requestFactory ?? Psr17FactoryDiscovery::findRequestFactory();
        $this->streamFactory = $streamFactory ?? Psr17FactoryDiscovery::findStreamFactory();

        $plugins = $plugins ?? [
            new RedirectPlugin(['strict' => true]),
            new ErrorPlugin(),
        ];

        if ($this->config->getDebug()) {
            $plugins[] = new DebugPlugin(fopen($this->config->getDebugFile(), 'ab'));
        }

        $this->httpClient = (new PluginClientFactory())->createClient(
            $httpClient ?? Psr18ClientDiscovery::find(),
            $plugins
        );

        $this->httpAsyncClient = (new PluginClientFactory())->createClient(
            $httpAsyncClient ?? HttpAsyncClientDiscovery::find(),
            $plugins
        );

        $this->uriFactory = $uriFactory ?? Psr17FactoryDiscovery::findUriFactory();

        $this->headerSelector = $selector ?? new HeaderSelector();

        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addPet
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addPet($pet)
    {
        $this->addPetWithHttpInfo($pet);
    }

    /**
     * Operation addPetWithHttpInfo
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addPetWithHttpInfo($pet)
    {
        $request = $this->addPetRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addPetAsync
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function addPetAsync($pet)
    {
        return $this->addPetAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addPetAsyncWithHttpInfo
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function addPetAsyncWithHttpInfo($pet)
    {
        $returnType = '';
        $request = $this->addPetRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'addPet'
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function addPetRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling addPet'
            );
        }

        $resourcePath = '/pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHosts = ["http://localhost/v2", "http://petstore.swagger.io/v2", "http://path-server-test.petstore.local/v2", "http://{server}.swagger.io:{port}/v2"];
        if ($this->hostIndex < 0 || $this->hostIndex >= sizeof($operationHosts)) {
            throw new \InvalidArgumentException("Invalid index {$this->hostIndex} when selecting the host. Must be less than ".sizeof($operationHosts));
        }
        $operationHost = $operationHosts[$this->hostIndex];

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation deletePet
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string $api_key api_key (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePet($pet_id, $api_key = null)
    {
        $this->deletePetWithHttpInfo($pet_id, $api_key);
    }

    /**
     * Operation deletePetWithHttpInfo
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string $api_key (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePetWithHttpInfo($pet_id, $api_key = null)
    {
        $request = $this->deletePetRequest($pet_id, $api_key);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deletePetAsync
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string $api_key (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function deletePetAsync($pet_id, $api_key = null)
    {
        return $this->deletePetAsyncWithHttpInfo($pet_id, $api_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePetAsyncWithHttpInfo
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string $api_key (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function deletePetAsyncWithHttpInfo($pet_id, $api_key = null)
    {
        $returnType = '';
        $request = $this->deletePetRequest($pet_id, $api_key);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePet'
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string $api_key (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function deletePetRequest($pet_id, $api_key = null)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling deletePet'
            );
        }

        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;


        // header params
        if ($api_key !== null) {
            $headerParams['api_key'] = ObjectSerializer::toHeaderValue($api_key);
        }

        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('DELETE', $uri, $headers, $httpBody);
    }

    /**
     * Operation findPetsByStatus
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet[]
     */
    public function findPetsByStatus($status)
    {
        list($response) = $this->findPetsByStatusWithHttpInfo($status);
        return $response;
    }

    /**
     * Operation findPetsByStatusWithHttpInfo
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findPetsByStatusWithHttpInfo($status)
    {
        $request = $this->findPetsByStatusRequest($status);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation findPetsByStatusAsync
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function findPetsByStatusAsync($status)
    {
        return $this->findPetsByStatusAsyncWithHttpInfo($status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPetsByStatusAsyncWithHttpInfo
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function findPetsByStatusAsyncWithHttpInfo($status)
    {
        $returnType = '\OpenAPI\Client\Model\Pet[]';
        $request = $this->findPetsByStatusRequest($status);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPetsByStatus'
     *
     * @param  string[] $status Status values that need to be considered for filter (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function findPetsByStatusRequest($status)
    {
        // verify the required parameter 'status' is set
        if ($status === null || (is_array($status) && count($status) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $status when calling findPetsByStatus'
            );
        }

        $resourcePath = '/pet/findByStatus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($status)) {
            $status = ObjectSerializer::serializeCollection($status, 'form', true);
        }
        if ($status !== null) {
            $queryParams['status'] = $status;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation findPetsByTags
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet[]
     */
    public function findPetsByTags($tags)
    {
        list($response) = $this->findPetsByTagsWithHttpInfo($tags);
        return $response;
    }

    /**
     * Operation findPetsByTagsWithHttpInfo
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findPetsByTagsWithHttpInfo($tags)
    {
        $request = $this->findPetsByTagsRequest($tags);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation findPetsByTagsAsync
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function findPetsByTagsAsync($tags)
    {
        return $this->findPetsByTagsAsyncWithHttpInfo($tags)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPetsByTagsAsyncWithHttpInfo
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function findPetsByTagsAsyncWithHttpInfo($tags)
    {
        $returnType = '\OpenAPI\Client\Model\Pet[]';
        $request = $this->findPetsByTagsRequest($tags);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPetsByTags'
     *
     * @param  string[] $tags Tags to filter by (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function findPetsByTagsRequest($tags)
    {
        // verify the required parameter 'tags' is set
        if ($tags === null || (is_array($tags) && count($tags) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tags when calling findPetsByTags'
            );
        }


        $resourcePath = '/pet/findByTags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($tags)) {
            $tags = ObjectSerializer::serializeCollection($tags, 'form', true);
        }
        if ($tags !== null) {
            $queryParams['tags'] = $tags;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation getPetById
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet
     */
    public function getPetById($pet_id)
    {
        list($response) = $this->getPetByIdWithHttpInfo($pet_id);
        return $response;
    }

    /**
     * Operation getPetByIdWithHttpInfo
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPetByIdWithHttpInfo($pet_id)
    {
        $request = $this->getPetByIdRequest($pet_id);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPetByIdAsync
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function getPetByIdAsync($pet_id)
    {
        return $this->getPetByIdAsyncWithHttpInfo($pet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPetByIdAsyncWithHttpInfo
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function getPetByIdAsyncWithHttpInfo($pet_id)
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->getPetByIdRequest($pet_id);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPetById'
     *
     * @param  int $pet_id ID of pet to return (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function getPetByIdRequest($pet_id)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling getPetById'
            );
        }

        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation updatePet
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePet($pet)
    {
        $this->updatePetWithHttpInfo($pet);
    }

    /**
     * Operation updatePetWithHttpInfo
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePetWithHttpInfo($pet)
    {
        $request = $this->updatePetRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePetAsync
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function updatePetAsync($pet)
    {
        return $this->updatePetAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePetAsyncWithHttpInfo
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function updatePetAsyncWithHttpInfo($pet)
    {
        $returnType = '';
        $request = $this->updatePetRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePet'
     *
     * This operation contains host(s) defined in the OpenAP spec. Use 'hostIndex' to select the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function updatePetRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling updatePet'
            );
        }

        $resourcePath = '/pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHosts = ["http://localhost/v2", "http://petstore.swagger.io/v2", "http://path-server-test.petstore.local/v2", "http://{server}.swagger.io:{port}/v2"];
        if ($this->hostIndex < 0 || $this->hostIndex >= sizeof($operationHosts)) {
            throw new \InvalidArgumentException("Invalid index {$this->hostIndex} when selecting the host. Must be less than ".sizeof($operationHosts));
        }
        $operationHost = $operationHosts[$this->hostIndex];

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PUT', $uri, $headers, $httpBody);
    }

    /**
     * Operation updatePetWithForm
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string $name Updated name of the pet (optional)
     * @param  string $status Updated status of the pet (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePetWithForm($pet_id, $name = null, $status = null)
    {
        $this->updatePetWithFormWithHttpInfo($pet_id, $name, $status);
    }

    /**
     * Operation updatePetWithFormWithHttpInfo
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string $name Updated name of the pet (optional)
     * @param  string $status Updated status of the pet (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePetWithFormWithHttpInfo($pet_id, $name = null, $status = null)
    {
        $request = $this->updatePetWithFormRequest($pet_id, $name, $status);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePetWithFormAsync
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string $name Updated name of the pet (optional)
     * @param  string $status Updated status of the pet (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function updatePetWithFormAsync($pet_id, $name = null, $status = null)
    {
        return $this->updatePetWithFormAsyncWithHttpInfo($pet_id, $name, $status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePetWithFormAsyncWithHttpInfo
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string $name Updated name of the pet (optional)
     * @param  string $status Updated status of the pet (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function updatePetWithFormAsyncWithHttpInfo($pet_id, $name = null, $status = null)
    {
        $returnType = '';
        $request = $this->updatePetWithFormRequest($pet_id, $name, $status);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePetWithForm'
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string $name Updated name of the pet (optional)
     * @param  string $status Updated status of the pet (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function updatePetWithFormRequest($pet_id, $name = null, $status = null)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling updatePetWithForm'
            );
        }

        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'name' => $name,
            'status' => $status,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/x-www-form-urlencoded',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation uploadFile
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject $file file to upload (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadFile($pet_id, $additional_metadata = null, $file = null)
    {
        list($response) = $this->uploadFileWithHttpInfo($pet_id, $additional_metadata, $file);
        return $response;
    }

    /**
     * Operation uploadFileWithHttpInfo
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject $file file to upload (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithHttpInfo($pet_id, $additional_metadata = null, $file = null)
    {
        $request = $this->uploadFileRequest($pet_id, $additional_metadata, $file);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadFileAsync
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject $file file to upload (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadFileAsync($pet_id, $additional_metadata = null, $file = null)
    {
        return $this->uploadFileAsyncWithHttpInfo($pet_id, $additional_metadata, $file)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadFileAsyncWithHttpInfo
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject $file file to upload (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadFileAsyncWithHttpInfo($pet_id, $additional_metadata = null, $file = null)
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadFileRequest($pet_id, $additional_metadata, $file);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFile'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject $file file to upload (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function uploadFileRequest($pet_id, $additional_metadata = null, $file = null)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadFile'
            );
        }

        $resourcePath = '/pet/{petId}/uploadImage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'additional_metadata' => $additional_metadata,
            'file' => $file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'multipart/form-data',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation uploadFileWithRequiredFile
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadFileWithRequiredFile($pet_id, $required_file, $additional_metadata = null)
    {
        list($response) = $this->uploadFileWithRequiredFileWithHttpInfo($pet_id, $required_file, $additional_metadata);
        return $response;
    }

    /**
     * Operation uploadFileWithRequiredFileWithHttpInfo
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithRequiredFileWithHttpInfo($pet_id, $required_file, $additional_metadata = null)
    {
        $request = $this->uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadFileWithRequiredFileAsync
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadFileWithRequiredFileAsync($pet_id, $required_file, $additional_metadata = null)
    {
        return $this->uploadFileWithRequiredFileAsyncWithHttpInfo($pet_id, $required_file, $additional_metadata)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadFileWithRequiredFileAsyncWithHttpInfo
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadFileWithRequiredFileAsyncWithHttpInfo($pet_id, $required_file, $additional_metadata = null)
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFileWithRequiredFile'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string $additional_metadata Additional data to pass to server (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata = null)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadFileWithRequiredFile'
            );
        }
        // verify the required parameter 'required_file' is set
        if ($required_file === null || (is_array($required_file) && count($required_file) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $required_file when calling uploadFileWithRequiredFile'
            );
        }

        $resourcePath = '/fake/{petId}/uploadImageWithRequiredFile';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'additional_metadata' => $additional_metadata,
            'required_file' => $required_file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'multipart/form-data',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation uploadImageFullFormData
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name name (required)
     * @param  string[] $photo_urls photo_urls (required)
     * @param  int $id id (optional)
     * @param  \OpenAPI\Client\Model\Category $category category (optional)
     * @param  \OpenAPI\Client\Model\Tag[] $tags tags (optional)
     * @param  string $status pet status in the store (optional)
     * @param  \SplFileObject $file file to upload (optional)
     * @param  \SplFileObject[] $multiple_files multiple_files (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadImageFullFormData($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null)
    {
        list($response) = $this->uploadImageFullFormDataWithHttpInfo($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files);
        return $response;
    }

    /**
     * Operation uploadImageFullFormDataWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int $id (optional)
     * @param  \OpenAPI\Client\Model\Category $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[] $tags (optional)
     * @param  string $status pet status in the store (optional)
     * @param  \SplFileObject $file file to upload (optional)
     * @param  \SplFileObject[] $multiple_files (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadImageFullFormDataWithHttpInfo($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null)
    {
        $request = $this->uploadImageFullFormDataRequest($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadImageFullFormDataAsync
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int $id (optional)
     * @param  \OpenAPI\Client\Model\Category $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[] $tags (optional)
     * @param  string $status pet status in the store (optional)
     * @param  \SplFileObject $file file to upload (optional)
     * @param  \SplFileObject[] $multiple_files (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadImageFullFormDataAsync($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null)
    {
        return $this->uploadImageFullFormDataAsyncWithHttpInfo($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadImageFullFormDataAsyncWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int $id (optional)
     * @param  \OpenAPI\Client\Model\Category $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[] $tags (optional)
     * @param  string $status pet status in the store (optional)
     * @param  \SplFileObject $file file to upload (optional)
     * @param  \SplFileObject[] $multiple_files (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadImageFullFormDataAsyncWithHttpInfo($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null)
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadImageFullFormDataRequest($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadImageFullFormData'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int $id (optional)
     * @param  \OpenAPI\Client\Model\Category $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[] $tags (optional)
     * @param  string $status pet status in the store (optional)
     * @param  \SplFileObject $file file to upload (optional)
     * @param  \SplFileObject[] $multiple_files (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function uploadImageFullFormDataRequest($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadImageFullFormData'
            );
        }
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling uploadImageFullFormData'
            );
        }
        // verify the required parameter 'photo_urls' is set
        if ($photo_urls === null || (is_array($photo_urls) && count($photo_urls) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $photo_urls when calling uploadImageFullFormData'
            );
        }


        $resourcePath = '/pet/{petId}/uploadImageFullFormData';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'id' => $id,
            'category' => $category,
            'name' => $name,
            'photo_urls' => $photo_urls,
            'tags' => $tags,
            'status' => $status,
            'file' => $file,
            'multiple_files' => $multiple_files,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'multipart/form-data',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation uploadImageFullFormDataNested
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile $pet pet (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadImageFullFormDataNested($pet_id, $pet = null)
    {
        list($response) = $this->uploadImageFullFormDataNestedWithHttpInfo($pet_id, $pet);
        return $response;
    }

    /**
     * Operation uploadImageFullFormDataNestedWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile $pet (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadImageFullFormDataNestedWithHttpInfo($pet_id, $pet = null)
    {
        $request = $this->uploadImageFullFormDataNestedRequest($pet_id, $pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadImageFullFormDataNestedAsync
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile $pet (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadImageFullFormDataNestedAsync($pet_id, $pet = null)
    {
        return $this->uploadImageFullFormDataNestedAsyncWithHttpInfo($pet_id, $pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadImageFullFormDataNestedAsyncWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile $pet (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function uploadImageFullFormDataNestedAsyncWithHttpInfo($pet_id, $pet = null)
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadImageFullFormDataNestedRequest($pet_id, $pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadImageFullFormDataNested'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile $pet (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function uploadImageFullFormDataNestedRequest($pet_id, $pet = null)
    {
        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadImageFullFormDataNested'
            );
        }

        $resourcePath = '/pet/{petId}/uploadImageFullFormDataNested';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'pet' => $pet,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'multipart/form-data',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }


    /**
     * @param string $method
     * @param string|UriInterface $uri
     * @param array $headers
     * @param string|StreamInterface|null $body
     *
     * @return RequestInterface
     */
    protected function createRequest(string $method, $uri, array $headers = [], $body = null): RequestInterface
    {
        if ($this->requestFactory instanceof RequestFactory) {
            return $this->requestFactory->createRequest(
                $method,
                $uri,
                $headers,
                $body
            );
        }

        if (is_string($body) && '' !== $body && null === $this->streamFactory) {
            throw new \RuntimeException('Cannot create request: A stream factory is required to create a request with a non-empty string body.');
        }

        $request = $this->requestFactory->createRequest($method, $uri);

        foreach ($headers as $key => $value) {
            $request = $request->withHeader($key, $value);
        }

        if (null !== $body && '' !== $body) {
            $request = $request->withBody(
                is_string($body) ? $this->streamFactory->createStream($body) : $body
            );
        }

        return $request;
    }

    private function createUri(
        string $operationHost,
        string $resourcePath,
        array $queryParams
    ): UriInterface {
        $parsedUrl = parse_url($operationHost);

        $host = $parsedUrl['host'] ?? null;
        $scheme = $parsedUrl['scheme'] ?? null;
        $basePath = $parsedUrl['path'] ?? null;
        $port = $parsedUrl['port'] ?? null;
        $user = $parsedUrl['user'] ?? null;
        $password = $parsedUrl['pass'] ?? null;

        $uri = $this->uriFactory->createUri($basePath . $resourcePath)
            ->withHost($host)
            ->withScheme($scheme)
            ->withPort($port)
            ->withQuery(ObjectSerializer::buildQuery($queryParams));

        if ($user) {
            $uri = $uri->withUserInfo($user, $password);
        }

        return $uri;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
			$request,
                        $response,
                        $exception
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
