<?php
/**
 * PetApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * PetApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PetApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addPet' => [
            'application/json',
            'application/xml',
        ],
        'deletePet' => [
            'application/json',
        ],
        'findPetsByStatus' => [
            'application/json',
        ],
        'findPetsByTags' => [
            'application/json',
        ],
        'getPetById' => [
            'application/json',
        ],
        'updatePet' => [
            'application/json',
            'application/xml',
        ],
        'updatePetWithForm' => [
            'application/x-www-form-urlencoded',
        ],
        'uploadFile' => [
            'multipart/form-data',
        ],
        'uploadFileWithRequiredFile' => [
            'multipart/form-data',
        ],
        'uploadImageFullFormData' => [
            'multipart/form-data',
        ],
        'uploadImageFullFormDataNested' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addPet
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addPet($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['addPet'][0])
    {
        $this->addPetWithHttpInfo($pet, $hostIndex, $variables, $contentType);
    }

    /**
     * Operation addPetWithHttpInfo
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addPetWithHttpInfo($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['addPet'][0])
    {
        $request = $this->addPetRequest($pet, $hostIndex, $variables, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation addPetAsync
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addPetAsync($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['addPet'][0])
    {
        return $this->addPetAsyncWithHttpInfo($pet, $hostIndex, $variables, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addPetAsyncWithHttpInfo
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addPetAsyncWithHttpInfo($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['addPet'][0])
    {
        $returnType = '';
        $request = $this->addPetRequest($pet, $hostIndex, $variables, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addPet'
     *
    * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
    * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
    *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
    *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addPetRequest($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['addPet'][0])
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling addPet'
            );
        }


        $resourcePath = '/pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        # Preserve the original behavior of server indexing.
        if ($hostIndex === null) {
            $hostIndex = $this->hostIndex;
        }

        $hostSettings = $this->getHostSettingsForaddPet();

        if ($hostIndex < 0 || $hostIndex >= count($hostSettings)) {
            throw new \InvalidArgumentException("Invalid index {$hostIndex} when selecting the host. Must be less than ".count($hostSettings));
        }
        $operationHost = Configuration::getHostString($hostSettings, $hostIndex, $variables);
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Returns an array of host settings for Operation addPet
     *
     * @return array an array of host settings
     */
    protected function getHostSettingsForaddPet(): array
    {
        return [
            [
                "url" => "http://localhost/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://petstore.swagger.io/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://path-server-test.petstore.local/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://{server}.swagger.io:{port}/v2",
                "description" => "test server with variables",
                "variables" => [
                    "server" => [
                    "description" => "target server",
                    "default_value" => "petstore",
                    "enum_values" => [
                        "petstore",
                        "qa-petstore",
                        "dev-petstore",
                    ]
                    ],
                    "port" => [
                    "description" => "No description provided",
                    "default_value" => "80",
                    "enum_values" => [
                        "80",
                        "8080",
                    ]
                    ]
                ]
            ]
        ];
    }

    /**
     * Operation deletePet
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePet($pet_id, $api_key = null, string $contentType = self::contentTypes['deletePet'][0])
    {
        $this->deletePetWithHttpInfo($pet_id, $api_key, $contentType);
    }

    /**
     * Operation deletePetWithHttpInfo
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePetWithHttpInfo($pet_id, $api_key = null, string $contentType = self::contentTypes['deletePet'][0])
    {
        $request = $this->deletePetRequest($pet_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deletePetAsync
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePetAsync($pet_id, $api_key = null, string $contentType = self::contentTypes['deletePet'][0])
    {
        return $this->deletePetAsyncWithHttpInfo($pet_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePetAsyncWithHttpInfo
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePetAsyncWithHttpInfo($pet_id, $api_key = null, string $contentType = self::contentTypes['deletePet'][0])
    {
        $returnType = '';
        $request = $this->deletePetRequest($pet_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePet'
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePetRequest($pet_id, $api_key = null, string $contentType = self::contentTypes['deletePet'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling deletePet'
            );
        }



        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($api_key !== null) {
            $headerParams['api_key'] = ObjectSerializer::toHeaderValue($api_key);
        }

        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findPetsByStatus
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet[]
     */
    public function findPetsByStatus($status, string $contentType = self::contentTypes['findPetsByStatus'][0])
    {
        list($response) = $this->findPetsByStatusWithHttpInfo($status, $contentType);
        return $response;
    }

    /**
     * Operation findPetsByStatusWithHttpInfo
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findPetsByStatusWithHttpInfo($status, string $contentType = self::contentTypes['findPetsByStatus'][0])
    {
        $request = $this->findPetsByStatusRequest($status, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation findPetsByStatusAsync
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findPetsByStatusAsync($status, string $contentType = self::contentTypes['findPetsByStatus'][0])
    {
        return $this->findPetsByStatusAsyncWithHttpInfo($status, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPetsByStatusAsyncWithHttpInfo
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findPetsByStatusAsyncWithHttpInfo($status, string $contentType = self::contentTypes['findPetsByStatus'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Pet[]';
        $request = $this->findPetsByStatusRequest($status, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPetsByStatus'
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function findPetsByStatusRequest($status, string $contentType = self::contentTypes['findPetsByStatus'][0])
    {

        // verify the required parameter 'status' is set
        if ($status === null || (is_array($status) && count($status) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $status when calling findPetsByStatus'
            );
        }


        $resourcePath = '/pet/findByStatus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findPetsByTags
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet[]
     * @deprecated
     */
    public function findPetsByTags($tags, string $contentType = self::contentTypes['findPetsByTags'][0])
    {
        list($response) = $this->findPetsByTagsWithHttpInfo($tags, $contentType);
        return $response;
    }

    /**
     * Operation findPetsByTagsWithHttpInfo
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet[], HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function findPetsByTagsWithHttpInfo($tags, string $contentType = self::contentTypes['findPetsByTags'][0])
    {
        $request = $this->findPetsByTagsRequest($tags, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation findPetsByTagsAsync
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function findPetsByTagsAsync($tags, string $contentType = self::contentTypes['findPetsByTags'][0])
    {
        return $this->findPetsByTagsAsyncWithHttpInfo($tags, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPetsByTagsAsyncWithHttpInfo
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function findPetsByTagsAsyncWithHttpInfo($tags, string $contentType = self::contentTypes['findPetsByTags'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Pet[]';
        $request = $this->findPetsByTagsRequest($tags, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPetsByTags'
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function findPetsByTagsRequest($tags, string $contentType = self::contentTypes['findPetsByTags'][0])
    {

        // verify the required parameter 'tags' is set
        if ($tags === null || (is_array($tags) && count($tags) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tags when calling findPetsByTags'
            );
        }
        

        $resourcePath = '/pet/findByTags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tags,
            'tags', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPetById
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet
     */
    public function getPetById($pet_id, string $contentType = self::contentTypes['getPetById'][0])
    {
        list($response) = $this->getPetByIdWithHttpInfo($pet_id, $contentType);
        return $response;
    }

    /**
     * Operation getPetByIdWithHttpInfo
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPetByIdWithHttpInfo($pet_id, string $contentType = self::contentTypes['getPetById'][0])
    {
        $request = $this->getPetByIdRequest($pet_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPetByIdAsync
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPetByIdAsync($pet_id, string $contentType = self::contentTypes['getPetById'][0])
    {
        return $this->getPetByIdAsyncWithHttpInfo($pet_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPetByIdAsyncWithHttpInfo
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPetByIdAsyncWithHttpInfo($pet_id, string $contentType = self::contentTypes['getPetById'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->getPetByIdRequest($pet_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPetById'
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPetByIdRequest($pet_id, string $contentType = self::contentTypes['getPetById'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling getPetById'
            );
        }


        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePet
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePet($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['updatePet'][0])
    {
        $this->updatePetWithHttpInfo($pet, $hostIndex, $variables, $contentType);
    }

    /**
     * Operation updatePetWithHttpInfo
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePetWithHttpInfo($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['updatePet'][0])
    {
        $request = $this->updatePetRequest($pet, $hostIndex, $variables, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePetAsync
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePetAsync($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['updatePet'][0])
    {
        return $this->updatePetAsyncWithHttpInfo($pet, $hostIndex, $variables, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePetAsyncWithHttpInfo
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePetAsyncWithHttpInfo($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['updatePet'][0])
    {
        $returnType = '';
        $request = $this->updatePetRequest($pet, $hostIndex, $variables, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePet'
     *
    * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
    * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
    *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
    *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePetRequest($pet, ?int $hostIndex = null, array $variables = [], string $contentType = self::contentTypes['updatePet'][0])
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling updatePet'
            );
        }


        $resourcePath = '/pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        # Preserve the original behavior of server indexing.
        if ($hostIndex === null) {
            $hostIndex = $this->hostIndex;
        }

        $hostSettings = $this->getHostSettingsForupdatePet();

        if ($hostIndex < 0 || $hostIndex >= count($hostSettings)) {
            throw new \InvalidArgumentException("Invalid index {$hostIndex} when selecting the host. Must be less than ".count($hostSettings));
        }
        $operationHost = Configuration::getHostString($hostSettings, $hostIndex, $variables);
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Returns an array of host settings for Operation updatePet
     *
     * @return array an array of host settings
     */
    protected function getHostSettingsForupdatePet(): array
    {
        return [
            [
                "url" => "http://localhost/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://petstore.swagger.io/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://path-server-test.petstore.local/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://{server}.swagger.io:{port}/v2",
                "description" => "test server with variables",
                "variables" => [
                    "server" => [
                    "description" => "target server",
                    "default_value" => "petstore",
                    "enum_values" => [
                        "petstore",
                        "qa-petstore",
                        "dev-petstore",
                    ]
                    ],
                    "port" => [
                    "description" => "No description provided",
                    "default_value" => "80",
                    "enum_values" => [
                        "80",
                        "8080",
                    ]
                    ]
                ]
            ]
        ];
    }

    /**
     * Operation updatePetWithForm
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePetWithForm($pet_id, $name = null, $status = null, string $contentType = self::contentTypes['updatePetWithForm'][0])
    {
        $this->updatePetWithFormWithHttpInfo($pet_id, $name, $status, $contentType);
    }

    /**
     * Operation updatePetWithFormWithHttpInfo
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePetWithFormWithHttpInfo($pet_id, $name = null, $status = null, string $contentType = self::contentTypes['updatePetWithForm'][0])
    {
        $request = $this->updatePetWithFormRequest($pet_id, $name, $status, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePetWithFormAsync
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePetWithFormAsync($pet_id, $name = null, $status = null, string $contentType = self::contentTypes['updatePetWithForm'][0])
    {
        return $this->updatePetWithFormAsyncWithHttpInfo($pet_id, $name, $status, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePetWithFormAsyncWithHttpInfo
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePetWithFormAsyncWithHttpInfo($pet_id, $name = null, $status = null, string $contentType = self::contentTypes['updatePetWithForm'][0])
    {
        $returnType = '';
        $request = $this->updatePetWithFormRequest($pet_id, $name, $status, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePetWithForm'
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePetWithFormRequest($pet_id, $name = null, $status = null, string $contentType = self::contentTypes['updatePetWithForm'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling updatePetWithForm'
            );
        }




        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'name' => $name,
            'status' => $status,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadFile
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadFile($pet_id, $additional_metadata = null, $file = null, string $contentType = self::contentTypes['uploadFile'][0])
    {
        list($response) = $this->uploadFileWithHttpInfo($pet_id, $additional_metadata, $file, $contentType);
        return $response;
    }

    /**
     * Operation uploadFileWithHttpInfo
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithHttpInfo($pet_id, $additional_metadata = null, $file = null, string $contentType = self::contentTypes['uploadFile'][0])
    {
        $request = $this->uploadFileRequest($pet_id, $additional_metadata, $file, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadFileAsync
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadFileAsync($pet_id, $additional_metadata = null, $file = null, string $contentType = self::contentTypes['uploadFile'][0])
    {
        return $this->uploadFileAsyncWithHttpInfo($pet_id, $additional_metadata, $file, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadFileAsyncWithHttpInfo
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadFileAsyncWithHttpInfo($pet_id, $additional_metadata = null, $file = null, string $contentType = self::contentTypes['uploadFile'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadFileRequest($pet_id, $additional_metadata, $file, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFile'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadFileRequest($pet_id, $additional_metadata = null, $file = null, string $contentType = self::contentTypes['uploadFile'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadFile'
            );
        }




        $resourcePath = '/pet/{petId}/uploadImage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'additional_metadata' => $additional_metadata,
            'file' => $file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadFileWithRequiredFile
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadFileWithRequiredFile($pet_id, $required_file, $additional_metadata = null, string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0])
    {
        list($response) = $this->uploadFileWithRequiredFileWithHttpInfo($pet_id, $required_file, $additional_metadata, $contentType);
        return $response;
    }

    /**
     * Operation uploadFileWithRequiredFileWithHttpInfo
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithRequiredFileWithHttpInfo($pet_id, $required_file, $additional_metadata = null, string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0])
    {
        $request = $this->uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadFileWithRequiredFileAsync
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadFileWithRequiredFileAsync($pet_id, $required_file, $additional_metadata = null, string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0])
    {
        return $this->uploadFileWithRequiredFileAsyncWithHttpInfo($pet_id, $required_file, $additional_metadata, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadFileWithRequiredFileAsyncWithHttpInfo
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadFileWithRequiredFileAsyncWithHttpInfo($pet_id, $required_file, $additional_metadata = null, string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFileWithRequiredFile'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata = null, string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadFileWithRequiredFile'
            );
        }

        // verify the required parameter 'required_file' is set
        if ($required_file === null || (is_array($required_file) && count($required_file) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $required_file when calling uploadFileWithRequiredFile'
            );
        }



        $resourcePath = '/fake/{petId}/uploadImageWithRequiredFile';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'additional_metadata' => $additional_metadata,
            'required_file' => $required_file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadImageFullFormData
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name name (required)
     * @param  string[] $photo_urls photo_urls (required)
     * @param  int|null $id id (optional)
     * @param  \OpenAPI\Client\Model\Category|null $category category (optional)
     * @param  \OpenAPI\Client\Model\Tag[]|null $tags tags (optional)
     * @param  string|null $status pet status in the store (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  \SplFileObject[]|null $multiple_files multiple_files (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormData'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadImageFullFormData($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null, string $contentType = self::contentTypes['uploadImageFullFormData'][0])
    {
        list($response) = $this->uploadImageFullFormDataWithHttpInfo($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files, $contentType);
        return $response;
    }

    /**
     * Operation uploadImageFullFormDataWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int|null $id (optional)
     * @param  \OpenAPI\Client\Model\Category|null $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[]|null $tags (optional)
     * @param  string|null $status pet status in the store (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  \SplFileObject[]|null $multiple_files (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormData'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadImageFullFormDataWithHttpInfo($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null, string $contentType = self::contentTypes['uploadImageFullFormData'][0])
    {
        $request = $this->uploadImageFullFormDataRequest($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadImageFullFormDataAsync
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int|null $id (optional)
     * @param  \OpenAPI\Client\Model\Category|null $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[]|null $tags (optional)
     * @param  string|null $status pet status in the store (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  \SplFileObject[]|null $multiple_files (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImageFullFormDataAsync($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null, string $contentType = self::contentTypes['uploadImageFullFormData'][0])
    {
        return $this->uploadImageFullFormDataAsyncWithHttpInfo($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadImageFullFormDataAsyncWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int|null $id (optional)
     * @param  \OpenAPI\Client\Model\Category|null $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[]|null $tags (optional)
     * @param  string|null $status pet status in the store (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  \SplFileObject[]|null $multiple_files (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImageFullFormDataAsyncWithHttpInfo($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null, string $contentType = self::contentTypes['uploadImageFullFormData'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadImageFullFormDataRequest($pet_id, $name, $photo_urls, $id, $category, $tags, $status, $file, $multiple_files, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadImageFullFormData'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string $name (required)
     * @param  string[] $photo_urls (required)
     * @param  int|null $id (optional)
     * @param  \OpenAPI\Client\Model\Category|null $category (optional)
     * @param  \OpenAPI\Client\Model\Tag[]|null $tags (optional)
     * @param  string|null $status pet status in the store (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  \SplFileObject[]|null $multiple_files (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadImageFullFormDataRequest($pet_id, $name, $photo_urls, $id = null, $category = null, $tags = null, $status = null, $file = null, $multiple_files = null, string $contentType = self::contentTypes['uploadImageFullFormData'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadImageFullFormData'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling uploadImageFullFormData'
            );
        }

        // verify the required parameter 'photo_urls' is set
        if ($photo_urls === null || (is_array($photo_urls) && count($photo_urls) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $photo_urls when calling uploadImageFullFormData'
            );
        }
        







        $resourcePath = '/pet/{petId}/uploadImageFullFormData';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'id' => $id,
            'category' => $category,
            'name' => $name,
            'photo_urls' => $photo_urls,
            'tags' => $tags,
            'status' => $status,
            'file' => $file,
            'multiple_files' => $multiple_files,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadImageFullFormDataNested
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile|null $pet pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormDataNested'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadImageFullFormDataNested($pet_id, $pet = null, string $contentType = self::contentTypes['uploadImageFullFormDataNested'][0])
    {
        list($response) = $this->uploadImageFullFormDataNestedWithHttpInfo($pet_id, $pet, $contentType);
        return $response;
    }

    /**
     * Operation uploadImageFullFormDataNestedWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile|null $pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormDataNested'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadImageFullFormDataNestedWithHttpInfo($pet_id, $pet = null, string $contentType = self::contentTypes['uploadImageFullFormDataNested'][0])
    {
        $request = $this->uploadImageFullFormDataNestedRequest($pet_id, $pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadImageFullFormDataNestedAsync
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile|null $pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormDataNested'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImageFullFormDataNestedAsync($pet_id, $pet = null, string $contentType = self::contentTypes['uploadImageFullFormDataNested'][0])
    {
        return $this->uploadImageFullFormDataNestedAsyncWithHttpInfo($pet_id, $pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadImageFullFormDataNestedAsyncWithHttpInfo
     *
     * uploads an image attached to a Pet object as formdata
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile|null $pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormDataNested'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImageFullFormDataNestedAsyncWithHttpInfo($pet_id, $pet = null, string $contentType = self::contentTypes['uploadImageFullFormDataNested'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadImageFullFormDataNestedRequest($pet_id, $pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadImageFullFormDataNested'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \OpenAPI\Client\Model\PetWithFile|null $pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImageFullFormDataNested'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadImageFullFormDataNestedRequest($pet_id, $pet = null, string $contentType = self::contentTypes['uploadImageFullFormDataNested'][0])
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadImageFullFormDataNested'
            );
        }



        $resourcePath = '/pet/{petId}/uploadImageFullFormDataNested';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'pet' => $pet,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
