<?php
/**
 * FakeApi
 * PHP version 8.1
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * @generated Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use InvalidArgumentException;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;

/**
 * FakeApi Class Doc Comment
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FakeApi
{
    /**
     * @var ClientInterface
     */
    protected ClientInterface $client;

    /**
     * @var Configuration
     */
    protected Configuration $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @var int Host index
     */
    protected int $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'fakeBigDecimalMap' => [
            'application/json',
        ],
        'fakeDeletePet' => [
            'application/json',
        ],
        'fakeEnumEndpoint' => [
            'application/json',
        ],
        'fakeHealthGet' => [
            'application/json',
        ],
        'fakeHttpSignatureTest' => [
            'application/json',
            'application/xml',
        ],
        'fakeOuterBooleanSerialize' => [
            'application/json',
        ],
        'fakeOuterCompositeSerialize' => [
            'application/json',
        ],
        'fakeOuterNumberSerialize' => [
            'application/json',
        ],
        'fakeOuterStringSerialize' => [
            'application/json',
        ],
        'fakePropertyEnumIntegerSerialize' => [
            'application/json',
        ],
        'fakeWith400And4xxRangeResponseEndpoint' => [
            'application/json',
            'application/xml',
        ],
        'fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint' => [
            'application/json',
            'application/xml',
        ],
        'fakeWith400ResponseEndpoint' => [
            'application/json',
            'application/xml',
        ],
        'fakeWith4xxRangeResponseEndpoint' => [
            'application/json',
            'application/xml',
        ],
        'fakeWith4xxRangeResponseNo4xxDatatypeEndpoint' => [
            'application/json',
            'application/xml',
        ],
        'testAdditionalPropertiesReference' => [
            'application/json',
        ],
        'testBodyWithBinary' => [
            'image/png',
        ],
        'testBodyWithFileSchema' => [
            'application/json',
        ],
        'testBodyWithQueryParams' => [
            'application/json',
        ],
        'testClientModel' => [
            'application/json',
        ],
        'testEndpointParameters' => [
            'application/x-www-form-urlencoded',
        ],
        'testEnumParameters' => [
            'application/x-www-form-urlencoded',
        ],
        'testGroupParameters' => [
            'application/json',
        ],
        'testInlineAdditionalProperties' => [
            'application/json',
        ],
        'testInlineFreeformAdditionalProperties' => [
            'application/json',
        ],
        'testJsonFormData' => [
            'application/x-www-form-urlencoded',
        ],
        'testNullable' => [
            'application/json',
        ],
        'testQueryParameterCollectionFormat' => [
            'application/json',
        ],
        'testStringMapReference' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface|null $client
     * @param Configuration|null   $config
     * @param HeaderSelector|null  $selector
     * @param int                  $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex(int $hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex(): int
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig(): Configuration
    {
        return $this->config;
    }

    /**
     * Operation fakeBigDecimalMap
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeBigDecimalMap'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\FakeBigDecimalMap200Response
     */
    public function fakeBigDecimalMap(
        string $contentType = self::contentTypes['fakeBigDecimalMap'][0]
    ): \OpenAPI\Client\Model\FakeBigDecimalMap200Response
    {
        list($response) = $this->fakeBigDecimalMapWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation fakeBigDecimalMapWithHttpInfo
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeBigDecimalMap'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\FakeBigDecimalMap200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeBigDecimalMapWithHttpInfo(
        string $contentType = self::contentTypes['fakeBigDecimalMap'][0]
    ): array
    {
        $request = $this->fakeBigDecimalMapRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\FakeBigDecimalMap200Response',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\FakeBigDecimalMap200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\FakeBigDecimalMap200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeBigDecimalMapAsync
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeBigDecimalMap'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeBigDecimalMapAsync(
        string $contentType = self::contentTypes['fakeBigDecimalMap'][0]
    ): PromiseInterface
    {
        return $this->fakeBigDecimalMapAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeBigDecimalMapAsyncWithHttpInfo
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeBigDecimalMap'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeBigDecimalMapAsyncWithHttpInfo(
        string $contentType = self::contentTypes['fakeBigDecimalMap'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\FakeBigDecimalMap200Response';
        $request = $this->fakeBigDecimalMapRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeBigDecimalMap'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeBigDecimalMap'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeBigDecimalMapRequest(
        string $contentType = self::contentTypes['fakeBigDecimalMap'][0]
    ): Request
    {


        $resourcePath = '/fake/BigDecimalMap';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeDeletePet
     *
     * @param  string $pet_id The id of the pet to retrieve (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeDeletePet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Error|null
     */
    public function fakeDeletePet(
        string $pet_id,
        string $contentType = self::contentTypes['fakeDeletePet'][0]
    ): ?\OpenAPI\Client\Model\Error
    {
        list($response) = $this->fakeDeletePetWithHttpInfo($pet_id, $contentType);
        return $response;
    }

    /**
     * Operation fakeDeletePetWithHttpInfo
     *
     * @param  string $pet_id The id of the pet to retrieve (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeDeletePet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeDeletePetWithHttpInfo(
        string $pet_id,
        string $contentType = self::contentTypes['fakeDeletePet'][0]
    ): array
    {
        $request = $this->fakeDeletePetRequest($pet_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeDeletePetAsync
     *
     * @param  string $pet_id The id of the pet to retrieve (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeDeletePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeDeletePetAsync(
        string $pet_id,
        string $contentType = self::contentTypes['fakeDeletePet'][0]
    ): PromiseInterface
    {
        return $this->fakeDeletePetAsyncWithHttpInfo($pet_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeDeletePetAsyncWithHttpInfo
     *
     * @param  string $pet_id The id of the pet to retrieve (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeDeletePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeDeletePetAsyncWithHttpInfo(
        string $pet_id,
        string $contentType = self::contentTypes['fakeDeletePet'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->fakeDeletePetRequest($pet_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeDeletePet'
     *
     * @param  string $pet_id The id of the pet to retrieve (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeDeletePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeDeletePetRequest(
        string $pet_id,
        string $contentType = self::contentTypes['fakeDeletePet'][0]
    ): Request
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet_id when calling fakeDeletePet'
            );
        }


        $resourcePath = '/fake/pet/{pet_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'pet_id' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeEnumEndpoint
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeEnumEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\EnumClass
     */
    public function fakeEnumEndpoint(
        \OpenAPI\Client\Model\EnumClass $enum_class,
        array $enum_class_array,
        array $enum_class_map,
        string $contentType = self::contentTypes['fakeEnumEndpoint'][0]
    ): \OpenAPI\Client\Model\EnumClass
    {
        list($response) = $this->fakeEnumEndpointWithHttpInfo($enum_class, $enum_class_array, $enum_class_map, $contentType);
        return $response;
    }

    /**
     * Operation fakeEnumEndpointWithHttpInfo
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeEnumEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\EnumClass, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeEnumEndpointWithHttpInfo(
        \OpenAPI\Client\Model\EnumClass $enum_class,
        array $enum_class_array,
        array $enum_class_map,
        string $contentType = self::contentTypes['fakeEnumEndpoint'][0]
    ): array
    {
        $request = $this->fakeEnumEndpointRequest($enum_class, $enum_class_array, $enum_class_map, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\EnumClass',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\EnumClass',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\EnumClass',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeEnumEndpointAsync
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeEnumEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeEnumEndpointAsync(
        \OpenAPI\Client\Model\EnumClass $enum_class,
        array $enum_class_array,
        array $enum_class_map,
        string $contentType = self::contentTypes['fakeEnumEndpoint'][0]
    ): PromiseInterface
    {
        return $this->fakeEnumEndpointAsyncWithHttpInfo($enum_class, $enum_class_array, $enum_class_map, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeEnumEndpointAsyncWithHttpInfo
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeEnumEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeEnumEndpointAsyncWithHttpInfo(
        \OpenAPI\Client\Model\EnumClass $enum_class,
        array $enum_class_array,
        array $enum_class_map,
        string $contentType = self::contentTypes['fakeEnumEndpoint'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\EnumClass';
        $request = $this->fakeEnumEndpointRequest($enum_class, $enum_class_array, $enum_class_map, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeEnumEndpoint'
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeEnumEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeEnumEndpointRequest(
        \OpenAPI\Client\Model\EnumClass $enum_class,
        array $enum_class_array,
        array $enum_class_map,
        string $contentType = self::contentTypes['fakeEnumEndpoint'][0]
    ): Request
    {

        // verify the required parameter 'enum_class' is set
        if ($enum_class === null || (is_array($enum_class) && count($enum_class) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $enum_class when calling fakeEnumEndpoint'
            );
        }

        // verify the required parameter 'enum_class_array' is set
        if ($enum_class_array === null || (is_array($enum_class_array) && count($enum_class_array) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $enum_class_array when calling fakeEnumEndpoint'
            );
        }

        // verify the required parameter 'enum_class_map' is set
        if ($enum_class_map === null || (is_array($enum_class_map) && count($enum_class_map) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $enum_class_map when calling fakeEnumEndpoint'
            );
        }


        $resourcePath = '/fake/enum/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_class?->value,
            'enum-class', // param base name
            'EnumClass', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_class_array,
            'enum-class-array', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_class_map,
            'enum-class-map', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeHealthGet
     *
     * Health check endpoint
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHealthGet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\HealthCheckResult
     */
    public function fakeHealthGet(
        string $contentType = self::contentTypes['fakeHealthGet'][0]
    ): \OpenAPI\Client\Model\HealthCheckResult
    {
        list($response) = $this->fakeHealthGetWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation fakeHealthGetWithHttpInfo
     *
     * Health check endpoint
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHealthGet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\HealthCheckResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeHealthGetWithHttpInfo(
        string $contentType = self::contentTypes['fakeHealthGet'][0]
    ): array
    {
        $request = $this->fakeHealthGetRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\HealthCheckResult',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\HealthCheckResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\HealthCheckResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeHealthGetAsync
     *
     * Health check endpoint
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHealthGet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeHealthGetAsync(
        string $contentType = self::contentTypes['fakeHealthGet'][0]
    ): PromiseInterface
    {
        return $this->fakeHealthGetAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeHealthGetAsyncWithHttpInfo
     *
     * Health check endpoint
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHealthGet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeHealthGetAsyncWithHttpInfo(
        string $contentType = self::contentTypes['fakeHealthGet'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\HealthCheckResult';
        $request = $this->fakeHealthGetRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeHealthGet'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHealthGet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeHealthGetRequest(
        string $contentType = self::contentTypes['fakeHealthGet'][0]
    ): Request
    {


        $resourcePath = '/fake/health';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeHttpSignatureTest
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string|null $query_1 query parameter (optional)
     * @param  string|null $header_1 header parameter (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHttpSignatureTest'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function fakeHttpSignatureTest(
        \OpenAPI\Client\Model\Pet $pet,
        ?string $query_1 = null,
        ?string $header_1 = null,
        string $contentType = self::contentTypes['fakeHttpSignatureTest'][0]
    ): void
    {
        $this->fakeHttpSignatureTestWithHttpInfo($pet, $query_1, $header_1, $contentType);
    }

    /**
     * Operation fakeHttpSignatureTestWithHttpInfo
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string|null $query_1 query parameter (optional)
     * @param  string|null $header_1 header parameter (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHttpSignatureTest'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeHttpSignatureTestWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        ?string $query_1 = null,
        ?string $header_1 = null,
        string $contentType = self::contentTypes['fakeHttpSignatureTest'][0]
    ): array
    {
        $request = $this->fakeHttpSignatureTestRequest($pet, $query_1, $header_1, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeHttpSignatureTestAsync
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string|null $query_1 query parameter (optional)
     * @param  string|null $header_1 header parameter (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHttpSignatureTest'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeHttpSignatureTestAsync(
        \OpenAPI\Client\Model\Pet $pet,
        ?string $query_1 = null,
        ?string $header_1 = null,
        string $contentType = self::contentTypes['fakeHttpSignatureTest'][0]
    ): PromiseInterface
    {
        return $this->fakeHttpSignatureTestAsyncWithHttpInfo($pet, $query_1, $header_1, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeHttpSignatureTestAsyncWithHttpInfo
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string|null $query_1 query parameter (optional)
     * @param  string|null $header_1 header parameter (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHttpSignatureTest'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeHttpSignatureTestAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        ?string $query_1 = null,
        ?string $header_1 = null,
        string $contentType = self::contentTypes['fakeHttpSignatureTest'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->fakeHttpSignatureTestRequest($pet, $query_1, $header_1, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeHttpSignatureTest'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string|null $query_1 query parameter (optional)
     * @param  string|null $header_1 header parameter (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeHttpSignatureTest'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeHttpSignatureTestRequest(
        \OpenAPI\Client\Model\Pet $pet,
        ?string $query_1 = null,
        ?string $header_1 = null,
        string $contentType = self::contentTypes['fakeHttpSignatureTest'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeHttpSignatureTest'
            );
        }




        $resourcePath = '/fake/http-signature-test';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_1,
            'query_1', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($header_1 !== null) {
            $headerParams['header_1'] = ObjectSerializer::toHeaderValue($header_1);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeOuterBooleanSerialize
     *
     * @param  bool|null $body Input boolean as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterBooleanSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return bool
     */
    public function fakeOuterBooleanSerialize(
        ?bool $body = null,
        string $contentType = self::contentTypes['fakeOuterBooleanSerialize'][0]
    ): bool
    {
        list($response) = $this->fakeOuterBooleanSerializeWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation fakeOuterBooleanSerializeWithHttpInfo
     *
     * @param  bool|null $body Input boolean as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterBooleanSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of bool, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterBooleanSerializeWithHttpInfo(
        ?bool $body = null,
        string $contentType = self::contentTypes['fakeOuterBooleanSerialize'][0]
    ): array
    {
        $request = $this->fakeOuterBooleanSerializeRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'bool',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'bool',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeOuterBooleanSerializeAsync
     *
     * @param  bool|null $body Input boolean as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterBooleanSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterBooleanSerializeAsync(
        ?bool $body = null,
        string $contentType = self::contentTypes['fakeOuterBooleanSerialize'][0]
    ): PromiseInterface
    {
        return $this->fakeOuterBooleanSerializeAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterBooleanSerializeAsyncWithHttpInfo
     *
     * @param  bool|null $body Input boolean as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterBooleanSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterBooleanSerializeAsyncWithHttpInfo(
        ?bool $body = null,
        string $contentType = self::contentTypes['fakeOuterBooleanSerialize'][0]
    ): PromiseInterface
    {
        $returnType = 'bool';
        $request = $this->fakeOuterBooleanSerializeRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterBooleanSerialize'
     *
     * @param  bool|null $body Input boolean as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterBooleanSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeOuterBooleanSerializeRequest(
        ?bool $body = null,
        string $contentType = self::contentTypes['fakeOuterBooleanSerialize'][0]
    ): Request
    {



        $resourcePath = '/fake/outer/boolean';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeOuterCompositeSerialize
     *
     * @param  \OpenAPI\Client\Model\OuterComposite|null $outer_composite Input composite as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterCompositeSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\OuterComposite
     */
    public function fakeOuterCompositeSerialize(
        ?\OpenAPI\Client\Model\OuterComposite $outer_composite = null,
        string $contentType = self::contentTypes['fakeOuterCompositeSerialize'][0]
    ): \OpenAPI\Client\Model\OuterComposite
    {
        list($response) = $this->fakeOuterCompositeSerializeWithHttpInfo($outer_composite, $contentType);
        return $response;
    }

    /**
     * Operation fakeOuterCompositeSerializeWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterComposite|null $outer_composite Input composite as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterCompositeSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OuterComposite, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterCompositeSerializeWithHttpInfo(
        ?\OpenAPI\Client\Model\OuterComposite $outer_composite = null,
        string $contentType = self::contentTypes['fakeOuterCompositeSerialize'][0]
    ): array
    {
        $request = $this->fakeOuterCompositeSerializeRequest($outer_composite, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OuterComposite',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OuterComposite',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OuterComposite',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeOuterCompositeSerializeAsync
     *
     * @param  \OpenAPI\Client\Model\OuterComposite|null $outer_composite Input composite as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterCompositeSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterCompositeSerializeAsync(
        ?\OpenAPI\Client\Model\OuterComposite $outer_composite = null,
        string $contentType = self::contentTypes['fakeOuterCompositeSerialize'][0]
    ): PromiseInterface
    {
        return $this->fakeOuterCompositeSerializeAsyncWithHttpInfo($outer_composite, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterCompositeSerializeAsyncWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterComposite|null $outer_composite Input composite as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterCompositeSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterCompositeSerializeAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\OuterComposite $outer_composite = null,
        string $contentType = self::contentTypes['fakeOuterCompositeSerialize'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\OuterComposite';
        $request = $this->fakeOuterCompositeSerializeRequest($outer_composite, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterCompositeSerialize'
     *
     * @param  \OpenAPI\Client\Model\OuterComposite|null $outer_composite Input composite as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterCompositeSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeOuterCompositeSerializeRequest(
        ?\OpenAPI\Client\Model\OuterComposite $outer_composite = null,
        string $contentType = self::contentTypes['fakeOuterCompositeSerialize'][0]
    ): Request
    {



        $resourcePath = '/fake/outer/composite';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($outer_composite)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($outer_composite));
            } else {
                $httpBody = $outer_composite;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeOuterNumberSerialize
     *
     * @param  float|null $body Input number as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterNumberSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return float
     */
    public function fakeOuterNumberSerialize(
        ?float $body = null,
        string $contentType = self::contentTypes['fakeOuterNumberSerialize'][0]
    ): float
    {
        list($response) = $this->fakeOuterNumberSerializeWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation fakeOuterNumberSerializeWithHttpInfo
     *
     * @param  float|null $body Input number as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterNumberSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of float, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterNumberSerializeWithHttpInfo(
        ?float $body = null,
        string $contentType = self::contentTypes['fakeOuterNumberSerialize'][0]
    ): array
    {
        $request = $this->fakeOuterNumberSerializeRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'float',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'float',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'float',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeOuterNumberSerializeAsync
     *
     * @param  float|null $body Input number as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterNumberSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterNumberSerializeAsync(
        ?float $body = null,
        string $contentType = self::contentTypes['fakeOuterNumberSerialize'][0]
    ): PromiseInterface
    {
        return $this->fakeOuterNumberSerializeAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterNumberSerializeAsyncWithHttpInfo
     *
     * @param  float|null $body Input number as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterNumberSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterNumberSerializeAsyncWithHttpInfo(
        ?float $body = null,
        string $contentType = self::contentTypes['fakeOuterNumberSerialize'][0]
    ): PromiseInterface
    {
        $returnType = 'float';
        $request = $this->fakeOuterNumberSerializeRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterNumberSerialize'
     *
     * @param  float|null $body Input number as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterNumberSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeOuterNumberSerializeRequest(
        ?float $body = null,
        string $contentType = self::contentTypes['fakeOuterNumberSerialize'][0]
    ): Request
    {



        $resourcePath = '/fake/outer/number';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeOuterStringSerialize
     *
     * @param  string|null $body Input string as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterStringSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function fakeOuterStringSerialize(
        ?string $body = null,
        string $contentType = self::contentTypes['fakeOuterStringSerialize'][0]
    ): string
    {
        list($response) = $this->fakeOuterStringSerializeWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation fakeOuterStringSerializeWithHttpInfo
     *
     * @param  string|null $body Input string as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterStringSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterStringSerializeWithHttpInfo(
        ?string $body = null,
        string $contentType = self::contentTypes['fakeOuterStringSerialize'][0]
    ): array
    {
        $request = $this->fakeOuterStringSerializeRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeOuterStringSerializeAsync
     *
     * @param  string|null $body Input string as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterStringSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterStringSerializeAsync(
        ?string $body = null,
        string $contentType = self::contentTypes['fakeOuterStringSerialize'][0]
    ): PromiseInterface
    {
        return $this->fakeOuterStringSerializeAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterStringSerializeAsyncWithHttpInfo
     *
     * @param  string|null $body Input string as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterStringSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeOuterStringSerializeAsyncWithHttpInfo(
        ?string $body = null,
        string $contentType = self::contentTypes['fakeOuterStringSerialize'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->fakeOuterStringSerializeRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterStringSerialize'
     *
     * @param  string|null $body Input string as post body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeOuterStringSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeOuterStringSerializeRequest(
        ?string $body = null,
        string $contentType = self::contentTypes['fakeOuterStringSerialize'][0]
    ): Request
    {



        $resourcePath = '/fake/outer/string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakePropertyEnumIntegerSerialize
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakePropertyEnumIntegerSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\OuterObjectWithEnumProperty
     */
    public function fakePropertyEnumIntegerSerialize(
        \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property,
        string $contentType = self::contentTypes['fakePropertyEnumIntegerSerialize'][0]
    ): \OpenAPI\Client\Model\OuterObjectWithEnumProperty
    {
        list($response) = $this->fakePropertyEnumIntegerSerializeWithHttpInfo($outer_object_with_enum_property, $contentType);
        return $response;
    }

    /**
     * Operation fakePropertyEnumIntegerSerializeWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakePropertyEnumIntegerSerialize'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OuterObjectWithEnumProperty, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakePropertyEnumIntegerSerializeWithHttpInfo(
        \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property,
        string $contentType = self::contentTypes['fakePropertyEnumIntegerSerialize'][0]
    ): array
    {
        $request = $this->fakePropertyEnumIntegerSerializeRequest($outer_object_with_enum_property, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OuterObjectWithEnumProperty',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OuterObjectWithEnumProperty',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OuterObjectWithEnumProperty',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakePropertyEnumIntegerSerializeAsync
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakePropertyEnumIntegerSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakePropertyEnumIntegerSerializeAsync(
        \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property,
        string $contentType = self::contentTypes['fakePropertyEnumIntegerSerialize'][0]
    ): PromiseInterface
    {
        return $this->fakePropertyEnumIntegerSerializeAsyncWithHttpInfo($outer_object_with_enum_property, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakePropertyEnumIntegerSerializeAsyncWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakePropertyEnumIntegerSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakePropertyEnumIntegerSerializeAsyncWithHttpInfo(
        \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property,
        string $contentType = self::contentTypes['fakePropertyEnumIntegerSerialize'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\OuterObjectWithEnumProperty';
        $request = $this->fakePropertyEnumIntegerSerializeRequest($outer_object_with_enum_property, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakePropertyEnumIntegerSerialize'
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakePropertyEnumIntegerSerialize'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakePropertyEnumIntegerSerializeRequest(
        \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property,
        string $contentType = self::contentTypes['fakePropertyEnumIntegerSerialize'][0]
    ): Request
    {

        // verify the required parameter 'outer_object_with_enum_property' is set
        if ($outer_object_with_enum_property === null || (is_array($outer_object_with_enum_property) && count($outer_object_with_enum_property) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $outer_object_with_enum_property when calling fakePropertyEnumIntegerSerialize'
            );
        }


        $resourcePath = '/fake/property/enum-int';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($outer_object_with_enum_property)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($outer_object_with_enum_property));
            } else {
                $httpBody = $outer_object_with_enum_property;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpoint
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
     */
    public function fakeWith400And4xxRangeResponseEndpoint(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'][0]
    ): \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
    {
        list($response) = $this->fakeWith400And4xxRangeResponseEndpointWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpointWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith400And4xxRangeResponseEndpointWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'][0]
    ): array
    {
        $request = $this->fakeWith400And4xxRangeResponseEndpointRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                
            }
            
            if ($this->responseWithinRangeCode('4xx', $statusCode)) {
                return $this->handleResponseWithDataType(
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $request,
                    $response,
                );
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                
            }
        
            if ($this->responseWithinRangeCode('4xx', $e->getCode())) {
                $data = ObjectSerializer::deserialize(
                    $e->getResponseBody(),
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $e->getResponseHeaders()
                );
                $e->setResponseObject($data);
                throw $e;
            }
            throw $e;
        }
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpointAsync
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith400And4xxRangeResponseEndpointAsync(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'][0]
    ): PromiseInterface
    {
        return $this->fakeWith400And4xxRangeResponseEndpointAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith400And4xxRangeResponseEndpointAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith400And4xxRangeResponseEndpointRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith400And4xxRangeResponseEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeWith400And4xxRangeResponseEndpointRequest(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseEndpoint'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith400And4xxRangeResponseEndpoint'
            );
        }


        $resourcePath = '/fake/with_400_and_4xx_range_response/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|null
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): ?\OpenAPI\Client\Model\Pet
    {
        list($response) = $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): array
    {
        $request = $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsync
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsync(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): PromiseInterface
    {
        return $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointRequest(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'
            );
        }


        $resourcePath = '/fake/with_400_and_4xx_range_response_no_4xx_datatype/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeWith400ResponseEndpoint
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400ResponseEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
     */
    public function fakeWith400ResponseEndpoint(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400ResponseEndpoint'][0]
    ): \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
    {
        list($response) = $this->fakeWith400ResponseEndpointWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation fakeWith400ResponseEndpointWithHttpInfo
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400ResponseEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith400ResponseEndpointWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400ResponseEndpoint'][0]
    ): array
    {
        $request = $this->fakeWith400ResponseEndpointRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeWith400ResponseEndpointAsync
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400ResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith400ResponseEndpointAsync(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400ResponseEndpoint'][0]
    ): PromiseInterface
    {
        return $this->fakeWith400ResponseEndpointAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith400ResponseEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400ResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith400ResponseEndpointAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400ResponseEndpoint'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith400ResponseEndpointRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith400ResponseEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith400ResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeWith400ResponseEndpointRequest(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith400ResponseEndpoint'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith400ResponseEndpoint'
            );
        }


        $resourcePath = '/fake/with_400_response/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpoint
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
     */
    public function fakeWith4xxRangeResponseEndpoint(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseEndpoint'][0]
    ): \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
    {
        list($response) = $this->fakeWith4xxRangeResponseEndpointWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpointWithHttpInfo
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith4xxRangeResponseEndpointWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseEndpoint'][0]
    ): array
    {
        $request = $this->fakeWith4xxRangeResponseEndpointRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
                
            }
            
            if ($this->responseWithinRangeCode('4xx', $statusCode)) {
                return $this->handleResponseWithDataType(
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $request,
                    $response,
                );
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                
            }
        
            if ($this->responseWithinRangeCode('4xx', $e->getCode())) {
                $data = ObjectSerializer::deserialize(
                    $e->getResponseBody(),
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $e->getResponseHeaders()
                );
                $e->setResponseObject($data);
                throw $e;
            }
            throw $e;
        }
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpointAsync
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith4xxRangeResponseEndpointAsync(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseEndpoint'][0]
    ): PromiseInterface
    {
        return $this->fakeWith4xxRangeResponseEndpointAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith4xxRangeResponseEndpointAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseEndpoint'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith4xxRangeResponseEndpointRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith4xxRangeResponseEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeWith4xxRangeResponseEndpointRequest(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseEndpoint'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith4xxRangeResponseEndpoint'
            );
        }


        $resourcePath = '/fake/with_4xx_range_response/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpoint
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|null
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpoint(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): ?\OpenAPI\Client\Model\Pet
    {
        list($response) = $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo($pet, $contentType);
        return $response;
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): array
    {
        $request = $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointRequest($pet, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsync
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsync(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): PromiseInterface
    {
        return $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo($pet, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointRequest($pet, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointRequest(
        \OpenAPI\Client\Model\Pet $pet,
        string $contentType = self::contentTypes['fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'
            );
        }


        $resourcePath = '/fake/with_4xx_range_response_no_4xx_datatype/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testAdditionalPropertiesReference
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testAdditionalPropertiesReference'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testAdditionalPropertiesReference(
        array $request_body,
        string $contentType = self::contentTypes['testAdditionalPropertiesReference'][0]
    ): void
    {
        $this->testAdditionalPropertiesReferenceWithHttpInfo($request_body, $contentType);
    }

    /**
     * Operation testAdditionalPropertiesReferenceWithHttpInfo
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testAdditionalPropertiesReference'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testAdditionalPropertiesReferenceWithHttpInfo(
        array $request_body,
        string $contentType = self::contentTypes['testAdditionalPropertiesReference'][0]
    ): array
    {
        $request = $this->testAdditionalPropertiesReferenceRequest($request_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testAdditionalPropertiesReferenceAsync
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testAdditionalPropertiesReference'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testAdditionalPropertiesReferenceAsync(
        array $request_body,
        string $contentType = self::contentTypes['testAdditionalPropertiesReference'][0]
    ): PromiseInterface
    {
        return $this->testAdditionalPropertiesReferenceAsyncWithHttpInfo($request_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testAdditionalPropertiesReferenceAsyncWithHttpInfo
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testAdditionalPropertiesReference'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testAdditionalPropertiesReferenceAsyncWithHttpInfo(
        array $request_body,
        string $contentType = self::contentTypes['testAdditionalPropertiesReference'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testAdditionalPropertiesReferenceRequest($request_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testAdditionalPropertiesReference'
     *
     * @param  array<string,mixed> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testAdditionalPropertiesReference'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testAdditionalPropertiesReferenceRequest(
        array $request_body,
        string $contentType = self::contentTypes['testAdditionalPropertiesReference'][0]
    ): Request
    {

        // verify the required parameter 'request_body' is set
        if ($request_body === null || (is_array($request_body) && count($request_body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $request_body when calling testAdditionalPropertiesReference'
            );
        }


        $resourcePath = '/fake/additionalProperties-reference';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testBodyWithBinary
     *
     * @param  \SplFileObject|null $body image to upload (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testBodyWithBinary(
        ?\SplFileObject $body,
        string $contentType = self::contentTypes['testBodyWithBinary'][0]
    ): void
    {
        $this->testBodyWithBinaryWithHttpInfo($body, $contentType);
    }

    /**
     * Operation testBodyWithBinaryWithHttpInfo
     *
     * @param  \SplFileObject|null $body image to upload (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithBinary'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyWithBinaryWithHttpInfo(
        ?\SplFileObject $body,
        string $contentType = self::contentTypes['testBodyWithBinary'][0]
    ): array
    {
        $request = $this->testBodyWithBinaryRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBodyWithBinaryAsync
     *
     * @param  \SplFileObject|null $body image to upload (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyWithBinaryAsync(
        ?\SplFileObject $body,
        string $contentType = self::contentTypes['testBodyWithBinary'][0]
    ): PromiseInterface
    {
        return $this->testBodyWithBinaryAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyWithBinaryAsyncWithHttpInfo
     *
     * @param  \SplFileObject|null $body image to upload (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyWithBinaryAsyncWithHttpInfo(
        ?\SplFileObject $body,
        string $contentType = self::contentTypes['testBodyWithBinary'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testBodyWithBinaryRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyWithBinary'
     *
     * @param  \SplFileObject|null $body image to upload (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithBinary'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBodyWithBinaryRequest(
        ?\SplFileObject $body,
        string $contentType = self::contentTypes['testBodyWithBinary'][0]
    ): Request
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling testBodyWithBinary'
            );
        }


        $resourcePath = '/fake/body-with-binary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testBodyWithFileSchema
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class file_schema_test_class (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithFileSchema'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testBodyWithFileSchema(
        \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class,
        string $contentType = self::contentTypes['testBodyWithFileSchema'][0]
    ): void
    {
        $this->testBodyWithFileSchemaWithHttpInfo($file_schema_test_class, $contentType);
    }

    /**
     * Operation testBodyWithFileSchemaWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithFileSchema'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyWithFileSchemaWithHttpInfo(
        \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class,
        string $contentType = self::contentTypes['testBodyWithFileSchema'][0]
    ): array
    {
        $request = $this->testBodyWithFileSchemaRequest($file_schema_test_class, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBodyWithFileSchemaAsync
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithFileSchema'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyWithFileSchemaAsync(
        \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class,
        string $contentType = self::contentTypes['testBodyWithFileSchema'][0]
    ): PromiseInterface
    {
        return $this->testBodyWithFileSchemaAsyncWithHttpInfo($file_schema_test_class, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyWithFileSchemaAsyncWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithFileSchema'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyWithFileSchemaAsyncWithHttpInfo(
        \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class,
        string $contentType = self::contentTypes['testBodyWithFileSchema'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testBodyWithFileSchemaRequest($file_schema_test_class, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyWithFileSchema'
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithFileSchema'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBodyWithFileSchemaRequest(
        \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class,
        string $contentType = self::contentTypes['testBodyWithFileSchema'][0]
    ): Request
    {

        // verify the required parameter 'file_schema_test_class' is set
        if ($file_schema_test_class === null || (is_array($file_schema_test_class) && count($file_schema_test_class) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $file_schema_test_class when calling testBodyWithFileSchema'
            );
        }


        $resourcePath = '/fake/body-with-file-schema';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($file_schema_test_class)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($file_schema_test_class));
            } else {
                $httpBody = $file_schema_test_class;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testBodyWithQueryParams
     *
     * @param  string $query query (required)
     * @param  \OpenAPI\Client\Model\User $user user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithQueryParams'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testBodyWithQueryParams(
        string $query,
        \OpenAPI\Client\Model\User $user,
        string $contentType = self::contentTypes['testBodyWithQueryParams'][0]
    ): void
    {
        $this->testBodyWithQueryParamsWithHttpInfo($query, $user, $contentType);
    }

    /**
     * Operation testBodyWithQueryParamsWithHttpInfo
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithQueryParams'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyWithQueryParamsWithHttpInfo(
        string $query,
        \OpenAPI\Client\Model\User $user,
        string $contentType = self::contentTypes['testBodyWithQueryParams'][0]
    ): array
    {
        $request = $this->testBodyWithQueryParamsRequest($query, $user, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testBodyWithQueryParamsAsync
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithQueryParams'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyWithQueryParamsAsync(
        string $query,
        \OpenAPI\Client\Model\User $user,
        string $contentType = self::contentTypes['testBodyWithQueryParams'][0]
    ): PromiseInterface
    {
        return $this->testBodyWithQueryParamsAsyncWithHttpInfo($query, $user, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyWithQueryParamsAsyncWithHttpInfo
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithQueryParams'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testBodyWithQueryParamsAsyncWithHttpInfo(
        string $query,
        \OpenAPI\Client\Model\User $user,
        string $contentType = self::contentTypes['testBodyWithQueryParams'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testBodyWithQueryParamsRequest($query, $user, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyWithQueryParams'
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testBodyWithQueryParams'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testBodyWithQueryParamsRequest(
        string $query,
        \OpenAPI\Client\Model\User $user,
        string $contentType = self::contentTypes['testBodyWithQueryParams'][0]
    ): Request
    {

        // verify the required parameter 'query' is set
        if ($query === null || (is_array($query) && count($query) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $query when calling testBodyWithQueryParams'
            );
        }

        // verify the required parameter 'user' is set
        if ($user === null || (is_array($user) && count($user) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $user when calling testBodyWithQueryParams'
            );
        }


        $resourcePath = '/fake/body-with-query-params';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query,
            'query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($user)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($user));
            } else {
                $httpBody = $user;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testClientModel
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testClientModel'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Client
     */
    public function testClientModel(
        \OpenAPI\Client\Model\Client $client,
        string $contentType = self::contentTypes['testClientModel'][0]
    ): \OpenAPI\Client\Model\Client
    {
        list($response) = $this->testClientModelWithHttpInfo($client, $contentType);
        return $response;
    }

    /**
     * Operation testClientModelWithHttpInfo
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testClientModel'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Client, HTTP status code, HTTP response headers (array of strings)
     */
    public function testClientModelWithHttpInfo(
        \OpenAPI\Client\Model\Client $client,
        string $contentType = self::contentTypes['testClientModel'][0]
    ): array
    {
        $request = $this->testClientModelRequest($client, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Client',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Client',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Client',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testClientModelAsync
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testClientModel'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testClientModelAsync(
        \OpenAPI\Client\Model\Client $client,
        string $contentType = self::contentTypes['testClientModel'][0]
    ): PromiseInterface
    {
        return $this->testClientModelAsyncWithHttpInfo($client, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testClientModelAsyncWithHttpInfo
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testClientModel'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testClientModelAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Client $client,
        string $contentType = self::contentTypes['testClientModel'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Client';
        $request = $this->testClientModelRequest($client, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testClientModel'
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testClientModel'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testClientModelRequest(
        \OpenAPI\Client\Model\Client $client,
        string $contentType = self::contentTypes['testClientModel'][0]
    ): Request
    {

        // verify the required parameter 'client' is set
        if ($client === null || (is_array($client) && count($client) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $client when calling testClientModel'
            );
        }


        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($client)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($client));
            } else {
                $httpBody = $client;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEndpointParameters
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int|null $integer None (optional)
     * @param  int|null $int32 None (optional)
     * @param  int|null $int64 None (optional)
     * @param  float|null $float None (optional)
     * @param  string|null $string None (optional)
     * @param  \SplFileObject|null $binary None (optional)
     * @param  \DateTime|null $date None (optional)
     * @param  \DateTime|null $date_time None (optional)
     * @param  string|null $password None (optional)
     * @param  string|null $callback None (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEndpointParameters'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testEndpointParameters(
        float $number,
        float $double,
        string $pattern_without_delimiter,
        string $byte,
        ?int $integer = null,
        ?int $int32 = null,
        ?int $int64 = null,
        ?float $float = null,
        ?string $string = null,
        ?\SplFileObject $binary = null,
        ?\DateTime $date = null,
        ?\DateTime $date_time = null,
        ?string $password = null,
        ?string $callback = null,
        string $contentType = self::contentTypes['testEndpointParameters'][0]
    ): void
    {
        $this->testEndpointParametersWithHttpInfo($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback, $contentType);
    }

    /**
     * Operation testEndpointParametersWithHttpInfo
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int|null $integer None (optional)
     * @param  int|null $int32 None (optional)
     * @param  int|null $int64 None (optional)
     * @param  float|null $float None (optional)
     * @param  string|null $string None (optional)
     * @param  \SplFileObject|null $binary None (optional)
     * @param  \DateTime|null $date None (optional)
     * @param  \DateTime|null $date_time None (optional)
     * @param  string|null $password None (optional)
     * @param  string|null $callback None (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEndpointParameters'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEndpointParametersWithHttpInfo(
        float $number,
        float $double,
        string $pattern_without_delimiter,
        string $byte,
        ?int $integer = null,
        ?int $int32 = null,
        ?int $int64 = null,
        ?float $float = null,
        ?string $string = null,
        ?\SplFileObject $binary = null,
        ?\DateTime $date = null,
        ?\DateTime $date_time = null,
        ?string $password = null,
        ?string $callback = null,
        string $contentType = self::contentTypes['testEndpointParameters'][0]
    ): array
    {
        $request = $this->testEndpointParametersRequest($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEndpointParametersAsync
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int|null $integer None (optional)
     * @param  int|null $int32 None (optional)
     * @param  int|null $int64 None (optional)
     * @param  float|null $float None (optional)
     * @param  string|null $string None (optional)
     * @param  \SplFileObject|null $binary None (optional)
     * @param  \DateTime|null $date None (optional)
     * @param  \DateTime|null $date_time None (optional)
     * @param  string|null $password None (optional)
     * @param  string|null $callback None (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEndpointParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEndpointParametersAsync(
        float $number,
        float $double,
        string $pattern_without_delimiter,
        string $byte,
        ?int $integer = null,
        ?int $int32 = null,
        ?int $int64 = null,
        ?float $float = null,
        ?string $string = null,
        ?\SplFileObject $binary = null,
        ?\DateTime $date = null,
        ?\DateTime $date_time = null,
        ?string $password = null,
        ?string $callback = null,
        string $contentType = self::contentTypes['testEndpointParameters'][0]
    ): PromiseInterface
    {
        return $this->testEndpointParametersAsyncWithHttpInfo($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEndpointParametersAsyncWithHttpInfo
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int|null $integer None (optional)
     * @param  int|null $int32 None (optional)
     * @param  int|null $int64 None (optional)
     * @param  float|null $float None (optional)
     * @param  string|null $string None (optional)
     * @param  \SplFileObject|null $binary None (optional)
     * @param  \DateTime|null $date None (optional)
     * @param  \DateTime|null $date_time None (optional)
     * @param  string|null $password None (optional)
     * @param  string|null $callback None (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEndpointParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEndpointParametersAsyncWithHttpInfo(
        float $number,
        float $double,
        string $pattern_without_delimiter,
        string $byte,
        ?int $integer = null,
        ?int $int32 = null,
        ?int $int64 = null,
        ?float $float = null,
        ?string $string = null,
        ?\SplFileObject $binary = null,
        ?\DateTime $date = null,
        ?\DateTime $date_time = null,
        ?string $password = null,
        ?string $callback = null,
        string $contentType = self::contentTypes['testEndpointParameters'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testEndpointParametersRequest($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEndpointParameters'
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int|null $integer None (optional)
     * @param  int|null $int32 None (optional)
     * @param  int|null $int64 None (optional)
     * @param  float|null $float None (optional)
     * @param  string|null $string None (optional)
     * @param  \SplFileObject|null $binary None (optional)
     * @param  \DateTime|null $date None (optional)
     * @param  \DateTime|null $date_time None (optional)
     * @param  string|null $password None (optional)
     * @param  string|null $callback None (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEndpointParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEndpointParametersRequest(
        float $number,
        float $double,
        string $pattern_without_delimiter,
        string $byte,
        ?int $integer = null,
        ?int $int32 = null,
        ?int $int64 = null,
        ?float $float = null,
        ?string $string = null,
        ?\SplFileObject $binary = null,
        ?\DateTime $date = null,
        ?\DateTime $date_time = null,
        ?string $password = null,
        ?string $callback = null,
        string $contentType = self::contentTypes['testEndpointParameters'][0]
    ): Request
    {

        // verify the required parameter 'number' is set
        if ($number === null || (is_array($number) && count($number) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $number when calling testEndpointParameters'
            );
        }
        if ($number > 543.2) {
            throw new InvalidArgumentException('invalid value for "$number" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 543.2.');
        }
        if ($number < 32.1) {
            throw new InvalidArgumentException('invalid value for "$number" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 32.1.');
        }
        
        // verify the required parameter 'double' is set
        if ($double === null || (is_array($double) && count($double) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $double when calling testEndpointParameters'
            );
        }
        if ($double > 123.4) {
            throw new InvalidArgumentException('invalid value for "$double" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 123.4.');
        }
        if ($double < 67.8) {
            throw new InvalidArgumentException('invalid value for "$double" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 67.8.');
        }
        
        // verify the required parameter 'pattern_without_delimiter' is set
        if ($pattern_without_delimiter === null || (is_array($pattern_without_delimiter) && count($pattern_without_delimiter) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pattern_without_delimiter when calling testEndpointParameters'
            );
        }
        if (!preg_match("/^[A-Z].*/", $pattern_without_delimiter)) {
            throw new InvalidArgumentException("invalid value for \"pattern_without_delimiter\" when calling FakeApi.testEndpointParameters, must conform to the pattern /^[A-Z].*/.");
        }
        
        // verify the required parameter 'byte' is set
        if ($byte === null || (is_array($byte) && count($byte) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $byte when calling testEndpointParameters'
            );
        }

        if ($integer !== null && $integer > 100) {
            throw new InvalidArgumentException('invalid value for "$integer" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 100.');
        }
        if ($integer !== null && $integer < 10) {
            throw new InvalidArgumentException('invalid value for "$integer" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 10.');
        }
        
        if ($int32 !== null && $int32 > 200) {
            throw new InvalidArgumentException('invalid value for "$int32" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 200.');
        }
        if ($int32 !== null && $int32 < 20) {
            throw new InvalidArgumentException('invalid value for "$int32" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 20.');
        }
        

        if ($float !== null && $float > 987.6) {
            throw new InvalidArgumentException('invalid value for "$float" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 987.6.');
        }
        
        if ($string !== null && !preg_match("/[a-z]/i", $string)) {
            throw new InvalidArgumentException("invalid value for \"string\" when calling FakeApi.testEndpointParameters, must conform to the pattern /[a-z]/i.");
        }
        



        if ($password !== null && strlen($password) > 64) {
            throw new InvalidArgumentException('invalid length for "$password" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 64.');
        }
        if ($password !== null && strlen($password) < 10) {
            throw new InvalidArgumentException('invalid length for "$password" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 10.');
        }
        


        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'integer' => $integer,
            'int32' => $int32,
            'int64' => $int64,
            'number' => $number,
            'float' => $float,
            'double' => $double,
            'string' => $string,
            'pattern_without_delimiter' => $pattern_without_delimiter,
            'byte' => $byte,
            'binary' => $binary,
            'date' => $date,
            'date_time' => $date_time,
            'password' => $password,
            'callback' => $callback,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testEnumParameters
     *
     * To test enum parameters
     *
     * @param  string[]|null $enum_header_string_array Header parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[]|null $enum_query_string_array Query parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int|null $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float|null $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[]|null $enum_query_model_array enum_query_model_array (optional)
     * @param  string[]|null $enum_form_string_array Form parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumParameters'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testEnumParameters(
        ?array $enum_header_string_array = ['$'],
        ?string $enum_header_string = '-efg',
        ?array $enum_query_string_array = ['$'],
        ?string $enum_query_string = '-efg',
        ?int $enum_query_integer = null,
        ?float $enum_query_double = null,
        ?array $enum_query_model_array = null,
        ?array $enum_form_string_array = ['$'],
        ?string $enum_form_string = '-efg',
        string $contentType = self::contentTypes['testEnumParameters'][0]
    ): void
    {
        $this->testEnumParametersWithHttpInfo($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string, $contentType);
    }

    /**
     * Operation testEnumParametersWithHttpInfo
     *
     * To test enum parameters
     *
     * @param  string[]|null $enum_header_string_array Header parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[]|null $enum_query_string_array Query parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int|null $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float|null $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[]|null $enum_query_model_array (optional)
     * @param  string[]|null $enum_form_string_array Form parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumParameters'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEnumParametersWithHttpInfo(
        ?array $enum_header_string_array = ['$'],
        ?string $enum_header_string = '-efg',
        ?array $enum_query_string_array = ['$'],
        ?string $enum_query_string = '-efg',
        ?int $enum_query_integer = null,
        ?float $enum_query_double = null,
        ?array $enum_query_model_array = null,
        ?array $enum_form_string_array = ['$'],
        ?string $enum_form_string = '-efg',
        string $contentType = self::contentTypes['testEnumParameters'][0]
    ): array
    {
        $request = $this->testEnumParametersRequest($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEnumParametersAsync
     *
     * To test enum parameters
     *
     * @param  string[]|null $enum_header_string_array Header parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[]|null $enum_query_string_array Query parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int|null $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float|null $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[]|null $enum_query_model_array (optional)
     * @param  string[]|null $enum_form_string_array Form parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEnumParametersAsync(
        ?array $enum_header_string_array = ['$'],
        ?string $enum_header_string = '-efg',
        ?array $enum_query_string_array = ['$'],
        ?string $enum_query_string = '-efg',
        ?int $enum_query_integer = null,
        ?float $enum_query_double = null,
        ?array $enum_query_model_array = null,
        ?array $enum_form_string_array = ['$'],
        ?string $enum_form_string = '-efg',
        string $contentType = self::contentTypes['testEnumParameters'][0]
    ): PromiseInterface
    {
        return $this->testEnumParametersAsyncWithHttpInfo($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEnumParametersAsyncWithHttpInfo
     *
     * To test enum parameters
     *
     * @param  string[]|null $enum_header_string_array Header parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[]|null $enum_query_string_array Query parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int|null $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float|null $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[]|null $enum_query_model_array (optional)
     * @param  string[]|null $enum_form_string_array Form parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEnumParametersAsyncWithHttpInfo(
        ?array $enum_header_string_array = ['$'],
        ?string $enum_header_string = '-efg',
        ?array $enum_query_string_array = ['$'],
        ?string $enum_query_string = '-efg',
        ?int $enum_query_integer = null,
        ?float $enum_query_double = null,
        ?array $enum_query_model_array = null,
        ?array $enum_form_string_array = ['$'],
        ?string $enum_form_string = '-efg',
        string $contentType = self::contentTypes['testEnumParameters'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testEnumParametersRequest($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEnumParameters'
     *
     * @param  string[]|null $enum_header_string_array Header parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[]|null $enum_query_string_array Query parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int|null $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float|null $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[]|null $enum_query_model_array (optional)
     * @param  string[]|null $enum_form_string_array Form parameter enum test (string array) (optional, default to ['$'])
     * @param  string|null $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEnumParametersRequest(
        ?array $enum_header_string_array = ['$'],
        ?string $enum_header_string = '-efg',
        ?array $enum_query_string_array = ['$'],
        ?string $enum_query_string = '-efg',
        ?int $enum_query_integer = null,
        ?float $enum_query_double = null,
        ?array $enum_query_model_array = null,
        ?array $enum_form_string_array = ['$'],
        ?string $enum_form_string = '-efg',
        string $contentType = self::contentTypes['testEnumParameters'][0]
    ): Request
    {











        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_query_string_array,
            'enum_query_string_array', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_query_string,
            'enum_query_string', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_query_integer,
            'enum_query_integer', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_query_double,
            'enum_query_double', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_query_model_array,
            'enum_query_model_array', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if (is_array($enum_header_string_array)) {
            $enum_header_string_array = ObjectSerializer::serializeCollection($enum_header_string_array, 'csv');
        }
        if ($enum_header_string_array !== null) {
            $headerParams['enum_header_string_array'] = ObjectSerializer::toHeaderValue($enum_header_string_array);
        }
        // header params
        if ($enum_header_string !== null) {
            $headerParams['enum_header_string'] = ObjectSerializer::toHeaderValue($enum_header_string);
        }


        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'enum_form_string_array' => $enum_form_string_array,
            'enum_form_string' => $enum_form_string,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testGroupParameters
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int|null $string_group String in group parameters (optional)
     * @param  bool|null $boolean_group Boolean in group parameters (optional)
     * @param  int|null $int64_group Integer in group parameters (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testGroupParameters'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testGroupParameters(
        array $associative_array
    ): void
    {
        $this->testGroupParametersWithHttpInfo($associative_array);
    }

    /**
     * Operation testGroupParametersWithHttpInfo
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int|null $string_group String in group parameters (optional)
     * @param  bool|null $boolean_group Boolean in group parameters (optional)
     * @param  int|null $int64_group Integer in group parameters (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testGroupParameters'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testGroupParametersWithHttpInfo(
        array $associative_array
    ): array
    {
        $request = $this->testGroupParametersRequest($associative_array);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testGroupParametersAsync
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int|null $string_group String in group parameters (optional)
     * @param  bool|null $boolean_group Boolean in group parameters (optional)
     * @param  int|null $int64_group Integer in group parameters (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testGroupParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testGroupParametersAsync(
        array $associative_array
    ): PromiseInterface
    {
        return $this->testGroupParametersAsyncWithHttpInfo($associative_array)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testGroupParametersAsyncWithHttpInfo
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int|null $string_group String in group parameters (optional)
     * @param  bool|null $boolean_group Boolean in group parameters (optional)
     * @param  int|null $int64_group Integer in group parameters (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testGroupParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testGroupParametersAsyncWithHttpInfo(
        array $associative_array
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testGroupParametersRequest($associative_array);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testGroupParameters'
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int|null $string_group String in group parameters (optional)
     * @param  bool|null $boolean_group Boolean in group parameters (optional)
     * @param  int|null $int64_group Integer in group parameters (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testGroupParameters'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testGroupParametersRequest(
        array $associative_array
    ): Request
    {
        // unbox the parameters from the associative array
        $required_string_group = array_key_exists('required_string_group', $associative_array) ? $associative_array['required_string_group'] : null;
        $required_boolean_group = array_key_exists('required_boolean_group', $associative_array) ? $associative_array['required_boolean_group'] : null;
        $required_int64_group = array_key_exists('required_int64_group', $associative_array) ? $associative_array['required_int64_group'] : null;
        $string_group = array_key_exists('string_group', $associative_array) ? $associative_array['string_group'] : null;
        $boolean_group = array_key_exists('boolean_group', $associative_array) ? $associative_array['boolean_group'] : null;
        $int64_group = array_key_exists('int64_group', $associative_array) ? $associative_array['int64_group'] : null;
        $contentType = $associative_array['contentType'] ?? self::contentTypes['testGroupParameters'][0];
        
        // verify the required parameter 'required_string_group' is set
        if ($required_string_group === null || (is_array($required_string_group) && count($required_string_group) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $required_string_group when calling testGroupParameters'
            );
        }

        // verify the required parameter 'required_boolean_group' is set
        if ($required_boolean_group === null || (is_array($required_boolean_group) && count($required_boolean_group) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $required_boolean_group when calling testGroupParameters'
            );
        }

        // verify the required parameter 'required_int64_group' is set
        if ($required_int64_group === null || (is_array($required_int64_group) && count($required_int64_group) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $required_int64_group when calling testGroupParameters'
            );
        }





        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $required_string_group,
            'required_string_group', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $required_int64_group,
            'required_int64_group', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $string_group,
            'string_group', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $int64_group,
            'int64_group', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($required_boolean_group !== null) {
            $headerParams['required_boolean_group'] = ObjectSerializer::toHeaderValue($required_boolean_group);
        }
        // header params
        if ($boolean_group !== null) {
            $headerParams['boolean_group'] = ObjectSerializer::toHeaderValue($boolean_group);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testInlineAdditionalProperties
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineAdditionalProperties'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testInlineAdditionalProperties(
        array $request_body,
        string $contentType = self::contentTypes['testInlineAdditionalProperties'][0]
    ): void
    {
        $this->testInlineAdditionalPropertiesWithHttpInfo($request_body, $contentType);
    }

    /**
     * Operation testInlineAdditionalPropertiesWithHttpInfo
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineAdditionalProperties'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testInlineAdditionalPropertiesWithHttpInfo(
        array $request_body,
        string $contentType = self::contentTypes['testInlineAdditionalProperties'][0]
    ): array
    {
        $request = $this->testInlineAdditionalPropertiesRequest($request_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testInlineAdditionalPropertiesAsync
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineAdditionalProperties'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testInlineAdditionalPropertiesAsync(
        array $request_body,
        string $contentType = self::contentTypes['testInlineAdditionalProperties'][0]
    ): PromiseInterface
    {
        return $this->testInlineAdditionalPropertiesAsyncWithHttpInfo($request_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testInlineAdditionalPropertiesAsyncWithHttpInfo
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineAdditionalProperties'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testInlineAdditionalPropertiesAsyncWithHttpInfo(
        array $request_body,
        string $contentType = self::contentTypes['testInlineAdditionalProperties'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testInlineAdditionalPropertiesRequest($request_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testInlineAdditionalProperties'
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineAdditionalProperties'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testInlineAdditionalPropertiesRequest(
        array $request_body,
        string $contentType = self::contentTypes['testInlineAdditionalProperties'][0]
    ): Request
    {

        // verify the required parameter 'request_body' is set
        if ($request_body === null || (is_array($request_body) && count($request_body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $request_body when calling testInlineAdditionalProperties'
            );
        }


        $resourcePath = '/fake/inline-additionalProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testInlineFreeformAdditionalProperties
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineFreeformAdditionalProperties'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testInlineFreeformAdditionalProperties(
        \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request,
        string $contentType = self::contentTypes['testInlineFreeformAdditionalProperties'][0]
    ): void
    {
        $this->testInlineFreeformAdditionalPropertiesWithHttpInfo($test_inline_freeform_additional_properties_request, $contentType);
    }

    /**
     * Operation testInlineFreeformAdditionalPropertiesWithHttpInfo
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineFreeformAdditionalProperties'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testInlineFreeformAdditionalPropertiesWithHttpInfo(
        \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request,
        string $contentType = self::contentTypes['testInlineFreeformAdditionalProperties'][0]
    ): array
    {
        $request = $this->testInlineFreeformAdditionalPropertiesRequest($test_inline_freeform_additional_properties_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testInlineFreeformAdditionalPropertiesAsync
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineFreeformAdditionalProperties'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testInlineFreeformAdditionalPropertiesAsync(
        \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request,
        string $contentType = self::contentTypes['testInlineFreeformAdditionalProperties'][0]
    ): PromiseInterface
    {
        return $this->testInlineFreeformAdditionalPropertiesAsyncWithHttpInfo($test_inline_freeform_additional_properties_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testInlineFreeformAdditionalPropertiesAsyncWithHttpInfo
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineFreeformAdditionalProperties'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testInlineFreeformAdditionalPropertiesAsyncWithHttpInfo(
        \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request,
        string $contentType = self::contentTypes['testInlineFreeformAdditionalProperties'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testInlineFreeformAdditionalPropertiesRequest($test_inline_freeform_additional_properties_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testInlineFreeformAdditionalProperties'
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testInlineFreeformAdditionalProperties'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testInlineFreeformAdditionalPropertiesRequest(
        \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request,
        string $contentType = self::contentTypes['testInlineFreeformAdditionalProperties'][0]
    ): Request
    {

        // verify the required parameter 'test_inline_freeform_additional_properties_request' is set
        if ($test_inline_freeform_additional_properties_request === null || (is_array($test_inline_freeform_additional_properties_request) && count($test_inline_freeform_additional_properties_request) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $test_inline_freeform_additional_properties_request when calling testInlineFreeformAdditionalProperties'
            );
        }


        $resourcePath = '/fake/inline-freeform-additionalProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($test_inline_freeform_additional_properties_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($test_inline_freeform_additional_properties_request));
            } else {
                $httpBody = $test_inline_freeform_additional_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testJsonFormData
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testJsonFormData'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testJsonFormData(
        string $param,
        string $param2,
        string $contentType = self::contentTypes['testJsonFormData'][0]
    ): void
    {
        $this->testJsonFormDataWithHttpInfo($param, $param2, $contentType);
    }

    /**
     * Operation testJsonFormDataWithHttpInfo
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testJsonFormData'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testJsonFormDataWithHttpInfo(
        string $param,
        string $param2,
        string $contentType = self::contentTypes['testJsonFormData'][0]
    ): array
    {
        $request = $this->testJsonFormDataRequest($param, $param2, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testJsonFormDataAsync
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testJsonFormData'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testJsonFormDataAsync(
        string $param,
        string $param2,
        string $contentType = self::contentTypes['testJsonFormData'][0]
    ): PromiseInterface
    {
        return $this->testJsonFormDataAsyncWithHttpInfo($param, $param2, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testJsonFormDataAsyncWithHttpInfo
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testJsonFormData'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testJsonFormDataAsyncWithHttpInfo(
        string $param,
        string $param2,
        string $contentType = self::contentTypes['testJsonFormData'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testJsonFormDataRequest($param, $param2, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testJsonFormData'
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testJsonFormData'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testJsonFormDataRequest(
        string $param,
        string $param2,
        string $contentType = self::contentTypes['testJsonFormData'][0]
    ): Request
    {

        // verify the required parameter 'param' is set
        if ($param === null || (is_array($param) && count($param) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $param when calling testJsonFormData'
            );
        }

        // verify the required parameter 'param2' is set
        if ($param2 === null || (is_array($param2) && count($param2) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $param2 when calling testJsonFormData'
            );
        }


        $resourcePath = '/fake/jsonFormData';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'param' => $param,
            'param2' => $param2,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testNullable
     *
     * test nullable parent property
     *
     * @param  \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testNullable'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testNullable(
        \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable,
        string $contentType = self::contentTypes['testNullable'][0]
    ): void
    {
        $this->testNullableWithHttpInfo($child_with_nullable, $contentType);
    }

    /**
     * Operation testNullableWithHttpInfo
     *
     * test nullable parent property
     *
     * @param  \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testNullable'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testNullableWithHttpInfo(
        \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable,
        string $contentType = self::contentTypes['testNullable'][0]
    ): array
    {
        $request = $this->testNullableRequest($child_with_nullable, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testNullableAsync
     *
     * test nullable parent property
     *
     * @param  \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testNullable'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testNullableAsync(
        \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable,
        string $contentType = self::contentTypes['testNullable'][0]
    ): PromiseInterface
    {
        return $this->testNullableAsyncWithHttpInfo($child_with_nullable, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testNullableAsyncWithHttpInfo
     *
     * test nullable parent property
     *
     * @param  \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testNullable'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testNullableAsyncWithHttpInfo(
        \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable,
        string $contentType = self::contentTypes['testNullable'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testNullableRequest($child_with_nullable, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testNullable'
     *
     * @param  \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testNullable'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testNullableRequest(
        \OpenAPI\Client\Model\ChildWithNullable $child_with_nullable,
        string $contentType = self::contentTypes['testNullable'][0]
    ): Request
    {

        // verify the required parameter 'child_with_nullable' is set
        if ($child_with_nullable === null || (is_array($child_with_nullable) && count($child_with_nullable) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $child_with_nullable when calling testNullable'
            );
        }


        $resourcePath = '/fake/nullable';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($child_with_nullable)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($child_with_nullable));
            } else {
                $httpBody = $child_with_nullable;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryParameterCollectionFormat
     *
     * @param  string[] $pipe pipe (required)
     * @param  string[] $ioutil ioutil (required)
     * @param  string[] $http http (required)
     * @param  string[] $url url (required)
     * @param  string[] $context context (required)
     * @param  string $allow_empty allow_empty (required)
     * @param  array<string,string>|null $language language (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryParameterCollectionFormat'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testQueryParameterCollectionFormat(
        array $pipe,
        array $ioutil,
        array $http,
        array $url,
        array $context,
        string $allow_empty,
        ?array $language = null,
        string $contentType = self::contentTypes['testQueryParameterCollectionFormat'][0]
    ): void
    {
        $this->testQueryParameterCollectionFormatWithHttpInfo($pipe, $ioutil, $http, $url, $context, $allow_empty, $language, $contentType);
    }

    /**
     * Operation testQueryParameterCollectionFormatWithHttpInfo
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string>|null $language (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryParameterCollectionFormat'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryParameterCollectionFormatWithHttpInfo(
        array $pipe,
        array $ioutil,
        array $http,
        array $url,
        array $context,
        string $allow_empty,
        ?array $language = null,
        string $contentType = self::contentTypes['testQueryParameterCollectionFormat'][0]
    ): array
    {
        $request = $this->testQueryParameterCollectionFormatRequest($pipe, $ioutil, $http, $url, $context, $allow_empty, $language, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryParameterCollectionFormatAsync
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string>|null $language (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryParameterCollectionFormat'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryParameterCollectionFormatAsync(
        array $pipe,
        array $ioutil,
        array $http,
        array $url,
        array $context,
        string $allow_empty,
        ?array $language = null,
        string $contentType = self::contentTypes['testQueryParameterCollectionFormat'][0]
    ): PromiseInterface
    {
        return $this->testQueryParameterCollectionFormatAsyncWithHttpInfo($pipe, $ioutil, $http, $url, $context, $allow_empty, $language, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryParameterCollectionFormatAsyncWithHttpInfo
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string>|null $language (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryParameterCollectionFormat'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryParameterCollectionFormatAsyncWithHttpInfo(
        array $pipe,
        array $ioutil,
        array $http,
        array $url,
        array $context,
        string $allow_empty,
        ?array $language = null,
        string $contentType = self::contentTypes['testQueryParameterCollectionFormat'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testQueryParameterCollectionFormatRequest($pipe, $ioutil, $http, $url, $context, $allow_empty, $language, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryParameterCollectionFormat'
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string>|null $language (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryParameterCollectionFormat'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryParameterCollectionFormatRequest(
        array $pipe,
        array $ioutil,
        array $http,
        array $url,
        array $context,
        string $allow_empty,
        ?array $language = null,
        string $contentType = self::contentTypes['testQueryParameterCollectionFormat'][0]
    ): Request
    {

        // verify the required parameter 'pipe' is set
        if ($pipe === null || (is_array($pipe) && count($pipe) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pipe when calling testQueryParameterCollectionFormat'
            );
        }

        // verify the required parameter 'ioutil' is set
        if ($ioutil === null || (is_array($ioutil) && count($ioutil) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $ioutil when calling testQueryParameterCollectionFormat'
            );
        }

        // verify the required parameter 'http' is set
        if ($http === null || (is_array($http) && count($http) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $http when calling testQueryParameterCollectionFormat'
            );
        }

        // verify the required parameter 'url' is set
        if ($url === null || (is_array($url) && count($url) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $url when calling testQueryParameterCollectionFormat'
            );
        }

        // verify the required parameter 'context' is set
        if ($context === null || (is_array($context) && count($context) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $context when calling testQueryParameterCollectionFormat'
            );
        }

        // verify the required parameter 'allow_empty' is set
        if ($allow_empty === null || (is_array($allow_empty) && count($allow_empty) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $allow_empty when calling testQueryParameterCollectionFormat'
            );
        }



        $resourcePath = '/fake/test-query-parameters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pipe,
            'pipe', // param base name
            'array', // openApiType
            'pipeDelimited', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ioutil,
            'ioutil', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $http,
            'http', // param base name
            'array', // openApiType
            'spaceDelimited', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $url,
            'url', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $context,
            'context', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $language,
            'language', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $allow_empty,
            'allowEmpty', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testStringMapReference
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testStringMapReference'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function testStringMapReference(
        array $request_body,
        string $contentType = self::contentTypes['testStringMapReference'][0]
    ): void
    {
        $this->testStringMapReferenceWithHttpInfo($request_body, $contentType);
    }

    /**
     * Operation testStringMapReferenceWithHttpInfo
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testStringMapReference'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testStringMapReferenceWithHttpInfo(
        array $request_body,
        string $contentType = self::contentTypes['testStringMapReference'][0]
    ): array
    {
        $request = $this->testStringMapReferenceRequest($request_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation testStringMapReferenceAsync
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testStringMapReference'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testStringMapReferenceAsync(
        array $request_body,
        string $contentType = self::contentTypes['testStringMapReference'][0]
    ): PromiseInterface
    {
        return $this->testStringMapReferenceAsyncWithHttpInfo($request_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testStringMapReferenceAsyncWithHttpInfo
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testStringMapReference'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testStringMapReferenceAsyncWithHttpInfo(
        array $request_body,
        string $contentType = self::contentTypes['testStringMapReference'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->testStringMapReferenceRequest($request_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testStringMapReference'
     *
     * @param  array<string,string> $request_body request body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testStringMapReference'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testStringMapReferenceRequest(
        array $request_body,
        string $contentType = self::contentTypes['testStringMapReference'][0]
    ): Request
    {

        // verify the required parameter 'request_body' is set
        if ($request_body === null || (is_array($request_body) && count($request_body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $request_body when calling testStringMapReference'
            );
        }


        $resourcePath = '/fake/stringMap-reference';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption(): array
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response,
    ): array {
        if (in_array($dataType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode,
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
