=begin comment

OpenAPI Petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

The version of the OpenAPI document: 1.0.0

Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package WWW::OpenAPIClient::FakeApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use WWW::OpenAPIClient::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'WWW::OpenAPIClient::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = WWW::OpenAPIClient::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# fake_big_decimal_map
#
# 
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'fake_big_decimal_map' } = {
        summary => '',
        params => $params,
        returns => 'FakeBigDecimalMap200Response',
        };
}
# @return FakeBigDecimalMap200Response
#
sub fake_big_decimal_map {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/BigDecimalMap';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('*/*');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FakeBigDecimalMap200Response', $response);
    return $_response_object;
}

#
# fake_health_get
#
# Health check endpoint
#
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'fake_health_get' } = {
        summary => 'Health check endpoint',
        params => $params,
        returns => 'HealthCheckResult',
        };
}
# @return HealthCheckResult
#
sub fake_health_get {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/health';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HealthCheckResult', $response);
    return $_response_object;
}

#
# fake_http_signature_test
#
# test http signature authentication
#
# @param Pet $pet Pet object that needs to be added to the store (required)
# @param string $query_1 query parameter (optional)
# @param string $header_1 header parameter (optional)
{
    my $params = {
    'pet' => {
        data_type => 'Pet',
        description => 'Pet object that needs to be added to the store',
        required => '1',
    },
    'query_1' => {
        data_type => 'string',
        description => 'query parameter',
        required => '0',
    },
    'header_1' => {
        data_type => 'string',
        description => 'header parameter',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'fake_http_signature_test' } = {
        summary => 'test http signature authentication',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub fake_http_signature_test {
    my ($self, %args) = @_;

    # verify the required parameter 'pet' is set
    unless (exists $args{'pet'}) {
      croak("Missing the required parameter 'pet' when calling fake_http_signature_test");
    }

    # parse inputs
    my $_resource_path = '/fake/http-signature-test';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json', 'application/xml');

    # query params
    if ( exists $args{'query_1'}) {
        $query_params->{'query_1'} = $self->{api_client}->to_query_value($args{'query_1'});
    }

    # header params
    if ( exists $args{'header_1'}) {
        $header_params->{'header_1'} = $self->{api_client}->to_header_value($args{'header_1'});
    }

    my $_body_data;
    # body params
    if ( exists $args{'pet'}) {
        $_body_data = $args{'pet'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(http_signature_test )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# fake_outer_boolean_serialize
#
# 
#
# @param boolean $body Input boolean as post body (optional)
{
    my $params = {
    'body' => {
        data_type => 'boolean',
        description => 'Input boolean as post body',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'fake_outer_boolean_serialize' } = {
        summary => '',
        params => $params,
        returns => 'boolean',
        };
}
# @return boolean
#
sub fake_outer_boolean_serialize {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/outer/boolean';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('*/*');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'body'}) {
        $_body_data = $args{'body'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('boolean', $response);
    return $_response_object;
}

#
# fake_outer_composite_serialize
#
# 
#
# @param OuterComposite $outer_composite Input composite as post body (optional)
{
    my $params = {
    'outer_composite' => {
        data_type => 'OuterComposite',
        description => 'Input composite as post body',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'fake_outer_composite_serialize' } = {
        summary => '',
        params => $params,
        returns => 'OuterComposite',
        };
}
# @return OuterComposite
#
sub fake_outer_composite_serialize {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/outer/composite';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('*/*');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'outer_composite'}) {
        $_body_data = $args{'outer_composite'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OuterComposite', $response);
    return $_response_object;
}

#
# fake_outer_number_serialize
#
# 
#
# @param double $body Input number as post body (optional)
{
    my $params = {
    'body' => {
        data_type => 'double',
        description => 'Input number as post body',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'fake_outer_number_serialize' } = {
        summary => '',
        params => $params,
        returns => 'double',
        };
}
# @return double
#
sub fake_outer_number_serialize {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/outer/number';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('*/*');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'body'}) {
        $_body_data = $args{'body'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('double', $response);
    return $_response_object;
}

#
# fake_outer_string_serialize
#
# 
#
# @param string $body Input string as post body (optional)
{
    my $params = {
    'body' => {
        data_type => 'string',
        description => 'Input string as post body',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'fake_outer_string_serialize' } = {
        summary => '',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub fake_outer_string_serialize {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/outer/string';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('*/*');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'body'}) {
        $_body_data = $args{'body'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# fake_property_enum_integer_serialize
#
# 
#
# @param OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
{
    my $params = {
    'outer_object_with_enum_property' => {
        data_type => 'OuterObjectWithEnumProperty',
        description => 'Input enum (int) as post body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'fake_property_enum_integer_serialize' } = {
        summary => '',
        params => $params,
        returns => 'OuterObjectWithEnumProperty',
        };
}
# @return OuterObjectWithEnumProperty
#
sub fake_property_enum_integer_serialize {
    my ($self, %args) = @_;

    # verify the required parameter 'outer_object_with_enum_property' is set
    unless (exists $args{'outer_object_with_enum_property'}) {
      croak("Missing the required parameter 'outer_object_with_enum_property' when calling fake_property_enum_integer_serialize");
    }

    # parse inputs
    my $_resource_path = '/fake/property/enum-int';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('*/*');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'outer_object_with_enum_property'}) {
        $_body_data = $args{'outer_object_with_enum_property'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OuterObjectWithEnumProperty', $response);
    return $_response_object;
}

#
# test_additional_properties_reference
#
# test referenced additionalProperties
#
# @param HASH[string,object] $request_body request body (required)
{
    my $params = {
    'request_body' => {
        data_type => 'HASH[string,object]',
        description => 'request body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_additional_properties_reference' } = {
        summary => 'test referenced additionalProperties',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_additional_properties_reference {
    my ($self, %args) = @_;

    # verify the required parameter 'request_body' is set
    unless (exists $args{'request_body'}) {
      croak("Missing the required parameter 'request_body' when calling test_additional_properties_reference");
    }

    # parse inputs
    my $_resource_path = '/fake/additionalProperties-reference';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'request_body'}) {
        $_body_data = $args{'request_body'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_body_with_binary
#
# 
#
# @param string $body image to upload (required)
{
    my $params = {
    'body' => {
        data_type => 'string',
        description => 'image to upload',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_body_with_binary' } = {
        summary => '',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_body_with_binary {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake/body-with-binary';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('image/png');

    my $_body_data;
    # body params
    if ( exists $args{'body'}) {
        $_body_data = $args{'body'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_body_with_file_schema
#
# 
#
# @param FileSchemaTestClass $file_schema_test_class  (required)
{
    my $params = {
    'file_schema_test_class' => {
        data_type => 'FileSchemaTestClass',
        description => '',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_body_with_file_schema' } = {
        summary => '',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_body_with_file_schema {
    my ($self, %args) = @_;

    # verify the required parameter 'file_schema_test_class' is set
    unless (exists $args{'file_schema_test_class'}) {
      croak("Missing the required parameter 'file_schema_test_class' when calling test_body_with_file_schema");
    }

    # parse inputs
    my $_resource_path = '/fake/body-with-file-schema';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'file_schema_test_class'}) {
        $_body_data = $args{'file_schema_test_class'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_body_with_query_params
#
# 
#
# @param string $query  (required)
# @param User $user  (required)
{
    my $params = {
    'query' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'user' => {
        data_type => 'User',
        description => '',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_body_with_query_params' } = {
        summary => '',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_body_with_query_params {
    my ($self, %args) = @_;

    # verify the required parameter 'query' is set
    unless (exists $args{'query'}) {
      croak("Missing the required parameter 'query' when calling test_body_with_query_params");
    }

    # verify the required parameter 'user' is set
    unless (exists $args{'user'}) {
      croak("Missing the required parameter 'user' when calling test_body_with_query_params");
    }

    # parse inputs
    my $_resource_path = '/fake/body-with-query-params';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'query'}) {
        $query_params->{'query'} = $self->{api_client}->to_query_value($args{'query'});
    }

    my $_body_data;
    # body params
    if ( exists $args{'user'}) {
        $_body_data = $args{'user'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_client_model
#
# To test \"client\" model
#
# @param Client $client client model (required)
{
    my $params = {
    'client' => {
        data_type => 'Client',
        description => 'client model',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_client_model' } = {
        summary => 'To test \&quot;client\&quot; model',
        params => $params,
        returns => 'Client',
        };
}
# @return Client
#
sub test_client_model {
    my ($self, %args) = @_;

    # verify the required parameter 'client' is set
    unless (exists $args{'client'}) {
      croak("Missing the required parameter 'client' when calling test_client_model");
    }

    # parse inputs
    my $_resource_path = '/fake';

    my $_method = 'PATCH';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'client'}) {
        $_body_data = $args{'client'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Client', $response);
    return $_response_object;
}

#
# test_endpoint_parameters
#
# Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
#
# @param double $number None (required)
# @param double $double None (required)
# @param string $pattern_without_delimiter None (required)
# @param string $byte None (required)
# @param int $integer None (optional)
# @param int $int32 None (optional)
# @param int $int64 None (optional)
# @param double $float None (optional)
# @param string $string None (optional)
# @param string $binary None (optional)
# @param DATE $date None (optional)
# @param DATE_TIME $date_time None (optional)
# @param string $password None (optional)
# @param string $callback None (optional)
{
    my $params = {
    'number' => {
        data_type => 'double',
        description => 'None',
        required => '1',
    },
    'double' => {
        data_type => 'double',
        description => 'None',
        required => '1',
    },
    'pattern_without_delimiter' => {
        data_type => 'string',
        description => 'None',
        required => '1',
    },
    'byte' => {
        data_type => 'string',
        description => 'None',
        required => '1',
    },
    'integer' => {
        data_type => 'int',
        description => 'None',
        required => '0',
    },
    'int32' => {
        data_type => 'int',
        description => 'None',
        required => '0',
    },
    'int64' => {
        data_type => 'int',
        description => 'None',
        required => '0',
    },
    'float' => {
        data_type => 'double',
        description => 'None',
        required => '0',
    },
    'string' => {
        data_type => 'string',
        description => 'None',
        required => '0',
    },
    'binary' => {
        data_type => 'string',
        description => 'None',
        required => '0',
    },
    'date' => {
        data_type => 'DATE',
        description => 'None',
        required => '0',
    },
    'date_time' => {
        data_type => 'DATE_TIME',
        description => 'None',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'None',
        required => '0',
    },
    'callback' => {
        data_type => 'string',
        description => 'None',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_endpoint_parameters' } = {
        summary => 'Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 ',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_endpoint_parameters {
    my ($self, %args) = @_;

    # verify the required parameter 'number' is set
    unless (exists $args{'number'}) {
      croak("Missing the required parameter 'number' when calling test_endpoint_parameters");
    }

    # verify the required parameter 'double' is set
    unless (exists $args{'double'}) {
      croak("Missing the required parameter 'double' when calling test_endpoint_parameters");
    }

    # verify the required parameter 'pattern_without_delimiter' is set
    unless (exists $args{'pattern_without_delimiter'}) {
      croak("Missing the required parameter 'pattern_without_delimiter' when calling test_endpoint_parameters");
    }

    # verify the required parameter 'byte' is set
    unless (exists $args{'byte'}) {
      croak("Missing the required parameter 'byte' when calling test_endpoint_parameters");
    }

    # parse inputs
    my $_resource_path = '/fake';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/x-www-form-urlencoded');

    # form params
    if ( exists $args{'integer'} ) {
                $form_params->{'integer'} = $self->{api_client}->to_form_value($args{'integer'});
    }

    # form params
    if ( exists $args{'int32'} ) {
                $form_params->{'int32'} = $self->{api_client}->to_form_value($args{'int32'});
    }

    # form params
    if ( exists $args{'int64'} ) {
                $form_params->{'int64'} = $self->{api_client}->to_form_value($args{'int64'});
    }

    # form params
    if ( exists $args{'number'} ) {
                $form_params->{'number'} = $self->{api_client}->to_form_value($args{'number'});
    }

    # form params
    if ( exists $args{'float'} ) {
                $form_params->{'float'} = $self->{api_client}->to_form_value($args{'float'});
    }

    # form params
    if ( exists $args{'double'} ) {
                $form_params->{'double'} = $self->{api_client}->to_form_value($args{'double'});
    }

    # form params
    if ( exists $args{'string'} ) {
                $form_params->{'string'} = $self->{api_client}->to_form_value($args{'string'});
    }

    # form params
    if ( exists $args{'pattern_without_delimiter'} ) {
                $form_params->{'pattern_without_delimiter'} = $self->{api_client}->to_form_value($args{'pattern_without_delimiter'});
    }

    # form params
    if ( exists $args{'byte'} ) {
                $form_params->{'byte'} = $self->{api_client}->to_form_value($args{'byte'});
    }

    # form params
    if ( exists $args{'binary'} ) {
        $form_params->{'binary'} = [] unless defined $form_params->{'binary'};
        push @{$form_params->{'binary'}}, $args{'binary'};
            }

    # form params
    if ( exists $args{'date'} ) {
                $form_params->{'date'} = $self->{api_client}->to_form_value($args{'date'});
    }

    # form params
    if ( exists $args{'date_time'} ) {
                $form_params->{'dateTime'} = $self->{api_client}->to_form_value($args{'date_time'});
    }

    # form params
    if ( exists $args{'password'} ) {
                $form_params->{'password'} = $self->{api_client}->to_form_value($args{'password'});
    }

    # form params
    if ( exists $args{'callback'} ) {
                $form_params->{'callback'} = $self->{api_client}->to_form_value($args{'callback'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(http_basic_test )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_enum_parameters
#
# To test enum parameters
#
# @param ARRAY[string] $enum_header_string_array Header parameter enum test (string array) (optional)
# @param string $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
# @param ARRAY[string] $enum_query_string_array Query parameter enum test (string array) (optional)
# @param string $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
# @param int $enum_query_integer Query parameter enum test (double) (optional)
# @param double $enum_query_double Query parameter enum test (double) (optional)
# @param ARRAY[EnumClass] $enum_query_model_array  (optional)
# @param ARRAY[string] $enum_form_string_array Form parameter enum test (string array) (optional, default to '$')
# @param string $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
{
    my $params = {
    'enum_header_string_array' => {
        data_type => 'ARRAY[string]',
        description => 'Header parameter enum test (string array)',
        required => '0',
    },
    'enum_header_string' => {
        data_type => 'string',
        description => 'Header parameter enum test (string)',
        required => '0',
    },
    'enum_query_string_array' => {
        data_type => 'ARRAY[string]',
        description => 'Query parameter enum test (string array)',
        required => '0',
    },
    'enum_query_string' => {
        data_type => 'string',
        description => 'Query parameter enum test (string)',
        required => '0',
    },
    'enum_query_integer' => {
        data_type => 'int',
        description => 'Query parameter enum test (double)',
        required => '0',
    },
    'enum_query_double' => {
        data_type => 'double',
        description => 'Query parameter enum test (double)',
        required => '0',
    },
    'enum_query_model_array' => {
        data_type => 'ARRAY[EnumClass]',
        description => '',
        required => '0',
    },
    'enum_form_string_array' => {
        data_type => 'ARRAY[string]',
        description => 'Form parameter enum test (string array)',
        required => '0',
    },
    'enum_form_string' => {
        data_type => 'string',
        description => 'Form parameter enum test (string)',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_enum_parameters' } = {
        summary => 'To test enum parameters',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_enum_parameters {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/fake';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/x-www-form-urlencoded');

    # query params
    if ( exists $args{'enum_query_string_array'}) {
        $query_params->{'enum_query_string_array'} = $self->{api_client}->to_query_value($args{'enum_query_string_array'});
    }

    # query params
    if ( exists $args{'enum_query_string'}) {
        $query_params->{'enum_query_string'} = $self->{api_client}->to_query_value($args{'enum_query_string'});
    }

    # query params
    if ( exists $args{'enum_query_integer'}) {
        $query_params->{'enum_query_integer'} = $self->{api_client}->to_query_value($args{'enum_query_integer'});
    }

    # query params
    if ( exists $args{'enum_query_double'}) {
        $query_params->{'enum_query_double'} = $self->{api_client}->to_query_value($args{'enum_query_double'});
    }

    # query params
    if ( exists $args{'enum_query_model_array'}) {
        $query_params->{'enum_query_model_array'} = $self->{api_client}->to_query_value($args{'enum_query_model_array'});
    }

    # header params
    if ( exists $args{'enum_header_string_array'}) {
        $header_params->{'enum_header_string_array'} = $self->{api_client}->to_header_value($args{'enum_header_string_array'});
    }

    # header params
    if ( exists $args{'enum_header_string'}) {
        $header_params->{'enum_header_string'} = $self->{api_client}->to_header_value($args{'enum_header_string'});
    }

    # form params
    if ( exists $args{'enum_form_string_array'} ) {
                $form_params->{'enum_form_string_array'} = $self->{api_client}->to_form_value($args{'enum_form_string_array'});
    }

    # form params
    if ( exists $args{'enum_form_string'} ) {
                $form_params->{'enum_form_string'} = $self->{api_client}->to_form_value($args{'enum_form_string'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_group_parameters
#
# Fake endpoint to test group parameters (optional)
#
# @param int $required_string_group Required String in group parameters (required)
# @param boolean $required_boolean_group Required Boolean in group parameters (required)
# @param int $required_int64_group Required Integer in group parameters (required)
# @param int $string_group String in group parameters (optional)
# @param boolean $boolean_group Boolean in group parameters (optional)
# @param int $int64_group Integer in group parameters (optional)
{
    my $params = {
    'required_string_group' => {
        data_type => 'int',
        description => 'Required String in group parameters',
        required => '1',
    },
    'required_boolean_group' => {
        data_type => 'boolean',
        description => 'Required Boolean in group parameters',
        required => '1',
    },
    'required_int64_group' => {
        data_type => 'int',
        description => 'Required Integer in group parameters',
        required => '1',
    },
    'string_group' => {
        data_type => 'int',
        description => 'String in group parameters',
        required => '0',
    },
    'boolean_group' => {
        data_type => 'boolean',
        description => 'Boolean in group parameters',
        required => '0',
    },
    'int64_group' => {
        data_type => 'int',
        description => 'Integer in group parameters',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_group_parameters' } = {
        summary => 'Fake endpoint to test group parameters (optional)',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_group_parameters {
    my ($self, %args) = @_;

    # verify the required parameter 'required_string_group' is set
    unless (exists $args{'required_string_group'}) {
      croak("Missing the required parameter 'required_string_group' when calling test_group_parameters");
    }

    # verify the required parameter 'required_boolean_group' is set
    unless (exists $args{'required_boolean_group'}) {
      croak("Missing the required parameter 'required_boolean_group' when calling test_group_parameters");
    }

    # verify the required parameter 'required_int64_group' is set
    unless (exists $args{'required_int64_group'}) {
      croak("Missing the required parameter 'required_int64_group' when calling test_group_parameters");
    }

    # parse inputs
    my $_resource_path = '/fake';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'required_string_group'}) {
        $query_params->{'required_string_group'} = $self->{api_client}->to_query_value($args{'required_string_group'});
    }

    # query params
    if ( exists $args{'required_int64_group'}) {
        $query_params->{'required_int64_group'} = $self->{api_client}->to_query_value($args{'required_int64_group'});
    }

    # query params
    if ( exists $args{'string_group'}) {
        $query_params->{'string_group'} = $self->{api_client}->to_query_value($args{'string_group'});
    }

    # query params
    if ( exists $args{'int64_group'}) {
        $query_params->{'int64_group'} = $self->{api_client}->to_query_value($args{'int64_group'});
    }

    # header params
    if ( exists $args{'required_boolean_group'}) {
        $header_params->{'required_boolean_group'} = $self->{api_client}->to_header_value($args{'required_boolean_group'});
    }

    # header params
    if ( exists $args{'boolean_group'}) {
        $header_params->{'boolean_group'} = $self->{api_client}->to_header_value($args{'boolean_group'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(bearer_test )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_inline_additional_properties
#
# test inline additionalProperties
#
# @param HASH[string,string] $request_body request body (required)
{
    my $params = {
    'request_body' => {
        data_type => 'HASH[string,string]',
        description => 'request body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_inline_additional_properties' } = {
        summary => 'test inline additionalProperties',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_inline_additional_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'request_body' is set
    unless (exists $args{'request_body'}) {
      croak("Missing the required parameter 'request_body' when calling test_inline_additional_properties");
    }

    # parse inputs
    my $_resource_path = '/fake/inline-additionalProperties';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'request_body'}) {
        $_body_data = $args{'request_body'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_inline_freeform_additional_properties
#
# test inline free-form additionalProperties
#
# @param TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
{
    my $params = {
    'test_inline_freeform_additional_properties_request' => {
        data_type => 'TestInlineFreeformAdditionalPropertiesRequest',
        description => 'request body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_inline_freeform_additional_properties' } = {
        summary => 'test inline free-form additionalProperties',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_inline_freeform_additional_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'test_inline_freeform_additional_properties_request' is set
    unless (exists $args{'test_inline_freeform_additional_properties_request'}) {
      croak("Missing the required parameter 'test_inline_freeform_additional_properties_request' when calling test_inline_freeform_additional_properties");
    }

    # parse inputs
    my $_resource_path = '/fake/inline-freeform-additionalProperties';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'test_inline_freeform_additional_properties_request'}) {
        $_body_data = $args{'test_inline_freeform_additional_properties_request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_json_form_data
#
# test json serialization of form data
#
# @param string $param field1 (required)
# @param string $param2 field2 (required)
{
    my $params = {
    'param' => {
        data_type => 'string',
        description => 'field1',
        required => '1',
    },
    'param2' => {
        data_type => 'string',
        description => 'field2',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_json_form_data' } = {
        summary => 'test json serialization of form data',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_json_form_data {
    my ($self, %args) = @_;

    # verify the required parameter 'param' is set
    unless (exists $args{'param'}) {
      croak("Missing the required parameter 'param' when calling test_json_form_data");
    }

    # verify the required parameter 'param2' is set
    unless (exists $args{'param2'}) {
      croak("Missing the required parameter 'param2' when calling test_json_form_data");
    }

    # parse inputs
    my $_resource_path = '/fake/jsonFormData';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/x-www-form-urlencoded');

    # form params
    if ( exists $args{'param'} ) {
                $form_params->{'param'} = $self->{api_client}->to_form_value($args{'param'});
    }

    # form params
    if ( exists $args{'param2'} ) {
                $form_params->{'param2'} = $self->{api_client}->to_form_value($args{'param2'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_nullable
#
# test nullable parent property
#
# @param ChildWithNullable $child_with_nullable request body (required)
{
    my $params = {
    'child_with_nullable' => {
        data_type => 'ChildWithNullable',
        description => 'request body',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_nullable' } = {
        summary => 'test nullable parent property',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_nullable {
    my ($self, %args) = @_;

    # verify the required parameter 'child_with_nullable' is set
    unless (exists $args{'child_with_nullable'}) {
      croak("Missing the required parameter 'child_with_nullable' when calling test_nullable");
    }

    # parse inputs
    my $_resource_path = '/fake/nullable';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'child_with_nullable'}) {
        $_body_data = $args{'child_with_nullable'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# test_query_parameter_collection_format
#
# 
#
# @param ARRAY[string] $pipe  (required)
# @param ARRAY[string] $ioutil  (required)
# @param ARRAY[string] $http  (required)
# @param ARRAY[string] $url  (required)
# @param ARRAY[string] $context  (required)
# @param string $allow_empty  (required)
# @param HASH[string,string] $language  (optional)
{
    my $params = {
    'pipe' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'ioutil' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'http' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'url' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'context' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'allow_empty' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'language' => {
        data_type => 'HASH[string,string]',
        description => '',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'test_query_parameter_collection_format' } = {
        summary => '',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub test_query_parameter_collection_format {
    my ($self, %args) = @_;

    # verify the required parameter 'pipe' is set
    unless (exists $args{'pipe'}) {
      croak("Missing the required parameter 'pipe' when calling test_query_parameter_collection_format");
    }

    # verify the required parameter 'ioutil' is set
    unless (exists $args{'ioutil'}) {
      croak("Missing the required parameter 'ioutil' when calling test_query_parameter_collection_format");
    }

    # verify the required parameter 'http' is set
    unless (exists $args{'http'}) {
      croak("Missing the required parameter 'http' when calling test_query_parameter_collection_format");
    }

    # verify the required parameter 'url' is set
    unless (exists $args{'url'}) {
      croak("Missing the required parameter 'url' when calling test_query_parameter_collection_format");
    }

    # verify the required parameter 'context' is set
    unless (exists $args{'context'}) {
      croak("Missing the required parameter 'context' when calling test_query_parameter_collection_format");
    }

    # verify the required parameter 'allow_empty' is set
    unless (exists $args{'allow_empty'}) {
      croak("Missing the required parameter 'allow_empty' when calling test_query_parameter_collection_format");
    }

    # parse inputs
    my $_resource_path = '/fake/test-query-parameters';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'pipe'}) {
        $query_params->{'pipe'} = $self->{api_client}->to_query_value($args{'pipe'});
    }

    # query params
    if ( exists $args{'ioutil'}) {
        $query_params->{'ioutil'} = $self->{api_client}->to_query_value($args{'ioutil'});
    }

    # query params
    if ( exists $args{'http'}) {
        $query_params->{'http'} = $self->{api_client}->to_query_value($args{'http'});
    }

    # query params
    if ( exists $args{'url'}) {
        $query_params->{'url'} = $self->{api_client}->to_query_value($args{'url'});
    }

    # query params
    if ( exists $args{'context'}) {
        $query_params->{'context'} = $self->{api_client}->to_query_value($args{'context'});
    }

    # query params
    if ( exists $args{'language'}) {
        $query_params->{'language'} = $self->{api_client}->to_query_value($args{'language'});
    }

    # query params
    if ( exists $args{'allow_empty'}) {
        $query_params->{'allowEmpty'} = $self->{api_client}->to_query_value($args{'allow_empty'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

1;
